package org.lsst.sal.mtheader.event;

import org.lsst.sal.SALEvent;

public class LargeFileObjectAvailableEvent extends SALEvent {
  private final String url;

  private final String generator;

  private final float version;

  private final int byteSize;

  private final String checkSum;

  private final String mimeType;

  private final String id;

  public LargeFileObjectAvailableEvent(String url, String generator, float version, int byteSize,
      String checkSum, String mimeType, String id) {
    this.url = url;
    this.generator = generator;
    this.version = version;
    this.byteSize = byteSize;
    this.checkSum = checkSum;
    this.mimeType = mimeType;
    this.id = id;
  }

  public String getUrl() {
    return url;
  }

  public String getGenerator() {
    return generator;
  }

  public float getVersion() {
    return version;
  }

  public int getByteSize() {
    return byteSize;
  }

  public String getCheckSum() {
    return checkSum;
  }

  public String getMimeType() {
    return mimeType;
  }

  public String getId() {
    return id;
  }

  @Override
  public String toString() {
    return "LargeFileObjectAvailableEvent{" + "url=" + url +", generator=" + generator +
        ", version=" + version +", byteSize=" + byteSize +", checkSum=" + checkSum +
        ", mimeType=" + mimeType +", id=" + id +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    private String generator;

    private float version;

    private int byteSize;

    private String checkSum;

    private String mimeType;

    private String id;

    private Builder() {
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder generator(String generator) {
      this.generator = generator;
      return this;
    }

    public Builder version(float version) {
      this.version = version;
      return this;
    }

    public Builder byteSize(int byteSize) {
      this.byteSize = byteSize;
      return this;
    }

    public Builder checkSum(String checkSum) {
      this.checkSum = checkSum;
      return this;
    }

    public Builder mimeType(String mimeType) {
      this.mimeType = mimeType;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public LargeFileObjectAvailableEvent build() {
      return new LargeFileObjectAvailableEvent(url, generator, version, byteSize, checkSum, mimeType, id);
    }
  }
}
