/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class XupsTelemetry
extends SALTelemetry {
    private final String systemDescription;
    private final float batteryCapacity;
    private final float batteryTimeRemaining;
    private final float batteryVoltage;
    private final float envAmbientTemp;
    private final float batteryCurrent;
    private final float[] inputCurrent;
    private final float[] inputPower;
    private final float[] inputVoltage;
    private final float inputFrequency;
    private final float[] outputCurrent;
    private final float[] outputPower;
    private final float[] outputVoltage;
    private final float outputFrequency;
    private final float outputLoad;
    private final float[] bypassVoltage;
    private final float bypassFrequency;
    private final int batteryAbmStatus;
    private final String sensorName;

    public XupsTelemetry(String systemDescription, float batteryCapacity, float batteryTimeRemaining, float batteryVoltage, float envAmbientTemp, float batteryCurrent, float[] inputCurrent, float[] inputPower, float[] inputVoltage, float inputFrequency, float[] outputCurrent, float[] outputPower, float[] outputVoltage, float outputFrequency, float outputLoad, float[] bypassVoltage, float bypassFrequency, int batteryAbmStatus, String sensorName) {
        this.systemDescription = systemDescription;
        this.batteryCapacity = batteryCapacity;
        this.batteryTimeRemaining = batteryTimeRemaining;
        this.batteryVoltage = batteryVoltage;
        this.envAmbientTemp = envAmbientTemp;
        this.batteryCurrent = batteryCurrent;
        this.inputCurrent = inputCurrent;
        this.inputPower = inputPower;
        this.inputVoltage = inputVoltage;
        this.inputFrequency = inputFrequency;
        this.outputCurrent = outputCurrent;
        this.outputPower = outputPower;
        this.outputVoltage = outputVoltage;
        this.outputFrequency = outputFrequency;
        this.outputLoad = outputLoad;
        this.bypassVoltage = bypassVoltage;
        this.bypassFrequency = bypassFrequency;
        this.batteryAbmStatus = batteryAbmStatus;
        this.sensorName = sensorName;
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    public float getBatteryCapacity() {
        return this.batteryCapacity;
    }

    public float getBatteryTimeRemaining() {
        return this.batteryTimeRemaining;
    }

    public float getBatteryVoltage() {
        return this.batteryVoltage;
    }

    public float getEnvAmbientTemp() {
        return this.envAmbientTemp;
    }

    public float getBatteryCurrent() {
        return this.batteryCurrent;
    }

    public float[] getInputCurrent() {
        return this.inputCurrent;
    }

    public float[] getInputPower() {
        return this.inputPower;
    }

    public float[] getInputVoltage() {
        return this.inputVoltage;
    }

    public float getInputFrequency() {
        return this.inputFrequency;
    }

    public float[] getOutputCurrent() {
        return this.outputCurrent;
    }

    public float[] getOutputPower() {
        return this.outputPower;
    }

    public float[] getOutputVoltage() {
        return this.outputVoltage;
    }

    public float getOutputFrequency() {
        return this.outputFrequency;
    }

    public float getOutputLoad() {
        return this.outputLoad;
    }

    public float[] getBypassVoltage() {
        return this.bypassVoltage;
    }

    public float getBypassFrequency() {
        return this.bypassFrequency;
    }

    public int getBatteryAbmStatus() {
        return this.batteryAbmStatus;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String toString() {
        return "XupsTelemetry{systemDescription=" + this.systemDescription + ", batteryCapacity=" + this.batteryCapacity + ", batteryTimeRemaining=" + this.batteryTimeRemaining + ", batteryVoltage=" + this.batteryVoltage + ", envAmbientTemp=" + this.envAmbientTemp + ", batteryCurrent=" + this.batteryCurrent + ", inputCurrent=" + Arrays.toString(this.inputCurrent) + ", inputPower=" + Arrays.toString(this.inputPower) + ", inputVoltage=" + Arrays.toString(this.inputVoltage) + ", inputFrequency=" + this.inputFrequency + ", outputCurrent=" + Arrays.toString(this.outputCurrent) + ", outputPower=" + Arrays.toString(this.outputPower) + ", outputVoltage=" + Arrays.toString(this.outputVoltage) + ", outputFrequency=" + this.outputFrequency + ", outputLoad=" + this.outputLoad + ", bypassVoltage=" + Arrays.toString(this.bypassVoltage) + ", bypassFrequency=" + this.bypassFrequency + ", batteryAbmStatus=" + this.batteryAbmStatus + ", sensorName=" + this.sensorName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemDescription;
        private float batteryCapacity;
        private float batteryTimeRemaining;
        private float batteryVoltage;
        private float envAmbientTemp;
        private float batteryCurrent;
        private float[] inputCurrent;
        private float[] inputPower;
        private float[] inputVoltage;
        private float inputFrequency;
        private float[] outputCurrent;
        private float[] outputPower;
        private float[] outputVoltage;
        private float outputFrequency;
        private float outputLoad;
        private float[] bypassVoltage;
        private float bypassFrequency;
        private int batteryAbmStatus;
        private String sensorName;

        private Builder() {
        }

        public Builder systemDescription(String systemDescription) {
            this.systemDescription = systemDescription;
            return this;
        }

        public Builder batteryCapacity(float batteryCapacity) {
            this.batteryCapacity = batteryCapacity;
            return this;
        }

        public Builder batteryTimeRemaining(float batteryTimeRemaining) {
            this.batteryTimeRemaining = batteryTimeRemaining;
            return this;
        }

        public Builder batteryVoltage(float batteryVoltage) {
            this.batteryVoltage = batteryVoltage;
            return this;
        }

        public Builder envAmbientTemp(float envAmbientTemp) {
            this.envAmbientTemp = envAmbientTemp;
            return this;
        }

        public Builder batteryCurrent(float batteryCurrent) {
            this.batteryCurrent = batteryCurrent;
            return this;
        }

        public Builder inputCurrent(float[] inputCurrent) {
            this.inputCurrent = inputCurrent;
            return this;
        }

        public Builder inputPower(float[] inputPower) {
            this.inputPower = inputPower;
            return this;
        }

        public Builder inputVoltage(float[] inputVoltage) {
            this.inputVoltage = inputVoltage;
            return this;
        }

        public Builder inputFrequency(float inputFrequency) {
            this.inputFrequency = inputFrequency;
            return this;
        }

        public Builder outputCurrent(float[] outputCurrent) {
            this.outputCurrent = outputCurrent;
            return this;
        }

        public Builder outputPower(float[] outputPower) {
            this.outputPower = outputPower;
            return this;
        }

        public Builder outputVoltage(float[] outputVoltage) {
            this.outputVoltage = outputVoltage;
            return this;
        }

        public Builder outputFrequency(float outputFrequency) {
            this.outputFrequency = outputFrequency;
            return this;
        }

        public Builder outputLoad(float outputLoad) {
            this.outputLoad = outputLoad;
            return this;
        }

        public Builder bypassVoltage(float[] bypassVoltage) {
            this.bypassVoltage = bypassVoltage;
            return this;
        }

        public Builder bypassFrequency(float bypassFrequency) {
            this.bypassFrequency = bypassFrequency;
            return this;
        }

        public Builder batteryAbmStatus(int batteryAbmStatus) {
            this.batteryAbmStatus = batteryAbmStatus;
            return this;
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public XupsTelemetry build() {
            return new XupsTelemetry(this.systemDescription, this.batteryCapacity, this.batteryTimeRemaining, this.batteryVoltage, this.envAmbientTemp, this.batteryCurrent, this.inputCurrent, this.inputPower, this.inputVoltage, this.inputFrequency, this.outputCurrent, this.outputPower, this.outputVoltage, this.outputFrequency, this.outputLoad, this.bypassVoltage, this.bypassFrequency, this.batteryAbmStatus, this.sensorName);
        }
    }
}

