/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import org.lsst.sal.SALTelemetry;

public class LightningStrikeStatusTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float closeStrikeRate;
    private final float totalStrikeRate;
    private final boolean closeAlarmStatus;
    private final boolean severeAlarmStatus;
    private final float heading;
    private final String location;

    public LightningStrikeStatusTelemetry(String sensorName, double timestamp, float closeStrikeRate, float totalStrikeRate, boolean closeAlarmStatus, boolean severeAlarmStatus, float heading, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.closeStrikeRate = closeStrikeRate;
        this.totalStrikeRate = totalStrikeRate;
        this.closeAlarmStatus = closeAlarmStatus;
        this.severeAlarmStatus = severeAlarmStatus;
        this.heading = heading;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float getCloseStrikeRate() {
        return this.closeStrikeRate;
    }

    public float getTotalStrikeRate() {
        return this.totalStrikeRate;
    }

    public boolean isCloseAlarmStatus() {
        return this.closeAlarmStatus;
    }

    public boolean isSevereAlarmStatus() {
        return this.severeAlarmStatus;
    }

    public float getHeading() {
        return this.heading;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "LightningStrikeStatusTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", closeStrikeRate=" + this.closeStrikeRate + ", totalStrikeRate=" + this.totalStrikeRate + ", closeAlarmStatus=" + this.closeAlarmStatus + ", severeAlarmStatus=" + this.severeAlarmStatus + ", heading=" + this.heading + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float closeStrikeRate;
        private float totalStrikeRate;
        private boolean closeAlarmStatus;
        private boolean severeAlarmStatus;
        private float heading;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder closeStrikeRate(float closeStrikeRate) {
            this.closeStrikeRate = closeStrikeRate;
            return this;
        }

        public Builder totalStrikeRate(float totalStrikeRate) {
            this.totalStrikeRate = totalStrikeRate;
            return this;
        }

        public Builder closeAlarmStatus(boolean closeAlarmStatus) {
            this.closeAlarmStatus = closeAlarmStatus;
            return this;
        }

        public Builder severeAlarmStatus(boolean severeAlarmStatus) {
            this.severeAlarmStatus = severeAlarmStatus;
            return this;
        }

        public Builder heading(float heading) {
            this.heading = heading;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public LightningStrikeStatusTelemetry build() {
            return new LightningStrikeStatusTelemetry(this.sensorName, this.timestamp, this.closeStrikeRate, this.totalStrikeRate, this.closeAlarmStatus, this.severeAlarmStatus, this.heading, this.location);
        }
    }
}

