/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import org.lsst.sal.SALTelemetry;

public class ElectricFieldStrengthTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float strength;
    private final float strengthStdDev;
    private final float strengthMax;
    private final String location;

    public ElectricFieldStrengthTelemetry(String sensorName, double timestamp, float strength, float strengthStdDev, float strengthMax, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.strength = strength;
        this.strengthStdDev = strengthStdDev;
        this.strengthMax = strengthMax;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getStrengthStdDev() {
        return this.strengthStdDev;
    }

    public float getStrengthMax() {
        return this.strengthMax;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "ElectricFieldStrengthTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", strength=" + this.strength + ", strengthStdDev=" + this.strengthStdDev + ", strengthMax=" + this.strengthMax + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float strength;
        private float strengthStdDev;
        private float strengthMax;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder strength(float strength) {
            this.strength = strength;
            return this;
        }

        public Builder strengthStdDev(float strengthStdDev) {
            this.strengthStdDev = strengthStdDev;
            return this;
        }

        public Builder strengthMax(float strengthMax) {
            this.strengthMax = strengthMax;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public ElectricFieldStrengthTelemetry build() {
            return new ElectricFieldStrengthTelemetry(this.sensorName, this.timestamp, this.strength, this.strengthStdDev, this.strengthMax, this.location);
        }
    }
}

