/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import org.lsst.sal.SALTelemetry;

public class EarthquakeLongPeriodHighGainTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float accelerationEastWest;
    private final float accelerationNorthSouth;
    private final float accelerationZenith;
    private final String location;

    public EarthquakeLongPeriodHighGainTelemetry(String sensorName, double timestamp, float accelerationEastWest, float accelerationNorthSouth, float accelerationZenith, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.accelerationEastWest = accelerationEastWest;
        this.accelerationNorthSouth = accelerationNorthSouth;
        this.accelerationZenith = accelerationZenith;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float getAccelerationEastWest() {
        return this.accelerationEastWest;
    }

    public float getAccelerationNorthSouth() {
        return this.accelerationNorthSouth;
    }

    public float getAccelerationZenith() {
        return this.accelerationZenith;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "EarthquakeLongPeriodHighGainTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", accelerationEastWest=" + this.accelerationEastWest + ", accelerationNorthSouth=" + this.accelerationNorthSouth + ", accelerationZenith=" + this.accelerationZenith + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float accelerationEastWest;
        private float accelerationNorthSouth;
        private float accelerationZenith;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder accelerationEastWest(float accelerationEastWest) {
            this.accelerationEastWest = accelerationEastWest;
            return this;
        }

        public Builder accelerationNorthSouth(float accelerationNorthSouth) {
            this.accelerationNorthSouth = accelerationNorthSouth;
            return this;
        }

        public Builder accelerationZenith(float accelerationZenith) {
            this.accelerationZenith = accelerationZenith;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public EarthquakeLongPeriodHighGainTelemetry build() {
            return new EarthquakeLongPeriodHighGainTelemetry(this.sensorName, this.timestamp, this.accelerationEastWest, this.accelerationNorthSouth, this.accelerationZenith, this.location);
        }
    }
}

