/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import org.lsst.sal.SALTelemetry;

public class AircraftTrackTelemetry
extends SALTelemetry {
    private final double timestamp;
    private final String track;
    private final String transponder;
    private final double azimuth;
    private final float altitude;
    private final float speed;
    private final double latitude;
    private final double longitude;
    private final float velocityX;
    private final float velocityY;

    public AircraftTrackTelemetry(double timestamp, String track, String transponder, double azimuth, float altitude, float speed, double latitude, double longitude, float velocityX, float velocityY) {
        this.timestamp = timestamp;
        this.track = track;
        this.transponder = transponder;
        this.azimuth = azimuth;
        this.altitude = altitude;
        this.speed = speed;
        this.latitude = latitude;
        this.longitude = longitude;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public String getTrack() {
        return this.track;
    }

    public String getTransponder() {
        return this.transponder;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public float getSpeed() {
        return this.speed;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public String toString() {
        return "AircraftTrackTelemetry{timestamp=" + this.timestamp + ", track=" + this.track + ", transponder=" + this.transponder + ", azimuth=" + this.azimuth + ", altitude=" + this.altitude + ", speed=" + this.speed + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", velocityX=" + this.velocityX + ", velocityY=" + this.velocityY + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double timestamp;
        private String track;
        private String transponder;
        private double azimuth;
        private float altitude;
        private float speed;
        private double latitude;
        private double longitude;
        private float velocityX;
        private float velocityY;

        private Builder() {
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder track(String track) {
            this.track = track;
            return this;
        }

        public Builder transponder(String transponder) {
            this.transponder = transponder;
            return this;
        }

        public Builder azimuth(double azimuth) {
            this.azimuth = azimuth;
            return this;
        }

        public Builder altitude(float altitude) {
            this.altitude = altitude;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder velocityX(float velocityX) {
            this.velocityX = velocityX;
            return this;
        }

        public Builder velocityY(float velocityY) {
            this.velocityY = velocityY;
            return this;
        }

        public AircraftTrackTelemetry build() {
            return new AircraftTrackTelemetry(this.timestamp, this.track, this.transponder, this.azimuth, this.altitude, this.speed, this.latitude, this.longitude, this.velocityX, this.velocityY);
        }
    }
}

