/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class AccelerometerTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final double interval;
    private final float[] accelerationX;
    private final float[] accelerationY;
    private final float[] accelerationZ;
    private final String location;

    public AccelerometerTelemetry(String sensorName, double timestamp, double interval, float[] accelerationX, float[] accelerationY, float[] accelerationZ, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.interval = interval;
        this.accelerationX = accelerationX;
        this.accelerationY = accelerationY;
        this.accelerationZ = accelerationZ;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public double getInterval() {
        return this.interval;
    }

    public float[] getAccelerationX() {
        return this.accelerationX;
    }

    public float[] getAccelerationY() {
        return this.accelerationY;
    }

    public float[] getAccelerationZ() {
        return this.accelerationZ;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "AccelerometerTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", interval=" + this.interval + ", accelerationX=" + Arrays.toString(this.accelerationX) + ", accelerationY=" + Arrays.toString(this.accelerationY) + ", accelerationZ=" + Arrays.toString(this.accelerationZ) + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private double interval;
        private float[] accelerationX;
        private float[] accelerationY;
        private float[] accelerationZ;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder interval(double interval) {
            this.interval = interval;
            return this;
        }

        public Builder accelerationX(float[] accelerationX) {
            this.accelerationX = accelerationX;
            return this;
        }

        public Builder accelerationY(float[] accelerationY) {
            this.accelerationY = accelerationY;
            return this;
        }

        public Builder accelerationZ(float[] accelerationZ) {
            this.accelerationZ = accelerationZ;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public AccelerometerTelemetry build() {
            return new AccelerometerTelemetry(this.sensorName, this.timestamp, this.interval, this.accelerationX, this.accelerationY, this.accelerationZ, this.location);
        }
    }
}

