/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class AccelerometerPSDTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float maxPSDFrequency;
    private final float[] accelerationPSDX;
    private final float[] accelerationPSDY;
    private final float[] accelerationPSDZ;
    private final String location;

    public AccelerometerPSDTelemetry(String sensorName, double timestamp, float maxPSDFrequency, float[] accelerationPSDX, float[] accelerationPSDY, float[] accelerationPSDZ, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.maxPSDFrequency = maxPSDFrequency;
        this.accelerationPSDX = accelerationPSDX;
        this.accelerationPSDY = accelerationPSDY;
        this.accelerationPSDZ = accelerationPSDZ;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float getMaxPSDFrequency() {
        return this.maxPSDFrequency;
    }

    public float[] getAccelerationPSDX() {
        return this.accelerationPSDX;
    }

    public float[] getAccelerationPSDY() {
        return this.accelerationPSDY;
    }

    public float[] getAccelerationPSDZ() {
        return this.accelerationPSDZ;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "AccelerometerPSDTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", maxPSDFrequency=" + this.maxPSDFrequency + ", accelerationPSDX=" + Arrays.toString(this.accelerationPSDX) + ", accelerationPSDY=" + Arrays.toString(this.accelerationPSDY) + ", accelerationPSDZ=" + Arrays.toString(this.accelerationPSDZ) + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float maxPSDFrequency;
        private float[] accelerationPSDX;
        private float[] accelerationPSDY;
        private float[] accelerationPSDZ;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder maxPSDFrequency(float maxPSDFrequency) {
            this.maxPSDFrequency = maxPSDFrequency;
            return this;
        }

        public Builder accelerationPSDX(float[] accelerationPSDX) {
            this.accelerationPSDX = accelerationPSDX;
            return this;
        }

        public Builder accelerationPSDY(float[] accelerationPSDY) {
            this.accelerationPSDY = accelerationPSDY;
            return this;
        }

        public Builder accelerationPSDZ(float[] accelerationPSDZ) {
            this.accelerationPSDZ = accelerationPSDZ;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public AccelerometerPSDTelemetry build() {
            return new AccelerometerPSDTelemetry(this.sensorName, this.timestamp, this.maxPSDFrequency, this.accelerationPSDX, this.accelerationPSDY, this.accelerationPSDZ, this.location);
        }
    }
}

