/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.CodegenMojo;
import org.lsst.sal.codegen.EnumValues;
import org.lsst.sal.codegen.JavaClassWriter;
import org.lsst.sal.codegen.SalWriter;
import org.lsst.sal.codegen.TestWriter;
import org.lsst.sal.codegen.XMLReader;
import org.xml.sax.SAXException;

public class JavaFromXML {
    private final CodegenMojo mojo;

    JavaFromXML(CodegenMojo mojo) {
        this.mojo = mojo;
    }

    void execute() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        XMLReader reader = new XMLReader(this.mojo);
        XMLReader.XMLReaderResult result = new XMLReader.XMLReaderResult();
        for (URL xmlURL : this.mojo.getXMLs()) {
            result.addAll(reader.read(builder, xmlURL, this.mojo.getBasePackageName()));
        }
        XMLReader.XMLReaderResult inheritedResult = new XMLReader.XMLReaderResult();
        List<URL> xmlInheritURLs = this.mojo.getInheritXMLs();
        for (URL uRL : xmlInheritURLs) {
            inheritedResult.addAll(reader.read(builder, uRL, this.mojo.getInheritPackageName()));
        }
        for (ClassInfo classInfo : result.getClasses()) {
            classInfo.checkIfCanInherit(inheritedResult.getClasses());
        }
        String packageName = this.mojo.getBasePackageName() + ".enumeration";
        for (Map.Entry<String, EnumValues> entry : result.getGlobalEnumerations().entrySet()) {
            JavaClassWriter.writeEnumeration(this.mojo.getOutputDir().getAbsolutePath(), packageName, entry);
        }
        for (ClassInfo classInfo : result.getClasses()) {
            if (classInfo.isInherited()) continue;
            JavaClassWriter writer = new JavaClassWriter(classInfo);
            writer.writeClasses(this.mojo.getOutputDir().getAbsolutePath());
        }
        SalWriter salWriter = new SalWriter(result.getClasses(), this.mojo);
        salWriter.writeSalFile();
        TestWriter testWriter = new TestWriter(result.getClasses(), this.mojo.getBasePackageName(), this.mojo.getSalMain());
        testWriter.writeTestFiles(this.mojo.getTestOutputDir().getAbsolutePath());
    }

    static String capitalize(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    static enum ClassType {
        TELEMETRY("SALTelemetry"),
        STATE("SALEvent"),
        EVENT("SALEvent"),
        COMMAND("SALCommand");

        private final String tag;

        private ClassType(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

