package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_TurboTelemetry extends CameraTelemetry {
  private final double cntrlrAirTemperature;

  private final double cntrlrSinkTemperature;

  private final double current;

  private final double driveFrequency;

  private final double power;

  private final double pumpTemperature;

  private final double rpm;

  private final double status;

  private final double voltage;

  public Vacuum_TurboTelemetry(double cntrlrAirTemperature, double cntrlrSinkTemperature,
      double current, double driveFrequency, double power, double pumpTemperature, double rpm,
      double status, double voltage) {
    this.cntrlrAirTemperature = cntrlrAirTemperature;
    this.cntrlrSinkTemperature = cntrlrSinkTemperature;
    this.current = current;
    this.driveFrequency = driveFrequency;
    this.power = power;
    this.pumpTemperature = pumpTemperature;
    this.rpm = rpm;
    this.status = status;
    this.voltage = voltage;
  }

  public double getCntrlrAirTemperature() {
    return cntrlrAirTemperature;
  }

  public double getCntrlrSinkTemperature() {
    return cntrlrSinkTemperature;
  }

  public double getCurrent() {
    return current;
  }

  public double getDriveFrequency() {
    return driveFrequency;
  }

  public double getPower() {
    return power;
  }

  public double getPumpTemperature() {
    return pumpTemperature;
  }

  public double getRpm() {
    return rpm;
  }

  public double getStatus() {
    return status;
  }

  public double getVoltage() {
    return voltage;
  }

  @Override
  public String toString() {
    return "Vacuum_TurboTelemetry{" + "cntrlrAirTemperature=" + cntrlrAirTemperature +
        ", cntrlrSinkTemperature=" + cntrlrSinkTemperature +", current=" + current +
        ", driveFrequency=" + driveFrequency +", power=" + power +
        ", pumpTemperature=" + pumpTemperature +", rpm=" + rpm +", status=" + status +
        ", voltage=" + voltage +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double cntrlrAirTemperature;

    private double cntrlrSinkTemperature;

    private double current;

    private double driveFrequency;

    private double power;

    private double pumpTemperature;

    private double rpm;

    private double status;

    private double voltage;

    private Builder() {
    }

    public Builder cntrlrAirTemperature(double cntrlrAirTemperature) {
      this.cntrlrAirTemperature = cntrlrAirTemperature;
      return this;
    }

    public Builder cntrlrSinkTemperature(double cntrlrSinkTemperature) {
      this.cntrlrSinkTemperature = cntrlrSinkTemperature;
      return this;
    }

    public Builder current(double current) {
      this.current = current;
      return this;
    }

    public Builder driveFrequency(double driveFrequency) {
      this.driveFrequency = driveFrequency;
      return this;
    }

    public Builder power(double power) {
      this.power = power;
      return this;
    }

    public Builder pumpTemperature(double pumpTemperature) {
      this.pumpTemperature = pumpTemperature;
      return this;
    }

    public Builder rpm(double rpm) {
      this.rpm = rpm;
      return this;
    }

    public Builder status(double status) {
      this.status = status;
      return this;
    }

    public Builder voltage(double voltage) {
      this.voltage = voltage;
      return this;
    }

    public Vacuum_TurboTelemetry build() {
      return new Vacuum_TurboTelemetry(cntrlrAirTemperature, cntrlrSinkTemperature, current, driveFrequency, power, pumpTemperature, rpm, status, voltage);
    }
  }
}
