package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_CryoTelemetry extends CameraTelemetry {
  private final double autoOffEnabled;

  private final double autoOffTemperature;

  private final double autoOnTemperature;

  private final double power;

  private final double rejectTemperature;

  private final double setPower;

  private final double setpoint;

  private final double temperature;

  public Vacuum_CryoTelemetry(double autoOffEnabled, double autoOffTemperature,
      double autoOnTemperature, double power, double rejectTemperature, double setPower,
      double setpoint, double temperature) {
    this.autoOffEnabled = autoOffEnabled;
    this.autoOffTemperature = autoOffTemperature;
    this.autoOnTemperature = autoOnTemperature;
    this.power = power;
    this.rejectTemperature = rejectTemperature;
    this.setPower = setPower;
    this.setpoint = setpoint;
    this.temperature = temperature;
  }

  public double getAutoOffEnabled() {
    return autoOffEnabled;
  }

  public double getAutoOffTemperature() {
    return autoOffTemperature;
  }

  public double getAutoOnTemperature() {
    return autoOnTemperature;
  }

  public double getPower() {
    return power;
  }

  public double getRejectTemperature() {
    return rejectTemperature;
  }

  public double getSetPower() {
    return setPower;
  }

  public double getSetpoint() {
    return setpoint;
  }

  public double getTemperature() {
    return temperature;
  }

  @Override
  public String toString() {
    return "Vacuum_CryoTelemetry{" + "autoOffEnabled=" + autoOffEnabled +
        ", autoOffTemperature=" + autoOffTemperature +", autoOnTemperature=" + autoOnTemperature +
        ", power=" + power +", rejectTemperature=" + rejectTemperature +", setPower=" + setPower +
        ", setpoint=" + setpoint +", temperature=" + temperature +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double autoOffEnabled;

    private double autoOffTemperature;

    private double autoOnTemperature;

    private double power;

    private double rejectTemperature;

    private double setPower;

    private double setpoint;

    private double temperature;

    private Builder() {
    }

    public Builder autoOffEnabled(double autoOffEnabled) {
      this.autoOffEnabled = autoOffEnabled;
      return this;
    }

    public Builder autoOffTemperature(double autoOffTemperature) {
      this.autoOffTemperature = autoOffTemperature;
      return this;
    }

    public Builder autoOnTemperature(double autoOnTemperature) {
      this.autoOnTemperature = autoOnTemperature;
      return this;
    }

    public Builder power(double power) {
      this.power = power;
      return this;
    }

    public Builder rejectTemperature(double rejectTemperature) {
      this.rejectTemperature = rejectTemperature;
      return this;
    }

    public Builder setPower(double setPower) {
      this.setPower = setPower;
      return this;
    }

    public Builder setpoint(double setpoint) {
      this.setpoint = setpoint;
      return this;
    }

    public Builder temperature(double temperature) {
      this.temperature = temperature;
      return this;
    }

    public Vacuum_CryoTelemetry build() {
      return new Vacuum_CryoTelemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature);
    }
  }
}
