package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FitsFilesWrittenEvent extends CameraEvent {
  private final String imageName;

  private final double timestampFilesWritten;

  private final String rootFileName;

  private final String relativeFileNames;

  private final String fileNode;

  public FitsFilesWrittenEvent(String imageName, double timestampFilesWritten, String rootFileName,
      String relativeFileNames, String fileNode) {
    this.imageName = imageName;
    this.timestampFilesWritten = timestampFilesWritten;
    this.rootFileName = rootFileName;
    this.relativeFileNames = relativeFileNames;
    this.fileNode = fileNode;
  }

  public String getImageName() {
    return imageName;
  }

  public double getTimestampFilesWritten() {
    return timestampFilesWritten;
  }

  public String getRootFileName() {
    return rootFileName;
  }

  public String getRelativeFileNames() {
    return relativeFileNames;
  }

  public String getFileNode() {
    return fileNode;
  }

  @Override
  public String toString() {
    return "FitsFilesWrittenEvent{" + "imageName=" + imageName +
        ", timestampFilesWritten=" + timestampFilesWritten +", rootFileName=" + rootFileName +
        ", relativeFileNames=" + relativeFileNames +", fileNode=" + fileNode +"}";
  }
}
