package org.lsst.sal.cccamera.event;

import java.util.Arrays;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

public class ShutterBladeMotionProfileEvent extends CameraEvent {
  private final Blade blade;

  private final Direction direction;

  private final double timestampStart;

  private final double startPosition;

  private final double targetDuration;

  private final double targetPosition;

  private final double endPosition;

  private final double actualDuration;

  private final int hallSensorCount;

  private final double[] timestampHallSensor;

  private final int[] hallSensorID;

  private final double[] hallSensorPosition;

  private final boolean[] hallSensorTransition;

  private final int encoderCount;

  private final double[] timestampEncoder;

  private final double[] encoderPosition;

  public ShutterBladeMotionProfileEvent(int priority, Blade blade, Direction direction,
      double timestampStart, double startPosition, double targetDuration, double targetPosition,
      double endPosition, double actualDuration, int hallSensorCount, double[] timestampHallSensor,
      int[] hallSensorID, double[] hallSensorPosition, boolean[] hallSensorTransition,
      int encoderCount, double[] timestampEncoder, double[] encoderPosition) {
    super (priority);
    this.blade = blade;
    this.direction = direction;
    this.timestampStart = timestampStart;
    this.startPosition = startPosition;
    this.targetDuration = targetDuration;
    this.targetPosition = targetPosition;
    this.endPosition = endPosition;
    this.actualDuration = actualDuration;
    this.hallSensorCount = hallSensorCount;
    this.timestampHallSensor = timestampHallSensor;
    this.hallSensorID = hallSensorID;
    this.hallSensorPosition = hallSensorPosition;
    this.hallSensorTransition = hallSensorTransition;
    this.encoderCount = encoderCount;
    this.timestampEncoder = timestampEncoder;
    this.encoderPosition = encoderPosition;
  }

  public Blade getBlade() {
    return blade;
  }

  public Direction getDirection() {
    return direction;
  }

  public double getTimestampStart() {
    return timestampStart;
  }

  public double getStartPosition() {
    return startPosition;
  }

  public double getTargetDuration() {
    return targetDuration;
  }

  public double getTargetPosition() {
    return targetPosition;
  }

  public double getEndPosition() {
    return endPosition;
  }

  public double getActualDuration() {
    return actualDuration;
  }

  public int getHallSensorCount() {
    return hallSensorCount;
  }

  public double[] getTimestampHallSensor() {
    return timestampHallSensor;
  }

  public int[] getHallSensorID() {
    return hallSensorID;
  }

  public double[] getHallSensorPosition() {
    return hallSensorPosition;
  }

  public boolean[] getHallSensorTransition() {
    return hallSensorTransition;
  }

  public int getEncoderCount() {
    return encoderCount;
  }

  public double[] getTimestampEncoder() {
    return timestampEncoder;
  }

  public double[] getEncoderPosition() {
    return encoderPosition;
  }

  @Override
  public String toString() {
    return "ShutterBladeMotionProfileEvent{" + "blade=" + blade +", direction=" + direction +
        ", timestampStart=" + timestampStart +", startPosition=" + startPosition +
        ", targetDuration=" + targetDuration +", targetPosition=" + targetPosition +
        ", endPosition=" + endPosition +", actualDuration=" + actualDuration +
        ", hallSensorCount=" + hallSensorCount +
        ", timestampHallSensor=" + Arrays.toString(timestampHallSensor) +
        ", hallSensorID=" + Arrays.toString(hallSensorID) +
        ", hallSensorPosition=" + Arrays.toString(hallSensorPosition) +
        ", hallSensorTransition=" + Arrays.toString(hallSensorTransition) +
        ", encoderCount=" + encoderCount +
        ", timestampEncoder=" + Arrays.toString(timestampEncoder) +
        ", encoderPosition=" + Arrays.toString(encoderPosition) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public enum Direction implements SALEnum {
    OPEN,

    CLOSE
  }

  public enum Blade implements SALEnum {
    PLUS_X,

    MINUS_X
  }

  public static class Builder {
    private int priority;

    private Blade blade;

    private Direction direction;

    private double timestampStart;

    private double startPosition;

    private double targetDuration;

    private double targetPosition;

    private double endPosition;

    private double actualDuration;

    private int hallSensorCount;

    private double[] timestampHallSensor;

    private int[] hallSensorID;

    private double[] hallSensorPosition;

    private boolean[] hallSensorTransition;

    private int encoderCount;

    private double[] timestampEncoder;

    private double[] encoderPosition;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder blade(Blade blade) {
      this.blade = blade;
      return this;
    }

    public Builder direction(Direction direction) {
      this.direction = direction;
      return this;
    }

    public Builder timestampStart(double timestampStart) {
      this.timestampStart = timestampStart;
      return this;
    }

    public Builder startPosition(double startPosition) {
      this.startPosition = startPosition;
      return this;
    }

    public Builder targetDuration(double targetDuration) {
      this.targetDuration = targetDuration;
      return this;
    }

    public Builder targetPosition(double targetPosition) {
      this.targetPosition = targetPosition;
      return this;
    }

    public Builder endPosition(double endPosition) {
      this.endPosition = endPosition;
      return this;
    }

    public Builder actualDuration(double actualDuration) {
      this.actualDuration = actualDuration;
      return this;
    }

    public Builder hallSensorCount(int hallSensorCount) {
      this.hallSensorCount = hallSensorCount;
      return this;
    }

    public Builder timestampHallSensor(double[] timestampHallSensor) {
      this.timestampHallSensor = timestampHallSensor;
      return this;
    }

    public Builder hallSensorID(int[] hallSensorID) {
      this.hallSensorID = hallSensorID;
      return this;
    }

    public Builder hallSensorPosition(double[] hallSensorPosition) {
      this.hallSensorPosition = hallSensorPosition;
      return this;
    }

    public Builder hallSensorTransition(boolean[] hallSensorTransition) {
      this.hallSensorTransition = hallSensorTransition;
      return this;
    }

    public Builder encoderCount(int encoderCount) {
      this.encoderCount = encoderCount;
      return this;
    }

    public Builder timestampEncoder(double[] timestampEncoder) {
      this.timestampEncoder = timestampEncoder;
      return this;
    }

    public Builder encoderPosition(double[] encoderPosition) {
      this.encoderPosition = encoderPosition;
      return this;
    }

    public ShutterBladeMotionProfileEvent build() {
      return new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition);
    }
  }
}
