package org.lsst.sal.cccamera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneRebRaftsSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final double[] bias0_csGateP;

  private final double[] bias0_gdP;

  private final double[] bias0_odP;

  private final double[] bias0_ogP;

  private final double[] bias0_rdP;

  private final double[] bias1_csGateP;

  private final double[] bias1_gdP;

  private final double[] bias1_odP;

  private final double[] bias1_ogP;

  private final double[] bias1_rdP;

  private final double[] bias2_csGateP;

  private final double[] bias2_gdP;

  private final double[] bias2_odP;

  private final double[] bias2_ogP;

  private final double[] bias2_rdP;

  private final double[] dac_pclkHighP;

  private final double[] dac_pclkLowP;

  private final double[] dac_rgHighP;

  private final double[] dac_rgLowP;

  private final double[] dac_sclkHighP;

  private final double[] dac_sclkLowP;

  private final boolean[] disableRTDHardwareCheck;

  private final String location;

  private final int[] serialNum;

  public FocalPlaneRebRaftsSettingsAppliedEvent(int priority, int version, double[] bias0_csGateP,
      double[] bias0_gdP, double[] bias0_odP, double[] bias0_ogP, double[] bias0_rdP,
      double[] bias1_csGateP, double[] bias1_gdP, double[] bias1_odP, double[] bias1_ogP,
      double[] bias1_rdP, double[] bias2_csGateP, double[] bias2_gdP, double[] bias2_odP,
      double[] bias2_ogP, double[] bias2_rdP, double[] dac_pclkHighP, double[] dac_pclkLowP,
      double[] dac_rgHighP, double[] dac_rgLowP, double[] dac_sclkHighP, double[] dac_sclkLowP,
      boolean[] disableRTDHardwareCheck, String location, int[] serialNum) {
    super (priority);
    this.version = version;
    this.bias0_csGateP = bias0_csGateP;
    this.bias0_gdP = bias0_gdP;
    this.bias0_odP = bias0_odP;
    this.bias0_ogP = bias0_ogP;
    this.bias0_rdP = bias0_rdP;
    this.bias1_csGateP = bias1_csGateP;
    this.bias1_gdP = bias1_gdP;
    this.bias1_odP = bias1_odP;
    this.bias1_ogP = bias1_ogP;
    this.bias1_rdP = bias1_rdP;
    this.bias2_csGateP = bias2_csGateP;
    this.bias2_gdP = bias2_gdP;
    this.bias2_odP = bias2_odP;
    this.bias2_ogP = bias2_ogP;
    this.bias2_rdP = bias2_rdP;
    this.dac_pclkHighP = dac_pclkHighP;
    this.dac_pclkLowP = dac_pclkLowP;
    this.dac_rgHighP = dac_rgHighP;
    this.dac_rgLowP = dac_rgLowP;
    this.dac_sclkHighP = dac_sclkHighP;
    this.dac_sclkLowP = dac_sclkLowP;
    this.disableRTDHardwareCheck = disableRTDHardwareCheck;
    this.location = location;
    this.serialNum = serialNum;
  }

  public int getVersion() {
    return version;
  }

  public double[] getBias0_csGateP() {
    return bias0_csGateP;
  }

  public double[] getBias0_gdP() {
    return bias0_gdP;
  }

  public double[] getBias0_odP() {
    return bias0_odP;
  }

  public double[] getBias0_ogP() {
    return bias0_ogP;
  }

  public double[] getBias0_rdP() {
    return bias0_rdP;
  }

  public double[] getBias1_csGateP() {
    return bias1_csGateP;
  }

  public double[] getBias1_gdP() {
    return bias1_gdP;
  }

  public double[] getBias1_odP() {
    return bias1_odP;
  }

  public double[] getBias1_ogP() {
    return bias1_ogP;
  }

  public double[] getBias1_rdP() {
    return bias1_rdP;
  }

  public double[] getBias2_csGateP() {
    return bias2_csGateP;
  }

  public double[] getBias2_gdP() {
    return bias2_gdP;
  }

  public double[] getBias2_odP() {
    return bias2_odP;
  }

  public double[] getBias2_ogP() {
    return bias2_ogP;
  }

  public double[] getBias2_rdP() {
    return bias2_rdP;
  }

  public double[] getDac_pclkHighP() {
    return dac_pclkHighP;
  }

  public double[] getDac_pclkLowP() {
    return dac_pclkLowP;
  }

  public double[] getDac_rgHighP() {
    return dac_rgHighP;
  }

  public double[] getDac_rgLowP() {
    return dac_rgLowP;
  }

  public double[] getDac_sclkHighP() {
    return dac_sclkHighP;
  }

  public double[] getDac_sclkLowP() {
    return dac_sclkLowP;
  }

  public boolean[] getDisableRTDHardwareCheck() {
    return disableRTDHardwareCheck;
  }

  public String getLocation() {
    return location;
  }

  public int[] getSerialNum() {
    return serialNum;
  }

  @Override
  public String toString() {
    return "FocalPlaneRebRaftsSettingsAppliedEvent{" + "version=" + version +
        ", bias0_csGateP=" + Arrays.toString(bias0_csGateP) +
        ", bias0_gdP=" + Arrays.toString(bias0_gdP) +", bias0_odP=" + Arrays.toString(bias0_odP) +
        ", bias0_ogP=" + Arrays.toString(bias0_ogP) +", bias0_rdP=" + Arrays.toString(bias0_rdP) +
        ", bias1_csGateP=" + Arrays.toString(bias1_csGateP) +
        ", bias1_gdP=" + Arrays.toString(bias1_gdP) +", bias1_odP=" + Arrays.toString(bias1_odP) +
        ", bias1_ogP=" + Arrays.toString(bias1_ogP) +", bias1_rdP=" + Arrays.toString(bias1_rdP) +
        ", bias2_csGateP=" + Arrays.toString(bias2_csGateP) +
        ", bias2_gdP=" + Arrays.toString(bias2_gdP) +", bias2_odP=" + Arrays.toString(bias2_odP) +
        ", bias2_ogP=" + Arrays.toString(bias2_ogP) +", bias2_rdP=" + Arrays.toString(bias2_rdP) +
        ", dac_pclkHighP=" + Arrays.toString(dac_pclkHighP) +
        ", dac_pclkLowP=" + Arrays.toString(dac_pclkLowP) +
        ", dac_rgHighP=" + Arrays.toString(dac_rgHighP) +
        ", dac_rgLowP=" + Arrays.toString(dac_rgLowP) +
        ", dac_sclkHighP=" + Arrays.toString(dac_sclkHighP) +
        ", dac_sclkLowP=" + Arrays.toString(dac_sclkLowP) +
        ", disableRTDHardwareCheck=" + Arrays.toString(disableRTDHardwareCheck) +
        ", location=" + location +", serialNum=" + Arrays.toString(serialNum) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private double[] bias0_csGateP;

    private double[] bias0_gdP;

    private double[] bias0_odP;

    private double[] bias0_ogP;

    private double[] bias0_rdP;

    private double[] bias1_csGateP;

    private double[] bias1_gdP;

    private double[] bias1_odP;

    private double[] bias1_ogP;

    private double[] bias1_rdP;

    private double[] bias2_csGateP;

    private double[] bias2_gdP;

    private double[] bias2_odP;

    private double[] bias2_ogP;

    private double[] bias2_rdP;

    private double[] dac_pclkHighP;

    private double[] dac_pclkLowP;

    private double[] dac_rgHighP;

    private double[] dac_rgLowP;

    private double[] dac_sclkHighP;

    private double[] dac_sclkLowP;

    private boolean[] disableRTDHardwareCheck;

    private String location;

    private int[] serialNum;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder bias0_csGateP(double[] bias0_csGateP) {
      this.bias0_csGateP = bias0_csGateP;
      return this;
    }

    public Builder bias0_gdP(double[] bias0_gdP) {
      this.bias0_gdP = bias0_gdP;
      return this;
    }

    public Builder bias0_odP(double[] bias0_odP) {
      this.bias0_odP = bias0_odP;
      return this;
    }

    public Builder bias0_ogP(double[] bias0_ogP) {
      this.bias0_ogP = bias0_ogP;
      return this;
    }

    public Builder bias0_rdP(double[] bias0_rdP) {
      this.bias0_rdP = bias0_rdP;
      return this;
    }

    public Builder bias1_csGateP(double[] bias1_csGateP) {
      this.bias1_csGateP = bias1_csGateP;
      return this;
    }

    public Builder bias1_gdP(double[] bias1_gdP) {
      this.bias1_gdP = bias1_gdP;
      return this;
    }

    public Builder bias1_odP(double[] bias1_odP) {
      this.bias1_odP = bias1_odP;
      return this;
    }

    public Builder bias1_ogP(double[] bias1_ogP) {
      this.bias1_ogP = bias1_ogP;
      return this;
    }

    public Builder bias1_rdP(double[] bias1_rdP) {
      this.bias1_rdP = bias1_rdP;
      return this;
    }

    public Builder bias2_csGateP(double[] bias2_csGateP) {
      this.bias2_csGateP = bias2_csGateP;
      return this;
    }

    public Builder bias2_gdP(double[] bias2_gdP) {
      this.bias2_gdP = bias2_gdP;
      return this;
    }

    public Builder bias2_odP(double[] bias2_odP) {
      this.bias2_odP = bias2_odP;
      return this;
    }

    public Builder bias2_ogP(double[] bias2_ogP) {
      this.bias2_ogP = bias2_ogP;
      return this;
    }

    public Builder bias2_rdP(double[] bias2_rdP) {
      this.bias2_rdP = bias2_rdP;
      return this;
    }

    public Builder dac_pclkHighP(double[] dac_pclkHighP) {
      this.dac_pclkHighP = dac_pclkHighP;
      return this;
    }

    public Builder dac_pclkLowP(double[] dac_pclkLowP) {
      this.dac_pclkLowP = dac_pclkLowP;
      return this;
    }

    public Builder dac_rgHighP(double[] dac_rgHighP) {
      this.dac_rgHighP = dac_rgHighP;
      return this;
    }

    public Builder dac_rgLowP(double[] dac_rgLowP) {
      this.dac_rgLowP = dac_rgLowP;
      return this;
    }

    public Builder dac_sclkHighP(double[] dac_sclkHighP) {
      this.dac_sclkHighP = dac_sclkHighP;
      return this;
    }

    public Builder dac_sclkLowP(double[] dac_sclkLowP) {
      this.dac_sclkLowP = dac_sclkLowP;
      return this;
    }

    public Builder disableRTDHardwareCheck(boolean[] disableRTDHardwareCheck) {
      this.disableRTDHardwareCheck = disableRTDHardwareCheck;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder serialNum(int[] serialNum) {
      this.serialNum = serialNum;
      return this;
    }

    public FocalPlaneRebRaftsSettingsAppliedEvent build() {
      return new FocalPlaneRebRaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum);
    }
  }
}
