package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneDAQSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String daqFolder;

  private final String daqPartition;

  private final boolean emulatedDAQ;

  public FocalPlaneDAQSettingsAppliedEvent(int priority, int version, String daqFolder,
      String daqPartition, boolean emulatedDAQ) {
    super (priority);
    this.version = version;
    this.daqFolder = daqFolder;
    this.daqPartition = daqPartition;
    this.emulatedDAQ = emulatedDAQ;
  }

  public int getVersion() {
    return version;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public String getDaqPartition() {
    return daqPartition;
  }

  public boolean isEmulatedDAQ() {
    return emulatedDAQ;
  }

  @Override
  public String toString() {
    return "FocalPlaneDAQSettingsAppliedEvent{" + "version=" + version +", daqFolder=" + daqFolder +
        ", daqPartition=" + daqPartition +", emulatedDAQ=" + emulatedDAQ +"}";
  }
}
