package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_Socket5Telemetry extends CameraTelemetry {
  private final boolean atStandby;

  private final boolean carouselMoving;

  private final String clampsState;

  private final int deltaPosition;

  private final boolean empty;

  private final int filterID;

  private final String filterName;

  private final String slaveStatus;

  private final int socketID;

  public Fcs_Socket5Telemetry(boolean atStandby, boolean carouselMoving, String clampsState,
      int deltaPosition, boolean empty, int filterID, String filterName, String slaveStatus,
      int socketID) {
    this.atStandby = atStandby;
    this.carouselMoving = carouselMoving;
    this.clampsState = clampsState;
    this.deltaPosition = deltaPosition;
    this.empty = empty;
    this.filterID = filterID;
    this.filterName = filterName;
    this.slaveStatus = slaveStatus;
    this.socketID = socketID;
  }

  public boolean isAtStandby() {
    return atStandby;
  }

  public boolean isCarouselMoving() {
    return carouselMoving;
  }

  public String getClampsState() {
    return clampsState;
  }

  public int getDeltaPosition() {
    return deltaPosition;
  }

  public boolean isEmpty() {
    return empty;
  }

  public int getFilterID() {
    return filterID;
  }

  public String getFilterName() {
    return filterName;
  }

  public String getSlaveStatus() {
    return slaveStatus;
  }

  public int getSocketID() {
    return socketID;
  }

  @Override
  public String toString() {
    return "Fcs_Socket5Telemetry{" + "atStandby=" + atStandby +
        ", carouselMoving=" + carouselMoving +", clampsState=" + clampsState +
        ", deltaPosition=" + deltaPosition +", empty=" + empty +", filterID=" + filterID +
        ", filterName=" + filterName +", slaveStatus=" + slaveStatus +", socketID=" + socketID +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean atStandby;

    private boolean carouselMoving;

    private String clampsState;

    private int deltaPosition;

    private boolean empty;

    private int filterID;

    private String filterName;

    private String slaveStatus;

    private int socketID;

    private Builder() {
    }

    public Builder atStandby(boolean atStandby) {
      this.atStandby = atStandby;
      return this;
    }

    public Builder carouselMoving(boolean carouselMoving) {
      this.carouselMoving = carouselMoving;
      return this;
    }

    public Builder clampsState(String clampsState) {
      this.clampsState = clampsState;
      return this;
    }

    public Builder deltaPosition(int deltaPosition) {
      this.deltaPosition = deltaPosition;
      return this;
    }

    public Builder empty(boolean empty) {
      this.empty = empty;
      return this;
    }

    public Builder filterID(int filterID) {
      this.filterID = filterID;
      return this;
    }

    public Builder filterName(String filterName) {
      this.filterName = filterName;
      return this;
    }

    public Builder slaveStatus(String slaveStatus) {
      this.slaveStatus = slaveStatus;
      return this;
    }

    public Builder socketID(int socketID) {
      this.socketID = socketID;
      return this;
    }

    public Fcs_Socket5Telemetry build() {
      return new Fcs_Socket5Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID);
    }
  }
}
