package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_RuntimeInfoTelemetry extends CameraTelemetry {
  private final long freeMemory;

  private final long maxMemory;

  private final int nThreads;

  private final double processCpuLoad;

  private final double systemCpuLoad;

  private final long totalMemory;

  private final int uptime;

  public Fcs_RuntimeInfoTelemetry(long freeMemory, long maxMemory, int nThreads,
      double processCpuLoad, double systemCpuLoad, long totalMemory, int uptime) {
    this.freeMemory = freeMemory;
    this.maxMemory = maxMemory;
    this.nThreads = nThreads;
    this.processCpuLoad = processCpuLoad;
    this.systemCpuLoad = systemCpuLoad;
    this.totalMemory = totalMemory;
    this.uptime = uptime;
  }

  public long getFreeMemory() {
    return freeMemory;
  }

  public long getMaxMemory() {
    return maxMemory;
  }

  public int getNThreads() {
    return nThreads;
  }

  public double getProcessCpuLoad() {
    return processCpuLoad;
  }

  public double getSystemCpuLoad() {
    return systemCpuLoad;
  }

  public long getTotalMemory() {
    return totalMemory;
  }

  public int getUptime() {
    return uptime;
  }

  @Override
  public String toString() {
    return "Fcs_RuntimeInfoTelemetry{" + "freeMemory=" + freeMemory +", maxMemory=" + maxMemory +
        ", nThreads=" + nThreads +", processCpuLoad=" + processCpuLoad +
        ", systemCpuLoad=" + systemCpuLoad +", totalMemory=" + totalMemory +", uptime=" + uptime +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private long freeMemory;

    private long maxMemory;

    private int nThreads;

    private double processCpuLoad;

    private double systemCpuLoad;

    private long totalMemory;

    private int uptime;

    private Builder() {
    }

    public Builder freeMemory(long freeMemory) {
      this.freeMemory = freeMemory;
      return this;
    }

    public Builder maxMemory(long maxMemory) {
      this.maxMemory = maxMemory;
      return this;
    }

    public Builder nThreads(int nThreads) {
      this.nThreads = nThreads;
      return this;
    }

    public Builder processCpuLoad(double processCpuLoad) {
      this.processCpuLoad = processCpuLoad;
      return this;
    }

    public Builder systemCpuLoad(double systemCpuLoad) {
      this.systemCpuLoad = systemCpuLoad;
      return this;
    }

    public Builder totalMemory(long totalMemory) {
      this.totalMemory = totalMemory;
      return this;
    }

    public Builder uptime(int uptime) {
      this.uptime = uptime;
      return this;
    }

    public Fcs_RuntimeInfoTelemetry build() {
      return new Fcs_RuntimeInfoTelemetry(freeMemory, maxMemory, nThreads, processCpuLoad, systemCpuLoad, totalMemory, uptime);
    }
  }
}
