package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_OnlineClampXplusTelemetry extends CameraTelemetry {
  private final boolean controllerBooted;

  private final boolean controllerInFault;

  private final int current;

  private final boolean homingDone;

  private final boolean inError;

  private final boolean lockSensorInError;

  private final boolean lockSensorValue;

  private final String lockStatus;

  private final int position;

  private final int sentCurrent;

  private final boolean unlockSensorInError;

  private final boolean unlockSensorValue;

  public Fcs_OnlineClampXplusTelemetry(boolean controllerBooted, boolean controllerInFault,
      int current, boolean homingDone, boolean inError, boolean lockSensorInError,
      boolean lockSensorValue, String lockStatus, int position, int sentCurrent,
      boolean unlockSensorInError, boolean unlockSensorValue) {
    this.controllerBooted = controllerBooted;
    this.controllerInFault = controllerInFault;
    this.current = current;
    this.homingDone = homingDone;
    this.inError = inError;
    this.lockSensorInError = lockSensorInError;
    this.lockSensorValue = lockSensorValue;
    this.lockStatus = lockStatus;
    this.position = position;
    this.sentCurrent = sentCurrent;
    this.unlockSensorInError = unlockSensorInError;
    this.unlockSensorValue = unlockSensorValue;
  }

  public boolean isControllerBooted() {
    return controllerBooted;
  }

  public boolean isControllerInFault() {
    return controllerInFault;
  }

  public int getCurrent() {
    return current;
  }

  public boolean isHomingDone() {
    return homingDone;
  }

  public boolean isInError() {
    return inError;
  }

  public boolean isLockSensorInError() {
    return lockSensorInError;
  }

  public boolean isLockSensorValue() {
    return lockSensorValue;
  }

  public String getLockStatus() {
    return lockStatus;
  }

  public int getPosition() {
    return position;
  }

  public int getSentCurrent() {
    return sentCurrent;
  }

  public boolean isUnlockSensorInError() {
    return unlockSensorInError;
  }

  public boolean isUnlockSensorValue() {
    return unlockSensorValue;
  }

  @Override
  public String toString() {
    return "Fcs_OnlineClampXplusTelemetry{" + "controllerBooted=" + controllerBooted +
        ", controllerInFault=" + controllerInFault +", current=" + current +
        ", homingDone=" + homingDone +", inError=" + inError +
        ", lockSensorInError=" + lockSensorInError +", lockSensorValue=" + lockSensorValue +
        ", lockStatus=" + lockStatus +", position=" + position +", sentCurrent=" + sentCurrent +
        ", unlockSensorInError=" + unlockSensorInError +", unlockSensorValue=" + unlockSensorValue +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean controllerBooted;

    private boolean controllerInFault;

    private int current;

    private boolean homingDone;

    private boolean inError;

    private boolean lockSensorInError;

    private boolean lockSensorValue;

    private String lockStatus;

    private int position;

    private int sentCurrent;

    private boolean unlockSensorInError;

    private boolean unlockSensorValue;

    private Builder() {
    }

    public Builder controllerBooted(boolean controllerBooted) {
      this.controllerBooted = controllerBooted;
      return this;
    }

    public Builder controllerInFault(boolean controllerInFault) {
      this.controllerInFault = controllerInFault;
      return this;
    }

    public Builder current(int current) {
      this.current = current;
      return this;
    }

    public Builder homingDone(boolean homingDone) {
      this.homingDone = homingDone;
      return this;
    }

    public Builder inError(boolean inError) {
      this.inError = inError;
      return this;
    }

    public Builder lockSensorInError(boolean lockSensorInError) {
      this.lockSensorInError = lockSensorInError;
      return this;
    }

    public Builder lockSensorValue(boolean lockSensorValue) {
      this.lockSensorValue = lockSensorValue;
      return this;
    }

    public Builder lockStatus(String lockStatus) {
      this.lockStatus = lockStatus;
      return this;
    }

    public Builder position(int position) {
      this.position = position;
      return this;
    }

    public Builder sentCurrent(int sentCurrent) {
      this.sentCurrent = sentCurrent;
      return this;
    }

    public Builder unlockSensorInError(boolean unlockSensorInError) {
      this.unlockSensorInError = unlockSensorInError;
      return this;
    }

    public Builder unlockSensorValue(boolean unlockSensorValue) {
      this.unlockSensorValue = unlockSensorValue;
      return this;
    }

    public Fcs_OnlineClampXplusTelemetry build() {
      return new Fcs_OnlineClampXplusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue);
    }
  }
}
