package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_ClampXplus3Telemetry extends CameraTelemetry {
  private final String clampState;

  private final int filterPositionSensorValue;

  private final int filterPresenceMinNoFilter;

  private final int filterPresenceOffset2;

  private final String filterPresenceStatus;

  private final int lockSensorOffset1;

  private final int lockSensorValue;

  private final String lockStatus;

  private final double temperature;

  public Fcs_ClampXplus3Telemetry(String clampState, int filterPositionSensorValue,
      int filterPresenceMinNoFilter, int filterPresenceOffset2, String filterPresenceStatus,
      int lockSensorOffset1, int lockSensorValue, String lockStatus, double temperature) {
    this.clampState = clampState;
    this.filterPositionSensorValue = filterPositionSensorValue;
    this.filterPresenceMinNoFilter = filterPresenceMinNoFilter;
    this.filterPresenceOffset2 = filterPresenceOffset2;
    this.filterPresenceStatus = filterPresenceStatus;
    this.lockSensorOffset1 = lockSensorOffset1;
    this.lockSensorValue = lockSensorValue;
    this.lockStatus = lockStatus;
    this.temperature = temperature;
  }

  public String getClampState() {
    return clampState;
  }

  public int getFilterPositionSensorValue() {
    return filterPositionSensorValue;
  }

  public int getFilterPresenceMinNoFilter() {
    return filterPresenceMinNoFilter;
  }

  public int getFilterPresenceOffset2() {
    return filterPresenceOffset2;
  }

  public String getFilterPresenceStatus() {
    return filterPresenceStatus;
  }

  public int getLockSensorOffset1() {
    return lockSensorOffset1;
  }

  public int getLockSensorValue() {
    return lockSensorValue;
  }

  public String getLockStatus() {
    return lockStatus;
  }

  public double getTemperature() {
    return temperature;
  }

  @Override
  public String toString() {
    return "Fcs_ClampXplus3Telemetry{" + "clampState=" + clampState +
        ", filterPositionSensorValue=" + filterPositionSensorValue +
        ", filterPresenceMinNoFilter=" + filterPresenceMinNoFilter +
        ", filterPresenceOffset2=" + filterPresenceOffset2 +
        ", filterPresenceStatus=" + filterPresenceStatus +
        ", lockSensorOffset1=" + lockSensorOffset1 +", lockSensorValue=" + lockSensorValue +
        ", lockStatus=" + lockStatus +", temperature=" + temperature +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String clampState;

    private int filterPositionSensorValue;

    private int filterPresenceMinNoFilter;

    private int filterPresenceOffset2;

    private String filterPresenceStatus;

    private int lockSensorOffset1;

    private int lockSensorValue;

    private String lockStatus;

    private double temperature;

    private Builder() {
    }

    public Builder clampState(String clampState) {
      this.clampState = clampState;
      return this;
    }

    public Builder filterPositionSensorValue(int filterPositionSensorValue) {
      this.filterPositionSensorValue = filterPositionSensorValue;
      return this;
    }

    public Builder filterPresenceMinNoFilter(int filterPresenceMinNoFilter) {
      this.filterPresenceMinNoFilter = filterPresenceMinNoFilter;
      return this;
    }

    public Builder filterPresenceOffset2(int filterPresenceOffset2) {
      this.filterPresenceOffset2 = filterPresenceOffset2;
      return this;
    }

    public Builder filterPresenceStatus(String filterPresenceStatus) {
      this.filterPresenceStatus = filterPresenceStatus;
      return this;
    }

    public Builder lockSensorOffset1(int lockSensorOffset1) {
      this.lockSensorOffset1 = lockSensorOffset1;
      return this;
    }

    public Builder lockSensorValue(int lockSensorValue) {
      this.lockSensorValue = lockSensorValue;
      return this;
    }

    public Builder lockStatus(String lockStatus) {
      this.lockStatus = lockStatus;
      return this;
    }

    public Builder temperature(double temperature) {
      this.temperature = temperature;
      return this;
    }

    public Fcs_ClampXplus3Telemetry build() {
      return new Fcs_ClampXplus3Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature);
    }
  }
}
