package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_CarouselTelemetry extends CameraTelemetry {
  private final boolean af3;

  private final boolean af3_InError;

  private final boolean ap1;

  private final boolean ap1_InError;

  private final boolean ap2;

  private final boolean ap2_InError;

  private final boolean ap3;

  private final boolean ap3_InError;

  private final boolean atStandby;

  private final String brakeState1;

  private final String brakeState2;

  private final String brakeState3;

  private final boolean brakesActivated;

  private final boolean caEng;

  private final boolean caeng_InError;

  private final boolean caLockout;

  private final boolean calockout_InError;

  private final String clampsStateAtStandby;

  private final double current;

  private final int deltaPositionAtStandby;

  private final boolean emptyAtStandby;

  private final boolean enableBrakes;

  private final boolean enableRotation;

  private final boolean enableShutter;

  private final boolean enableUnclamp;

  private final int estimatedPosition;

  private final String filterAtStandbyName;

  private final String filterOnAutochangerName;

  private final boolean locked;

  private final long minLocked;

  private final boolean moving;

  private final boolean out_CF0;

  private final boolean out_CF0_InError;

  private final boolean out_CF1;

  private final boolean out_CF1_InError;

  private final boolean out_CFC;

  private final boolean out_CFC_InError;

  private final boolean out_CS;

  private final boolean out_CS_InError;

  private final int position;

  private final int positionSensorType;

  private final long profileAcceleration;

  private final long profileDeceleration;

  private final long profileVelocity;

  private final long rotationTimeout;

  private final long sensor1;

  private final long sensor2;

  private final long sensor3;

  private final boolean shutterInactive;

  private final String slaveStatusAtStandby;

  private final boolean sleep;

  private final int socketAtStandbyID;

  private final String socketAtStandbyName;

  private final double temperature1;

  private final double temperature2;

  private final double temperature3;

  private final double temperature4;

  private final boolean tpCheckRotation;

  private final boolean tpStopRotation;

  private final boolean tpStopUnclamp;

  private final boolean tp_InError;

  private final double velocity;

  public Fcs_CarouselTelemetry(boolean af3, boolean af3_InError, boolean ap1, boolean ap1_InError,
      boolean ap2, boolean ap2_InError, boolean ap3, boolean ap3_InError, boolean atStandby,
      String brakeState1, String brakeState2, String brakeState3, boolean brakesActivated,
      boolean caEng, boolean caeng_InError, boolean caLockout, boolean calockout_InError,
      String clampsStateAtStandby, double current, int deltaPositionAtStandby,
      boolean emptyAtStandby, boolean enableBrakes, boolean enableRotation, boolean enableShutter,
      boolean enableUnclamp, int estimatedPosition, String filterAtStandbyName,
      String filterOnAutochangerName, boolean locked, long minLocked, boolean moving,
      boolean out_CF0, boolean out_CF0_InError, boolean out_CF1, boolean out_CF1_InError,
      boolean out_CFC, boolean out_CFC_InError, boolean out_CS, boolean out_CS_InError,
      int position, int positionSensorType, long profileAcceleration, long profileDeceleration,
      long profileVelocity, long rotationTimeout, long sensor1, long sensor2, long sensor3,
      boolean shutterInactive, String slaveStatusAtStandby, boolean sleep, int socketAtStandbyID,
      String socketAtStandbyName, double temperature1, double temperature2, double temperature3,
      double temperature4, boolean tpCheckRotation, boolean tpStopRotation, boolean tpStopUnclamp,
      boolean tp_InError, double velocity) {
    this.af3 = af3;
    this.af3_InError = af3_InError;
    this.ap1 = ap1;
    this.ap1_InError = ap1_InError;
    this.ap2 = ap2;
    this.ap2_InError = ap2_InError;
    this.ap3 = ap3;
    this.ap3_InError = ap3_InError;
    this.atStandby = atStandby;
    this.brakeState1 = brakeState1;
    this.brakeState2 = brakeState2;
    this.brakeState3 = brakeState3;
    this.brakesActivated = brakesActivated;
    this.caEng = caEng;
    this.caeng_InError = caeng_InError;
    this.caLockout = caLockout;
    this.calockout_InError = calockout_InError;
    this.clampsStateAtStandby = clampsStateAtStandby;
    this.current = current;
    this.deltaPositionAtStandby = deltaPositionAtStandby;
    this.emptyAtStandby = emptyAtStandby;
    this.enableBrakes = enableBrakes;
    this.enableRotation = enableRotation;
    this.enableShutter = enableShutter;
    this.enableUnclamp = enableUnclamp;
    this.estimatedPosition = estimatedPosition;
    this.filterAtStandbyName = filterAtStandbyName;
    this.filterOnAutochangerName = filterOnAutochangerName;
    this.locked = locked;
    this.minLocked = minLocked;
    this.moving = moving;
    this.out_CF0 = out_CF0;
    this.out_CF0_InError = out_CF0_InError;
    this.out_CF1 = out_CF1;
    this.out_CF1_InError = out_CF1_InError;
    this.out_CFC = out_CFC;
    this.out_CFC_InError = out_CFC_InError;
    this.out_CS = out_CS;
    this.out_CS_InError = out_CS_InError;
    this.position = position;
    this.positionSensorType = positionSensorType;
    this.profileAcceleration = profileAcceleration;
    this.profileDeceleration = profileDeceleration;
    this.profileVelocity = profileVelocity;
    this.rotationTimeout = rotationTimeout;
    this.sensor1 = sensor1;
    this.sensor2 = sensor2;
    this.sensor3 = sensor3;
    this.shutterInactive = shutterInactive;
    this.slaveStatusAtStandby = slaveStatusAtStandby;
    this.sleep = sleep;
    this.socketAtStandbyID = socketAtStandbyID;
    this.socketAtStandbyName = socketAtStandbyName;
    this.temperature1 = temperature1;
    this.temperature2 = temperature2;
    this.temperature3 = temperature3;
    this.temperature4 = temperature4;
    this.tpCheckRotation = tpCheckRotation;
    this.tpStopRotation = tpStopRotation;
    this.tpStopUnclamp = tpStopUnclamp;
    this.tp_InError = tp_InError;
    this.velocity = velocity;
  }

  public boolean isAf3() {
    return af3;
  }

  public boolean isAf3_InError() {
    return af3_InError;
  }

  public boolean isAp1() {
    return ap1;
  }

  public boolean isAp1_InError() {
    return ap1_InError;
  }

  public boolean isAp2() {
    return ap2;
  }

  public boolean isAp2_InError() {
    return ap2_InError;
  }

  public boolean isAp3() {
    return ap3;
  }

  public boolean isAp3_InError() {
    return ap3_InError;
  }

  public boolean isAtStandby() {
    return atStandby;
  }

  public String getBrakeState1() {
    return brakeState1;
  }

  public String getBrakeState2() {
    return brakeState2;
  }

  public String getBrakeState3() {
    return brakeState3;
  }

  public boolean isBrakesActivated() {
    return brakesActivated;
  }

  public boolean isCaEng() {
    return caEng;
  }

  public boolean isCaeng_InError() {
    return caeng_InError;
  }

  public boolean isCaLockout() {
    return caLockout;
  }

  public boolean isCalockout_InError() {
    return calockout_InError;
  }

  public String getClampsStateAtStandby() {
    return clampsStateAtStandby;
  }

  public double getCurrent() {
    return current;
  }

  public int getDeltaPositionAtStandby() {
    return deltaPositionAtStandby;
  }

  public boolean isEmptyAtStandby() {
    return emptyAtStandby;
  }

  public boolean isEnableBrakes() {
    return enableBrakes;
  }

  public boolean isEnableRotation() {
    return enableRotation;
  }

  public boolean isEnableShutter() {
    return enableShutter;
  }

  public boolean isEnableUnclamp() {
    return enableUnclamp;
  }

  public int getEstimatedPosition() {
    return estimatedPosition;
  }

  public String getFilterAtStandbyName() {
    return filterAtStandbyName;
  }

  public String getFilterOnAutochangerName() {
    return filterOnAutochangerName;
  }

  public boolean isLocked() {
    return locked;
  }

  public long getMinLocked() {
    return minLocked;
  }

  public boolean isMoving() {
    return moving;
  }

  public boolean isOut_CF0() {
    return out_CF0;
  }

  public boolean isOut_CF0_InError() {
    return out_CF0_InError;
  }

  public boolean isOut_CF1() {
    return out_CF1;
  }

  public boolean isOut_CF1_InError() {
    return out_CF1_InError;
  }

  public boolean isOut_CFC() {
    return out_CFC;
  }

  public boolean isOut_CFC_InError() {
    return out_CFC_InError;
  }

  public boolean isOut_CS() {
    return out_CS;
  }

  public boolean isOut_CS_InError() {
    return out_CS_InError;
  }

  public int getPosition() {
    return position;
  }

  public int getPositionSensorType() {
    return positionSensorType;
  }

  public long getProfileAcceleration() {
    return profileAcceleration;
  }

  public long getProfileDeceleration() {
    return profileDeceleration;
  }

  public long getProfileVelocity() {
    return profileVelocity;
  }

  public long getRotationTimeout() {
    return rotationTimeout;
  }

  public long getSensor1() {
    return sensor1;
  }

  public long getSensor2() {
    return sensor2;
  }

  public long getSensor3() {
    return sensor3;
  }

  public boolean isShutterInactive() {
    return shutterInactive;
  }

  public String getSlaveStatusAtStandby() {
    return slaveStatusAtStandby;
  }

  public boolean isSleep() {
    return sleep;
  }

  public int getSocketAtStandbyID() {
    return socketAtStandbyID;
  }

  public String getSocketAtStandbyName() {
    return socketAtStandbyName;
  }

  public double getTemperature1() {
    return temperature1;
  }

  public double getTemperature2() {
    return temperature2;
  }

  public double getTemperature3() {
    return temperature3;
  }

  public double getTemperature4() {
    return temperature4;
  }

  public boolean isTpCheckRotation() {
    return tpCheckRotation;
  }

  public boolean isTpStopRotation() {
    return tpStopRotation;
  }

  public boolean isTpStopUnclamp() {
    return tpStopUnclamp;
  }

  public boolean isTp_InError() {
    return tp_InError;
  }

  public double getVelocity() {
    return velocity;
  }

  @Override
  public String toString() {
    return "Fcs_CarouselTelemetry{" + "af3=" + af3 +", af3_InError=" + af3_InError +", ap1=" + ap1 +
        ", ap1_InError=" + ap1_InError +", ap2=" + ap2 +", ap2_InError=" + ap2_InError +
        ", ap3=" + ap3 +", ap3_InError=" + ap3_InError +", atStandby=" + atStandby +
        ", brakeState1=" + brakeState1 +", brakeState2=" + brakeState2 +
        ", brakeState3=" + brakeState3 +", brakesActivated=" + brakesActivated +", caEng=" + caEng +
        ", caeng_InError=" + caeng_InError +", caLockout=" + caLockout +
        ", calockout_InError=" + calockout_InError +
        ", clampsStateAtStandby=" + clampsStateAtStandby +", current=" + current +
        ", deltaPositionAtStandby=" + deltaPositionAtStandby +", emptyAtStandby=" + emptyAtStandby +
        ", enableBrakes=" + enableBrakes +", enableRotation=" + enableRotation +
        ", enableShutter=" + enableShutter +", enableUnclamp=" + enableUnclamp +
        ", estimatedPosition=" + estimatedPosition +", filterAtStandbyName=" + filterAtStandbyName +
        ", filterOnAutochangerName=" + filterOnAutochangerName +", locked=" + locked +
        ", minLocked=" + minLocked +", moving=" + moving +", out_CF0=" + out_CF0 +
        ", out_CF0_InError=" + out_CF0_InError +", out_CF1=" + out_CF1 +
        ", out_CF1_InError=" + out_CF1_InError +", out_CFC=" + out_CFC +
        ", out_CFC_InError=" + out_CFC_InError +", out_CS=" + out_CS +
        ", out_CS_InError=" + out_CS_InError +", position=" + position +
        ", positionSensorType=" + positionSensorType +
        ", profileAcceleration=" + profileAcceleration +
        ", profileDeceleration=" + profileDeceleration +", profileVelocity=" + profileVelocity +
        ", rotationTimeout=" + rotationTimeout +", sensor1=" + sensor1 +", sensor2=" + sensor2 +
        ", sensor3=" + sensor3 +", shutterInactive=" + shutterInactive +
        ", slaveStatusAtStandby=" + slaveStatusAtStandby +", sleep=" + sleep +
        ", socketAtStandbyID=" + socketAtStandbyID +", socketAtStandbyName=" + socketAtStandbyName +
        ", temperature1=" + temperature1 +", temperature2=" + temperature2 +
        ", temperature3=" + temperature3 +", temperature4=" + temperature4 +
        ", tpCheckRotation=" + tpCheckRotation +", tpStopRotation=" + tpStopRotation +
        ", tpStopUnclamp=" + tpStopUnclamp +", tp_InError=" + tp_InError +", velocity=" + velocity +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean af3;

    private boolean af3_InError;

    private boolean ap1;

    private boolean ap1_InError;

    private boolean ap2;

    private boolean ap2_InError;

    private boolean ap3;

    private boolean ap3_InError;

    private boolean atStandby;

    private String brakeState1;

    private String brakeState2;

    private String brakeState3;

    private boolean brakesActivated;

    private boolean caEng;

    private boolean caeng_InError;

    private boolean caLockout;

    private boolean calockout_InError;

    private String clampsStateAtStandby;

    private double current;

    private int deltaPositionAtStandby;

    private boolean emptyAtStandby;

    private boolean enableBrakes;

    private boolean enableRotation;

    private boolean enableShutter;

    private boolean enableUnclamp;

    private int estimatedPosition;

    private String filterAtStandbyName;

    private String filterOnAutochangerName;

    private boolean locked;

    private long minLocked;

    private boolean moving;

    private boolean out_CF0;

    private boolean out_CF0_InError;

    private boolean out_CF1;

    private boolean out_CF1_InError;

    private boolean out_CFC;

    private boolean out_CFC_InError;

    private boolean out_CS;

    private boolean out_CS_InError;

    private int position;

    private int positionSensorType;

    private long profileAcceleration;

    private long profileDeceleration;

    private long profileVelocity;

    private long rotationTimeout;

    private long sensor1;

    private long sensor2;

    private long sensor3;

    private boolean shutterInactive;

    private String slaveStatusAtStandby;

    private boolean sleep;

    private int socketAtStandbyID;

    private String socketAtStandbyName;

    private double temperature1;

    private double temperature2;

    private double temperature3;

    private double temperature4;

    private boolean tpCheckRotation;

    private boolean tpStopRotation;

    private boolean tpStopUnclamp;

    private boolean tp_InError;

    private double velocity;

    private Builder() {
    }

    public Builder af3(boolean af3) {
      this.af3 = af3;
      return this;
    }

    public Builder af3_InError(boolean af3_InError) {
      this.af3_InError = af3_InError;
      return this;
    }

    public Builder ap1(boolean ap1) {
      this.ap1 = ap1;
      return this;
    }

    public Builder ap1_InError(boolean ap1_InError) {
      this.ap1_InError = ap1_InError;
      return this;
    }

    public Builder ap2(boolean ap2) {
      this.ap2 = ap2;
      return this;
    }

    public Builder ap2_InError(boolean ap2_InError) {
      this.ap2_InError = ap2_InError;
      return this;
    }

    public Builder ap3(boolean ap3) {
      this.ap3 = ap3;
      return this;
    }

    public Builder ap3_InError(boolean ap3_InError) {
      this.ap3_InError = ap3_InError;
      return this;
    }

    public Builder atStandby(boolean atStandby) {
      this.atStandby = atStandby;
      return this;
    }

    public Builder brakeState1(String brakeState1) {
      this.brakeState1 = brakeState1;
      return this;
    }

    public Builder brakeState2(String brakeState2) {
      this.brakeState2 = brakeState2;
      return this;
    }

    public Builder brakeState3(String brakeState3) {
      this.brakeState3 = brakeState3;
      return this;
    }

    public Builder brakesActivated(boolean brakesActivated) {
      this.brakesActivated = brakesActivated;
      return this;
    }

    public Builder caEng(boolean caEng) {
      this.caEng = caEng;
      return this;
    }

    public Builder caeng_InError(boolean caeng_InError) {
      this.caeng_InError = caeng_InError;
      return this;
    }

    public Builder caLockout(boolean caLockout) {
      this.caLockout = caLockout;
      return this;
    }

    public Builder calockout_InError(boolean calockout_InError) {
      this.calockout_InError = calockout_InError;
      return this;
    }

    public Builder clampsStateAtStandby(String clampsStateAtStandby) {
      this.clampsStateAtStandby = clampsStateAtStandby;
      return this;
    }

    public Builder current(double current) {
      this.current = current;
      return this;
    }

    public Builder deltaPositionAtStandby(int deltaPositionAtStandby) {
      this.deltaPositionAtStandby = deltaPositionAtStandby;
      return this;
    }

    public Builder emptyAtStandby(boolean emptyAtStandby) {
      this.emptyAtStandby = emptyAtStandby;
      return this;
    }

    public Builder enableBrakes(boolean enableBrakes) {
      this.enableBrakes = enableBrakes;
      return this;
    }

    public Builder enableRotation(boolean enableRotation) {
      this.enableRotation = enableRotation;
      return this;
    }

    public Builder enableShutter(boolean enableShutter) {
      this.enableShutter = enableShutter;
      return this;
    }

    public Builder enableUnclamp(boolean enableUnclamp) {
      this.enableUnclamp = enableUnclamp;
      return this;
    }

    public Builder estimatedPosition(int estimatedPosition) {
      this.estimatedPosition = estimatedPosition;
      return this;
    }

    public Builder filterAtStandbyName(String filterAtStandbyName) {
      this.filterAtStandbyName = filterAtStandbyName;
      return this;
    }

    public Builder filterOnAutochangerName(String filterOnAutochangerName) {
      this.filterOnAutochangerName = filterOnAutochangerName;
      return this;
    }

    public Builder locked(boolean locked) {
      this.locked = locked;
      return this;
    }

    public Builder minLocked(long minLocked) {
      this.minLocked = minLocked;
      return this;
    }

    public Builder moving(boolean moving) {
      this.moving = moving;
      return this;
    }

    public Builder out_CF0(boolean out_CF0) {
      this.out_CF0 = out_CF0;
      return this;
    }

    public Builder out_CF0_InError(boolean out_CF0_InError) {
      this.out_CF0_InError = out_CF0_InError;
      return this;
    }

    public Builder out_CF1(boolean out_CF1) {
      this.out_CF1 = out_CF1;
      return this;
    }

    public Builder out_CF1_InError(boolean out_CF1_InError) {
      this.out_CF1_InError = out_CF1_InError;
      return this;
    }

    public Builder out_CFC(boolean out_CFC) {
      this.out_CFC = out_CFC;
      return this;
    }

    public Builder out_CFC_InError(boolean out_CFC_InError) {
      this.out_CFC_InError = out_CFC_InError;
      return this;
    }

    public Builder out_CS(boolean out_CS) {
      this.out_CS = out_CS;
      return this;
    }

    public Builder out_CS_InError(boolean out_CS_InError) {
      this.out_CS_InError = out_CS_InError;
      return this;
    }

    public Builder position(int position) {
      this.position = position;
      return this;
    }

    public Builder positionSensorType(int positionSensorType) {
      this.positionSensorType = positionSensorType;
      return this;
    }

    public Builder profileAcceleration(long profileAcceleration) {
      this.profileAcceleration = profileAcceleration;
      return this;
    }

    public Builder profileDeceleration(long profileDeceleration) {
      this.profileDeceleration = profileDeceleration;
      return this;
    }

    public Builder profileVelocity(long profileVelocity) {
      this.profileVelocity = profileVelocity;
      return this;
    }

    public Builder rotationTimeout(long rotationTimeout) {
      this.rotationTimeout = rotationTimeout;
      return this;
    }

    public Builder sensor1(long sensor1) {
      this.sensor1 = sensor1;
      return this;
    }

    public Builder sensor2(long sensor2) {
      this.sensor2 = sensor2;
      return this;
    }

    public Builder sensor3(long sensor3) {
      this.sensor3 = sensor3;
      return this;
    }

    public Builder shutterInactive(boolean shutterInactive) {
      this.shutterInactive = shutterInactive;
      return this;
    }

    public Builder slaveStatusAtStandby(String slaveStatusAtStandby) {
      this.slaveStatusAtStandby = slaveStatusAtStandby;
      return this;
    }

    public Builder sleep(boolean sleep) {
      this.sleep = sleep;
      return this;
    }

    public Builder socketAtStandbyID(int socketAtStandbyID) {
      this.socketAtStandbyID = socketAtStandbyID;
      return this;
    }

    public Builder socketAtStandbyName(String socketAtStandbyName) {
      this.socketAtStandbyName = socketAtStandbyName;
      return this;
    }

    public Builder temperature1(double temperature1) {
      this.temperature1 = temperature1;
      return this;
    }

    public Builder temperature2(double temperature2) {
      this.temperature2 = temperature2;
      return this;
    }

    public Builder temperature3(double temperature3) {
      this.temperature3 = temperature3;
      return this;
    }

    public Builder temperature4(double temperature4) {
      this.temperature4 = temperature4;
      return this;
    }

    public Builder tpCheckRotation(boolean tpCheckRotation) {
      this.tpCheckRotation = tpCheckRotation;
      return this;
    }

    public Builder tpStopRotation(boolean tpStopRotation) {
      this.tpStopRotation = tpStopRotation;
      return this;
    }

    public Builder tpStopUnclamp(boolean tpStopUnclamp) {
      this.tpStopUnclamp = tpStopUnclamp;
      return this;
    }

    public Builder tp_InError(boolean tp_InError) {
      this.tp_InError = tp_InError;
      return this;
    }

    public Builder velocity(double velocity) {
      this.velocity = velocity;
      return this;
    }

    public Fcs_CarouselTelemetry build() {
      return new Fcs_CarouselTelemetry(af3, af3_InError, ap1, ap1_InError, ap2, ap2_InError, ap3, ap3_InError, atStandby, brakeState1, brakeState2, brakeState3, brakesActivated, caEng, caeng_InError, caLockout, calockout_InError, clampsStateAtStandby, current, deltaPositionAtStandby, emptyAtStandby, enableBrakes, enableRotation, enableShutter, enableUnclamp, estimatedPosition, filterAtStandbyName, filterOnAutochangerName, locked, minLocked, moving, out_CF0, out_CF0_InError, out_CF1, out_CF1_InError, out_CFC, out_CFC_InError, out_CS, out_CS_InError, position, positionSensorType, profileAcceleration, profileDeceleration, profileVelocity, rotationTimeout, sensor1, sensor2, sensor3, shutterInactive, slaveStatusAtStandby, sleep, socketAtStandbyID, socketAtStandbyName, temperature1, temperature2, temperature3, temperature4, tpCheckRotation, tpStopRotation, tpStopUnclamp, tp_InError, velocity);
    }
  }
}
