package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class StartSetFilterEvent extends CameraEvent {
  private final String filterName;

  private final String filterType;

  public StartSetFilterEvent(String filterName, String filterType) {
    this.filterName = filterName;
    this.filterType = filterType;
  }

  public String getFilterName() {
    return filterName;
  }

  public String getFilterType() {
    return filterType;
  }

  @Override
  public String toString() {
    return "StartSetFilterEvent{" + "filterName=" + filterName +", filterType=" + filterType +"}";
  }
}
