package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Rebpower_RebConfigurationEvent extends CameraEvent {
  private final String version;

  private final int[] dphi;

  private final int[] hvBias;

  private final String location;

  public Rebpower_RebConfigurationEvent(String version, int[] dphi, int[] hvBias, String location) {
    this.version = version;
    this.dphi = dphi;
    this.hvBias = hvBias;
    this.location = location;
  }

  public String getVersion() {
    return version;
  }

  public int[] getDphi() {
    return dphi;
  }

  public int[] getHvBias() {
    return hvBias;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "Rebpower_RebConfigurationEvent{" + "version=" + version +
        ", dphi=" + Arrays.toString(dphi) +", hvBias=" + Arrays.toString(hvBias) +
        ", location=" + location +"}";
  }
}
