/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacGaugeTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double protection_I = 0.5285582542419434;
        double clean_5_24V_I = 0.05276191234588623;
        double dirty_24V_I = 0.2538655996322632;
        double dirty_48V_I = 0.6691250801086426;
        double rebps_0_2_I = 0.9484793543815613;
        double rebps_3_5_I = 0.06510055065155029;
        double rebps_6_8_I = 0.5246146321296692;
        double rebps_9_12_I = 0.3711746335029602;
        double dirty_28V_I = 0.7069011926651001;
        double heater_I = 0.5332658886909485;
        double rebps_Spr_I = 0.948168933391571;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(protection_I, clean_5_24V_I, dirty_24V_I, dirty_48V_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, dirty_28V_I, heater_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_V = 0.6169564127922058;
        double otm_0_A_I = 0.45495182275772095;
        double otm_0_B_V = 0.808083176612854;
        double otm_0_B_I = 0.23556727170944214;
        double otm_1_A_V = 0.10788506269454956;
        double otm_1_A_I = 0.2229914665222168;
        double otm_1_B_V = 0.8505874276161194;
        double otm_1_B_I = 0.4057621359825134;
        double otm_2_A_V = 0.8716052770614624;
        double otm_2_A_I = 0.007391571998596191;
        double otm_2_B_V = 0.3050888180732727;
        double otm_2_B_I = 0.5499875545501709;
        double otm_3_A_V = 0.7689109444618225;
        double otm_3_A_I = 0.6060041785240173;
        double otm_3_B_V = 0.0859571099281311;
        double otm_3_B_I = 0.824268f;
        double otm_4_A_V = 0.1545369029045105;
        double otm_4_A_I = 0.6669414043426514;
        double otm_4_B_V = 0.8774278163909912;
        double otm_4_B_I = 0.8820335865020752;
        double otm_5_A_V = 0.3361157178878784;
        double otm_5_A_I = 0.34206151962280273;
        double otm_5_B_V = 0.08746248483657837;
        double otm_5_B_I = 0.3192116f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_V, otm_0_A_I, otm_0_B_V, otm_0_B_I, otm_1_A_V, otm_1_A_I, otm_1_B_V, otm_1_B_I, otm_2_A_V, otm_2_A_I, otm_2_B_V, otm_2_B_I, otm_3_A_V, otm_3_A_I, otm_3_B_V, otm_3_B_I, otm_4_A_V, otm_4_A_I, otm_4_B_V, otm_4_B_I, otm_5_A_V, otm_5_A_I, otm_5_B_V, otm_5_B_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double main_V = 0.1792404055595398;
        double main_I = 0.40563303232192993;
        double main_T = 0.017583012580871582;
        double board_T = 0.7870346307754517;
        double fPGA_T = 0.8785438537597656;
        double pwr_Cry_HCU_V = 0.5586521625518799;
        double pwr_Cry_HCU_I = 0.8116310834884644;
        double fes_Shu_HCU_V = 0.3396013379096985;
        double fes_Shu_HCU_I = 0.6575390696525574;
        double ion_Pumps_V = 0.5669811367988586;
        double ion_Pumps_I = 0.3941730260848999;
        double body_Purge_V = 0.883506178855896;
        double body_Purge_I = 0.4668201208114624;
        double bpu_Maq20_V = 0.13173907995224;
        double bpu_Maq20_I = 0.38600724935531616;
        double gauges_V = 0.5483200550079346;
        double gauges_I = 0.7548995018005371;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(main_V, main_I, main_T, board_T, fPGA_T, pwr_Cry_HCU_V, pwr_Cry_HCU_I, fes_Shu_HCU_V, fes_Shu_HCU_I, ion_Pumps_V, ion_Pumps_I, body_Purge_V, body_Purge_I, bpu_Maq20_V, bpu_Maq20_I, gauges_V, gauges_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fPGA_T, (double)item_.getFPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double main_V = 0.04621785879135132;
        double main_I = 0.43778812885284424;
        double main_T = 0.6151735782623291;
        double board_T = 0.11285722255706787;
        double fPGA_T = 0.41614866256713867;
        double cryo_Turbo_V = 0.6166310906410217;
        double cryo_Turbo_I = 0.745116f;
        double hex_Turbo_V = 0.20814841985702515;
        double hex_Turbo_I = 0.9986693263053894;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(main_V, main_I, main_T, board_T, fPGA_T, cryo_Turbo_V, cryo_Turbo_I, hex_Turbo_V, hex_Turbo_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fPGA_T, (double)item_.getFPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double main_V = 0.24381285905838013;
        double main_I = 0.5113597512245178;
        double main_T = 0.4800183176994324;
        double board_T = 0.11721396446228027;
        double fPGA_T = 0.7590519189834595;
        double purge_Fan_V = 0.23517823219299316;
        double purge_Fan_I = 0.7652957439422607;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(main_V, main_I, main_T, board_T, fPGA_T, purge_Fan_V, purge_Fan_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fPGA_T, (double)item_.getFPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_Brd_T = 0.03028369f;
        double rebbulkps_0_2_V = 0.8887019157409668;
        double rebbulkps_0_2_I = 0.3824140429496765;
        double rebbulkps_0_2_T = 0.4457968f;
        double rebbulkps_3_5_V = 0.04528224468231201;
        double rebbulkps_3_5_I = 0.24748897552490234;
        double rebbulkps_3_5_T = 0.027725934982299805;
        double rebbulkps_6_8_V = 0.0847016f;
        double rebbulkps_6_8_I = 0.37607938051223755;
        double rebbulkps_6_8_T = 0.8977767825126648;
        double rebbulkps_9_12_V = 0.3214273452758789;
        double rebbulkps_9_12_I = 0.4672391414642334;
        double rebbulkps_9_12_T = 0.6245750784873962;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_Brd_T, rebbulkps_0_2_V, rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_3_5_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_6_8_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_9_12_V, rebbulkps_9_12_I, rebbulkps_9_12_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = new double[]{0.7339740991592407, 0.3867373f, 0.7396143078804016, 0.5302886962890625, 0.52546226978302, 0.4743010997772217, 0.09875047206878662, 0.06402587890625, 0.2277928f, 0.5498886704444885, 0.5141436457633972, 0.15622997283935547, 0.7129836082458496};
        String location = "";
        double[] boardTemp1 = new double[]{0.9425868988037109, 0.04010009765625, 0.3452610969543457, 0.8819695115089417, 0.7480261325836182, 0.8744506239891052, 0.07389664649963379, 0.3445904850959778, 0.7742528319358826, 0.5902373194694519, 0.68085777759552, 0.33548396825790405, 0.09007406234741211};
        double[] boardTemp2 = new double[]{0.7044384479522705, 0.02442491054534912, 0.967660129070282, 0.5781850814819336, 0.6704366207122803, 0.0929533839225769, 0.8538467884063721, 0.6539929509162903, 0.5182100534439087, 0.22342896461486816, 0.46468567848205566, 0.7535201907157898, 0.49164074659347534};
        double[] boardTemp3 = new double[]{0.2608568072319031, 0.2715240716934204, 0.23528772592544556, 0.8533391356468201, 0.815934956073761, 0.2895486354827881, 0.8054046630859375, 0.31695497035980225, 0.21462613344192505, 0.34066665172576904, 0.94427f, 0.828498899936676, 0.5845011472702026};
        double[] boardTemp4 = new double[]{0.39886826276779175, 0.4242229461669922, 0.8753719329833984, 0.6650663018226624, 0.7452285289764404, 0.33771592378616333, 0.7063472867012024, 0.004302442f, 0.7798169255256653, 0.9732813239097595, 0.92755526304245, 0.868564f, 0.35125768184661865};
        double[] boardTemp5 = new double[]{0.8905128836631775, 0.856594979763031, 0.3706645965576172, 0.4623536467552185, 0.05489999055862427, 0.805367112159729, 0.4498847f, 0.48599326610565186, 0.4386753439903259, 0.48635f, 0.6218813061714172, 0.32657474279403687, 0.005529582500457764};
        double[] boardTemp6 = new double[]{0.9392091035842896, 0.0757865309715271, 0.7385959625244141, 0.046394526958465576, 0.5253446698188782, 0.2154989242553711, 0.6692019104957581, 0.8824235200881958, 0.4858775f, 0.12327843904495239, 0.6317868828773499, 0.6023301482200623, 0.4804054f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, location, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] digital_VbefLDO = new double[]{0.4328557252883911, 0.8027974367141724, 0.7475591897964478, 0.17451727390289307, 0.5185796618461609, 0.526363f, 0.33413875102996826, 0.9065343737602234, 0.7845127582550049, 0.9271166920661926, 0.8289186954498291, 0.3993911147117615, 0.7363129258155823, 0.2895035147666931, 0.3452731966972351, 0.38123178482055664, 0.7683166265487671, 0.13407975435256958, 0.44489985704421997, 0.405565083026886, 0.5431897044181824, 0.5829771161079407, 0.2243766188621521, 0.5141918659210205, 0.09218466281890869, 0.6861616373062134, 0.4145456f, 0.1372414231300354, 0.446424f, 0.10880494117736816, 0.755133867263794, 0.576267f, 0.6153053641319275, 0.6425737738609314, 0.04444164037704468, 0.9483559131622314, 0.9643363952636719, 0.7876291275024414, 0.7632316946983337, 0.7895994782447815, 0.684298574924469, 0.4984275f, 0.6825485825538635, 0.9111863970756531, 0.7750866413116455, 0.638982892036438, 0.17711788415908813, 0.18508023023605347, 0.2449805736541748, 0.7491421103477478, 0.2598956823348999, 0.9011051654815674, 0.5192011594772339, 0.08285337686538696, 0.4505406f, 0.2037997841835022, 0.09573167562484741, 0.1956794261932373, 0.20298081636428833, 0.9842374324798584, 0.5325362682342529, 0.48837214708328247, 0.5973848104476929, 0.8959168791770935, 0.9150654673576355, 0.3657575249671936, 0.5928830504417419, 0.8896746635437012, 0.06854617595672607, 0.058166325092315674, 0.22311514616012573};
        String location = "u";
        double[] digital_IbefLDO = new double[]{0.6420167684555054, 0.4715088f, 0.5090200304985046, 0.6322002410888672, 0.5558463931083679, 0.1021713f, 0.902158260345459, 0.4317305088043213, 0.5601807236671448, 0.7510571479797363, 0.43343013525009155, 0.8926216959953308, 0.9593026041984558, 0.04695213f, 0.07528221607208252, 0.6676658987998962, 0.2685765027999878, 0.26970362663269043, 0.5119476318359375, 0.2674948573112488, 0.853928f, 0.041564106941223145, 0.4894769787788391, 0.6060689091682434, 0.32494717836380005, 0.1546655297279358, 0.2948017716407776, 0.6795167922973633, 0.2675807476043701, 0.872297f, 0.4565240740776062, 0.7729224562644958, 0.8473111987113953, 0.8032259345054626, 0.011489689350128174, 0.1736438274383545, 0.6930426955223083, 0.7768311500549316, 0.07446908950805664, 0.8903203010559082, 0.5326936841011047, 0.4729587435722351, 0.4258297085762024, 0.053610384464263916, 0.2439296841621399, 0.9554680585861206, 0.664438009262085, 0.49324584007263184, 0.21087270975112915, 0.6843093633651733, 0.5088151097297668, 0.9471758008003235, 0.24645012617111206, 0.14021533727645874, 0.7455449104309082, 0.7289993166923523, 0.4098575711250305, 0.3818510174751282, 0.3749760389328003, 0.7417784333229065, 0.0821070671081543, 0.8013471364974976, 0.773384f, 0.02753680944442749, 0.8756334185600281, 0.07495027780532837, 0.33909255266189575, 0.6457557678222656, 0.7653827667236328, 0.9860984086990356, 0.6068593859672546};
        double[] digital_VaftLDO = new double[]{0.4100852f, 0.11077779531478882, 0.9842397570610046, 0.2674836f, 0.725014f, 0.5656404495239258, 0.23044276237487793, 0.8136123418807983, 0.5637492537498474, 0.7748758792877197, 0.5572089552879333, 0.6217285990715027, 0.14100736379623413, 0.9639227986335754, 0.46244025230407715, 0.47606295347213745, 0.4514286518096924, 0.22423040866851807, 0.5843902230262756, 0.7225638031959534, 0.9731157422065735, 0.3730232f, 0.3244326114654541, 0.11809343099594116, 0.14921408891677856, 0.5591821670532227, 0.5470287203788757, 0.7978251576423645, 0.9469820857048035, 0.34314948320388794, 0.8814008235931396, 0.7366548180580139, 0.807532548904419, 0.2944296598434448, 0.757791f, 0.32069432735443115, 0.6101022362709045, 0.4256961941719055, 0.2540908455848694, 0.6930896639823914, 0.1176653504371643, 0.17105382680892944, 0.3179798126220703, 0.993137538433075, 0.4969320297241211, 0.47408753633499146, 0.3180500268936157, 0.395719051361084, 0.4318616986274719, 0.6885254383087158, 0.90788733959198, 0.4843074679374695, 0.6080067157745361, 0.9233457446098328, 0.24350768327713013, 0.28825122117996216, 0.7331236600875854, 0.6507946252822876, 0.9513334035873413, 0.6948140859603882, 0.09104150533676147, 0.5089883208274841, 0.3160724639892578, 0.6478259563446045, 0.979839563369751, 0.3926283121109009, 0.7510979175567627, 0.8851513266563416, 0.35671013593673706, 0.9610503315925598, 0.17450577020645142};
        double[] digital_IaftLDO = new double[]{0.0920177698135376, 0.96079421043396, 0.38068634271621704, 0.7788727879524231, 0.4801989793777466, 0.987775f, 0.4404745101928711, 0.32937318086624146, 0.4958783984184265, 0.6876863241195679, 0.5683939456939697, 0.4215213656425476, 0.7416045665740967, 0.7074677348136902, 0.8728065490722656, 0.5851613283157349, 0.2281056046485901, 0.525134801864624, 0.22448945045471191, 0.1348472237586975, 0.785979f, 0.3614969253540039, 0.8780797719955444, 0.7784899473190308, 0.2296859f, 0.7122564911842346, 0.952198f, 0.13673967123031616, 0.619225800037384, 0.33778584003448486, 0.6959654688835144, 0.06633496284484863, 0.4788632392883301, 0.6652513146400452, 0.26929962635040283, 0.48347562551498413, 0.9559557437896729, 0.0990191102027893, 0.36171507835388184, 0.8507198095321655, 0.8130466341972351, 0.4670303f, 0.4289323687553406, 0.6161231994628906, 0.5978191494941711, 0.5353047847747803, 0.4011111259460449, 0.31011974811553955, 0.9112753868103027, 0.2477748990058899, 0.12679147720336914, 0.23840516805648804, 0.05572539567947388, 0.6577335596084595, 0.4815922975540161, 0.4228644371032715, 0.4801190495491028, 0.739416778087616, 0.3624539375305176, 0.693045f, 0.9182974100112915, 0.7483448386192322, 0.7819121479988098, 0.3141111135482788, 0.3313976526260376, 0.1473794f, 8.808374404907227E-4, 0.8405324220657349, 0.19254523515701294, 0.4579852223396301, 0.32413625717163086};
        double[] digital_VaftSwch = new double[]{0.7355019450187683, 0.09186446666717529, 0.624524f, 0.5147181153297424, 0.8124096393585205, 0.4726234f, 0.5007706880569458, 0.14947772026062012, 0.49540644884109497, 0.74300217628479, 0.05509376525878906, 0.9788369536399841, 0.9105919599533081, 0.3286703824996948, 0.5323424935340881, 0.013417422771453857, 0.6976903676986694, 0.05334120988845825, 0.560552716255188, 0.635627269744873, 0.35490357875823975, 0.7501116991043091, 0.5188309550285339, 0.22574901580810547, 0.7182397246360779, 0.23621594905853271, 0.1245659f, 0.25287485122680664, 0.5429196357727051, 0.8264403343200684, 0.4044198989868164, 0.3676353693008423, 0.95100998878479, 0.8426329493522644, 9.699463844299316E-4, 0.055625855922698975, 0.9793729186058044, 0.1033710241317749, 0.1676291823387146, 0.880457878112793, 0.489157497882843, 0.9819336533546448, 0.11643481254577637, 0.22926104068756104, 0.056796133518218994, 0.21339797973632812, 0.41991132497787476, 0.9401851296424866, 0.07184994220733643, 0.452190637588501, 0.5086182355880737, 0.8630732297897339, 0.4247344136238098, 0.4471691846847534, 0.5448827147483826, 0.6061835885047913, 0.823642909526825, 0.25778496265411377, 0.9509667158126831, 0.7319615483283997, 0.771777868270874, 0.9057208895683289, 0.002488374710083008, 0.964837f, 0.5408458113670349, 0.29337072372436523, 0.3069179654121399, 0.49842578172683716, 0.4628271460533142, 0.753501832485199, 0.8296246528625488};
        double[] analog_VbefLDO = new double[]{0.8760384917259216, 0.5380935072898865, 0.6814385652542114, 0.8291116952896118, 0.7578656673431396, 0.6234201192855835, 0.878247082233429, 0.5572206377983093, 0.9745615124702454, 0.35837435722351074, 0.3649506f, 0.5733171105384827, 0.8472592234611511, 0.9436098337173462, 0.9561455249786377, 0.7335067987442017, 0.778515100479126, 0.9710593819618225, 0.0770241f, 0.3321366310119629, 0.4906148314476013, 0.6858004927635193, 0.5193766951560974, 0.994174599647522, 0.11353057622909546, 0.43501168489456177, 0.7364017963409424, 0.01014697551727295, 0.16416245698928833, 0.1241106390953064, 0.12797755002975464, 0.15235835313796997, 0.574024498462677, 0.38764792680740356, 0.6504523754119873, 0.15999162197113037, 0.5300691723823547, 0.9172468185424805, 0.15912961959838867, 0.09484660625457764, 0.41182655096054077, 0.1358608603477478, 0.64670330286026, 0.4780379f, 0.4095345735549927, 0.722536027431488, 0.04434269666671753, 0.36565732955932617, 0.0676579475402832, 0.571001f, 0.3994166851043701, 0.4185652732849121, 0.5444425940513611, 0.6956780552864075, 0.008641839027404785, 0.19408690929412842, 0.5423893332481384, 0.6076556444168091, 0.7694752812385559, 0.727053f, 0.8313153982162476, 0.38894426822662354, 0.4957488179206848, 0.381571f, 0.9427034258842468, 0.35475146770477295, 0.9338545799255371, 0.6159851551055908, 0.8021369576454163, 0.9599621891975403, 0.4993806f};
        double[] analog_IbefLDO = new double[]{0.9001702070236206, 0.829734206199646, 0.7675462365150452, 0.4452148675918579, 0.510695f, 0.873681902885437, 0.5338900685310364, 0.963172f, 0.27522122859954834, 0.4494468f, 0.10036486387252808, 0.13265305757522583, 0.778120219707489, 0.2903081774711609, 0.023699283599853516, 0.2603601813316345, 0.8256701231002808, 0.5299704670906067, 0.0824732780456543, 0.9314156174659729, 0.6179431676864624, 0.7447406649589539, 0.7064468860626221, 0.5192534327507019, 0.6178314089775085, 0.09379088878631592, 0.3732725977897644, 0.3123772144317627, 0.3434414267539978, 0.3771934509277344, 0.3778343200683594, 0.22163933515548706, 0.5517924427986145, 0.651652991771698, 0.5180367231369019, 0.9713512659072876, 0.608476f, 0.22524887323379517, 0.9630126357078552, 0.06866782903671265, 0.34441041946411133, 0.2202223539352417, 0.32170265913009644, 0.8338043689727783, 0.7473955750465393, 0.22523283958435059, 0.04850787f, 0.5823819041252136, 0.2988243103027344, 0.8369970321655273, 0.2857654094696045, 0.23230499029159546, 0.28623634576797485, 0.5503937005996704, 0.9183058738708496, 0.2909461259841919, 0.6576314568519592, 0.6336575150489807, 0.5121147036552429, 0.3220444321632385, 0.856450617313385, 0.4120151996612549, 0.32654857635498047, 0.6317614316940308, 0.025355815887451172, 0.07298839092254639, 0.26769375801086426, 0.41402631998062134, 0.1964951753616333, 0.4466623067855835, 0.4199574589729309};
        double[] analog_VaftLDO = new double[]{0.899032711982727, 0.8155596852302551, 0.654699444770813, 0.22514522075653076, 0.926028f, 0.661967f, 0.4660797715187073, 0.9350160956382751, 0.6609916090965271, 0.9289290308952332, 0.2519201f, 0.2471522092819214, 0.07819592952728271, 0.6815697550773621, 0.6558336019515991, 0.03810513f, 0.07685893774032593, 0.9008873701095581, 0.2528366446495056, 0.4659690856933594, 0.2931435f, 0.8940519690513611, 0.2746056318283081, 0.951198935508728, 0.45476293563842773, 0.5707722306251526, 0.8508858680725098, 0.324676513671875, 0.4996801018714905, 0.2803533673286438, 0.5281224250793457, 0.8113967180252075, 0.20921391248703003, 0.919331f, 0.15211504697799683, 0.1929841f, 0.1848042607307434, 0.465553343296051, 0.5700189471244812, 0.0494743f, 0.1003677248954773, 0.09727442264556885, 0.24976319074630737, 0.14794373512268066, 0.09035599231719971, 0.5068118572235107, 0.5165084004402161, 0.9408081769943237, 0.26719367504119873, 0.8248472213745117, 0.053814053535461426, 0.5187243819236755, 0.9087271094322205, 0.9063484072685242, 0.95255047082901, 0.881436f, 0.1027945876121521, 0.2808569669723511, 0.4572157859802246, 0.8346399664878845, 0.1962890625, 0.2926040291786194, 0.6542792916297913, 0.3726828694343567, 0.46251094341278076, 0.3193243145942688, 0.3706586956977844, 0.8869090676307678, 0.9937039613723755, 0.19808429479599, 0.15577363967895508};
        double[] analog_IaftLDO = new double[]{0.659696638584137, 0.044072628021240234, 0.35289841890335083, 0.26424747705459595, 0.7171663641929626, 0.31904345750808716, 0.6289815902709961, 0.34782183170318604, 0.4623984098434448, 0.03394496440887451, 0.5244044661521912, 0.11709833145141602, 0.4795324206352234, 0.782646656036377, 0.6695271134376526, 0.5121548771858215, 0.2617705464363098, 0.27514833211898804, 0.8513689637184143, 0.09483903646469116, 0.2880900502204895, 0.06190735101699829, 0.1931254267692566, 0.06668978929519653, 0.16006678342819214, 0.27921462059020996, 0.8730942010879517, 0.8501834869384766, 0.3579018712043762, 0.8696876764297485, 0.8626740574836731, 0.8256478309631348, 0.4204432964324951, 0.3785746097564697, 0.9558301568031311, 0.07319802045822144, 0.9752457141876221, 0.3518139123916626, 0.9940738081932068, 0.7629812359809875, 0.40967506170272827, 0.1955548f, 0.8188180327415466, 0.805572509765625, 0.0915299654006958, 0.5571169257164001, 0.5297868251800537, 0.1083616f, 0.8170342445373535, 0.39029455184936523, 0.03245729207992554, 0.0771544f, 0.6253944039344788, 0.7377392053604126, 0.3233994245529175, 0.10205626487731934, 0.7030717730522156, 0.3422772288322449, 0.20957303047180176, 0.623198390007019, 0.8787863850593567, 0.7579361200332642, 0.1715014f, 0.8883354067802429, 0.1439586877822876, 0.018800735473632812, 0.3617393970489502, 0.7972317337989807, 0.8253456950187683, 0.8163586854934692, 0.5457910299301147};
        double[] analog_VaftSwch = new double[]{0.836626410484314, 0.980205774307251, 0.7885984182357788, 0.424838662147522, 0.3071276f, 0.4132169f, 0.01981222629547119, 0.7761707305908203, 0.04545038938522339, 0.4529954791069031, 0.34995073080062866, 0.2715141177177429, 0.07092666625976562, 0.4394496f, 0.08574283123016357, 0.5146961808204651, 0.9062464237213135, 0.3170241713523865, 0.26001375913619995, 0.6229004263877869, 0.3141421675682068, 0.9994347095489502, 0.5962113738059998, 0.6705964207649231, 0.38250982761383057, 0.3556661605834961, 0.7757212519645691, 0.14799284934997559, 0.01172637939453125, 0.9923641085624695, 0.7778740525245667, 0.6481812596321106, 0.09424054622650146, 0.09243494272232056, 0.846501350402832, 0.6962411999702454, 0.9155762195587158, 0.6724908351898193, 0.7404934763908386, 0.6423062086105347, 0.3885188102722168, 0.8921326398849487, 0.13518112897872925, 0.047433435916900635, 0.7023965716362, 0.7760049104690552, 0.47076523303985596, 0.9501650929450989, 0.32409411668777466, 0.575740396976471, 0.885834813117981, 0.7826586365699768, 0.22693806886672974, 0.3246299f, 0.6487501859664917, 0.7435328364372253, 0.9011955857276917, 0.1350187063217163, 0.3059648871421814, 0.8811157941818237, 0.4720706343650818, 0.809583842754364, 0.530962f, 0.5121822357177734, 0.9273414015769958, 0.1259489f, 0.8852877020835876, 0.4297632575035095, 0.5498489141464233, 0.09333747625350952, 0.7271665930747986};
        double[] od_VbefLDO = new double[]{0.43705064058303833, 0.6257441639900208, 0.8445626497268677, 0.7345280647277832, 0.3962767720222473, 0.02667129f, 0.03164154291152954, 0.6872087717056274, 0.28083235025405884, 0.46498173475265503, 0.4443695f, 0.5950102210044861, 0.760514497756958, 0.920830249786377, 0.5145847201347351, 0.10968774557113647, 0.9940268993377686, 0.7169210910797119, 0.7415061593055725, 0.643465518951416, 0.4256610870361328, 0.9521958827972412, 0.3529811501502991, 0.2860618829727173, 0.12607192993164062, 0.9344543814659119, 0.571897f, 0.5963594913482666, 0.2374504804611206, 0.011470317840576172, 0.1951778f, 0.6017722487449646, 0.3040431f, 0.8814266324043274, 0.2141265869140625, 0.9041741490364075, 0.12834423780441284, 0.3603968024253845, 0.4494091868400574, 0.030228376388549805, 0.49550437927246094, 0.44420385360717773, 0.5723927617073059, 0.01846456527709961, 0.8732677102088928, 0.7745010852813721, 0.008116722106933594, 0.4760128855705261, 0.507442831993103, 0.7076520323753357, 0.5258184671401978, 0.8131405711174011, 0.19448333978652954, 0.6963885426521301, 0.42318958044052124, 0.250414f, 0.18982505798339844, 0.687866747379303, 0.09356868267059326, 0.2463078498840332, 0.9854075312614441, 0.48031747341156006, 0.06487125158309937, 0.7954068183898926, 0.11016291379928589, 0.17981386184692383, 0.8396306037902832, 0.26013612747192383, 0.23665273189544678, 0.9777112603187561, 0.7121177315711975};
        double[] od_IbefLDO = new double[]{0.011460423469543457, 0.04457747936248779, 0.800111711025238, 0.24677908420562744, 0.7336034178733826, 0.8423047661781311, 0.038469672203063965, 0.9684793949127197, 0.19005513191223145, 0.4912036061286926, 0.5835068225860596, 0.6261651515960693, 0.026599586009979248, 0.8404200673103333, 0.9843844771385193, 0.8751201629638672, 0.6035534143447876, 0.553376317024231, 0.4261629581451416, 0.49712783098220825, 0.2837545871734619, 0.7989555597305298, 0.7486593127250671, 0.10137492418289185, 0.2630747f, 0.962894f, 0.2597065567970276, 0.27124422788619995, 0.20248931646347046, 0.9968196749687195, 0.16947948932647705, 0.1332862377166748, 0.2192828f, 0.7177543640136719, 0.08703964948654175, 0.5052968263626099, 0.4121708273887634, 0.7694599628448486, 0.8757721781730652, 0.9518499374389648, 0.05150198936462402, 0.7941092848777771, 0.9142528772354126, 0.9497514367103577, 0.9598853588104248, 0.8893787860870361, 0.309744f, 0.7952383756637573, 0.8673360347747803, 0.6587892174720764, 0.1725413203239441, 0.11250185966491699, 0.6532258987426758, 0.13419604301452637, 0.6934769153594971, 0.7330593466758728, 0.21797144412994385, 0.8565957546234131, 0.43984562158584595, 0.08205372095108032, 0.1716240644454956, 0.25835347175598145, 0.16580885648727417, 0.9457471966743469, 0.823606014251709, 0.7756658792495728, 0.14401185512542725, 0.9099817872047424, 0.9251385927200317, 0.4292819f, 0.8909226059913635};
        double[] od_VaftLDO = new double[]{0.7984728217124939, 0.8989483714103699, 0.8045603036880493, 0.4575839638710022, 0.9394100308418274, 0.6132451891899109, 0.8148303627967834, 0.6715084910392761, 0.026496827602386475, 0.17049521207809448, 0.4863317608833313, 0.778911828994751, 0.08442831039428711, 0.31605666875839233, 0.4159807562828064, 0.4870653748512268, 0.60768061876297, 0.3852988f, 0.947679877281189, 0.03508007526397705, 0.21477282047271729, 0.7365331053733826, 0.4273499846458435, 0.42184656858444214, 0.187908f, 0.22519594430923462, 0.8354001045227051, 0.5392314195632935, 0.4807614f, 0.9046261310577393, 0.3777068853378296, 0.6471555233001709, 0.24646002054214478, 0.06097674369812012, 0.2276879f, 0.28817933797836304, 0.625389575958252, 0.2529340386390686, 0.05370879f, 0.47913795709609985, 0.5409241914749146, 0.9077301025390625, 0.5044581890106201, 0.39577537775039673, 0.07365727424621582, 0.4783262610435486, 0.7422877550125122, 0.045916974544525146, 0.7550081610679626, 0.27561044692993164, 0.9586936831474304, 0.8233168721199036, 0.8636088967323303, 0.01512974500656128, 0.6405952572822571, 0.766857922077179, 0.687667727470398, 0.34952735900878906, 0.00993675f, 0.690349817276001, 0.28923535346984863, 0.26285213232040405, 0.3771381378173828, 0.6719495058059692, 0.7682473063468933, 0.07676881551742554, 0.24139052629470825, 0.2275436520576477, 0.4622993f, 0.9350489377975464, 0.4637170433998108};
        double[] od_VaftLDO2 = new double[]{0.5707303285598755, 0.15987098217010498, 0.29332494735717773, 0.12369662523269653, 0.8678842186927795, 0.868309736251831, 0.02582573890686035, 0.15500414371490479, 0.2178855538368225, 0.2221096158027649, 0.9776892066001892, 0.21130973100662231, 0.0632513165473938, 0.3912856f, 0.926598310470581, 0.6310747265815735, 0.9165858030319214, 0.6439908742904663, 0.08516901731491089, 0.8014885783195496, 0.16051793098449707, 0.2126123309135437, 0.1681169867515564, 0.6379313468933105, 0.4508323669433594, 0.12970668077468872, 0.18624818325042725, 0.5312761664390564, 0.07462853193283081, 0.4512097239494324, 0.11139404773712158, 0.7220391631126404, 0.8445212244987488, 0.12191075086593628, 0.30929964780807495, 0.1544435f, 0.5556836128234863, 0.4053928256034851, 0.6660559177398682, 0.977114737033844, 0.2076317f, 0.6812910437583923, 0.9709556698799133, 0.7882214188575745, 0.562879204750061, 0.7812221050262451, 0.7757747769355774, 0.7848882079124451, 0.8488917350769043, 0.3061372637748718, 0.3667f, 0.2487483024597168, 0.6302184462547302, 0.3478030562400818, 0.9778169393539429, 0.37628644704818726, 0.909467f, 0.1719151735305786, 0.0897547f, 0.7045115828514099, 0.13723468780517578, 0.04690980911254883, 0.8173778057098389, 0.16545891761779785, 0.003666102886199951, 0.9983981847763062, 0.5480917096138, 0.768664f, 0.0825345516204834, 0.7024706602096558, 0.2772570848464966};
        double[] od_IaftLDO = new double[]{0.7162968516349792, 0.740350067615509, 0.5106943249702454, 0.4574075937271118, 0.3239451050758362, 0.29878997802734375, 0.12486797571182251, 0.6695594191551208, 0.8895718455314636, 0.542678f, 0.25054746866226196, 0.4021570682525635, 0.8280426263809204, 0.04487931728363037, 0.5856694579124451, 0.628489f, 0.1885460615158081, 0.8840189576148987, 0.3155800700187683, 0.4772494435310364, 0.5825773477554321, 0.5641963481903076, 0.3503202795982361, 0.9419406652450562, 0.571884f, 0.9143024682998657, 0.4566831588745117, 0.44976943731307983, 0.4654986262321472, 0.5077179670333862, 0.19949185848236084, 0.9644697904586792, 0.03492170572280884, 0.46377694606781006, 0.8475499153137207, 0.7130911350250244, 0.924528181552887, 0.08624112606048584, 0.6441949605941772, 0.26536011695861816, 0.07382547855377197, 0.5800908207893372, 0.7553856372833252, 0.5450135469436646, 0.6083916425704956, 0.4382684826850891, 0.845430314540863, 0.9828876256942749, 0.7418993711471558, 0.07980525493621826, 0.28811997175216675, 0.8270516395568848, 0.8729289174079895, 0.9783458113670349, 0.08606314659118652, 0.07951432466506958, 0.38327741622924805, 0.07689392566680908, 0.3709811568260193, 0.4337762f, 0.5407761931419373, 0.42522042989730835, 0.010773241519927979, 0.3226267099380493, 0.2864617705345154, 0.08847993612289429, 0.11408644914627075, 0.9591028690338135, 0.7161638736724854, 0.8000139594078064, 0.7493444085121155};
        double[] od_VaftSwch = new double[]{0.3515675663948059, 0.4386467933654785, 0.11200529336929321, 0.7727377414703369, 0.3106893301010132, 0.1604752f, 0.9316699504852295, 0.4692228436470032, 0.6340921521186829, 0.2814931273460388, 0.01822417974472046, 0.5734025835990906, 0.9741061329841614, 0.71956467628479, 0.9102600812911987, 0.8651875853538513, 0.4640123248100281, 0.8699944019317627, 0.7108557820320129, 0.780899703502655, 0.42520612478256226, 0.5604330897331238, 0.4883003830909729, 0.5871396660804749, 0.4066761f, 0.11830466985702515, 0.7664282321929932, 0.5160966515541077, 0.2521233558654785, 0.5227116346359253, 0.6460506916046143, 0.6314314007759094, 0.7600611448287964, 0.8798719644546509, 0.6867908239364624, 0.9984661936759949, 0.03759205341339111, 0.7195050716400146, 0.4088412f, 0.2768210768699646, 0.666645884513855, 0.4539481997489929, 0.4719664454460144, 0.08413833379745483, 0.9477828145027161, 0.632499635219574, 0.5327885746955872, 0.23305213451385498, 0.48485177755355835, 0.7365257740020752, 0.9524611830711365, 0.1976214051246643, 0.2756111f, 0.3378385901451111, 0.859836220741272, 0.28822004795074463, 0.9087362885475159, 0.640973f, 0.20784467458724976, 0.014158666133880615, 0.8944817185401917, 0.17212438583374023, 0.9838724136352539, 0.890504777431488, 0.11074632406234741, 0.6021215319633484, 0.44235873222351074, 0.5397210717201233, 0.6926897168159485, 0.10200345516204834, 0.366751492023468};
        double[] clockhi_VbefLDO = new double[]{0.7805096507072449, 0.8747261762619019, 0.9472829103469849, 0.8885076642036438, 0.556930422782898, 0.5792065262794495, 0.2961454391479492, 0.19636154174804688, 0.0023627877235412598, 0.28500616550445557, 0.6686477661132812, 0.6660289168357849, 0.7577430605888367, 0.578338623046875, 0.9150266051292419, 0.0884554386138916, 0.36490005254745483, 0.04228156805038452, 0.6637503504753113, 0.036338627338409424, 0.26751482486724854, 0.8637517094612122, 0.9317817687988281, 0.1997787356376648, 0.6986638903617859, 0.8881232738494873, 0.8241537809371948, 0.1614902f, 0.6801071166992188, 0.3216143250465393, 0.876488f, 0.4421016573905945, 0.06011462211608887, 0.9373458623886108, 0.4472420811653137, 0.3018820285797119, 0.1699813f, 0.37811917066574097, 0.756597f, 0.2650805711746216, 0.3713676333427429, 0.9410897493362427, 0.3219779133796692, 0.3683926463127136, 0.7247708439826965, 0.3784014f, 0.04783368110656738, 0.9104452133178711, 0.8519304394721985, 0.6333589553833008, 0.49671435356140137, 0.8823203444480896, 0.050605833530426025, 0.7618787884712219, 0.5727295875549316, 0.1308283805847168, 0.998331f, 0.3498866558074951, 0.17562341690063477, 0.6904461979866028, 0.2425074f, 0.6432969570159912, 0.28806257247924805, 0.11362528800964355, 0.7981902956962585, 0.05058586597442627, 0.410033f, 0.2327372431755066, 0.8834550380706787, 0.17927193641662598, 0.4878249168395996};
        double[] clockhi_IbefLDO = new double[]{0.7535895705223083, 0.3272079825401306, 0.7254730463027954, 0.25193703174591064, 0.7666507363319397, 0.8382720947265625, 0.2768780589103699, 0.694943f, 0.4774436354637146, 0.8706921339035034, 0.9188368320465088, 0.8191748261451721, 0.7146965861320496, 0.6422613263130188, 0.7838386297225952, 0.5628254413604736, 0.5396012663841248, 0.2356804f, 0.76755690574646, 0.2852470874786377, 0.2208581566810608, 0.04956305f, 0.2891341f, 0.43691498041152954, 0.08017098903656006, 0.975362f, 0.5168592929840088, 0.1514669f, 0.07667070627212524, 0.002496182918548584, 0.05834996700286865, 0.8367744088172913, 0.2647276520729065, 0.834425f, 0.9504293203353882, 0.2851177453994751, 0.40919822454452515, 0.010683178901672363, 0.4298448f, 0.010835111141204834, 0.50991290807724, 0.8421172499656677, 0.5516842007637024, 0.11451911926269531, 0.9108472466468811, 0.687547f, 0.20582687854766846, 0.8887909054756165, 0.1397416591644287, 0.12922364473342896, 0.4991423487663269, 0.060374677181243896, 0.9349001049995422, 0.9818090796470642, 0.18668502569198608, 0.21072006225585938, 0.8145656585693359, 0.7258254885673523, 0.791206419467926, 0.7525073885917664, 0.480847f, 0.46290475130081177, 0.01742708683013916, 0.34737056493759155, 0.7279629111289978, 0.3086232542991638, 0.8943129181861877, 0.8320593237876892, 0.9500392079353333, 0.8717734217643738, 0.9418385624885559};
        double[] clockhi_VaftLDO = new double[]{0.3426443934440613, 0.8763936161994934, 0.10976654291152954, 0.31328171491622925, 0.17146307229995728, 0.5648835897445679, 0.03226763f, 0.8929800391197205, 0.007169842720031738, 0.6722826361656189, 0.9735507965087891, 0.3938329815864563, 0.15796732902526855, 0.513742208480835, 0.13346683979034424, 0.5879005789756775, 0.4709498882293701, 0.7932596206665039, 0.8530024886131287, 0.4846211075782776, 0.2812246084213257, 0.2088964f, 0.33946776390075684, 0.9399528503417969, 0.4634294f, 0.43860727548599243, 0.8752903938293457, 0.3097681999206543, 0.6414281129837036, 0.5263808965682983, 0.6607657074928284, 0.1538516879081726, 0.730922f, 0.09853965044021606, 0.4730631709098816, 0.03276348114013672, 0.1517086625099182, 0.5341876149177551, 0.03012669086456299, 0.3266274929046631, 0.4241926074028015, 0.5327516794204712, 0.9782283902168274, 0.02872532606124878, 0.1469811201095581, 0.009285271167755127, 0.5658922791481018, 0.24188333749771118, 0.9930896759033203, 0.9017523527145386, 0.5053524374961853, 0.8244085907936096, 0.8311557173728943, 0.9940950870513916, 0.07694637775421143, 0.31527024507522583, 0.1104759f, 0.8978132009506226, 0.9137728214263916, 0.01397031545639038, 0.4956052899360657, 0.749509f, 0.9661128520965576, 0.32585716247558594, 0.4143051505088806, 0.281935453414917, 0.13068228960037231, 0.21339058876037598, 0.7240076065063477, 0.7242322564125061, 0.8225416541099548};
        double[] clockhi_IaftLDO = new double[]{0.6510754227638245, 0.4045470356941223, 0.449058f, 0.14185333251953125, 0.27757835388183594, 0.862157940864563, 0.5791764855384827, 0.15868091583251953, 0.21217858791351318, 0.6607599258422852, 0.5157999396324158, 0.5123403668403625, 0.07157433032989502, 0.8760720491409302, 0.880825936794281, 0.9437201619148254, 0.23266452550888062, 0.6564675569534302, 0.9533509612083435, 0.38640785217285156, 0.06089651584625244, 0.3476797342300415, 0.8089441657066345, 0.812930703163147, 0.21386587619781494, 0.8380926251411438, 0.9726933836936951, 0.5340974926948547, 0.8659553527832031, 0.7646315097808838, 0.11168360710144043, 0.09111642837524414, 0.23992103338241577, 0.3090554475784302, 0.7101601958274841, 0.16126281023025513, 0.7116009593009949, 0.4492213f, 0.5851067304611206, 0.05842858552932739, 0.8385970592498779, 0.4137454628944397, 0.758403480052948, 0.8805614709854126, 0.3952442407608032, 0.4411519169807434, 0.5543213486671448, 0.20808666944503784, 0.14494377374649048, 0.7514247298240662, 0.7411676049232483, 0.45281195640563965, 0.9956294894218445, 0.3998481035232544, 0.1898796f, 0.5980870723724365, 0.04151439666748047, 0.6667261123657227, 0.43983322381973267, 0.6512831449508667, 0.04921752214431763, 0.12424784898757935, 0.005783796310424805, 0.7827691435813904, 0.2818986177444458, 0.06125783920288086, 0.44551634788513184, 0.8759012222290039, 0.3322707414627075, 0.6014798283576965, 0.5543889403343201};
        double[] clockhi_VaftSwch = new double[]{0.22514891624450684, 0.34356874227523804, 0.4499297f, 0.432578980922699, 0.9500213265419006, 0.7041158676147461, 0.5905601978302002, 0.15868675708770752, 0.5372181534767151, 0.9015504717826843, 0.5459669232368469, 0.9277271628379822, 0.8693253993988037, 0.6906915307044983, 0.6232205033302307, 0.5039002895355225, 0.372947096824646, 0.3661847f, 0.3001787066459656, 0.8834424614906311, 0.14057272672653198, 0.6173708438873291, 0.9612026810646057, 0.04801511764526367, 0.3075166344642639, 0.8862569332122803, 0.2429012f, 0.45531415939331055, 0.747342586517334, 0.13618344068527222, 0.4878356456756592, 0.5048176050186157, 0.5763466358184814, 0.5830276608467102, 0.18113607168197632, 0.12990832328796387, 0.7105728387832642, 0.9349414706230164, 0.731433629989624, 0.1032055f, 0.1187739372253418, 0.551204264163971, 0.7887552976608276, 0.7531317472457886, 0.6736131310462952, 0.2644098401069641, 0.2190326452255249, 0.932983f, 0.973775f, 0.3396545f, 0.3942485f, 0.06861793994903564, 0.9346742630004883, 0.6745418310165405, 0.14120906591415405, 0.4500460624694824, 0.7089152932167053, 0.2076675295829773, 0.31833577156066895, 0.09148335456848145, 0.8739694356918335, 0.011934459209442139, 0.8722001910209656, 0.13280963897705078, 0.22874730825424194, 0.44182825088500977, 0.4428752064704895, 0.014871478080749512, 0.7785090804100037, 0.2980414628982544, 0.2342730164527893};
        double[] clocklo_VbefLDO = new double[]{0.35692495107650757, 0.005169034004211426, 0.41407597064971924, 0.30284178256988525, 0.3750242590904236, 0.6544218063354492, 0.58131343126297, 0.5212643146514893, 0.786777913570404, 0.49979186058044434, 0.8632792830467224, 0.8847594261169434, 0.8851886987686157, 0.7348409295082092, 0.23631882667541504, 0.20344233512878418, 0.9699575304985046, 0.3071577548980713, 0.09066444635391235, 0.4878164f, 0.6894885897636414, 0.04080832004547119, 0.4690309762954712, 0.9243154525756836, 0.3648267388343811, 0.3376834988594055, 0.37369292974472046, 0.45799845457077026, 0.7849602103233337, 0.5333129167556763, 0.97985f, 0.8697410821914673, 0.7315243482589722, 0.1804996132850647, 0.923492968082428, 0.34092408418655396, 0.013272345066070557, 0.10649305582046509, 0.8345610499382019, 0.8406642079353333, 0.6731714010238647, 0.638889729976654, 0.13770556449890137, 0.015667974948883057, 0.3332202434539795, 0.9151987433433533, 0.5983132123947144, 0.3930413f, 0.1267513632774353, 0.3148263096809387, 0.733614981174469, 0.6697113513946533, 0.050904035568237305, 0.3045209050178528, 0.698835551738739, 0.22198176383972168, 0.7720783948898315, 0.03413683f, 0.5856906771659851, 0.05425792932510376, 0.3065725564956665, 0.914562f, 0.8024911284446716, 0.561866819858551, 0.6524629592895508, 0.8501238226890564, 0.7371757626533508, 0.3195068836212158, 0.395433247089386, 0.37063318490982056, 0.7104004621505737};
        double[] clocklo_IbefLDO = new double[]{0.7501804232597351, 0.7821298241615295, 0.34100186824798584, 0.10711503028869629, 0.8710756897926331, 0.4342998266220093, 0.33723026514053345, 0.9117512106895447, 0.2600153684616089, 0.1531394124031067, 0.9253020882606506, 0.872222363948822, 0.11161643266677856, 0.4767692f, 0.6135520339012146, 0.4675411581993103, 0.4446919f, 0.3485068082809448, 0.9594364762306213, 0.3672473430633545, 0.6357722282409668, 0.42668914794921875, 0.378991f, 0.3403865098953247, 0.9576561450958252, 0.9184102416038513, 0.4528998136520386, 0.6180059313774109, 0.43196988105773926, 0.0030002593994140625, 0.6589388847351074, 0.634658694267273, 0.3117980360984802, 0.7828250527381897, 0.33912956714630127, 0.2980002164840698, 0.9111488461494446, 0.5686032772064209, 0.5744142532348633, 0.4660971760749817, 0.32455867528915405, 0.18661415576934814, 0.37383097410202026, 0.9825586080551147, 0.13037598133087158, 0.8517256379127502, 0.9634333848953247, 0.3411770462989807, 0.25867152214050293, 0.15205252170562744, 0.8976141214370728, 0.0636865496635437, 0.4083990454673767, 0.46033036708831787, 0.5177094340324402, 0.9938944578170776, 0.3131089210510254, 0.9489572048187256, 0.8960791230201721, 0.5843248963356018, 0.6405413150787354, 0.6184304356575012, 0.665179431438446, 0.6012641191482544, 0.7447822093963623, 0.8340408205986023, 0.01802504062652588, 0.5524716377258301, 0.011943638324737549, 0.7377426028251648, 0.04702198505401611};
        double[] clocklo_VaftLDO = new double[]{0.1787082552909851, 0.3087698817253113, 0.19880056381225586, 0.47124534845352173, 0.0036298036575317383, 0.48100972175598145, 0.27893543243408203, 0.5872438549995422, 0.742646336555481, 0.8933253288269043, 0.30920177698135376, 0.00541454553604126, 0.19430255889892578, 0.35901355743408203, 0.8537948727607727, 0.833575963973999, 0.5199798941612244, 0.1956416368484497, 0.020608484745025635, 0.5128569602966309, 0.8297645449638367, 0.5471782684326172, 0.6729531288146973, 0.4603348970413208, 0.08279919624328613, 0.0353279709815979, 0.2078602910041809, 0.1305302381515503, 0.15609562397003174, 0.509138f, 0.2533954977989197, 0.5670694708824158, 0.7915201783180237, 0.4347783327102661, 0.16308891773223877, 0.11034232378005981, 0.07947146892547607, 0.8545461297035217, 0.765780508518219, 0.6812258362770081, 0.34079432487487793, 0.9090901613235474, 0.8828146457672119, 0.1399632692337036, 0.21496367454528809, 0.48869335651397705, 0.5236793756484985, 0.1787287f, 0.5199159383773804, 0.5029171705245972, 0.9910563230514526, 0.2425785f, 0.9126086831092834, 0.6433528661727905, 0.8951604962348938, 0.17329078912734985, 0.5230847001075745, 0.9876163005828857, 0.02663552761077881, 0.8615723848342896, 0.8602638244628906, 0.745669424533844, 0.35171544551849365, 0.7934263944625854, 0.27476412057876587, 0.28927671909332275, 0.9605495929718018, 0.2449181079864502, 0.8207762837409973, 0.004761755466461182, 0.46034324169158936};
        double[] clocklo_VaftLDO2 = new double[]{0.16555821895599365, 0.27150875329971313, 0.656694f, 0.10323494672775269, 0.7840898036956787, 0.42524755001068115, 0.7998093366622925, 0.37167954444885254, 0.3522723913192749, 0.3840165138244629, 0.2980801f, 0.01173532f, 0.5336012840270996, 0.7146857380867004, 0.4387451410293579, 0.7603783011436462, 0.9566890597343445, 0.9117953777313232, 0.2162758708000183, 0.6132370829582214, 0.7398157119750977, 0.2990939f, 0.6232790946960449, 0.23352354764938354, 0.0970807671546936, 0.9377151727676392, 0.7544595003128052, 0.524128f, 0.8414589166641235, 0.5860521793365479, 0.003827214241027832, 0.9386687278747559, 0.980285108089447, 0.6908504962921143, 0.927821f, 0.46268075704574585, 0.06930744647979736, 0.5201073288917542, 0.5370232462882996, 0.47517257928848267, 0.3581211566925049, 0.1934003233909607, 0.9613986015319824, 0.7286586165428162, 0.4688141345977783, 0.6697930693626404, 0.9688416719436646, 0.2408191f, 0.7379346489906311, 0.9411064386367798, 0.5802518129348755, 0.9545862078666687, 0.896969199180603, 0.3008613f, 0.6579626202583313, 0.03028130531311035, 0.3365599513053894, 0.7464718818664551, 0.5053682923316956, 0.721122f, 0.30348747968673706, 0.28231215476989746, 0.12685906887054443, 0.04280775785446167, 0.4164009094238281, 0.1602160930633545, 0.2971833348274231, 0.17291676998138428, 0.3964492678642273, 0.28606903553009033, 0.18219107389450073};
        double[] clocklo_IaftLDO = new double[]{0.45358043909072876, 0.8229976892471313, 0.07878583669662476, 0.1583128571510315, 0.4715355634689331, 0.6138122081756592, 0.7616521120071411, 0.181441068649292, 0.3565155267715454, 0.2553596f, 0.24437177181243896, 0.55808025598526, 0.7784669399261475, 0.1747505f, 0.5939624309539795, 0.03932642936706543, 0.19584494829177856, 0.04350852966308594, 0.3487668037414551, 0.5736426115036011, 0.4739394187927246, 0.8685665726661682, 0.18529528379440308, 0.8653779029846191, 0.7696412205696106, 0.9820922613143921, 0.3635314702987671, 0.6559988260269165, 0.48620766401290894, 0.15396034717559814, 0.9419606328010559, 0.7031729221343994, 0.5105147957801819, 0.0745890736579895, 0.5363178253173828, 0.12388885021209717, 0.93117f, 0.08772832155227661, 0.7913951277732849, 0.7020647525787354, 0.027035772800445557, 0.87954181432724, 0.2168329358100891, 0.06456923484802246, 0.7436206340789795, 0.5795066952705383, 0.4074091911315918, 0.1938508152961731, 0.8240005373954773, 0.518421471118927, 0.3058089017868042, 0.4776777f, 0.6191377639770508, 0.47795844078063965, 0.2792188f, 0.5696732997894287, 0.7104860544204712, 0.304135262966156, 0.656476616859436, 0.43687504529953003, 0.3795526f, 0.03384626f, 0.6241716742515564, 0.5565491318702698, 0.651703f, 0.37985825538635254, 0.2004251480102539, 0.7636793851852417, 0.8251405954360962, 0.35672032833099365, 0.4145827293395996};
        double[] clocklo_VaftSwch = new double[]{0.4782752990722656, 0.7239797711372375, 0.7197815775871277, 0.9183598160743713, 0.20888584852218628, 0.24312078952789307, 0.5844906568527222, 0.4658542275428772, 0.35205912590026855, 0.3917809f, 0.3365342f, 0.03115654f, 0.4191882014274597, 0.004744529724121094, 0.6189401745796204, 0.6160616278648376, 0.22007405757904053, 0.541482150554657, 0.5644496083259583, 0.9477417469024658, 0.03009939193725586, 0.10220110416412354, 0.4452778100967407, 0.5164448618888855, 0.944242537021637, 0.5786952972412109, 0.8435121774673462, 0.5737094879150391, 0.0709908f, 0.05176180601119995, 0.25011515617370605, 0.4477531909942627, 0.8028997182846069, 0.4242568016052246, 0.5157331228256226, 0.5582222938537598, 0.494049608707428, 0.32102978229522705, 0.7797937989234924, 0.8791483640670776, 0.6195932626724243, 0.42856353521347046, 0.7638687491416931, 0.9366223216056824, 0.04617792367935181, 0.3258591294288635, 0.6397758722305298, 0.19437897205352783, 0.8271254897117615, 0.06476038694381714, 0.9718087911605835, 0.4123146f, 0.891336f, 0.08645033836364746, 0.525852f, 0.12419843673706055, 0.8240468502044678, 0.7583534717559814, 0.4666261076927185, 0.21386557817459106, 0.36055612564086914, 0.8323262333869934, 0.6992086172103882, 0.9445028305053711, 0.2161598801612854, 0.3641442656517029, 0.8141933679580688, 0.06189322471618652, 0.9578322172164917, 0.2023366093635559, 0.3699355125427246};
        double[] dphi_VbefLDO = new double[]{0.4264281392097473, 0.05219519f, 0.6109493970870972, 0.5834362506866455, 0.28520846366882324, 0.2823162078857422, 0.19853603839874268, 0.03734469413757324};
        double[] dphi_IbefLDO = new double[]{0.857648491859436, 0.9606726169586182, 0.3003922700881958, 0.7687066793441772, 0.5367991924285889, 0.8407281637191772, 0.7217233777046204, 0.2505093812942505};
        double[] dphi_VaftLDO = new double[]{0.19337981939315796, 0.1740619f, 0.16812056303024292, 0.8654240965843201, 0.8776325583457947, 0.8186141848564148, 0.3416285514831543, 0.6987219452857971};
        double[] dphi_IaftLDO = new double[]{0.5410972833633423, 0.7867089509963989, 0.0941278338432312, 0.931046187877655, 0.21988266706466675, 0.7550634145736694, 0.9361757636070251, 0.019108355045318604};
        double[] dphi_VaftSwch = new double[]{0.7347357273101807, 0.2345951795578003, 0.7834237813949585, 0.8315953612327576, 0.2510741949081421, 0.7227205038070679, 0.9719487428665161, 0.21742552518844604};
        double[] hvbias_VbefSwch = new double[]{0.7121472358703613, 0.9078497886657715, 0.12912046909332275, 0.27337998151779175, 0.9967654943466187, 0.05340749f, 0.4919287f, 0.1381072998046875, 0.7738508582115173, 0.01103430986404419, 0.2170717716217041, 0.15021568536758423, 0.1217767596244812, 0.8693954944610596, 0.32677024602890015, 0.9909141063690186, 0.571614682674408, 0.27157366275787354, 0.33452296257019043, 0.19836342334747314, 0.9186033606529236, 0.681343138217926, 0.6523274779319763, 0.5440795421600342, 0.8521692156791687, 0.8633056879043579, 0.4047976f, 0.9445672631263733, 0.686534f, 0.0961449146270752, 0.7788357138633728, 0.22763729095458984, 0.5643602013587952, 0.9599761366844177, 0.9858710765838623, 0.45698732137680054, 0.8661306500434875, 0.2414093017578125, 0.9761012196540833, 0.05564993619918823, 0.927304f, 0.662605f, 0.3427470922470093, 0.4644889831542969, 0.8611056208610535, 0.858014f, 0.21424585580825806, 0.9723508358001709, 0.4526193141937256, 0.6550036072731018, 0.131877f, 0.9966618418693542, 0.9532673954963684, 0.1381598711013794, 0.9309994578361511, 0.954749f, 0.7155646085739136, 0.8333218693733215, 0.9204304814338684, 0.8151068091392517, 0.09608691930770874, 0.2935751f, 0.3242270350456238, 0.9630361199378967, 0.8779200315475464, 0.3283578157424927, 0.10404658317565918, 0.5559445023536682, 0.6585713028907776, 0.5269941091537476, 0.21232444047927856};
        double[] hvbias_IbefSwch = new double[]{0.620173990726471, 0.5797096490859985, 0.7934626936912537, 0.7837643623352051, 0.684160053730011, 0.3835126757621765, 0.5497651696205139, 0.2053104043006897, 0.32332944869995117, 0.8373674750328064, 0.5662262439727783, 0.8161535859107971, 0.07231658697128296, 0.9228143692016602, 0.03941547870635986, 0.785889208316803, 0.3423633575439453, 0.01270902156829834, 0.32872843742370605, 0.5602349042892456, 0.2593300938606262, 0.3174777030944824, 0.46322983503341675, 0.9124523401260376, 0.34436845779418945, 0.750078022480011, 0.18899625539779663, 0.8106003403663635, 0.2194158434867859, 0.7009671926498413, 0.507375180721283, 0.9249336123466492, 0.6982911229133606, 0.01829511f, 0.6854037046432495, 0.028214454650878906, 0.7769781351089478, 0.3220542073249817, 0.945830225944519, 0.8596281409263611, 0.8599603772163391, 0.03954344987869263, 0.07610797882080078, 0.2586974f, 0.6401305794715881, 0.706870436668396, 0.15935587882995605, 0.7605285048484802, 0.1153864860534668, 0.9390849471092224, 0.4172125f, 0.0624614953994751, 0.3936976194381714, 0.40978842973709106, 0.6719681620597839, 0.2124303f, 0.9689804911613464, 0.40770626068115234, 0.35620254278182983, 0.3718924f, 0.691962f, 0.338876f, 0.0108528733253479, 0.1150006651878357, 0.503386378288269, 0.5330544710159302, 0.2712981104850769, 0.4378369450569153, 0.3220877f, 0.08405661582946777, 0.915386974811554};
        double[] power = new double[]{0.6672022938728333, 0.10890454053878784, 0.2265278697013855, 0.3727222f, 0.9309805035591125, 0.7710607051849365, 0.024738788604736328, 0.4219083786010742, 0.6379082798957825, 0.08302581310272217, 0.34914594888687134, 0.6484825611114502, 0.823265790939331, 0.42215466499328613, 0.24856221675872803, 0.6331031918525696, 0.2612391710281372, 0.7343838214874268, 0.7228309512138367, 0.08511823415756226, 0.8903263211250305, 0.5313438773155212, 0.47403955459594727, 0.04435485601425171, 0.514099657535553, 0.7904729247093201, 0.7027900815010071, 0.422962f, 0.5479776859283447, 0.6897464394569397, 0.23725569248199463, 0.14412641525268555, 0.10858649015426636, 0.10476714372634888, 0.8821964263916016, 0.815823f, 0.2641300559043884, 0.5650993585586548, 0.5764214992523193, 0.6314249634742737, 0.26338517665863037, 0.886415421962738, 0.8021236658096313, 0.15659433603286743, 0.9720560312271118, 0.3334273099899292, 0.3279575705528259, 6.222128868103027E-4, 0.2059685f, 0.9344773888587952, 0.24769741296768188, 0.5031424164772034, 0.751767635345459, 0.3614826798439026, 0.9339208006858826, 0.4323824644088745, 0.4013543725013733, 0.6487030982971191, 0.8256847262382507, 0.9929359555244446, 0.543327271938324, 0.3811991810798645, 0.3529665470123291, 0.899176f, 0.703377f, 0.9101479053497314, 0.03925037384033203, 0.870225191116333, 0.8092371821403503, 0.6093133091926575, 0.265672504901886};
        double[] heater_VbefLDO = new double[]{0.14483213424682617, 0.980869472026825, 0.2774551f, 0.0023656487464904785, 0.7661821842193604, 0.8726224303245544, 0.008474588394165039, 0.269934f, 0.7298126220703125, 0.283852219581604, 0.3284257f, 0.26936566829681396, 0.1702648401260376, 0.12374293804168701, 0.1605767011642456, 0.17327308654785156, 0.6473636031150818, 0.2837662696838379, 0.39153552055358887, 0.9944057464599609, 0.11016994714736938, 0.40944063663482666, 0.028708934783935547, 0.8062850832939148, 0.11042892932891846, 0.5469865202903748, 0.35834717750549316, 0.7810779213905334, 0.4180908203125, 0.6984469294548035, 0.22103798389434814, 0.005081593990325928, 0.9851865768432617, 0.18229389190673828, 0.7453057169914246, 0.13420498371124268, 0.602597f, 0.5500474572181702, 0.2380974292755127, 0.5404694080352783, 0.0042948126792907715, 0.540683f, 0.6821931004524231, 0.3838379383087158, 0.2683054804801941, 0.0044209957122802734, 0.5843737721443176, 0.8077393174171448, 0.3314119577407837, 0.9398244023323059, 0.04455852508544922, 0.3157396912574768, 0.22961455583572388, 0.2600382f, 0.5557433366775513, 0.03332066535949707, 0.2682797312736511, 0.835699f, 0.5187285542488098, 0.5131472945213318, 0.9501218199729919, 0.9068294763565063, 0.9762282967567444, 0.6031903028488159, 0.8966374397277832, 0.47036391496658325, 0.9905407428741455};
        double[] heater_IbefLDO = new double[]{0.591361f, 0.7059505581855774, 0.5433976650238037, 0.15070343017578125, 0.8728080987930298, 0.22946041822433472, 0.7875076532363892, 0.28273457288742065, 0.08971691131591797, 0.9190602898597717, 0.3223743438720703, 0.824600100517273, 0.47948354482650757, 0.009491801261901855, 0.32639604806900024, 0.930970311164856, 0.7747588753700256, 0.43571794033050537, 0.3400881886482239, 0.9973176121711731, 0.74546f, 0.6377660632133484, 0.8800060749053955, 0.3847376f, 0.5039306879043579, 0.13565868139266968, 0.8150332570075989, 0.02296573f, 0.23363816738128662, 0.8407949209213257, 0.9345892667770386, 0.7469542622566223, 0.6008708477020264, 0.1490660309791565, 0.6841963529586792, 0.55022794008255, 0.8977405428886414, 0.5923176407814026, 0.29560422897338867, 0.9248427152633667, 0.9013956189155579, 0.1313532590866089, 0.587122917175293, 0.502545952796936, 0.554853f, 0.49399012327194214, 0.8488991260528564, 0.8547142744064331, 0.24351871013641357, 0.4998297095298767, 0.20467013120651245, 0.4804941415786743, 0.600662350654602, 0.28911691904067993, 0.10622406005859375, 0.2845771908760071, 0.19535952806472778, 0.2716858983039856, 0.57271808385849, 0.6801219582557678, 0.9863411784172058, 0.4345045f, 0.040596723556518555, 0.4510248899459839, 0.24155282974243164, 0.1593343f, 0.3006778359413147};
        double[] heater_VaftLDO = new double[]{0.6642115116119385, 0.480914f, 0.6877423524856567, 0.7297399044036865, 0.8706507086753845, 0.48177802562713623, 0.8769945502281189, 0.590458f, 0.09780663251876831, 0.15407198667526245, 0.4806939363479614, 0.4947551488876343, 0.3812718987464905, 0.1342865228652954, 0.19151055812835693, 0.5736196041107178, 0.8650376200675964, 0.831786f, 0.4447069764137268, 0.5463930368423462, 0.5145382881164551, 0.782811164855957, 0.11074292659759521, 0.7627708315849304, 0.8211779594421387, 7.00533390045166E-4, 0.829028308391571, 0.632724f, 0.2590363621711731, 0.3570008873939514, 0.7444774508476257, 0.34782296419143677, 0.8020336627960205, 0.26717454195022583, 0.7111355662345886, 0.8197100758552551, 0.28179192543029785, 0.29453176259994507, 0.7956450581550598, 0.6585484147071838, 0.4121803641319275, 0.012966454029083252, 0.836174488067627, 0.33012425899505615, 0.7161108255386353, 0.1973016858100891, 0.3437484f, 0.3619541525840759, 0.5442271828651428, 0.3319457173347473, 0.6424169540405273, 0.31645673513412476, 0.694988f, 0.5646265149116516, 0.5677422881126404, 0.8663014769554138, 0.5432001948356628, 0.6808434724807739, 0.5306318998336792, 0.5498949289321899, 0.9118539094924927, 0.86311f, 0.32221734523773193, 0.9631755352020264, 0.42330247163772583, 0.931940495967865, 0.7174871563911438};
        double[] heater_IaftLDO = new double[]{0.2701593041419983, 0.6242156028747559, 0.2758709788322449, 0.0285872220993042, 0.9548272490501404, 0.5687222480773926, 0.676720380783081, 0.07657766342163086, 0.8599209189414978, 0.6807896494865417, 0.9630666375160217, 0.1720807f, 0.38608092069625854, 0.9058241248130798, 0.6969020366668701, 0.2154008150100708, 0.5827234387397766, 0.34901314973831177, 0.5611594319343567, 0.8056930303573608, 0.028420686721801758, 0.6209725737571716, 0.492895f, 0.6625778675079346, 0.3547762632369995, 0.9473573565483093, 0.9501331448554993, 0.8538516163825989, 0.9484403133392334, 0.1164010763168335, 0.6396068930625916, 0.4468458294868469, 0.4086828827857971, 0.5456585884094238, 0.02587151527404785, 0.6814019083976746, 0.33366f, 0.04595458507537842, 0.5256627798080444, 0.5378202795982361, 0.751111f, 0.28671908378601074, 0.32916945219039917, 0.34762293100357056, 0.24578464031219482, 0.9531963467597961, 0.724480926990509, 0.5882585644721985, 0.5166085958480835, 0.20372027158737183, 0.903356671333313, 0.20033115148544312, 0.6247987151145935, 0.24628466367721558, 0.8442805409431458, 0.16852563619613647, 0.6762151122093201, 0.7605300545692444, 0.6792696714401245, 0.9817349314689636, 0.6768622398376465, 0.9871897101402283, 0.20898127555847168, 0.2161952257156372, 0.07220995426177979, 0.7257737517356873, 0.01931673288345337};
        double[] heater_VaftSwch = new double[]{0.41555172204971313, 0.24479424953460693, 0.24723303318023682, 0.13308674097061157, 0.7371931076049805, 0.4192899465560913, 0.4065789580345154, 0.7916378378868103, 0.3240036368370056, 0.881998f, 0.5865986943244934, 0.8710257411003113, 0.8896157741546631, 0.737658679485321, 0.7141920328140259, 0.49086976051330566, 0.683655858039856, 0.1290055513381958, 0.5523765683174133, 0.5450604557991028, 0.4573369026184082, 0.6649580597877502, 0.011204242706298828, 0.4737842082977295, 0.6706671714782715, 0.926386833190918, 0.9578647017478943, 0.4857508f, 0.37773674726486206, 0.23166781663894653, 0.19891422986984253, 0.33607447147369385, 0.6688705086708069, 0.18859022855758667, 0.1052696704864502, 0.4550988f, 0.4263696074485779, 0.9785431027412415, 0.04339194297790527, 0.8208237886428833, 0.4182051420211792, 0.3103522062301636, 0.044610023498535156, 0.1648794412612915, 0.3811091184616089, 0.7448558211326599, 0.310099720954895, 0.419697642326355, 0.9663720726966858, 0.7806322574615479, 0.42353951930999756, 0.35129547119140625, 0.9892883896827698, 0.06265145540237427, 0.8794628381729126, 0.0046578049659729, 0.8531876802444458, 0.1386016f, 0.475973f, 0.42198026180267334, 0.8435778021812439, 0.8549275994300842, 0.6495740413665771, 0.41100573539733887, 0.004959166049957275, 0.22203278541564941, 0.22181165218353271};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(digital_VbefLDO, location, digital_IbefLDO, digital_VaftLDO, digital_IaftLDO, digital_VaftSwch, analog_VbefLDO, analog_IbefLDO, analog_VaftLDO, analog_IaftLDO, analog_VaftSwch, od_VbefLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_IaftLDO, od_VaftSwch, clockhi_VbefLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_IaftLDO, clockhi_VaftSwch, clocklo_VbefLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_IaftLDO, clocklo_VaftSwch, dphi_VbefLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_IaftLDO, dphi_VaftSwch, hvbias_VbefSwch, hvbias_IbefSwch, power, heater_VbefLDO, heater_IbefLDO, heater_VaftLDO, heater_IaftLDO, heater_VaftSwch));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double supplyTmp = 0.3525004982948303;
        double preExpnTmp = 0.8358215093612671;
        double evapExitTmp = 0.05458575487136841;
        double hexRtrnTmp = 0.6972531080245972;
        double supplyPrs = 0.8818201422691345;
        double returnPrs = 0.1453111171722412;
        double superHeat = 0.03050941228866577;
        double supplySubCooling = 0.00572598f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(supplyTmp, preExpnTmp, evapExitTmp, hexRtrnTmp, supplyPrs, returnPrs, superHeat, supplySubCooling));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double supplyTmp = 0.07689869403839111;
        double preExpnTmp = 0.20277822017669678;
        double evapExitTmp = 0.8362040519714355;
        double hexRtrnTmp = 0.8649720549583435;
        double supplyPrs = 0.6793609261512756;
        double returnPrs = 0.13923954963684082;
        double superHeat = 0.5541933178901672;
        double supplySubCooling = 0.08987283706665039;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(supplyTmp, preExpnTmp, evapExitTmp, hexRtrnTmp, supplyPrs, returnPrs, superHeat, supplySubCooling));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.0904434323310852;
        double preC3Tmp = 0.30368977785110474;
        double preC4Tmp = 0.38412272930145264;
        double c4ExitTmp = 0.6686970591545105;
        double evapExitTmp = 0.970769464969635;
        double hexRtrnTmp = 0.5787754058837891;
        double vaporPrs = 0.6034592390060425;
        double liquidPrs = 0.13358372449874878;
        double returnPrs = 0.3626420497894287;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.17682719230651855;
        double preC3Tmp = 0.5080306529998779;
        double preC4Tmp = 0.18048542737960815;
        double c4ExitTmp = 0.3034044f;
        double evapExitTmp = 0.09148752689361572;
        double hexRtrnTmp = 0.015524685382843018;
        double vaporPrs = 0.042476534843444824;
        double liquidPrs = 0.9447004199028015;
        double returnPrs = 0.6106403470039368;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.9611856937408447;
        double preC3Tmp = 0.3297159671783447;
        double preC4Tmp = 0.599407970905304;
        double c4ExitTmp = 0.3071601390838623;
        double evapExitTmp = 0.6112763285636902;
        double hexRtrnTmp = 0.8501082062721252;
        double vaporPrs = 0.8479991555213928;
        double liquidPrs = 0.9348637461662292;
        double returnPrs = 0.01659691333770752;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.8881202340126038;
        double preC3Tmp = 0.6196069121360779;
        double preC4Tmp = 0.15332788228988647;
        double c4ExitTmp = 0.9288108348846436;
        double evapExitTmp = 0.007197737693786621;
        double hexRtrnTmp = 0.8687871098518372;
        double vaporPrs = 0.9879086017608643;
        double liquidPrs = 0.7129433751106262;
        double returnPrs = 0.2563207745552063;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.2736093997955322;
        double preC3Tmp = 0.166955828666687;
        double preC4Tmp = 0.06978166103363037;
        double c4ExitTmp = 0.6966151595115662;
        double evapExitTmp = 0.0391765832901001;
        double hexRtrnTmp = 0.7490960955619812;
        double vaporPrs = 0.19469726085662842;
        double liquidPrs = 0.05337143f;
        double returnPrs = 0.9859680533409119;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.8074027299880981;
        double preC3Tmp = 0.9604609608650208;
        double preC4Tmp = 0.566743791103363;
        double c4ExitTmp = 0.2956578731536865;
        double evapExitTmp = 0.9377648234367371;
        double hexRtrnTmp = 0.7398664951324463;
        double vaporPrs = 0.42583465576171875;
        double liquidPrs = 0.5675352811813354;
        double returnPrs = 0.3349054455757141;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1Telemetry() throws Exception {
        double dischrgtmp_P = 0.9514988660812378;
        double dischrgtmp_M = 0.5814900994300842;
        double dischrgPrs = 0.7737317085266113;
        double suctiontmp_P = 0.47601163387298584;
        double suctiontmp_M = 0.3939659595489502;
        double suctionPrs = 0.9392192959785461;
        double liquidtmp_P = 0.6866464018821716;
        double liquidtmp_M = 0.6791777014732361;
        double compVoltage = 0.9586793184280396;
        double compCurrent = 0.5221264362335205;
        double compPower = 0.8608935475349426;
        double compVfdVolt = 0.08780103921890259;
        double compVfdCurr = 0.6102727651596069;
        double compVfdFreq = 0.8921406865119934;
        double hGBValvePosn = 0.08652341365814209;
        double coolValvePosn = 0.8643139004707336;
        double coolFlowRate = 0.28154534101486206;
        double waterInTmp = 0.04431861639022827;
        double waterOutTmp = 0.7700846791267395;
        double cabinetTmp = 0.46440547704696655;
        double ambientTmp = 0.9341153502464294;
        double fan1Speed = 0.9023557901382446;
        double fan2Speed = 0.1533002257347107;
        double fan3Speed = 0.9790434837341309;
        double liquidSubCooling = 0.8275848031044006;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold1Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, liquidtmp_P, liquidtmp_M, compVoltage, compCurrent, compPower, compVfdVolt, compVfdCurr, compVfdFreq, hGBValvePosn, coolValvePosn, coolFlowRate, waterInTmp, waterOutTmp, cabinetTmp, ambientTmp, fan1Speed, fan2Speed, fan3Speed, liquidSubCooling));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1Telemetry));
        Refrig_Cold1Telemetry item_ = (Refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2Telemetry() throws Exception {
        double dischrgtmp_P = 0.09310239553451538;
        double dischrgtmp_M = 0.9318578839302063;
        double dischrgPrs = 0.36461538076400757;
        double suctiontmp_P = 0.5628921389579773;
        double suctiontmp_M = 0.6538625955581665;
        double suctionPrs = 0.30332714319229126;
        double liquidtmp_P = 0.3854808807373047;
        double liquidtmp_M = 0.7167383432388306;
        double compVoltage = 0.9092383980751038;
        double compCurrent = 0.9458901286125183;
        double compPower = 0.7378840446472168;
        double compVfdVolt = 0.5637106895446777;
        double compVfdCurr = 0.7655454277992249;
        double compVfdFreq = 0.9289215207099915;
        double hGBValvePosn = 0.8448687195777893;
        double coolValvePosn = 0.14431214332580566;
        double coolFlowRate = 0.8222881555557251;
        double waterInTmp = 0.18110471963882446;
        double waterOutTmp = 0.4595492482185364;
        double cabinetTmp = 0.6369833946228027;
        double ambientTmp = 0.844383f;
        double fan1Speed = 0.3184886574745178;
        double fan2Speed = 0.5054131746292114;
        double fan3Speed = 0.9399481415748596;
        double liquidSubCooling = 0.5189183354377747;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold2Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, liquidtmp_P, liquidtmp_M, compVoltage, compCurrent, compPower, compVfdVolt, compVfdCurr, compVfdFreq, hGBValvePosn, coolValvePosn, coolFlowRate, waterInTmp, waterOutTmp, cabinetTmp, ambientTmp, fan1Speed, fan2Speed, fan3Speed, liquidSubCooling));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2Telemetry));
        Refrig_Cold2Telemetry item_ = (Refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double dischrgtmp_P = 0.3685503602027893;
        double dischrgtmp_M = 0.5495001673698425;
        double dischrgPrs = 0.5770113468170166;
        double suctiontmp_P = 0.9200283288955688;
        double suctiontmp_M = 0.04994380474090576;
        double suctionPrs = 0.2451612949371338;
        double oilLevel = 0.4761243f;
        double compVoltage = 0.4993549f;
        double compCurrent = 0.6923170685768127;
        double compPower = 0.8091341853141785;
        double waterInTmp = 0.99953293800354;
        double waterOutTmp = 0.6226070523262024;
        double afterCoolTmp = 0.8456267714500427;
        double phaseSepTmp = 0.6919734477996826;
        double oilSepTmp = 0.4517285227775574;
        double surgeTankTmp = 0.9905713796615601;
        double cabinetTmp = 0.9511501789093018;
        double ambientTmp = 0.6561757922172546;
        double fanSpeed = 0.48141002655029297;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, oilLevel, compVoltage, compCurrent, compPower, waterInTmp, waterOutTmp, afterCoolTmp, phaseSepTmp, oilSepTmp, surgeTankTmp, cabinetTmp, ambientTmp, fanSpeed));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double dischrgtmp_P = 0.6618701815605164;
        double dischrgtmp_M = 0.7724047303199768;
        double dischrgPrs = 0.3529933f;
        double suctiontmp_P = 0.6045691967010498;
        double suctiontmp_M = 0.6717112064361572;
        double suctionPrs = 0.3370588421821594;
        double oilLevel = 0.5629045367240906;
        double compVoltage = 0.9890676140785217;
        double compCurrent = 0.3933763f;
        double compPower = 0.9724202156066895;
        double waterInTmp = 0.6776211261749268;
        double waterOutTmp = 0.5912569165229797;
        double afterCoolTmp = 0.1854075789451599;
        double phaseSepTmp = 0.257096f;
        double oilSepTmp = 0.910568356513977;
        double surgeTankTmp = 0.36000192165374756;
        double fanSpeed = 0.5161671042442322;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, oilLevel, compVoltage, compCurrent, compPower, waterInTmp, waterOutTmp, afterCoolTmp, phaseSepTmp, oilSepTmp, surgeTankTmp, fanSpeed));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double dischrgtmp_P = 0.8179458379745483;
        double dischrgtmp_M = 0.5508468747138977;
        double dischrgPrs = 0.11371076107025146;
        double suctiontmp_P = 0.5580775737762451;
        double suctiontmp_M = 0.41062116622924805;
        double suctionPrs = 0.2612317204475403;
        double oilLevel = 0.6456125378608704;
        double compVoltage = 0.23644012212753296;
        double compCurrent = 0.49806827306747437;
        double compPower = 0.6679016947746277;
        double waterInTmp = 0.8686143159866333;
        double waterOutTmp = 0.3329329f;
        double afterCoolTmp = 0.026739537715911865;
        double phaseSepTmp = 0.018037617206573486;
        double oilSepTmp = 0.32381415367126465;
        double surgeTankTmp = 0.553010106086731;
        double fanSpeed = 0.5654290914535522;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, oilLevel, compVoltage, compCurrent, compPower, waterInTmp, waterOutTmp, afterCoolTmp, phaseSepTmp, oilSepTmp, surgeTankTmp, fanSpeed));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double dischrgtmp_P = 0.4765365f;
        double dischrgtmp_M = 0.049465715885162354;
        double dischrgPrs = 0.43136143684387207;
        double suctiontmp_P = 0.7652438282966614;
        double suctiontmp_M = 0.1958372f;
        double suctionPrs = 0.746325f;
        double oilLevel = 0.6728905439376831;
        double compVoltage = 0.8980095386505127;
        double compCurrent = 0.889841f;
        double compPower = 0.940437f;
        double waterInTmp = 0.5015009045600891;
        double waterOutTmp = 0.2892676591873169;
        double afterCoolTmp = 0.5563682317733765;
        double phaseSepTmp = 0.6982271075248718;
        double oilSepTmp = 0.9491164088249207;
        double surgeTankTmp = 0.8639533519744873;
        double cabinetTmp = 0.7703639268875122;
        double ambientTmp = 0.6070781946182251;
        double fanSpeed = 0.7872368097305298;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, oilLevel, compVoltage, compCurrent, compPower, waterInTmp, waterOutTmp, afterCoolTmp, phaseSepTmp, oilSepTmp, surgeTankTmp, cabinetTmp, ambientTmp, fanSpeed));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double dischrgtmp_P = 0.9289936423301697;
        double dischrgtmp_M = 0.6756395101547241;
        double dischrgPrs = 0.6163363456726074;
        double suctiontmp_P = 0.147966206073761;
        double suctiontmp_M = 0.21668028831481934;
        double suctionPrs = 0.2654006f;
        double oilLevel = 0.8109714388847351;
        double compVoltage = 0.35652297735214233;
        double compCurrent = 0.17313945293426514;
        double compPower = 0.6059055924415588;
        double waterInTmp = 0.838118851184845;
        double waterOutTmp = 0.2990332841873169;
        double afterCoolTmp = 0.3930498957633972;
        double phaseSepTmp = 0.4336628317832947;
        double oilSepTmp = 0.05376213788986206;
        double surgeTankTmp = 0.8648365139961243;
        double fanSpeed = 0.948581f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, oilLevel, compVoltage, compCurrent, compPower, waterInTmp, waterOutTmp, afterCoolTmp, phaseSepTmp, oilSepTmp, surgeTankTmp, fanSpeed));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double dischrgtmp_P = 0.6705923080444336;
        double dischrgtmp_M = 0.23433172702789307;
        double dischrgPrs = 0.8591327667236328;
        double suctiontmp_P = 0.4390936493873596;
        double suctiontmp_M = 0.24514985084533691;
        double suctionPrs = 0.0905624f;
        double oilLevel = 0.8977431058883667;
        double compVoltage = 0.7783522605895996;
        double compCurrent = 0.5877601504325867;
        double compPower = 0.7162644267082214;
        double waterInTmp = 0.4298211932182312;
        double waterOutTmp = 0.7458406090736389;
        double afterCoolTmp = 0.9588882923126221;
        double phaseSepTmp = 0.3435439467430115;
        double oilSepTmp = 0.3359619379043579;
        double surgeTankTmp = 0.9443953037261963;
        double fanSpeed = 0.5561692714691162;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, oilLevel, compVoltage, compCurrent, compPower, waterInTmp, waterOutTmp, afterCoolTmp, phaseSepTmp, oilSepTmp, surgeTankTmp, fanSpeed));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double cip1_I = 0.4024010896682739;
        double cip2_I = 0.8083450794219971;
        double cip3_I = 0.14202088117599487;
        double cip4_I = 0.08731263875961304;
        double cip5_I = 0.39360755681991577;
        double cip6_I = 0.11698472499847412;
        double cip1_V = 0.7238171696662903;
        double cip2_V = 0.15773671865463257;
        double cip3_V = 0.67952f;
        double cip4_V = 0.7231218814849854;
        double cip5_V = 0.6609375476837158;
        double cip6_V = 0.6414085030555725;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(cip1_I, cip2_I, cip3_I, cip4_I, cip5_I, cip6_I, cip1_V, cip2_V, cip3_V, cip4_V, cip5_V, cip6_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)cip1_I, (double)item_.getCip1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2_I, (double)item_.getCip2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3_I, (double)item_.getCip3_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4_I, (double)item_.getCip4_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5_I, (double)item_.getCip5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6_I, (double)item_.getCip6_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1_V, (double)item_.getCip1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2_V, (double)item_.getCip2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3_V, (double)item_.getCip3_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4_V, (double)item_.getCip4_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5_V, (double)item_.getCip5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6_V, (double)item_.getCip6_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTelemetry() throws Exception {
        double turboSpeed = 0.13133573532104492;
        double turboCurrent = 0.22921711206436157;
        double turboVoltage = 0.6160411238670349;
        double turboPower = 0.9311520457267761;
        double turboPumpTemp = 0.9996904134750366;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPumpTelemetry(turboSpeed, turboCurrent, turboVoltage, turboPower, turboPumpTemp));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTelemetry));
        Vacuum_TurboPumpTelemetry item_ = (Vacuum_TurboPumpTelemetry)item;
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGaugeTelemetry() throws Exception {
        double cryoVac = 0.2073981761932373;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoVacGaugeTelemetry(cryoVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGaugeTelemetry));
        Vacuum_CryoVacGaugeTelemetry item_ = (Vacuum_CryoVacGaugeTelemetry)item;
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacGaugeTelemetry() throws Exception {
        double turboVac = 0.4755558967590332;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVacGaugeTelemetry(turboVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacGaugeTelemetry));
        Vacuum_TurboVacGaugeTelemetry item_ = (Vacuum_TurboVacGaugeTelemetry)item;
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacGaugeTelemetry() throws Exception {
        double forelineVac = 0.11734247207641602;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_ForelineVacGaugeTelemetry(forelineVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacGaugeTelemetry));
        Vacuum_ForelineVacGaugeTelemetry item_ = (Vacuum_ForelineVacGaugeTelemetry)item;
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacGaugeTelemetry() throws Exception {
        double hex1Vac = 0.20800745487213135;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex1VacGaugeTelemetry(hex1Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacGaugeTelemetry));
        Vacuum_Hex1VacGaugeTelemetry item_ = (Vacuum_Hex1VacGaugeTelemetry)item;
        Assert.assertEquals((double)hex1Vac, (double)item_.getHex1Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacGaugeTelemetry() throws Exception {
        double hex2Vac = 0.7677738666534424;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex2VacGaugeTelemetry(hex2Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacGaugeTelemetry));
        Vacuum_Hex2VacGaugeTelemetry item_ = (Vacuum_Hex2VacGaugeTelemetry)item;
        Assert.assertEquals((double)hex2Vac, (double)item_.getHex2Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.23312586545944214;
        double freeSpace = 0.25364553928375244;
        double freeFraction = 0.01732468605041504;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeSpace, freeFraction));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
    }

    /*
     * Opcode count of 16218 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = new double[]{0.19851797819137573, 0.07886761426925659, 0.7331538200378418, 0.14327090978622437, 0.405474f, 0.18665581941604614, 0.7313781380653381, 0.5893859267234802, 0.6152721047401428, 0.775844156742096, 0.7531850337982178, 0.8181444406509399, 0.6882471442222595, 0.8719899654388428, 0.6436505913734436, 0.23704993724822998, 0.8620907068252563, 0.9488015174865723, 0.3482805f, 0.1103331446647644, 0.1510737f, 0.5242906212806702, 0.11210393905639648, 0.8985620737075806, 0.43637847900390625, 0.3597577214241028, 0.3313819169998169, 0.11341977119445801, 0.36874884366989136, 0.30063343048095703, 0.5733118057250977, 0.1907286f, 0.07408136129379272, 0.9613697528839111, 0.2810043692588806, 0.7223102450370789, 0.7051712870597839, 0.4286355972290039, 0.821640133857727, 0.9404242634773254, 0.6586137413978577, 0.3022971749305725, 0.019173502922058105, 0.36438167095184326, 0.7055245637893677, 0.6544204950332642, 0.35897761583328247, 0.44769471883773804, 0.9395627379417419, 0.6333457827568054, 0.1457616090774536, 0.30910396575927734, 0.7876299619674683, 0.32137006521224976, 0.03891545534133911, 0.798478364944458, 0.960125744342804, 0.24750185012817383, 0.3477563261985779, 0.2984744906425476, 0.1319172978401184, 0.41599923372268677, 0.025183498859405518, 0.5576649308204651, 0.9760276079177856, 0.41997861862182617, 0.4998520612716675, 0.2064264416694641, 0.4438704252243042, 0.8284198641777039, 0.897624135017395};
        double[] anaV = new double[]{0.34215712547302246, 0.5637001991271973, 0.5536494255065918, 0.15185177326202393, 0.05744117498397827, 0.568472f, 0.8922428488731384, 0.33371347188949585, 0.0987931489944458, 0.5617997646331787, 0.7807552218437195, 0.858722f, 0.012916147708892822, 0.7730824947357178, 0.9924027919769287, 0.16961520910263062, 0.393436f, 0.4676728844642639, 0.3235267996788025, 0.950741708278656, 0.8684093952178955, 0.8833555579185486, 0.6592691540718079, 0.8019799590110779, 0.6552297472953796, 0.9191738367080688, 0.3743744492530823, 0.7640418410301208, 0.1957025f, 0.3562043309211731, 0.1035429835319519, 0.8301777243614197, 0.11396819353103638, 0.9322737455368042, 0.1205523f, 0.055927932262420654, 0.510693371295929, 0.8044971823692322, 0.5888203978538513, 0.5583794713020325, 0.118716299533844, 0.6361905932426453, 0.8087137341499329, 0.31473642587661743, 0.7514522075653076, 0.45007646083831787, 0.38733595609664917, 0.4778798818588257, 0.6322718262672424, 0.3503100275993347, 0.42153215408325195, 0.9405712485313416, 0.9103419184684753, 0.4748570919036865, 0.3192838430404663, 0.1322788f, 0.9587470889091492, 0.9809537529945374, 0.6215694546699524, 0.8211221098899841, 0.8799272179603577, 0.264176f, 0.037245213985443115, 0.8316174149513245, 0.18049907684326172, 0.8810932636260986, 0.10683053731918335, 0.6558665633201599, 0.4444645643234253, 0.0922282338142395, 0.2846348285675049};
        double[] aspicl_Temp0 = new double[]{0.5262895822525024, 0.355829f, 0.512394368648529, 0.4179529547691345, 0.49230873584747314, 0.8770867586135864, 0.8863378763198853, 0.3307120203971863, 0.7775276303291321, 0.2603192925453186, 0.4765177369117737, 0.538736f, 0.32951056957244873, 0.7873667478561401, 0.3249784f, 0.6645834445953369, 0.16848605871200562, 0.3423706293106079, 0.7413895726203918, 0.3397224545478821, 0.31702184677124023, 0.7047633528709412, 0.6738688945770264, 0.8167594075202942, 0.6884254813194275, 0.6074469685554504, 0.17819565534591675, 0.0288047194480896, 0.03141742944717407, 0.3805251717567444, 0.445138156414032, 0.8692061305046082, 0.5922234654426575, 0.34573203325271606, 0.8461409211158752, 0.29333287477493286, 0.5480014085769653, 0.9439455270767212, 0.17646163702011108, 0.8134715557098389, 0.9884178638458252, 0.9743461608886719, 0.8145559430122375, 0.7449623942375183, 0.5418396592140198, 0.8584350943565369, 0.37024158239364624, 0.4213432f, 0.9412123560905457, 0.7779667377471924, 0.6957201957702637, 0.6114848852157593, 0.45013368129730225, 0.08869701623916626, 0.9073131680488586, 0.7036300301551819, 0.1853525f, 6.425380706787109E-4, 0.4768126f, 0.3591451048851013, 0.8070500493049622, 0.012359857559204102, 0.05532526969909668, 0.350044f, 0.6475058197975159, 0.5667860507965088, 0.6856868863105774, 0.07445335388183594, 0.22247213125228882, 0.3877451419830322, 0.5288563966751099};
        double[] aspicl_Temp1 = new double[]{0.7667878866195679, 0.843757152557373, 0.6907736659049988, 0.40270912647247314, 0.9862614274024963, 0.11774063110351562, 0.124015212059021, 0.9264928698539734, 0.45834052562713623, 0.8800553679466248, 0.7722789645195007, 0.13968563079833984, 0.4668780565261841, 0.25430363416671753, 0.6907683610916138, 0.2695086f, 0.5360629558563232, 0.2209264039993286, 0.2684100270271301, 0.14694452285766602, 0.21525651216506958, 0.29529523849487305, 0.751218318939209, 0.29745012521743774, 0.07863074541091919, 0.6114919185638428, 0.6839163899421692, 0.28092825412750244, 0.09579664468765259, 0.1254165768623352, 0.006414890289306641, 0.6378452181816101, 0.9179320931434631, 0.5388111472129822, 0.4271765947341919, 0.1671883463859558, 0.28305935859680176, 0.42109203338623047, 0.2975338101387024, 0.9604177474975586, 0.1789534091949463, 0.40078842639923096, 0.0423734188079834, 0.027467668056488037, 0.9457014799118042, 0.01072669f, 0.7290836572647095, 0.750603437423706, 0.5633063912391663, 0.11436784267425537, 0.2472077f, 0.2045899f, 0.6921947002410889, 0.8939918875694275, 0.9479475021362305, 0.39282822608947754, 0.9334348440170288, 0.2394595742225647, 0.28069907426834106, 0.11516928672790527, 0.39640188217163086, 0.3994171619415283, 0.7414987683296204, 0.8409228324890137, 0.22817015647888184, 0.8210232853889465, 0.2970648407936096, 0.08768868446350098, 0.822840690612793, 0.8511691093444824, 0.8025991320610046};
        double[] aspicl_Temp2 = new double[]{0.2712118f, 0.12018972635269165, 0.0589558482170105, 0.9293656349182129, 0.3022868037223816, 0.6794726252555847, 0.28874891996383667, 0.8501083850860596, 0.763229489326477, 0.11206340789794922, 0.6039116978645325, 0.6905502676963806, 0.8386315107345581, 0.3401137f, 0.237440824508667, 0.29060542583465576, 0.2336796f, 0.9599564075469971, 0.7469072341918945, 0.5797286033630371, 0.6595475673675537, 0.4990702271461487, 0.26269805431365967, 0.2603398561477661, 0.5611686706542969, 0.4126906394958496, 0.02153939f, 0.11794614791870117, 0.2106036f, 0.4473613500595093, 0.0582507848739624, 0.1960049867630005, 0.08240824937820435, 0.2587484121322632, 0.7698737382888794, 0.05042862892150879, 0.1996554136276245, 0.492898f, 0.11557555198669434, 0.048741817474365234, 0.4149938225746155, 0.5849355459213257, 0.036534786224365234, 0.12121200561523438, 0.03537863492965698, 0.2862449288368225, 0.6014646291732788, 0.877855658531189, 0.8675341606140137, 0.9678035378456116, 0.7502580881118774, 0.6512664556503296, 0.35011518001556396, 0.4591013789176941, 0.9307867884635925, 0.8390450477600098, 0.5348168015480042, 0.04256415367126465, 0.5281383991241455, 0.13267016410827637, 0.009895265102386475, 0.03439295291900635, 0.6631322503089905, 0.5165162682533264, 0.5438616871833801, 0.5241110920906067, 0.5950376391410828, 0.6890823245048523, 0.023287177085876465, 0.524875f, 0.7748857736587524};
        double[] aspicu_Temp0 = new double[]{0.13917267322540283, 0.8161264061927795, 0.2908974289894104, 0.2490900754928589, 0.04671168327331543, 0.8007653951644897, 0.5014066696166992, 0.06237358f, 0.4681434631347656, 0.14179348945617676, 0.5847997665405273, 0.02397102117538452, 0.6101709604263306, 0.28757625818252563, 0.6825615167617798, 0.4170817f, 0.046231627464294434, 0.3239814043045044, 0.7287335991859436, 0.1995697021484375, 0.3440535068511963, 0.595621f, 0.27399855852127075, 0.98054438829422, 0.059435486793518066, 0.6438876390457153, 0.018665611743927002, 0.5949363708496094, 0.4237636923789978, 0.8936627507209778, 0.36902564764022827, 0.7343531250953674, 0.2765160799026489, 0.9222838282585144, 0.607803225517273, 0.6408467888832092, 0.03807801008224487, 0.4802056550979614, 0.7110458016395569, 0.909838f, 0.40465325117111206, 0.00844883918762207, 0.2681233882904053, 0.5740571022033691, 0.3011084794998169, 0.15968096256256104, 0.014082252979278564, 0.712326f, 0.7275546193122864, 0.6145391464233398, 0.8880361318588257, 0.22129642963409424, 0.9627864360809326, 0.2701165f, 0.33933937549591064, 0.24647927284240723, 0.07695084810256958, 0.03155922889709473, 0.4448605179786682, 0.2482717f, 0.4946792f, 0.9692517518997192, 0.7337613701820374, 0.20207273960113525, 0.029231727123260498, 0.4125097990036011, 0.9769237637519836, 0.9374368786811829, 0.17189723253250122, 0.676103949546814, 0.45081013441085815};
        double[] aspicu_Temp1 = new double[]{0.813667f, 0.7160466313362122, 0.988955557346344, 0.7724771499633789, 0.5280031561851501, 0.972046f, 0.8862753510475159, 0.594191f, 0.8429875373840332, 0.7910156846046448, 0.7991674542427063, 0.5912559032440186, 0.9026452898979187, 0.4686206579208374, 0.9318344593048096, 0.9520131945610046, 0.849421501159668, 0.9042651653289795, 0.249159038066864, 0.23939085006713867, 0.937585f, 0.4089372754096985, 0.6403907537460327, 0.12187862396240234, 0.8118945956230164, 0.5023233890533447, 0.10235142707824707, 0.22951513528823853, 0.14620810747146606, 0.335641086101532, 0.263022780418396, 0.7666521072387695, 0.24449288845062256, 0.8929827213287354, 0.2992633581161499, 0.5752900838851929, 0.34110045433044434, 0.4360247254371643, 0.487007737159729, 0.9861726760864258, 0.3085457f, 0.2930535078048706, 0.3455388f, 0.9932084679603577, 0.9153622388839722, 0.7848379611968994, 0.8268404006958008, 0.34192347526550293, 0.0654866099357605, 0.011506438255310059, 0.8747881054878235, 0.914415180683136, 0.0012892484664916992, 0.28396302461624146, 0.19581788778305054, 0.02968621253967285, 0.9376629590988159, 0.011319756507873535, 0.3921321f, 0.7454187273979187, 0.2029828429222107, 0.8962767124176025, 5.059242248535156E-4, 0.05946385860443115, 0.6483627557754517, 0.8404188752174377, 0.1350032091140747, 0.7589499354362488, 0.8191808462142944, 0.22121495008468628, 0.6716911792755127};
        double[] aspicu_Temp2 = new double[]{0.07246226072311401, 0.3976835012435913, 0.3254147171974182, 0.44967198371887207, 0.8448562026023865, 0.47357481718063354, 0.06600093841552734, 0.14796394109725952, 0.6016800999641418, 0.797464907169342, 0.4814193844795227, 0.0751307f, 0.10580384731292725, 0.852108f, 0.4291935f, 0.46186351776123047, 0.1656639575958252, 0.1363620162010193, 0.8070361614227295, 0.25038015842437744, 0.9436920881271362, 0.810223400592804, 0.23215728998184204, 0.2435584f, 0.5742436051368713, 0.8752353191375732, 0.5056929588317871, 0.6168304085731506, 0.8500670790672302, 0.4577585f, 0.20925217866897583, 0.6533224582672119, 0.22056913375854492, 0.8833869695663452, 0.20280665159225464, 0.47443896532058716, 0.5874550342559814, 0.9551604986190796, 0.5989840626716614, 0.9816069006919861, 0.9355312585830688, 0.8177720308303833, 0.4128384590148926, 0.06837540864944458, 0.8284186720848083, 0.661920428276062, 0.6660546660423279, 0.914297f, 0.1886521f, 0.22016805410385132, 0.35111796855926514, 0.2324143648147583, 0.6052715182304382, 0.9666034579277039, 0.6281944513320923, 0.2507822513580322, 0.03379279375076294, 0.3613848090171814, 0.682387f, 0.8959237337112427, 0.11576986312866211, 0.5975778102874756, 0.26185494661331177, 0.683756947517395, 0.2185322f, 0.5969497561454773, 0.45133131742477417, 0.6732280850410461, 0.528732419013977, 0.4645213f, 0.3172866702079773};
        double[] clkHI = new double[]{0.10220718383789062, 0.3028267025947571, 0.015305638313293457, 0.749941885471344, 0.9972925782203674, 0.4384235143661499, 0.11301231384277344, 0.8862195014953613, 0.7628299593925476, 0.4655722975730896, 0.45740777254104614, 0.6423649191856384, 0.03408527374267578, 0.5276654958724976, 0.6879861354827881, 0.03431123495101929, 0.5901688933372498, 0.9169453978538513, 0.5657105445861816, 0.4899718165397644, 0.9196410775184631, 0.8170307874679565, 0.8965678215026855, 0.3357229232788086, 0.81204f, 0.4799065589904785, 0.38088494539260864, 0.09770017862319946, 0.6987639665603638, 0.601096510887146, 0.8367648124694824, 0.4286269545555115, 0.11435937881469727, 0.9560117721557617, 0.1462084f, 0.037287235260009766, 0.7124680876731873, 0.8026264905929565, 0.7157336473464966, 0.3481471538543701, 0.5082758069038391, 0.34868013858795166, 0.4024224877357483, 0.09383702278137207, 0.08067286014556885, 0.011679470539093018, 0.4198077917098999, 0.1871771216392517, 0.14254766702651978, 0.8813273310661316, 0.1599532961845398, 0.029233217239379883, 0.35733115673065186, 0.9190243482589722, 0.618203f, 0.5857173204421997, 0.36539435386657715, 0.01828134059906006, 0.9207425117492676, 0.7592307925224304, 0.397083044052124, 0.20187681913375854, 0.583291232585907, 0.6558170318603516, 0.44259113073349, 0.37315356731414795, 0.5885370373725891, 0.6006278395652771, 0.965693f, 0.17485326528549194, 0.19256246089935303};
        double[] clkHV = new double[]{0.21190357208251953, 0.4723653197288513, 0.47234803438186646, 0.8543391227722168, 0.46074116230010986, 0.6509405970573425, 0.6801722645759583, 0.6408683657646179, 0.5952237248420715, 0.20269042253494263, 0.8306482434272766, 0.4728173017501831, 0.7134791612625122, 0.18630146980285645, 0.7585159540176392, 0.23626983165740967, 0.9563217759132385, 0.6528642177581787, 0.691328763961792, 0.9558330774307251, 0.03462434f, 0.38666582107543945, 0.6155957579612732, 0.278786838054657, 0.5909197330474854, 0.6687962412834167, 0.0849973f, 0.600838f, 0.6535108089447021, 0.5135097503662109, 0.2793514132499695, 0.4285746216773987, 0.8122632503509521, 0.8002185225486755, 0.5693804621696472, 0.4447472095489502, 0.3190999f, 0.03634554147720337, 0.1288432478904724, 0.15852785110473633, 0.8869417905807495, 0.1780725121498108, 0.1265236735343933, 0.68799889087677, 0.7755282521247864, 0.43794262409210205, 0.1682819128036499, 0.8560400605201721, 0.7613850831985474, 0.39161497354507446, 0.2143843173980713, 0.36885833740234375, 0.6955242156982422, 0.922725f, 0.5182716250419617, 0.8896235823631287, 0.6626859307289124, 0.7173235416412354, 0.896554708480835, 0.5846288800239563, 0.8296563029289246, 0.6309148669242859, 0.10122638940811157, 0.4883200526237488, 0.17009252309799194, 0.43547284603118896, 0.30685955286026, 0.35428208112716675, 0.59520024061203, 0.23540490865707397, 0.9090507626533508};
        double[] clkLI = new double[]{0.5953091979026794, 0.022459805011749268, 0.3852902054786682, 0.44482892751693726, 0.2961214780807495, 0.4504796862602234, 0.6040089130401611, 0.558561f, 0.95185f, 0.7521445751190186, 0.35588985681533813, 0.44355857372283936, 0.654447f, 0.17885643243789673, 0.5466504693031311, 0.06375300884246826, 0.5436651706695557, 0.217274010181427, 0.3877224922180176, 0.0032235383987426758, 0.850786566734314, 0.6411176323890686, 0.5352170467376709, 0.8839085102081299, 0.19910532236099243, 0.2420135736465454, 0.5680676698684692, 0.6415224075317383, 0.6581142544746399, 0.6458249092102051, 0.6832186579704285, 0.3426624f, 0.5669072270393372, 0.868403434753418, 0.444133996963501, 0.7765841484069824, 0.3005765f, 0.33426398038864136, 0.2030550241470337, 0.4555372f, 0.9210861325263977, 0.17353105545043945, 0.7486221194267273, 0.4283798336982727, 0.26659804582595825, 0.8799508810043335, 0.020609617233276367, 0.05208402872085571, 0.24147897958755493, 0.2122497f, 0.7351446151733398, 0.5014378428459167, 0.38984131813049316, 0.3622232675552368, 0.22005265951156616, 0.8336512446403503, 0.8006823062896729, 0.40835005044937134, 0.054684996604919434, 0.1946696f, 0.8003453612327576, 0.3892640471458435, 0.516148567199707, 0.6689355969429016, 0.05160415172576904, 0.6360364556312561, 0.7693183422088623, 0.07337045669555664, 0.6772706508636475, 0.4179755449295044, 0.007028937339782715};
        double[] clkLV = new double[]{0.9968532919883728, 0.9545769691467285, 0.3087554f, 0.7957040667533875, 0.7339683175086975, 0.345028817653656, 0.7464436888694763, 0.04730475f, 0.6799012422561646, 0.008954644203186035, 0.02386784553527832, 0.7984013557434082, 0.7938501834869385, 0.1461772322654724, 0.8392994403839111, 0.1995563507080078, 0.03106069564819336, 0.16134315729141235, 0.699354f, 0.3118462562561035, 0.1466047167778015, 0.697310209274292, 0.9871083498001099, 0.8716533184051514, 0.02343040704727173, 0.4510906934738159, 0.6826828122138977, 0.6598678231239319, 0.03727757930755615, 0.5882796049118042, 0.29798614978790283, 0.42802155017852783, 0.8841565251350403, 0.723391056060791, 0.012175381183624268, 0.06291204690933228, 0.5327414274215698, 0.32043081521987915, 0.6729613542556763, 0.27488642930984497, 0.3728615641593933, 0.9913286566734314, 0.8676349520683289, 0.17567843198776245, 0.38904452323913574, 0.296139f, 0.7261744737625122, 0.6626887917518616, 0.04965662956237793, 0.0604214072227478, 0.25971394777297974, 0.18166548013687134, 0.15060561895370483, 0.969784677028656, 0.5768238306045532, 0.723280131816864, 0.748953f, 0.8426942229270935, 0.17643022537231445, 0.48615914583206177, 0.5553824305534363, 0.8494077324867249, 0.06183946132659912, 0.5651716589927673, 0.2926744818687439, 0.38204145431518555, 0.7304448485374451, 0.9954877495765686, 0.965650200843811, 0.8986307978630066, 0.1965857744216919};
        double[] digI = new double[]{0.08702284097671509, 0.2001015f, 0.9886152744293213, 0.33215343952178955, 0.9479057192802429, 0.5957809686660767, 0.03004467487335205, 0.6454641222953796, 0.5377201437950134, 0.7814640998840332, 0.03719979524612427, 0.5513439178466797, 0.2702589f, 0.766426146030426, 0.8041006922721863, 0.5551072359085083, 0.7508121132850647, 0.5385303497314453, 0.9230126142501831, 0.1241145133972168, 0.47461992502212524, 0.2787594199180603, 0.15165424346923828, 0.3499273657798767, 0.4117283225059509, 0.23782312870025635, 0.38809633255004883, 0.5119433999061584, 0.18037575483322144, 0.27294737100601196, 0.9236583113670349, 0.9931003451347351, 0.6781256794929504, 0.3707275986671448, 0.9324435591697693, 0.5262464880943298, 0.449784517288208, 0.6117709279060364, 0.33810514211654663, 0.7756381630897522, 0.9668700695037842, 0.9696370959281921, 0.3062235713005066, 0.7944543957710266, 0.25881046056747437, 0.91333f, 0.9421666860580444, 0.9120232462882996, 0.7455727458000183, 0.9104164838790894, 0.1429547667503357, 0.26258552074432373, 0.590083f, 0.8460214138031006, 0.5365853905677795, 0.09294718503952026, 0.722268283367157, 0.8988456726074219, 0.6381955742835999, 0.5044876337051392, 0.8311173319816589, 0.1944863200187683, 0.6197198033332825, 0.6740178465843201, 0.9137324690818787, 0.3123382329940796, 0.8043011426925659, 0.3393649458885193, 0.3884698152542114, 0.506984293460846, 0.30024921894073486};
        double[] digV = new double[]{0.3638683557510376, 0.6911038160324097, 0.948113f, 0.2390207052230835, 0.14690375328063965, 0.6872937083244324, 0.8426553606987, 0.3003944754600525, 0.11592239141464233, 0.050885558128356934, 0.515129804611206, 0.5341867208480835, 0.3132544159889221, 0.015797853469848633, 0.2513923f, 0.6256130337715149, 0.4251399636268616, 0.04007077217102051, 0.3994826078414917, 0.42047423124313354, 0.4413236379623413, 0.9954005479812622, 0.1395513415336609, 0.7120785713195801, 0.3843892216682434, 0.4760446548461914, 0.8315765261650085, 0.49518346786499023, 0.3152748942375183, 0.8099096417427063, 0.6014875769615173, 0.3798556327819824, 0.664657711982727, 0.8450844883918762, 0.08829832077026367, 0.912227988243103, 0.12183153629302979, 0.710850179195404, 0.12991058826446533, 0.7175328731536865, 0.0491408109664917, 0.5376909375190735, 0.7745217084884644, 0.7269848585128784, 0.0999218225479126, 0.7310975790023804, 0.8573110699653625, 0.1031796932220459, 0.2733106017112732, 0.3846477270126343, 0.5456730723381042, 0.6833916306495667, 0.615400493144989, 0.985266387462616, 0.6262192130088806, 0.9268412590026855, 0.7013934254646301, 0.7946221232414246, 0.8567145466804504, 0.10664993524551392, 0.6390265226364136, 0.4128406047821045, 0.7378131747245789, 0.22139078378677368, 0.8042507171630859, 0.6622820496559143, 0.4527856707572937, 0.2221236228942871, 0.7435727715492249, 0.32882362604141235, 0.18640172481536865};
        double[] htrPI = new double[]{0.331407f, 0.49448084831237793, 0.6153187155723572, 0.3528764843940735, 0.6594946384429932, 0.029887735843658447, 0.686722457408905, 0.5515662431716919};
        double[] htrPV = new double[]{0.9538493156433105, 0.1216285228729248, 0.0994305f, 0.02028787136077881, 0.12096691131591797, 0.8419254422187805, 0.5299714803695679, 0.4902523159980774};
        double[] htrV = new double[]{0.36965036392211914, 0.33370906114578247, 0.26223433017730713, 0.26226896047592163, 0.19328594207763672, 0.7372046113014221, 0.7104390859603882, 0.9478601217269897, 0.4519529342651367, 0.07082492113113403, 0.5902376770973206, 0.1561023f, 0.06556594371795654, 0.941853404045105, 0.5864506959915161, 0.79039067029953, 0.08456408977508545, 0.672473f, 0.7774170637130737, 0.9600421786308289, 0.478396f, 0.43834203481674194, 0.07779967784881592, 0.5489626526832581, 0.953304648399353, 0.45221036672592163, 0.35961318016052246, 0.534893f, 0.574421226978302, 0.9091998934745789, 0.15150684118270874, 0.3635222315788269, 0.28328317403793335, 0.12166684865951538, 0.23586708307266235, 0.27564752101898193, 0.4465714693069458, 0.9914597868919373, 0.5396295189857483, 0.014325857162475586, 0.9867229461669922, 0.1304640769958496, 0.31598544120788574, 0.932489275932312, 0.0873381495475769, 0.6842671036720276, 0.2492081f, 0.1377851963043213, 0.8588252067565918, 0.3294191360473633, 0.18303775787353516, 0.9865933656692505, 0.13097500801086426, 0.29603683948516846, 0.21447932720184326, 0.3375188112258911, 0.9132510423660278, 0.36148297786712646, 0.8401514887809753, 0.4385449290275574, 0.25022536516189575, 0.01773691177368164, 0.26277297735214233, 0.9219653606414795, 0.6841568946838379, 0.8381834626197815, 0.322886f, 0.965827226638794, 0.32015544176101685, 0.06532156467437744, 0.41804826259613037};
        double[] htrW = new double[]{0.4266694188117981, 0.33832043409347534, 0.6689122319221497, 0.20162934064865112, 0.41071271896362305, 0.4938998818397522, 0.3470335602760315, 0.4498153328895569, 0.9123595356941223, 0.738744f, 0.8762168884277344, 0.7728777527809143, 0.4710242748260498, 0.1486014723777771, 0.7802398800849915, 0.4902266263961792, 0.26919543743133545, 0.1802259087562561, 0.8523287177085876, 0.0439186692237854, 0.2836172f, 0.2545545f, 0.707659900188446, 0.488411009311676, 0.4030695f, 0.3777400851249695, 0.29047656059265137, 0.4523560404777527, 0.31406354904174805, 0.09653699398040771, 0.3442919850349426, 0.2486640214920044, 0.23160594701766968, 0.43006718158721924, 0.9591088891029358, 0.6300771236419678, 0.5959053635597229, 0.433544397354126, 0.8240374326705933, 0.8078945875167847, 0.8755069375038147, 0.9039708375930786, 0.07796567678451538, 0.420676589012146, 0.8989740610122681, 0.12161296606063843, 0.20896893739700317, 0.947770357131958, 0.2951557f, 0.888315f, 0.3020111918449402, 0.7900169491767883, 0.8486577868461609, 0.9441485404968262, 0.7743825912475586, 0.7082904577255249, 0.8928915858268738, 0.8528701663017273, 0.22256118059158325, 0.23151761293411255, 0.3666307330131531, 0.8951523900032043, 0.9892210364341736, 0.8720544576644897, 0.27813196182250977, 0.4131561517715454, 0.854506f, 0.760930061340332, 0.05844026803970337, 0.44296252727508545, 0.8741492033004761};
        double[] hVBiasSwitch = new double[]{0.5222861170768738, 0.4755227565765381, 0.6505237221717834, 0.7943531274795532, 0.6197706460952759, 0.3344826102256775, 0.3656052350997925, 0.838508f, 0.9427078366279602, 0.3455565f, 0.4657749f, 0.6058825850486755, 0.36224573850631714, 0.11827832460403442, 0.5935790538787842, 0.67257f, 0.3236528f, 0.8826066851615906, 0.5549773573875427, 0.5185275077819824, 0.0874180793762207, 0.9695937037467957, 0.12186849117279053, 0.102963387966156, 0.966339111328125, 0.3570827841758728, 0.9877268671989441, 0.7081656455993652, 0.19652915000915527, 0.32983511686325073, 0.4602123498916626, 0.20682674646377563, 0.9360202550888062, 0.9764194488525391, 0.04096514f, 0.2708238959312439, 0.20480328798294067, 0.38327813148498535, 0.2791286110877991, 0.024204015731811523, 0.4047655463218689, 0.8538708686828613, 0.8955610394477844, 0.49687206745147705, 0.8177257180213928, 0.7200740575790405, 0.8789224028587341, 0.9083812832832336, 0.24591177701950073, 0.5945885181427002, 0.038214802742004395, 0.20659923553466797, 0.6937006711959839, 0.585611f, 0.8598822951316833, 0.5103155374526978, 0.7947682738304138, 0.7352200746536255, 0.7278470993041992, 0.717639148235321, 0.05815762281417847, 0.005688011646270752, 0.9040957689285278, 0.8059986233711243, 0.07394558191299438, 0.6062723994255066, 0.6834855079650879, 0.4805285930633545, 0.608591f, 0.4880955219268799, 0.8927910327911377};
        String location = "";
        double[] oDI = new double[]{0.1967166f, 0.9257416725158691, 0.22976309061050415, 0.5407558083534241, 0.9556796550750732, 0.31857532262802124, 0.6778390407562256, 0.9199929237365723, 0.10810941457748413, 0.5780209302902222, 0.496495f, 0.7639742493629456, 0.1825487f, 0.692768931388855, 0.7020271420478821, 0.6512355208396912, 0.3009687662124634, 0.5838517546653748, 0.910401f, 0.19562774896621704, 0.9723993539810181, 0.055644690990448, 0.3199407458305359, 0.9922282099723816, 0.6530133485794067, 0.225097f, 0.13989245891571045, 0.017054855823516846, 0.15414667129516602, 0.05602646f, 0.1097666f, 0.488522469997406, 0.07095426321029663, 0.6523668766021729, 0.8579456210136414, 0.30720794200897217, 0.44636887311935425, 0.4662301540374756, 0.6860590577125549, 0.9464040994644165, 0.19902878999710083, 0.07404065132141113, 0.17343240976333618, 0.22244542837142944, 0.641786515712738, 0.26544713973999023, 0.5244846940040588, 0.0873425f, 0.05184507369995117, 0.8019822835922241, 0.3478831f, 0.26642394065856934, 0.46765387058258057, 0.8403965830802917, 0.09179002046585083, 0.7231592535972595, 0.06521821022033691, 0.01225733757019043, 0.4625069f, 0.03793919086456299, 0.8818580508232117, 0.9179002642631531, 0.13771146535873413, 0.5062663555145264, 0.7237213850021362, 0.06841546297073364, 0.02939576f, 0.2166326642036438, 0.6201863884925842, 0.4114183187484741, 0.35027414560317993};
        double[] oDV = new double[]{0.3845224380493164, 0.6199628710746765, 0.6504114270210266, 0.1511920690536499, 0.5748035907745361, 0.3971366286277771, 0.8372153639793396, 0.7019031047821045, 0.1216988f, 0.5281376838684082, 0.7339946627616882, 0.7250988483428955, 0.48813456296920776, 0.2808075547218323, 0.3357105851173401, 0.7209962010383606, 0.6322429180145264, 0.83319491147995, 0.6734057664871216, 0.3599646f, 0.7589601874351501, 0.4118230938911438, 0.6196964383125305, 0.6120848655700684, 0.4229731559753418, 0.44699686765670776, 0.2544752359390259, 0.1292764f, 0.5627778768539429, 0.4169063f, 0.36349642276763916, 0.6174356341362, 0.1345319151878357, 0.16413915157318115, 0.6057294011116028, 0.01824522f, 0.9820212125778198, 0.5796330571174622, 0.6457613110542297, 0.2639222f, 0.03187215328216553, 0.26263678073883057, 0.28186362981796265, 0.9397711753845215, 0.9006848335266113, 0.07406091690063477, 0.06348955631256104, 0.17122292518615723, 0.30574554204940796, 0.03847181797027588, 0.6669538021087646, 0.49192488193511963, 0.999212920665741, 0.3413416f, 0.04598820209503174, 0.9108771085739136, 0.21610617637634277, 0.8780374526977539, 0.08403146266937256, 0.2086862325668335, 0.2111300826072693, 0.995089054107666, 0.7148743867874146, 4.5883655548095703E-4, 0.43354111909866333, 0.4188016f, 0.6431595683097839, 0.9160302877426147, 0.28121745586395264, 0.4781906008720398, 0.3598499298095703};
        double[] pClk0 = new double[]{0.4931039810180664, 0.4162802f, 0.3260529041290283, 0.9118999242782593, 0.9470535516738892, 0.9996038675308228, 0.0619124174118042, 0.22986477613449097, 0.7798523306846619, 0.29803794622421265, 0.2223801612854004, 0.9500743746757507, 0.3926847577095032, 0.2769647240638733, 0.6775627136230469, 0.8754173517227173, 0.16074371337890625, 0.555881f, 0.346576452255249, 0.11497682332992554, 0.2686259150505066, 0.4730901f, 0.5016433000564575, 0.7201228737831116, 0.4603336453437805, 0.6775134801864624, 0.5899475812911987, 0.31370365619659424, 0.4645206928253174, 0.2944047f, 0.17733114957809448, 0.8883137702941895, 0.46426987648010254, 0.1538153886795044, 0.6605433225631714, 0.05602604150772095, 0.6079491972923279, 0.1355912685394287, 0.048298f, 0.5703188180923462, 0.23579871654510498, 0.3851664066314697, 0.2596195340156555, 0.7442353367805481, 0.523699939250946, 0.9562922716140747, 0.8052888512611389, 0.3682003617286682, 0.43454545736312866, 0.5090310573577881, 0.3196784257888794, 0.12565267086029053, 0.7978700399398804, 0.655930757522583, 0.5015441179275513, 0.13211262226104736, 0.604641318321228, 0.731478214263916, 0.5497220754623413, 0.7289993166923523, 0.06669849157333374, 0.43801575899124146, 0.9800654053688049, 0.7710750699043274, 0.02524423599243164, 0.476751446723938, 0.7608950734138489, 0.407583f, 0.04163634777069092, 0.83986496925354, 0.3738877773284912};
        double[] pClk1 = new double[]{0.4018402695655823, 0.12372863292694092, 0.5567038655281067, 0.7044802308082581, 0.8202640414237976, 0.9550115466117859, 0.9444995522499084, 0.4899361729621887, 0.9856657385826111, 0.6402950882911682, 0.605855f, 0.444250226020813, 0.795421838760376, 0.06474602222442627, 0.788535f, 0.5677070617675781, 0.2951841950416565, 0.7024776339530945, 0.22802305221557617, 0.6064674854278564, 0.04365015f, 0.09193497896194458, 0.13321322202682495, 0.11593139171600342, 0.6521983742713928, 0.7190038561820984, 0.6569314002990723, 0.20336401462554932, 0.6116685271263123, 0.9817002415657043, 0.5752905011177063, 0.27353787422180176, 0.3821097f, 0.5346871018409729, 0.24588346481323242, 0.10972100496292114, 0.8029434084892273, 0.17557984590530396, 0.4403175115585327, 0.4156506657600403, 0.3418225646018982, 0.6015100479125977, 0.7705448269844055, 0.6872080564498901, 0.029771864414215088, 0.6628186702728271, 0.02291596f, 0.5310186147689819, 0.1953495740890503, 0.015782415866851807, 0.3540675f, 0.49743014574050903, 0.20708757638931274, 0.438276469707489, 0.5169790983200073, 0.23418891429901123, 0.3349747657775879, 0.1472340226173401, 0.8052363395690918, 0.5221702456474304, 0.8500064611434937, 0.6362707614898682, 0.413291335105896, 0.1438995f, 0.4757162928581238, 0.24312984943389893, 0.2980126738548279, 0.8181037902832031, 0.995138943195343, 0.5325232148170471, 0.23288464546203613};
        double[] pClkL = new double[]{0.7585811018943787, 0.9869605302810669, 0.8289714455604553, 0.6147958040237427, 0.07330119609832764, 0.4299505352973938, 0.8104814887046814, 0.2115178108215332, 0.8905232548713684, 0.9675249457359314, 0.9470747709274292, 0.6259182691574097, 0.1041227f, 0.48496347665786743, 0.9736374616622925, 0.9539863467216492, 0.18217051029205322, 0.9190376996994019, 0.2752906084060669, 0.284335732460022, 0.9336495399475098, 0.8203474879264832, 0.5520666837692261, 0.1365404725074768, 0.2211834192276001, 0.6274065375328064, 0.9503623247146606, 0.17716866731643677, 0.7265840768814087, 0.22145754098892212, 0.7992642521858215, 0.05150914192199707, 0.2953081f, 0.5232808589935303, 0.48388952016830444, 0.594697f, 0.5205914974212646, 0.4071318f, 0.9044538736343384, 0.16029822826385498, 0.8837661147117615, 0.35979437828063965, 0.5035951137542725, 0.152605f, 0.39034295082092285, 0.2500743269920349, 0.3558990955352783, 0.8492515683174133, 0.568788468837738, 0.5195092558860779, 0.17856848239898682, 0.234718918800354, 0.4080614447593689, 0.6104007959365845, 0.9823462963104248, 0.2674334645271301, 0.16908162832260132, 0.6423634886741638, 0.09438461065292358, 0.911175549030304, 0.5231582522392273, 0.19143664836883545, 0.3725815415382385, 0.4662118f, 0.546428918838501, 0.5525586009025574, 0.03247493505477905, 0.5309037566184998, 0.273589551448822, 0.4411134123802185, 0.8271845579147339};
        double[] pClkU = new double[]{0.05759161710739136, 0.7172926068305969, 0.6547052264213562, 0.5778533220291138, 0.8874979615211487, 0.06284892559051514, 0.5428166389465332, 0.7319145798683167, 0.26156866550445557, 0.6131980419158936, 0.06817853450775146, 0.7302761673927307, 0.7140079140663147, 0.5890531539916992, 0.9662972688674927, 0.2587639093399048, 0.5223425030708313, 0.07684427499771118, 0.7735177874565125, 0.7261424660682678, 0.27486205101013184, 0.8963664174079895, 0.8822656869888306, 0.5985681414604187, 0.8390507698059082, 0.45529937744140625, 0.9558366537094116, 0.09191673994064331, 0.99209064245224, 0.4340469241142273, 0.9835455417633057, 0.508161723613739, 0.5787542462348938, 0.45730364322662354, 0.5475943088531494, 0.544583f, 0.3682067394256592, 0.4546900987625122, 0.9011732339859009, 0.8154204487800598, 0.81772381067276, 0.7786173224449158, 0.6967106461524963, 0.7306166887283325, 0.9495512247085571, 0.06078004837036133, 0.4555841088294983, 0.6671329140663147, 0.19165176153182983, 0.3675134778022766, 0.5158894658088684, 0.952185f, 0.7116009593009949, 0.217451810836792, 0.441038f, 0.7274959087371826, 0.8262272477149963, 0.10193109512329102, 0.005149960517883301, 0.9677663445472717, 0.04168647527694702, 0.08940452337265015, 0.5056911706924438, 0.23912864923477173, 0.16658997535705566, 0.08046752214431763, 0.4819458f, 0.6741021871566772, 0.4447600245475769, 0.13119518756866455, 0.960231363773346};
        double[] power = new double[]{0.843854f, 0.42749232053756714, 0.6913027763366699, 0.20188724994659424, 0.9773748517036438, 0.20429933071136475, 0.4626823663711548, 0.024750173091888428, 0.3270948529243469, 0.9455741047859192, 0.11631321907043457, 0.10796147584915161, 0.4437282085418701, 0.4931296110153198, 0.195176899433136, 0.10653454065322876, 0.9975863695144653, 0.930972158908844, 0.9520459175109863, 0.8072822093963623, 0.3827277421951294, 0.84789f, 0.5388973355293274, 0.1907169222831726, 0.24320656061172485, 0.9875576496124268, 0.184888f, 0.94178f, 0.86208f, 0.4960668683052063, 0.7186155319213867, 0.3212316036224365, 0.9140776991844177, 0.2994155287742615, 0.844681441783905, 0.09287822246551514, 0.7779105305671692, 0.755961000919342, 0.9519176483154297, 0.45128297805786133, 0.5756949186325073, 0.5657491683959961, 0.2791956067085266, 0.24008393287658691, 0.5121251344680786, 0.6176519393920898, 0.003294646739959717, 0.6505381464958191, 0.3476876f, 0.6072147488594055, 0.14128583669662476, 0.579552948474884, 0.8968541622161865, 0.656967f, 0.11731559038162231, 0.7705156803131104, 0.9979225993156433, 0.06375974416732788, 0.8612285256385803, 0.20107340812683105, 0.1757097840309143, 0.6346591711044312, 0.4554256200790405, 0.1901483f, 0.19700860977172852, 0.7573602199554443, 0.5886393189430237, 0.7205448150634766, 0.4025585651397705, 0.4894410967826843, 0.5134505033493042};
        double[] ref05V = new double[]{0.19025683403015137, 0.35486364364624023, 0.10262203216552734, 0.33154296875, 0.46991032361984253, 0.25074201822280884, 0.946221113204956, 0.38067734241485596, 0.8386799693107605, 0.2588575482368469, 0.4140317440032959, 0.2945793867111206, 0.257636f, 0.5191508531570435, 0.6298286318778992, 0.11642175912857056, 0.007060587406158447, 0.8121451139450073, 0.0807119f, 0.22399264574050903, 0.030210494995117188, 0.716288685798645, 0.3997151255607605, 0.9662789106369019, 0.285801f, 0.5311554074287415, 0.3578583598136902, 0.9039658904075623, 0.9887736439704895, 0.9794342517852783, 0.6025596261024475, 0.617797315120697, 0.1154523491859436, 0.1028049f, 0.9586042165756226, 0.8170268535614014, 0.8448641300201416, 0.2432405948638916, 0.07740432024002075, 0.2041006088256836, 0.4108161926269531, 0.224853515625, 0.7208781838417053, 0.380664587020874, 0.9354097247123718, 0.010583877563476562, 0.04189121723175049, 0.30402427911758423, 0.3182897f, 0.15692448616027832, 0.3708941340446472, 0.10296088457107544, 0.859466016292572, 0.298203f, 0.43836456537246704, 0.7586208581924438, 0.5174973607063293, 0.8950605392456055, 0.8082286715507507, 0.46195483207702637, 0.14784234762191772, 0.3306458592414856, 0.925051748752594, 0.7264282703399658, 0.6550067663192749, 0.64929f, 0.3970147967338562, 0.30662262439727783, 0.2316373f, 0.33826714754104614, 0.46022796630859375};
        double[] ref125V = new double[]{0.0336841344833374, 0.0809369683265686, 0.351528f, 0.4635995030403137, 0.10176777839660645, 0.6368377804756165, 0.3784957528114319, 0.34621691703796387, 0.5407071113586426, 0.04852259159088135, 0.2502405643463135, 0.573083f, 0.3947838f, 0.8995190858840942, 0.44432002305984497, 0.6752747893333435, 0.9419572353363037, 0.9322072863578796, 0.2586494f, 0.18547892570495605, 0.4691614508628845, 0.169816255569458, 0.24991291761398315, 0.3508496880531311, 0.14482522010803223, 0.8215961456298828, 0.614858090877533, 0.9768036603927612, 0.26778072118759155, 0.8527199029922485, 0.990547239780426, 0.24540454149246216, 0.13098877668380737, 0.056605756282806396, 0.585130512714386, 0.4512244462966919, 0.3184388279914856, 0.9198816418647766, 0.062426745891571045, 0.5999358892440796, 0.994215726852417, 0.8834075331687927, 0.3956561f, 0.4674651622772217, 0.574731171131134, 0.7189982533454895, 0.1977863907814026, 0.4705180525779724, 0.6697796583175659, 0.4312680959701538, 0.31348538398742676, 0.9559900760650635, 0.7973154783248901, 0.2059764266014099, 0.7215908765792847, 0.8836451172828674, 0.7231954336166382, 0.6371483206748962, 0.813923f, 0.41305553913116455, 0.3437541127204895, 0.5299607515335083, 0.6683869361877441, 0.3748408555984497, 0.4497695565223694, 0.5779303908348083, 0.069516f, 0.7235399484634399, 0.009542524814605713, 0.8124440908432007, 0.3113426f};
        double[] ref15V = new double[]{0.7539498805999756, 0.4514995217323303, 0.9094005227088928, 0.5748766660690308, 0.4865322709083557, 0.8685975074768066, 0.7790580987930298, 0.25023216009140015, 0.2657204270362854, 0.8041464686393738, 0.756621241569519, 0.581931f, 0.295981228351593, 0.8983912467956543, 0.6262786388397217, 0.581102f, 0.7957332730293274, 0.9048423767089844, 0.4520873427391052, 0.16178607940673828, 0.363275408744812, 0.5430818200111389, 0.13515949249267578, 0.827580451965332, 0.4094271659851074, 0.0993850827217102, 0.9760653972625732, 0.1322593092918396, 0.45944637060165405, 0.2674063444137573, 0.5803442001342773, 0.25226891040802, 0.30591654777526855, 0.22841012477874756, 0.8177751302719116, 0.7942166328430176, 0.40175676345825195, 0.5847638845443726, 0.42498672008514404, 0.8863813877105713, 0.2184915542602539, 0.30292046070098877, 0.24658f, 0.4052159786224365, 0.2127559781074524, 0.004832923412322998, 0.14084428548812866, 0.11677253246307373, 0.4001381993293762, 0.6221920847892761, 0.6591092348098755, 0.585555374622345, 0.6394550800323486, 0.8392289280891418, 0.7476898431777954, 0.951723575592041, 0.5951078534126282, 0.780863344669342, 0.7512450814247131, 0.3996758460998535, 0.9360947608947754, 0.828124463558197, 0.8273234367370605, 0.15033096075057983, 0.8165153861045837, 0.1770561933517456, 0.7531639337539673, 0.6849716901779175, 0.6860493421554565, 0.10641586780548096, 0.8348446488380432};
        double[] ref25V = new double[]{0.24506932497024536, 0.3251359462738037, 0.8296629190444946, 0.8611286878585815, 0.31041085720062256, 0.96673f, 0.11493712663650513, 0.5034816265106201, 0.1130760908126831, 0.9360191822052002, 0.540476f, 0.30148857831954956, 0.4389711022377014, 0.34592121839523315, 0.6803826689720154, 0.01915425f, 0.158934f, 0.667233f, 0.6956236958503723, 0.1703487f, 0.5407485961914062, 0.03880512714385986, 0.6370178461074829, 0.4270828366279602, 0.3602006435394287, 0.7889949679374695, 0.2908143401145935, 0.3066306710243225, 0.857697f, 0.05199742317199707, 0.04391789436340332, 0.4251352f, 0.39666497707366943, 0.5316452383995056, 0.08618307113647461, 0.976752758026123, 0.2563069462776184, 0.29423975944519043, 0.2633909583091736, 0.29723918437957764, 0.8352833986282349, 0.06735879182815552, 0.1490703821182251, 0.07591694593429565, 0.9211373925209045, 0.4429643750190735, 0.9094047546386719, 0.245069682598114, 0.8749772310256958, 0.8931918740272522, 0.42685467004776, 0.8839961290359497, 0.1399616003036499, 0.8217657208442688, 0.9492508172988892, 0.7873517870903015, 0.46894896030426025, 0.412001371383667, 0.4069966f, 0.15327447652816772, 0.5103925466537476, 0.6658848524093628, 0.04734367f, 0.21350562572479248, 0.7369011044502258, 0.3329721f, 0.367745041847229, 0.45080071687698364, 0.2582031488418579, 0.9311329126358032, 0.5769665241241455};
        double[] refN12 = new double[]{0.30198973417282104, 0.45551812648773193, 0.49493128061294556, 0.2004913091659546, 0.22987210750579834, 0.99916011095047, 0.2362495f, 0.5939400792121887, 0.6435844898223877, 0.07279932498931885, 0.853326678276062, 0.2935488224029541, 0.06317496299743652, 0.19903916120529175, 0.619513750076294, 0.4656037f, 0.94598788022995, 0.13030529022216797, 0.6656875014305115, 0.5071735382080078, 0.8343644738197327, 0.790593683719635, 0.5374930500984192, 0.7791630625724792, 0.63848f, 0.1971091f, 0.36058497428894043, 0.8409298658370972, 0.4553765654563904, 0.8915982246398926, 0.9371393322944641, 0.615372f, 0.9440457820892334, 0.420219f, 0.18155354261398315, 0.9970463514328003, 0.8535187840461731, 0.3346911072731018, 0.29200756549835205, 0.2666816711425781, 0.34122687578201294, 0.5784653425216675, 0.4601287245750427, 0.6771931648254395, 0.5553991794586182, 0.7675917148590088, 0.2091974f, 0.003401815891265869, 0.9991077780723572, 0.09032237529754639, 0.2911042f, 0.11515432596206665, 0.1840064525604248, 0.41136884689331055, 0.5856832265853882, 0.547085f, 0.3362230658531189, 0.7708615064620972, 0.4583044f, 0.0441548228263855, 0.5807642340660095, 0.17478978633880615, 0.3210238814353943, 0.49725866317749023, 0.3278064f, 0.2590084f, 0.6906159520149231, 0.02514267f, 0.06614041328430176, 0.7143787145614624, 0.2780084013938904};
        double[] refP12 = new double[]{0.07579177618026733, 0.56568443775177, 0.9435044527053833, 0.7157146334648132, 0.8211161494255066, 0.5603989362716675, 0.20266777276992798, 0.5236191153526306, 0.2026004195213318, 0.3612499237060547, 0.9044482111930847, 0.12287229299545288, 0.2926226258277893, 0.9003398418426514, 0.02122288942337036, 0.8797598481178284, 0.0970568060874939, 0.3743353486061096, 0.8570195436477661, 0.7464203834533691, 0.1108478307723999, 0.7083825469017029, 0.3303794264793396, 0.46652013063430786, 0.3113839030265808, 0.3494352698326111, 0.3349667191505432, 0.1378955841064453, 0.4372509f, 0.5971024036407471, 0.48422425985336304, 0.23031479120254517, 0.34547924995422363, 0.5456147193908691, 0.38366132974624634, 0.7075849175453186, 0.6024907827377319, 0.325341f, 0.5572124719619751, 0.41505998373031616, 0.7670267224311829, 0.3575679063796997, 0.846003532409668, 0.28513604402542114, 0.7324286103248596, 0.7612669467926025, 0.827907f, 0.5566155314445496, 0.06641978025436401, 0.44267964363098145, 0.9191878437995911, 0.17409104108810425, 0.2152794f, 0.15327203273773193, 0.9256841540336609, 0.8590456247329712, 0.3129313588142395, 0.3925696015357971, 0.036313652992248535, 0.2566499710083008, 0.8815256357192993, 0.26134634017944336, 0.4878453016281128, 0.7458181977272034, 0.04673302173614502, 0.6174876093864441, 0.28405314683914185, 0.34266287088394165, 0.7769942283630371, 0.3595815896987915, 0.5974315404891968};
        double[] rG0 = new double[]{0.9698854684829712, 0.7407770752906799, 0.648055374622345, 0.506066f, 0.7507975697517395, 0.4495378f, 0.9847127795219421, 0.9761347770690918, 0.913657009601593, 0.5972207188606262, 0.5012385845184326, 0.961575f, 0.06002265214920044, 0.7410497069358826, 0.5761128664016724, 0.8920538425445557, 0.613198f, 0.4049862027168274, 0.10606098175048828, 0.909494936466217, 0.0759924054145813, 0.17908191680908203, 0.8294159173965454, 0.008644461631774902, 0.6005549430847168, 0.6782124638557434, 0.03945833444595337, 0.7707338929176331, 0.31961536407470703, 0.19612336158752441, 0.6689494252204895, 0.9490625262260437, 0.8739323019981384, 0.3197711110115051, 0.9838021397590637, 0.5847606062889099, 0.7640329599380493, 0.5696356296539307, 0.2334162f, 0.1792042851448059, 0.17751234769821167, 0.6096802949905396, 0.3850038f, 0.3212601f, 0.12143063545227051, 0.6722326874732971, 0.16477346420288086, 0.9230954051017761, 0.3010326027870178, 0.4051675796508789, 0.7637467384338379, 0.23367607593536377, 0.7125484943389893, 0.3489282727241516, 0.7920134663581848, 0.2158851f, 0.29380446672439575, 0.057293057441711426, 0.012272298336029053, 0.848663866519928, 0.8394546508789062, 0.4971665143966675, 0.5095604062080383, 0.8725516200065613, 0.32867681980133057, 0.6984619498252869, 0.7952814102172852, 0.37395572662353516, 0.6260892748832703, 0.7153884172439575, 0.7642527222633362};
        double[] rG1 = new double[]{0.10452711582183838, 0.4485195279121399, 0.23581701517105103, 0.865895688533783, 0.27686625719070435, 0.49128222465515137, 0.7071758508682251, 0.5853912830352783, 0.7518026232719421, 0.581121563911438, 0.5974168181419373, 0.7062533497810364, 0.5366419553756714, 0.7753937244415283, 0.48055553436279297, 0.5190884470939636, 0.6146730780601501, 0.017968297004699707, 0.5212689638137817, 0.4072004556655884, 0.6060861349105835, 0.5544212460517883, 0.765832f, 0.16116386651992798, 0.1671367883682251, 0.018184304237365723, 0.4517027735710144, 0.11266881227493286, 0.431366503238678, 0.344362735748291, 0.4903604984283447, 0.22208797931671143, 0.013062715530395508, 0.3209964f, 0.913227915763855, 0.6717151999473572, 0.9736396670341492, 0.22381997108459473, 0.5949568152427673, 0.20298415422439575, 0.806592583656311, 0.12839365005493164, 0.06894189119338989, 0.3648301959037781, 0.5521025657653809, 0.8842726945877075, 0.9541825652122498, 0.3134564757347107, 0.9998443722724915, 0.5542306900024414, 0.038711726665496826, 0.7010067105293274, 0.9853088855743408, 0.2551485300064087, 0.6715323328971863, 0.2200194001197815, 0.703837513923645, 0.6268398761749268, 0.9517692923545837, 0.3181915879249573, 0.9460634589195251, 0.6447587609291077, 0.5605880618095398, 0.5781629085540771, 0.1526598334312439, 0.6792912483215332, 0.6390251517295837, 0.9621262550354004, 0.16493523120880127, 0.7883666753768921, 0.19449561834335327};
        double[] rGL = new double[]{0.0715932846069336, 0.7462484836578369, 0.3647557f, 0.3323186f, 0.36721545457839966, 0.118405282497406, 0.8010991811752319, 0.508657693862915, 0.8589502573013306, 0.4137595295906067, 0.5939998030662537, 0.7309850454330444, 0.6179461479187012, 0.61989426612854, 0.7961078882217407, 0.5753249526023865, 0.9113056659698486, 0.08735036849975586, 0.4078601598739624, 0.3205387592315674, 0.23051035404205322, 0.29538804292678833, 0.8473324179649353, 0.8338084816932678, 0.713009774684906, 0.405303418636322, 0.16961562633514404, 0.8839293122291565, 0.7616698145866394, 0.27010852098464966, 0.05141180753707886, 0.7563237547874451, 0.19395703077316284, 0.3737683892250061, 0.4904951f, 0.7327471375465393, 0.22553253173828125, 0.518653392791748, 0.6747376918792725, 0.6570164561271667, 0.5631012916564941, 0.608004093170166, 0.9861311316490173, 0.3039160370826721, 0.9787943959236145, 0.23825335502624512, 0.759335994720459, 0.1105089783668518, 0.9210597276687622, 0.9468511343002319, 0.3025868535041809, 0.41682547330856323, 0.02113097906112671, 0.2932738661766052, 0.10521078109741211, 0.2363465428352356, 0.14390015602111816, 0.6882686614990234, 0.8476573824882507, 0.6665184497833252, 0.8498090505599976, 0.24881380796432495, 0.24697858095169067, 0.9270090460777283, 0.5507165193557739, 0.4291202425956726, 0.31646376848220825, 0.14046591520309448, 0.10621833801269531, 0.7622305154800415, 0.8990662097930908};
        double[] rGU = new double[]{0.949695885181427, 0.2943531274795532, 0.5089951753616333, 0.4099313020706177, 0.8896225690841675, 0.256908655166626, 0.1336471438407898, 0.3564424514770508, 0.7358787655830383, 0.2476483f, 0.35570287704467773, 0.11056089401245117, 0.3588717579841614, 0.462848424911499, 0.6299748420715332, 0.5067963600158691, 0.5876566171646118, 0.3968232274055481, 0.6091803908348083, 0.5019757747650146, 0.2876335382461548, 0.6080055236816406, 0.7917084097862244, 0.43527287244796753, 0.9762369394302368, 0.3991520404815674, 0.7609034776687622, 0.3970431685447693, 0.42832082509994507, 0.18198204040527344, 0.3077316880226135, 0.08432018756866455, 0.5854048132896423, 0.013805627822875977, 0.1874944567680359, 0.9739436507225037, 0.7984967827796936, 0.3413194417953491, 0.20059436559677124, 0.06889933347702026, 0.7616328597068787, 0.5727697610855103, 0.8800707459449768, 0.21037834882736206, 0.08199608325958252, 0.010221540927886963, 0.0031989216804504395, 0.5412513613700867, 0.07252120971679688, 0.5229958891868591, 0.8749794960021973, 0.1531773805618286, 0.2249404788017273, 0.32382726669311523, 0.32756322622299194, 0.9496131539344788, 0.7465482354164124, 0.34145092964172363, 0.37691646814346313, 0.9638907313346863, 0.234491229057312, 0.0657962f, 0.7273004651069641, 0.6417178511619568, 0.8696505427360535, 0.8014907240867615, 0.8320274353027344, 0.2405148148536682, 0.6813452839851379, 0.006854236125946045, 0.03768497705459595};
        double[] rTDTemp = new double[]{0.5266118049621582, 0.3479401469230652, 0.6519877910614014, 0.7564423680305481, 0.33132725954055786, 0.4313966f, 0.21207916736602783, 0.44064861536026, 0.4272640347480774, 0.8109055161476135, 0.2599042057991028, 0.9547948241233826, 0.22887331247329712, 0.687648f, 0.45208728313446045, 0.3467797636985779, 0.3316415548324585, 0.8257326483726501, 0.6625066995620728, 0.8736305236816406, 0.1604672074317932, 0.5103719234466553, 0.8269177675247192, 0.8123723268508911, 0.4813665747642517, 0.020921528339385986, 0.7771791815757751, 0.22620874643325806, 0.17614257335662842, 0.6016849279403687, 0.5912918448448181, 0.61680006980896, 0.12476956844329834, 0.9761613607406616, 0.2247957f, 0.69805508852005, 0.8758060336112976, 0.2901118993759155, 0.9560574889183044, 0.3139672875404358, 0.805095374584198, 0.02546858787536621, 0.3368757963180542, 0.4967222213745117, 0.9144179224967957, 0.3313818573951721, 0.3330138921737671, 0.541313f, 0.2548163f, 0.4418790936470032, 0.4372493028640747, 0.7445698380470276, 0.07734578847885132, 0.3536115884780884, 0.08894175291061401, 0.6208242774009705, 0.32345062494277954, 0.8245266675949097, 0.4157188f, 0.2299739122390747, 0.5276051163673401, 0.518195629119873, 0.379548f, 0.01873844861984253, 0.8789803385734558, 0.8927275538444519, 0.9442128539085388, 0.8302292227745056, 0.2925226092338562, 0.2421368956565857, 0.04516857862472534};
        double[] sClk0 = new double[]{0.544092059135437, 0.29190772771835327, 0.30673056840896606, 0.4251835346221924, 0.9985090494155884, 0.17942827939987183, 0.6332154870033264, 0.8674523234367371, 0.2610008120536804, 0.9361855983734131, 0.5810818076133728, 0.9075066447257996, 0.06759816408157349, 0.0883021354675293, 0.6263072490692139, 0.7098849415779114, 0.9655308723449707, 0.12270039319992065, 0.6340906620025635, 0.7569037675857544, 0.7647173404693604, 0.12387138605117798, 0.6773284673690796, 0.19489282369613647, 0.7352486252784729, 0.01868391f, 0.02567422389984131, 0.8259115219116211, 0.2546075f, 4.755258560180664E-4, 0.27069592475891113, 0.6064004302024841, 0.4980129599571228, 0.4003743529319763, 0.475896f, 0.23268067836761475, 0.23214513063430786, 0.980085551738739, 0.4268566370010376, 0.6490969657897949, 0.7862998247146606, 0.5364422798156738, 0.8278029561042786, 0.6283974647521973, 0.07111108303070068, 0.987185537815094, 0.8583552241325378, 0.5443015694618225, 0.844326376914978, 0.10614222288131714, 0.22070544958114624, 0.009875476360321045, 0.8023363351821899, 0.603792667388916, 0.4160711169242859, 0.6971986889839172, 0.03746795654296875, 0.8188477754592896, 0.8738324046134949, 0.7168754935264587, 0.7423006892204285, 0.3637155294418335, 0.9916715621948242, 0.8313478231430054, 0.07693803310394287, 0.3205704092979431, 0.545333743095398, 0.24296694993972778, 0.9223604202270508, 0.1372169852256775, 0.09799051284790039};
        double[] sClk1 = new double[]{0.0537557f, 0.9174267649650574, 0.0482601523399353, 0.42789143323898315, 0.8842554092407227, 0.07913511991500854, 0.42557162046432495, 0.9359580874443054, 0.7874302268028259, 0.31137293577194214, 0.924130380153656, 0.9697383046150208, 0.05205410718917847, 0.8581818342208862, 0.06957560777664185, 0.874868631362915, 0.8882201313972473, 0.9107673764228821, 0.16994398832321167, 0.868675172328949, 0.2835896f, 0.05593979358673096, 0.2168892f, 0.9221897721290588, 0.5488749146461487, 0.4958648085594177, 0.06514471769332886, 0.27671295404434204, 0.599086344242096, 0.17902839183807373, 0.3901596f, 0.9397789239883423, 0.7856447696685791, 0.37990695238113403, 0.17291146516799927, 0.07425785064697266, 0.8740844130516052, 0.33533287048339844, 0.15119624137878418, 0.07528811693191528, 0.40137147903442383, 0.28993552923202515, 0.41465938091278076, 0.9252957105636597, 0.322601854801178, 0.48791468143463135, 0.16603630781173706, 0.12070101499557495, 0.3239043951034546, 0.05600255727767944, 0.38620704412460327, 0.7088211178779602, 0.01976090669631958, 0.4006343483924866, 0.4415629506111145, 0.28436142206192017, 0.1298086f, 0.2545584440231323, 0.4777735471725464, 0.8367952108383179, 0.631755530834198, 0.18347585201263428, 0.12640488147735596, 0.16851598024368286, 0.38071537017822266, 0.5465285181999207, 0.6851654052734375, 0.915206f, 0.16654521226882935, 0.20591431856155396, 0.5471704602241516};
        double[] sClkL = new double[]{0.5813068151473999, 0.12329727411270142, 0.8265628218650818, 0.4809582829475403, 0.1823439f, 0.6104175448417664, 0.2882691025733948, 0.08563566207885742, 0.1803167462348938, 0.5337334275245667, 0.4571717381477356, 0.7521734833717346, 0.16719353199005127, 0.7735707759857178, 0.5038366317749023, 0.09332907199859619, 0.8441801071166992, 0.2236635684967041, 0.7999352812767029, 0.6048950552940369, 0.05088299512863159, 0.5321242213249207, 0.6286988258361816, 0.28702491521835327, 0.0994395f, 0.1670113205909729, 0.975703f, 0.7864682674407959, 0.285420298576355, 0.9244731068611145, 0.2614542841911316, 0.9719770550727844, 0.891740620136261, 0.5556915402412415, 0.2866741418838501, 0.5823656916618347, 0.12648552656173706, 0.23666197061538696, 0.9017212986946106, 0.9992961287498474, 0.4836227297782898, 0.14709758758544922, 0.015478968620300293, 0.30750203132629395, 0.8708362579345703, 0.294458270072937, 0.8241126537322998, 0.579692542552948, 0.28557586669921875, 0.8273983001708984, 0.3798535466194153, 0.930725f, 0.753924548625946, 0.6690660715103149, 0.4134852886199951, 0.947879433631897, 0.9826995730400085, 0.1820578f, 0.26623213291168213, 0.9464045166969299, 0.6596095561981201, 0.3989271f, 0.737616777420044, 0.40024787187576294, 0.40621328353881836, 0.8386217355728149, 0.9915530681610107, 0.33848655223846436, 0.021392107009887695, 0.1318148970603943, 0.5250653624534607};
        double[] sClkU = new double[]{0.41299957036972046, 0.21723055839538574, 0.22669953107833862, 0.7498044371604919, 0.3700758218765259, 0.5533856153488159, 0.29943495988845825, 0.38881915807724, 0.3887394070625305, 0.619625449180603, 0.1862025260925293, 0.5883095860481262, 0.9755542278289795, 0.7392749190330505, 0.05100148916244507, 0.09044337272644043, 0.07660460472106934, 0.999482274055481, 0.5472816824913025, 0.728481113910675, 0.7324390411376953, 0.32880693674087524, 0.19277018308639526, 0.874784529209137, 0.86432284116745, 0.6005339026451111, 0.4040418267250061, 0.796747f, 0.7466294765472412, 0.4438938f, 0.3072632f, 0.4218948f, 0.9501662850379944, 0.08815860748291016, 0.3089906f, 0.06358063220977783, 0.29738521575927734, 0.28019845485687256, 0.5589306950569153, 0.7606868147850037, 0.868586003780365, 0.1289190649986267, 0.02631556987762451, 0.10204082727432251, 0.757326602935791, 0.8051127791404724, 0.4322512149810791, 0.5679362416267395, 0.9653827548027039, 0.9182906150817871, 0.7994629144668579, 0.3719577193260193, 0.12794125080108643, 0.2993265390396118, 0.7937811017036438, 0.6365959048271179, 0.19659f, 0.9261416792869568, 0.31212663650512695, 0.11187314987182617, 0.5125262141227722, 0.06672406196594238, 0.22142034769058228, 0.9389902949333191, 0.05981576442718506, 0.9976910352706909, 0.6516375541687012, 0.5780746340751648, 0.9861922264099121, 0.14613652229309082, 0.5021710991859436};
        double[] sw_GDV = new double[]{0.6333096027374268, 0.5576098561286926, 0.34708255529403687, 0.6198765635490417, 0.10853475332260132, 0.616499125957489, 0.3985145688056946, 0.5639214515686035, 0.5659233927726746, 0.8394931554794312, 0.9113808870315552, 0.6792172193527222, 0.7092980742454529, 0.8384895920753479, 0.9143757224082947, 0.8772968053817749, 0.307387113571167, 0.5726067423820496, 0.9947065711021423, 0.6696373224258423, 0.8618305921554565, 0.9943314790725708, 0.2889217734336853, 0.5403767824172974, 0.526614248752594, 0.1505078673362732, 0.1253923773765564, 0.188021f, 0.03207695484161377, 0.6104758977890015, 0.9460075497627258, 0.8420856595039368, 0.5555407404899597, 0.5654615163803101, 0.5734569430351257, 0.1818053126335144, 0.9254441857337952, 0.9041823148727417, 0.357183575630188, 0.08932000398635864, 0.32570767402648926, 0.1416446566581726, 0.031356215476989746, 0.8765097260475159, 0.8766583800315857, 0.08645802736282349, 0.6983239650726318, 0.8783868551254272, 0.46854138374328613, 0.35500264167785645, 0.5478867292404175, 0.6303179264068604, 0.8894186615943909, 0.25990474224090576, 0.213889f, 0.793082058429718, 0.262711f, 0.6500661373138428, 0.92327880859375, 0.6887646317481995, 0.7479966878890991, 0.09765934944152832, 0.3176615834236145, 0.7197477221488953, 0.28479474782943726, 0.5048578977584839, 0.4229331f, 0.09871464967727661, 0.31140875816345215, 0.03356254f, 0.2488364f};
        double[] sw_ODI = new double[]{0.5839039087295532, 0.07358896732330322, 0.9920889139175415, 0.8479153513908386, 0.23320072889328003, 0.5705131888389587, 0.39388322830200195, 0.9236279129981995, 0.3335585594177246, 0.8537439107894897, 0.7381630539894104, 0.7122412919998169, 0.4773235321044922, 0.29936182498931885, 0.7573727369308472, 0.4751048f, 0.4210578203201294, 0.3810133934020996, 0.4910815954208374, 0.5201455950737, 0.6302965879440308, 0.16436225175857544, 0.8431176543235779, 0.857744574546814, 0.868345320224762, 0.2692553400993347, 0.4741566777229309, 0.9109435677528381, 0.48985421657562256, 0.9682828187942505, 0.3946055769920349, 0.8082448840141296, 0.23975801467895508, 0.738424f, 0.32451528310775757, 0.7447583675384521, 0.9026214480400085, 0.3008595108985901, 0.853613555431366, 0.40041273832321167, 0.4919936f, 0.5831433534622192, 0.6936943531036377, 0.0393005f, 0.28767943382263184, 0.24374037981033325, 0.09897369146347046, 0.4094959497451782, 0.7226423025131226, 0.3030560612678528, 0.522198498249054, 0.036050617694854736, 0.27044087648391724, 0.9347294569015503, 0.1629672f, 0.7101078033447266, 0.2966833f, 0.758990466594696, 0.5907119512557983, 0.5736100673675537, 0.6000851392745972, 0.7347694635391235, 0.6320409178733826, 0.9719349145889282, 0.69460529088974, 0.42309242486953735, 0.19772696495056152, 0.3766484260559082, 0.9661821722984314, 0.46082764863967896, 0.38873857259750366};
        double[] sw_ODV = new double[]{0.9887094497680664, 0.696316f, 0.2764192819595337, 0.7166702151298523, 0.830791175365448, 0.6787716150283813, 0.6488276124000549, 0.4581824541091919, 0.07846349477767944, 0.19176578521728516, 0.6740943193435669, 0.3451806902885437, 0.30695444345474243, 0.4310411214828491, 0.09299474954605103, 0.9851362705230713, 0.1268731951713562, 0.9922168850898743, 0.045972466468811035, 0.5750113129615784, 0.1230475902557373, 0.5248860716819763, 0.9714605808258057, 0.7866277098655701, 0.01054072380065918, 0.5053477883338928, 0.12986916303634644, 0.783098042011261, 0.7866299152374268, 0.007010936737060547, 0.7126977443695068, 0.5003007054328918, 0.3333491086959839, 0.032890915870666504, 0.544756293296814, 0.8726591467857361, 0.24901896715164185, 0.136868417263031, 0.38333332538604736, 0.08011680841445923, 0.6365653872489929, 0.7512577772140503, 0.9029297828674316, 0.07775962352752686, 0.5195161700248718, 0.4876148f, 0.7851153612136841, 0.2787168622016907, 0.502155601978302, 0.14361625909805298, 0.33300554752349854, 0.885594f, 0.13782453536987305, 0.7673909068107605, 0.6372836828231812, 0.7997020483016968, 0.2588163f, 0.7661392688751221, 0.23970288038253784, 0.527812123298645, 0.683402419090271, 0.14062362909317017, 0.19032323360443115, 0.0032872557640075684, 0.32151246070861816, 0.7516550421714783, 0.36172401905059814, 0.6455334424972534, 0.712406575679779, 0.4276737570762634, 0.3680534362792969};
        double[] sw_OGV = new double[]{0.40522563457489014, 0.5478557348251343, 0.38068485260009766, 0.7056418657302856, 0.5422636866569519, 0.2560460567474365, 0.0660393238067627, 0.06723564863204956, 0.7215975522994995, 0.3784409761428833, 0.38286274671554565, 0.7315587997436523, 0.9047503471374512, 0.2885791063308716, 0.12745702266693115, 0.5573546290397644, 0.8810051083564758, 0.9433023929595947, 0.37098896503448486, 0.24540084600448608, 0.9938822388648987, 0.3788516f, 0.002625763416290283, 0.017959892749786377, 0.250904381275177, 0.762936532497406, 0.9554783701896667, 0.813063383102417, 0.08605921268463135, 0.07618844509124756, 0.5889109373092651, 0.12692588567733765, 0.3062574863433838, 0.1498802900314331, 0.6387202143669128, 0.15322595834732056, 0.3800281286239624, 0.4496142864227295, 0.9462686777114868, 0.2702193260192871, 0.10637825727462769, 0.925620436668396, 0.5468756556510925, 0.8885058760643005, 0.6750024557113647, 0.5987920761108398, 0.4227651357650757, 0.3822364807128906, 0.239793062210083, 0.60765f, 0.42089664936065674, 0.2387201189994812, 0.8729516267776489, 0.8857355713844299, 0.19344472885131836, 0.6455016136169434, 0.3471318483352661, 0.792776882648468, 0.059056878089904785, 0.725379467010498, 0.7612676620483398, 0.09826153516769409, 0.004938483238220215, 0.2794927954673767, 0.938511073589325, 0.06532788276672363, 0.580044150352478, 0.7231374979019165, 0.591587245464325, 0.7493153810501099, 0.6730822324752808};
        double[] sw_RDV = new double[]{0.43058836460113525, 0.9845651984214783, 0.392681360244751, 0.45867103338241577, 0.7417703866958618, 0.6863664388656616, 0.2407158613204956, 0.5419507026672363, 0.7386049628257751, 0.6792275905609131, 0.6356002688407898, 0.27551883459091187, 0.6513644456863403, 0.6768761277198792, 0.675528347492218, 0.680094f, 0.5001222491264343, 0.8475592136383057, 0.49712681770324707, 0.5173366069793701, 0.6737401485443115, 0.004607737064361572, 0.6901922821998596, 0.06339681148529053, 0.4747687578201294, 0.7033668160438538, 0.9613383412361145, 0.5667761564254761, 0.8547422885894775, 0.0026469826698303223, 0.7956898808479309, 0.3738638162612915, 0.2878679037094116, 0.04904818534851074, 0.03205406665802002, 0.22805118560791016, 0.9048783183097839, 0.2143951f, 0.3664594292640686, 0.32976603507995605, 0.07131987810134888, 0.5540482401847839, 0.3716202974319458, 0.7493662238121033, 0.74988853931427, 0.6040878295898438, 0.5964187383651733, 0.654968f, 0.4543234705924988, 0.44850343465805054, 0.2611920237541199, 0.3234688f, 0.868181586265564, 0.9668801426887512, 0.45338016748428345, 0.8938860893249512, 0.266515851020813, 0.8250992298126221, 0.1564666f, 0.4744378924369812, 0.5086734294891357, 0.15583908557891846, 0.9063013792037964, 0.28341275453567505, 0.34833747148513794, 0.7548584938049316, 0.996615f, 0.5718257427215576, 0.1804161f, 0.7090030312538147, 0.4742300510406494};
        double[] sw_Temp = new double[]{0.8042739629745483, 0.6769030690193176, 0.5915257930755615, 0.3391953706741333, 0.9525324702262878, 0.38450706005096436, 0.08173954486846924, 0.45146602392196655, 0.35166895389556885, 0.6103894114494324, 0.16440743207931519, 0.34012216329574585, 0.776297f, 0.41911906003952026, 0.9679519534111023, 3.772378E-4f, 0.6886754035949707, 0.4299241304397583, 0.0409714f, 0.5753030776977539, 0.7924477458000183, 0.23009401559829712, 0.12825655937194824, 0.6714703440666199, 0.47578585147857666, 0.5151883959770203, 0.678208f, 0.709346354007721, 0.6535637974739075, 0.7023950815200806, 0.7340717315673828, 0.8097308874130249, 0.20607268810272217, 0.428422212600708, 0.07569670677185059, 0.0567777156829834, 0.2759544849395752, 0.4918113946914673, 0.4836311936378479, 0.7369117736816406, 0.3178641200065613, 0.9012472033500671, 0.4935199022293091, 0.15249818563461304, 0.017374157905578613, 0.4816650152206421, 0.6492535471916199, 0.561363697052002, 0.1054436f, 0.219698965549469, 0.9046097993850708, 0.5507502555847168, 0.11914616823196411, 0.21586668491363525, 0.7747704386711121, 0.9601638913154602, 0.3031706213951111, 0.7850876450538635, 0.11381012201309204, 0.2056514024734497, 0.9428771734237671, 0.2075222134590149, 0.9578370451927185, 0.30271488428115845, 0.37955182790756226, 0.6917812824249268, 0.8948792219161987, 0.9513908624649048, 0.02120316f, 0.851391613483429, 0.5239168405532837};
        double[] temp1 = new double[]{0.04064774513244629, 0.645175f, 0.007733643054962158, 0.07185667753219604, 0.7964763045310974, 0.8375123739242554, 0.7788529396057129, 0.4270556569099426, 0.37578028440475464, 0.25205057859420776, 0.06955450773239136, 0.20266103744506836, 0.9739556312561035, 0.5513527989387512, 0.8856284618377686, 0.8971274495124817, 0.836042046546936, 0.04179001f, 0.5111477375030518, 0.410481333732605, 0.948326826095581, 0.5942355990409851, 0.9353773593902588, 0.694057f, 0.5386950969696045, 0.9861799478530884, 0.933417022228241, 0.9524703025817871, 0.8698908686637878, 0.1748064160346985, 0.5963649153709412, 0.8265931606292725, 0.6008403301239014, 0.6560972332954407, 0.09226840734481812, 0.31544315814971924, 0.2885880470275879, 0.25286275148391724, 0.003767251968383789, 0.7465285658836365, 0.3691164255142212, 0.753340482711792, 0.2331133484840393, 0.9847295880317688, 0.2919005751609802, 0.46845465898513794, 0.45677316188812256, 0.8388293385505676, 0.88366f, 0.244838f, 0.7323029637336731, 0.5450242161750793, 0.6151904463768005, 0.8453121185302734, 0.6574962139129639, 0.4939615f, 0.265811026096344, 0.04982292652130127, 0.5194017291069031, 0.44102412462234497, 0.6878834962844849, 0.827102541923523, 0.9778108596801758, 0.17076951265335083, 0.5247107744216919, 0.54795241355896, 0.8489335775375366, 0.5508378744125366, 0.025196433067321777, 0.35052716732025146, 0.6005797386169434};
        double[] temp10 = new double[]{0.63658207654953, 0.614855f, 0.39997607469558716, 0.8662122488021851, 0.7065966129302979, 0.8526460528373718, 0.21102523803710938, 0.023338735103607178, 0.005793154239654541, 0.44482696056365967, 0.3024466633796692, 0.06909185647964478, 0.43439197540283203, 0.35936611890792847, 0.9348606467247009, 0.33535993099212646, 0.28898316621780396, 0.936851441860199, 0.3340940475463867, 0.2059522271156311, 0.47961145639419556, 0.5162976980209351, 0.7356255650520325, 0.8831120729446411, 0.9117186665534973, 0.167472243309021, 0.4938703179359436, 0.3699588179588318, 0.13393747806549072, 0.9666085243225098, 0.9037011861801147, 0.42449235916137695, 0.0654868483543396, 0.08157283067703247, 0.8793038129806519, 0.05061441659927368, 0.9867205023765564, 0.09823405742645264, 0.15397542715072632, 0.6388018131256104, 0.812793f, 0.2651207447052002, 0.7086845636367798, 0.6858458518981934, 0.4861338138580322, 0.04222393035888672, 0.04012423753738403, 0.9072908163070679, 0.5842688679695129, 0.786433219909668, 0.051734864711761475, 0.8213452696800232, 0.614461f, 0.005615353584289551, 0.5330211520195007, 0.6082016825675964, 0.07770925760269165, 0.17142271995544434, 0.7008031010627747, 0.3286135792732239, 0.05706292390823364, 0.04384434223175049, 0.25634777545928955, 0.780586f, 0.5972769260406494, 0.16519814729690552, 0.08825105428695679, 0.25912803411483765, 0.47601795196533203, 0.10524535179138184, 0.6742352247238159};
        double[] temp2 = new double[]{0.902777910232544, 0.5556829571723938, 0.050559282302856445, 0.5355862975120544, 0.8192843794822693, 0.887121856212616, 0.9389775991439819, 0.7337748408317566, 0.7042546272277832, 0.20297324657440186, 0.9433366656303406, 0.4060276746749878, 0.6392389535903931, 0.6828808784484863, 0.24775731563568115, 0.07949447631835938, 0.3837169408798218, 0.642619252204895, 0.6651942133903503, 0.9245704412460327, 0.9785050749778748, 0.544326901435852, 0.2880619764328003, 0.9774031639099121, 0.3415755033493042, 0.8489336371421814, 0.5064236521720886, 0.5282534956932068, 0.7621306777000427, 0.3409271240234375, 0.9730137586593628, 0.512967f, 0.5516283512115479, 0.7094010710716248, 0.43442755937576294, 0.6142131090164185, 0.3735159635543823, 0.13055896759033203, 0.4169372320175171, 0.4603843092918396, 0.9945682883262634, 0.0813332200050354, 0.07799690961837769, 0.4642393f, 0.9434007406234741, 0.5404626727104187, 0.775625467300415, 0.45978856086730957, 0.1550588607788086, 0.4743306636810303, 0.12315833568572998, 0.9419357776641846, 0.4692825675010681, 0.1352825164794922, 0.18263846635818481, 0.7845128774642944, 0.44447124004364014, 0.2483508586883545, 0.59327632188797, 0.282215f, 0.4755004644393921, 0.8597514629364014, 0.5594964623451233, 0.03230971097946167, 0.5529730916023254, 0.1517548f, 0.8542617559432983, 0.9227451086044312, 0.08144593238830566, 0.28126853704452515, 0.0864189863204956};
        double[] temp3 = new double[]{0.5324265360832214, 0.15751487016677856, 0.6145234107971191, 0.08515149354934692, 0.8630955815315247, 0.283841073513031, 0.15156543254852295, 0.16030138731002808, 0.12469482421875, 0.11635851860046387, 0.4589056372642517, 0.3849881887435913, 0.47971415519714355, 0.9787482023239136, 0.7568533420562744, 0.737908f, 0.2372998595237732, 0.2661466f, 0.5930808782577515, 0.648842990398407, 0.07349765300750732, 0.7499529123306274, 0.6322848796844482, 0.0648006796836853, 0.8666547536849976, 0.204109787940979, 0.8129878640174866, 0.8389888405799866, 0.6816045045852661, 0.7325897216796875, 0.47926443815231323, 0.9243106842041016, 0.14581084251403809, 0.9858641028404236, 0.053293466567993164, 0.30164462327957153, 0.846287727355957, 0.924354f, 0.543082058429718, 0.705901026725769, 0.6770938038825989, 0.49834924936294556, 0.3005438446998596, 0.3353760838508606, 0.10091108083724976, 0.16137337684631348, 0.2835441827774048, 0.7885550856590271, 0.7001635432243347, 0.3778119683265686, 0.9098625183105469, 0.30415254831314087, 0.9069435596466064, 0.6017847061157227, 0.9027182459831238, 0.9623663425445557, 0.4684526324272156, 0.7343395352363586, 0.2511278986930847, 0.20622271299362183, 0.6556101441383362, 0.9672932028770447, 0.18160325288772583, 0.8702937364578247, 0.9149466753005981, 0.617299497127533, 0.4513859152793884, 0.7593870759010315, 0.1340096f, 0.9814637303352356, 0.12148594856262207};
        double[] temp4 = new double[]{0.7420857548713684, 0.802528f, 0.11014509201049805, 0.4973207712173462, 0.743908166885376, 0.547892689704895, 0.41322243213653564, 0.08593416213989258, 0.01366502046585083, 0.07461011409759521, 0.17839467525482178, 0.11492961645126343, 0.5562143325805664, 0.7919279336929321, 0.8850230574607849, 0.495827317237854, 0.7778053879737854, 0.0485512f, 0.9111981391906738, 0.6531158089637756, 0.6697167158126831, 0.1631633f, 0.13735878467559814, 0.6425173282623291, 0.39572131633758545, 0.4273398518562317, 0.5947514772415161, 0.6637360453605652, 0.9734728336334229, 0.1245262622833252, 0.754777f, 0.8531598448753357, 0.014229416847229004, 0.8443055152893066, 0.13492578268051147, 0.9927076697349548, 0.7650945782661438, 0.0425871f, 0.4532815217971802, 0.06744980812072754, 0.17942994832992554, 0.8011139631271362, 0.7068256735801697, 0.9751013517379761, 0.5112125277519226, 0.04744327f, 0.9049818515777588, 0.866441547870636, 0.21539711952209473, 0.4110651f, 0.1505945324897766, 0.7617158889770508, 0.3569720983505249, 0.2924646735191345, 0.733077883720398, 0.13182878494262695, 0.5451528429985046, 0.3177192211151123, 0.5556369423866272, 0.8954521417617798, 0.7654516100883484, 0.9277739524841309, 0.7487426996231079, 0.8080050945281982, 0.671242f, 0.5231351256370544, 0.6795278787612915, 0.0028725266456604004, 0.5985565781593323, 0.043717265129089355, 0.7211943864822388};
        double[] temp5 = new double[]{0.6894202828407288, 0.10451167821884155, 0.6305108070373535, 0.3332318067550659, 0.8696532845497131, 0.4128573536872864, 0.6892148852348328, 0.9732235074043274, 0.7621943950653076, 0.13223963975906372, 0.18277627229690552, 0.6308545470237732, 0.2282077670097351, 0.7370032072067261, 0.8247628808021545, 0.8766695857048035, 0.3916453f, 0.9505444765090942, 0.36169564723968506, 0.05000501871109009, 0.3015778064727783, 0.6217581033706665, 0.7309912443161011, 0.8858166337013245, 0.5663325786590576, 0.35104936361312866, 0.3012924790382385, 0.5779418349266052, 0.5197622776031494, 0.8093692660331726, 0.9610646963119507, 0.09140431880950928, 0.4844135642051697, 0.8480600714683533, 0.6649214029312134, 0.8290349245071411, 0.85297030210495, 0.4558916687965393, 0.3988474f, 0.403927743434906, 0.9995548129081726, 0.8600578904151917, 0.9370658993721008, 0.9106717109680176, 0.8908591866493225, 0.45825833082199097, 0.36463356018066406, 0.3821257948875427, 0.831337f, 0.3180962800979614, 0.08895128965377808, 0.9875891208648682, 0.13763505220413208, 0.0872969f, 0.996381f, 0.4110334f, 0.9890350699424744, 0.8637291193008423, 0.8913176655769348, 0.9487156271934509, 0.9899663925170898, 0.8085609674453735, 0.3267647f, 0.4037020206451416, 0.5578536987304688, 0.6203885078430176, 0.16820716857910156, 0.315957f, 0.51798015832901, 0.8847546577453613, 0.5750030875205994};
        double[] temp6 = new double[]{0.451665997505188, 0.8531400561332703, 0.374667763710022, 0.712377667427063, 0.5509635806083679, 0.47918015718460083, 0.5966972708702087, 0.17729073762893677, 0.8814622163772583, 0.9607940912246704, 0.8877550959587097, 0.4159609079360962, 0.21376508474349976, 0.9609487056732178, 0.6941841244697571, 0.9908044934272766, 0.987984f, 0.8510401844978333, 0.9723028540611267, 0.4092438220977783, 0.006264746189117432, 0.6693617701530457, 0.9937687516212463, 0.9236326813697815, 0.31018006801605225, 0.5779196619987488, 0.9163049459457397, 0.6459565758705139, 0.5939314961433411, 0.1603686809539795, 0.8774012923240662, 0.966610848903656, 0.6905823349952698, 0.5583094954490662, 0.8130963444709778, 0.4252118468284607, 0.24063491821289062, 0.2439583f, 0.8140248656272888, 0.23292845487594604, 0.5173759460449219, 0.5619667768478394, 0.36537444591522217, 0.7982437014579773, 0.7144157886505127, 0.3827523f, 0.925645f, 0.14750593900680542, 0.4861999750137329, 0.8380454182624817, 0.7711847424507141, 0.6723573803901672, 0.6260880827903748, 0.1535385251045227, 0.05005037784576416, 0.370522141456604, 0.9385936856269836, 0.7537253499031067, 0.3710995316505432, 0.6950031518936157, 0.3479207158088684, 0.7435762286186218, 0.7142780423164368, 0.3881067f, 0.33498072624206543, 0.4270401f, 0.8383585214614868, 0.6776511669158936, 0.9262469410896301, 0.01307559f, 0.9260809421539307};
        double[] temp7 = new double[]{0.9580941200256348, 0.7023093700408936, 0.09868526458740234, 0.8275295495986938, 0.402147114276886, 0.949701726436615, 0.8710747361183167, 0.7150679230690002, 0.7598687410354614, 0.9599435925483704, 0.4065338373184204, 0.16228628158569336, 0.1414891481399536, 0.1638903021812439, 0.5840074419975281, 0.9108518362045288, 0.6647132039070129, 0.8721272349357605, 0.3017804026603699, 0.8391883969306946, 0.12247425317764282, 0.7336402535438538, 0.16457504034042358, 0.7324552536010742, 0.016705691814422607, 0.0013184547424316406, 0.07708275318145752, 0.351889967918396, 0.45941776037216187, 0.4455924f, 0.17310625314712524, 0.38138657808303833, 0.19409316778182983, 0.44391971826553345, 0.864762008190155, 0.09898990392684937, 0.7961611747741699, 0.8167381882667542, 0.1044088f, 0.9802145957946777, 0.5072026252746582, 0.31840431690216064, 0.007071077823638916, 0.9287771582603455, 0.007836997509002686, 0.028610527515411377, 0.030188381671905518, 0.8791321516036987, 0.18133306503295898, 0.9455674290657043, 0.9007331132888794, 0.1954137086868286, 0.8343716263771057, 0.8421884775161743, 0.3204282522201538, 0.5649151802062988, 0.7717046141624451, 0.41160547733306885, 0.2744000554084778, 0.05363631248474121, 0.2444610595703125, 0.16517776250839233, 0.07669574022293091, 0.14984625577926636, 0.8624247908592224, 0.7369556427001953, 0.3703743815422058, 0.10284703969955444, 0.6617646813392639, 0.741178572177887, 0.3761605f};
        double[] temp8 = new double[]{0.6925865411758423, 0.31256258487701416, 0.18730193376541138, 0.17088395357131958, 0.9065024852752686, 0.9243192672729492, 0.5093567967414856, 0.54718017578125, 0.40864354372024536, 0.6298071146011353, 0.3578829765319824, 0.6343936920166016, 0.3589999f, 0.993683f, 0.5435834527015686, 0.47562986612319946, 0.1649966835975647, 0.2758165f, 0.538210928440094, 0.8888853192329407, 0.34979814291000366, 0.9820772409439087, 0.12161076068878174, 0.3757215142250061, 0.5216066241264343, 0.837249f, 0.521539568901062, 0.4667292833328247, 0.683299f, 0.02380246f, 0.3977036476135254, 0.549879789352417, 0.9819477200508118, 0.03259849548339844, 0.4618951678276062, 0.9597198963165283, 0.7530564665794373, 0.8814603090286255, 0.3562476f, 0.4093116f, 0.045368313789367676, 0.46734195947647095, 0.6012097597122192, 0.923039436340332, 0.040166497230529785, 0.9480247497558594, 0.20920515060424805, 0.43022620677948, 0.11599612236022949, 0.8985358476638794, 0.6900745630264282, 0.4633628726005554, 0.10823297500610352, 0.4825601f, 0.16689467430114746, 0.7802342772483826, 0.3160714f, 0.5248847603797913, 0.7078564167022705, 0.7090084552764893, 0.40109115839004517, 0.5003935694694519, 0.5594173669815063, 0.0652725100517273, 0.7760035991668701, 0.4794362783432007, 0.05139714479446411, 0.2789878249168396, 0.8145118951797485, 0.7278062105178833, 0.6151588559150696};
        double[] temp9 = new double[]{0.019473552703857422, 0.02911198139190674, 0.2694391f, 0.7062428593635559, 0.9430009126663208, 0.709396481513977, 0.4268161f, 0.8131446242332458, 0.9887184500694275, 0.7259243726730347, 0.3815355896949768, 0.04032582f, 0.8958693742752075, 0.7615131139755249, 0.6973826289176941, 0.617629f, 0.743181f, 0.0010726451873779297, 0.6503399610519409, 0.7672485709190369, 0.4575955271720886, 0.8016131520271301, 0.07237106561660767, 0.576149046421051, 0.4949935f, 0.4752362370491028, 0.2745901942253113, 0.314797043800354, 0.5541805028915405, 0.5898063778877258, 0.8348726034164429, 0.2163775f, 0.9942328333854675, 0.055252254009246826, 0.5574401617050171, 0.3040347695350647, 0.03452927f, 0.2893616557121277, 0.5079842805862427, 0.912459f, 0.2297464f, 0.40742015838623047, 0.5460947751998901, 0.09530794620513916, 0.7352167963981628, 0.2576394f, 0.39391028881073, 0.908115804195404, 0.5709092617034912, 0.2221977710723877, 0.7508715987205505, 0.3897170424461365, 0.21758383512496948, 0.6556516885757446, 0.8722531795501709, 0.9816614389419556, 0.15222138166427612, 0.16289585828781128, 0.034906625747680664, 0.6880876421928406, 0.2705775499343872, 0.2927843928337097, 0.4066234230995178, 0.8171615600585938, 0.9247265458106995, 0.6966448426246643, 0.5831032991409302, 0.004199504852294922, 0.597944974899292, 0.06950384378433228, 0.8542014360427856};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, htrPI, htrPV, htrV, htrW, hVBiasSwitch, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, ref05V, ref125V, ref15V, ref25V, refN12, refP12, rG0, rG1, rGL, rGU, rTDTemp, sClk0, sClk1, sClkL, sClkU, sw_GDV, sw_ODI, sw_ODV, sw_OGV, sw_RDV, sw_Temp, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sw_GDV, (double[])item_.getSw_GDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sw_ODI, (double[])item_.getSw_ODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sw_ODV, (double[])item_.getSw_ODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sw_OGV, (double[])item_.getSw_OGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sw_RDV, (double[])item_.getSw_RDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sw_Temp, (double[])item_.getSw_Temp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = new double[]{0.006332755088806152, 0.0765537f, 0.8428194522857666, 0.5825581550598145, 0.6050093173980713, 0.5898361802101135, 0.358411967754364, 0.7246454358100891, 0.7473728060722351, 0.4594525098800659, 0.24227356910705566, 0.8765783309936523, 0.7078290581703186, 0.716566f, 0.672800600528717, 0.49274522066116333, 0.7297653555870056, 0.2490139603614807, 0.8501484990119934, 0.3905387f, 0.0028995275497436523, 0.8762302994728088, 0.011895835399627686, 0.9334807991981506, 0.39820587635040283, 0.3133384585380554, 0.9856851100921631, 0.5702108144760132, 0.589523434638977, 0.9780677556991577, 0.3432725f, 0.718652f, 0.7741456031799316, 0.66823410987854, 0.4343818426132202, 0.42182648181915283, 0.4149003028869629, 0.14990317821502686, 0.7854567766189575, 0.19100284576416016, 0.28005266189575195, 0.9565966129302979, 0.7910059690475464, 0.998023509979248, 0.5870317220687866, 0.22070425748825073, 0.18752586841583252, 0.3147731423377991, 0.559340238571167, 0.10544520616531372, 0.2563799023628235, 0.3349526f, 0.9965412616729736, 0.5482276678085327, 0.9675507545471191, 0.2908664345741272, 0.1140146255493164, 0.18615615367889404, 0.656526f, 0.9132081866264343, 0.5269818305969238, 0.8369277715682983, 0.2680183f, 0.2203320860862732, 0.692446231842041, 0.031759023666381836, 0.5396718382835388, 0.688878059387207, 0.7591769099235535, 0.3227441906929016, 0.7139081954956055, 0.5016166567802429, 0.7512683272361755, 0.34972792863845825, 0.8247761726379395, 0.6208896636962891, 0.4823719263076782, 0.5890822410583496, 0.3178880214691162, 0.3550482988357544, 0.9882614612579346, 0.9095237255096436, 0.6246557831764221, 0.4069647192955017, 0.5134460926055908, 0.3222431540489197, 0.3671302795410156, 0.982274055480957, 0.8971799612045288, 0.8812095522880554, 0.5474525690078735, 0.8328742384910583, 0.29516226053237915, 0.5147580504417419, 0.44754356145858765, 0.3888797163963318, 0.5308322310447693, 0.5547863841056824, 0.992098f, 0.7383220791816711, 0.49541014432907104, 0.9815243482589722, 0.11374855041503906, 0.8251785635948181, 0.1753246784210205, 0.4794623851776123, 0.696593f, 0.10766464471817017, 0.3616228f, 0.5663382411003113, 0.09692007303237915, 0.13316327333450317, 0.4362332224845886, 0.5278919339179993, 0.07233834266662598, 0.20481044054031372, 0.8980245590209961, 0.08536320924758911, 0.3576540946960449, 0.02687305212020874, 0.3165665864944458, 0.5124906897544861, 0.6634120941162109, 0.9890223741531372, 0.02809387445449829, 0.879268229007721, 0.737308144569397, 0.4789363741874695, 0.2267369031906128, 0.7592509388923645, 0.40660685300827026, 0.2719825506210327, 0.7806022763252258, 0.8272164463996887, 0.4388030171394348, 0.9378071427345276, 0.5083564519882202, 0.4790557622909546, 0.23620158433914185, 0.20635831356048584, 0.1948157548904419, 0.8135794997215271, 0.07666194438934326, 0.058219194412231445, 0.9765283465385437, 0.867307f, 0.9768588542938232, 0.7322438955307007, 0.07892346382141113, 0.932197093963623, 0.5761035084724426, 0.9916437268257141, 0.18940281867980957, 0.6097546219825745, 0.3987012505531311, 0.5502334833145142, 0.9754828810691833, 0.16319936513900757, 0.7722922563552856, 0.05403989553451538, 0.6391215324401855, 0.8757351636886597, 0.7705341577529907, 0.038514018058776855, 0.6886487007141113, 0.8638513088226318, 0.16339164972305298, 0.7649483680725098, 0.8248726725578308, 0.939595639705658, 0.240348219871521, 0.2862508296966553, 0.5101796984672546, 0.1775774359703064, 0.9048513174057007, 0.834984f, 0.2166338f, 0.2869024872779846, 0.8966467976570129, 0.07666915655136108, 0.8446915149688721, 0.3842673897743225, 0.7974016070365906, 0.6680433750152588, 0.44727832078933716, 0.434102f, 0.41980892419815063, 0.2206195592880249, 0.2793543338775635, 0.2901601195335388, 0.717515230178833, 0.3400484323501587, 0.6810743808746338, 0.7186221480369568, 0.8196117877960205, 0.11504805088043213, 0.26920658349990845};
        String location = "i";
        double[] oDI = new double[]{0.8178077340126038, 0.9982067346572876, 9.740591049194336E-4, 0.8732016682624817, 0.780672550201416, 0.5164855718612671, 0.6982448697090149, 0.37427037954330444, 0.38958245515823364, 0.807803f, 0.5612320303916931, 0.5272148251533508, 0.9193023443222046, 0.8108503818511963, 0.9726823568344116, 0.180049f, 0.8932039141654968, 0.7560471296310425, 0.4693423f, 0.7084153890609741, 0.7236192226409912, 0.5671005249023438, 0.1887444257736206, 0.741210401058197, 0.3480958938598633, 0.331315815448761, 0.3620295524597168, 0.6991311311721802, 0.27087146043777466, 0.5479692816734314, 0.18583154678344727, 0.9644283056259155, 0.02431321144104004, 0.3848733901977539, 0.8686416745185852, 0.4769303798675537, 0.33681434392929077, 0.291797935962677, 0.8543938398361206, 0.44474905729293823, 0.8147166967391968, 0.08351367712020874, 0.89409339427948, 0.1924002766609192, 0.3773655295372009, 0.5783728361129761, 0.6840893030166626, 0.609416127204895, 0.015660524368286133, 0.3896377682685852, 0.5891388058662415, 0.264548122882843, 0.24282395839691162, 0.8609350323677063, 0.5949298143386841, 0.7106565833091736, 0.26707834005355835, 0.024609744548797607, 0.11652421951293945, 0.4102625250816345, 0.913135290145874, 0.968347430229187, 0.857717752456665, 0.7890418171882629, 0.4546098f, 0.012831509113311768, 0.2561432719230652, 0.29243606328964233, 0.1725701093673706, 0.5386322140693665, 0.547775f, 0.7378244400024414, 0.834418773651123, 0.32683265209198, 0.483134388923645, 0.3707631230354309, 0.6783115863800049, 0.5835667252540588, 0.769909f, 0.6386917233467102, 0.505611777305603, 0.8577693104743958, 0.3999343514442444, 0.969893217086792, 0.3198356032371521, 0.3037535548210144, 0.8427575826644897, 0.6106656193733215, 0.6256721019744873, 0.9210810661315918, 0.3066191077232361, 0.5415313839912415, 0.11459547281265259, 0.774556f, 0.7370971441268921, 0.5164174437522888, 0.4410848617553711, 0.7736533880233765, 0.2534343f, 0.5902438163757324, 0.14040958881378174, 0.4055183529853821, 0.3253980875015259, 0.004056394100189209, 0.2883339524269104, 0.1666865348815918, 0.13523966073989868, 0.7571396827697754, 0.16607993841171265, 0.1393650770187378, 0.4188519f, 0.5274876356124878, 0.20971077680587769, 0.7875735759735107, 0.2596590518951416, 0.11126375198364258, 0.7091556191444397, 0.20140045881271362, 0.14329391717910767, 0.184726f, 0.7238824963569641, 0.5544398427009583, 0.34905028343200684, 0.7854499220848083, 0.2233845f, 0.8361077904701233, 0.9368874430656433, 0.4410915970802307, 0.5929254293441772, 0.11860001087188721, 0.12097889184951782, 0.7115481495857239, 0.9982832670211792, 0.8749711513519287, 0.3401338458061218, 0.06299972534179688, 0.1355353593826294, 0.6030387282371521, 0.4326992630958557, 0.3593527674674988, 0.13938432931900024, 0.16802281141281128, 0.7927149534225464, 0.8780995607376099, 0.7503877282142639, 0.5591237545013428, 0.47221839427948, 0.06422382593154907, 0.6901049613952637, 0.8813422918319702, 0.851872444152832, 0.2988031506538391, 0.8341245055198669, 0.35911113023757935, 0.6318364143371582, 0.7403059005737305, 0.5548144578933716, 0.4137130379676819, 0.6034720540046692, 0.8987863063812256, 0.20520591735839844, 0.758603f, 0.50962895154953, 0.5194153189659119, 0.3875581622123718, 0.217866f, 0.549597f, 0.715831995010376, 0.47787004709243774, 0.16097253561019897, 0.950157642364502, 0.13007837533950806, 0.022031128406524658, 0.1252194046974182, 0.9254599213600159, 0.36942464113235474, 0.5697037577629089, 0.1948692798614502, 0.15776324272155762, 0.636868953704834, 0.3357757329940796, 0.8677466511726379, 0.2236175537109375, 0.5277954936027527, 0.671834f, 0.5762714147567749, 0.6941181421279907, 0.497106671333313, 0.665211021900177, 0.36658525466918945, 0.6849187612533569, 0.7366546392440796, 0.5625077486038208, 0.8681522607803345, 0.606284499168396, 0.7601420879364014, 0.01798451f};
        double[] oDV = new double[]{0.014221787452697754, 0.6533106565475464, 0.13063812255859375, 0.102836012840271, 0.6736809015274048, 0.02234470844268799, 0.6338683366775513, 0.36526936292648315, 0.6155680418014526, 0.985573410987854, 0.08853477239608765, 0.1177358f, 0.0029767751693725586, 0.2987407445907593, 0.5737633109092712, 0.23901361227035522, 0.8729681968688965, 0.15724974870681763, 0.46464717388153076, 0.6356108784675598, 0.03879141807556152, 0.20677995681762695, 0.511680543422699, 0.7077792882919312, 0.30115365982055664, 0.3124803304672241, 0.631182074546814, 0.63707f, 0.2930905222892761, 0.7053354382514954, 0.8347705006599426, 0.5596944093704224, 0.24038928747177124, 0.2681516408920288, 0.20035123825073242, 0.04599088430404663, 0.19436198472976685, 0.5625876784324646, 0.24932897090911865, 0.18217182159423828, 0.1995309f, 0.4017072916030884, 0.9599062204360962, 0.685492992401123, 0.4745774269104004, 0.46172666549682617, 0.7200322151184082, 0.195432f, 0.1054402f, 0.4271716f, 0.2521169185638428, 0.3168928027153015, 0.33508485555648804, 0.2538526654243469, 0.2619335f, 0.3705002f, 0.16118115186691284, 0.295376f, 0.7537447810173035, 0.6814711689949036, 0.2623133659362793, 0.7058843970298767, 0.4807591438293457, 0.7422312498092651, 0.9226464033126831, 0.8420775532722473, 0.37334924936294556, 0.6728914976119995, 0.537021279335022, 0.4321043f, 0.4064568281173706, 0.11404722929000854, 0.8917404413223267, 0.3516010642051697, 0.7723057866096497, 0.38236403465270996, 0.9349205493927002, 0.6950390338897705, 0.3456118106842041, 0.3434569835662842, 0.3939728f, 0.9038351774215698, 0.8372026681900024, 0.7791609168052673, 0.851863443851471, 0.414697f, 0.19026267528533936, 0.8960587978363037, 0.7592893242835999, 0.22885394096374512, 0.2838233f, 0.21584242582321167, 0.10337632894515991, 0.03475087881088257, 0.8638104796409607, 0.16061055660247803, 0.8571990728378296, 0.8061347007751465, 0.45670825242996216, 0.7805647253990173, 0.9461796879768372, 0.8600772023200989, 0.3591296076774597, 0.928884f, 0.8507275581359863, 0.11428529024124146, 0.30333298444747925, 0.7580960392951965, 0.44843345880508423, 0.10213273763656616, 0.12965422868728638, 0.2614038586616516, 0.6284573078155518, 0.2623909115791321, 0.4482235312461853, 0.10667616128921509, 0.19579851627349854, 0.1469690203666687, 0.431126f, 0.6838032007217407, 0.7498893141746521, 0.7155355215072632, 0.2698732018470764, 0.9096118807792664, 0.46200746297836304, 0.49525654315948486, 0.5798543691635132, 0.2884118f, 0.8965891003608704, 0.4647475f, 0.8921118974685669, 0.2185099720954895, 0.39548832178115845, 0.41450977325439453, 0.9927541613578796, 0.8518251776695251, 0.7600553631782532, 0.7855658531188965, 0.041618525981903076, 0.5693046450614929, 0.47768741846084595, 0.5907754898071289, 0.30508965253829956, 0.5215848088264465, 0.016976892948150635, 0.6796172261238098, 0.7945566773414612, 0.722747f, 0.4940885305404663, 0.9703662395477295, 0.8237678408622742, 0.9737351536750793, 0.5435187220573425, 0.20004034042358398, 0.3378515839576721, 0.8577803373336792, 0.5255268216133118, 0.5417921543121338, 0.06718826293945312, 0.19790208339691162, 0.30250757932662964, 0.12428885698318481, 0.004417061805725098, 0.5292323231697083, 0.015248894691467285, 0.023863136768341064, 0.16707056760787964, 0.2276741862297058, 0.4008594751358032, 0.85679030418396, 0.006679117679595947, 0.1905149221420288, 0.79627f, 0.2980054020881653, 0.4633442163467407, 0.20144778490066528, 0.6593230962753296, 0.019132018089294434, 0.4890316128730774, 0.9775288701057434, 0.07393276691436768, 0.9511553049087524, 0.7101011276245117, 0.11253184080123901, 0.6625853776931763, 0.9168928861618042, 0.7473998069763184, 0.7517280578613281, 0.7501716613769531, 0.4801652431488037, 0.928773045539856, 0.487190306186676, 0.6650150418281555, 0.9599320888519287, 0.7228758335113525, 0.1083073616027832, 0.14884096384048462};
        double[] oGV = new double[]{0.5494742393493652, 0.0941118597984314, 0.01543271541595459, 0.9157946705818176, 0.1568945050239563, 0.16642826795578003, 0.16973435878753662, 0.15556377172470093, 0.19086915254592896, 0.5192142128944397, 0.851746678352356, 0.9369194507598877, 0.004884958267211914, 0.19297999143600464, 0.5053540468215942, 0.02091193199157715, 0.9874807596206665, 0.0177459716796875, 0.9015988707542419, 0.03851675987243652, 0.4517103433609009, 0.29568302631378174, 0.4445529580116272, 0.5923284292221069, 0.0937292f, 0.6646856069564819, 0.9144130945205688, 0.888167679309845, 0.12078410387039185, 0.27501344680786133, 0.38397717475891113, 0.5380551815032959, 0.40875518321990967, 0.251321017742157, 0.6148687601089478, 0.2643876075744629, 0.6577314734458923, 0.952343761920929, 0.42855626344680786, 0.20543086528778076, 0.34294217824935913, 0.33589673042297363, 0.4217427372932434, 0.2191503f, 0.882931f, 0.983941912651062, 0.8515936136245728, 0.11627393960952759, 0.3954553008079529, 0.128223717212677, 0.527154266834259, 0.7503158450126648, 0.4156712293624878, 0.5688849091529846, 0.4109400510787964, 0.7436703443527222, 0.19529396295547485, 0.3147273063659668, 0.23895204067230225, 0.7420495748519897, 0.5732993483543396, 0.35316312313079834, 0.5162773728370667, 0.1373327374458313, 0.7491744756698608, 0.32982325553894043, 0.5251168608665466, 0.3697957992553711, 0.6426806449890137, 0.3722909092903137, 0.6067949533462524, 0.16880416870117188, 0.38662922382354736, 0.5101763010025024, 0.6414371728897095, 0.3860968351364136, 0.07148563861846924, 0.4460286498069763, 0.8690500855445862, 0.6531270742416382, 0.29603081941604614, 0.03030836582183838, 0.5723443627357483, 0.7045236229896545, 0.7332660555839539, 0.0413599f, 0.601561963558197, 0.37020182609558105, 0.6048174500465393, 0.5111891627311707, 0.7696815133094788, 0.48121178150177, 0.18297582864761353, 0.2536564f, 0.11569583415985107, 0.05691099166870117, 0.6730182766914368, 0.7178553938865662, 0.3353092074394226, 0.4569730758666992, 0.7385388016700745, 0.221002459526062, 0.05165189504623413, 0.7701848149299622, 0.641247f, 0.8177680969238281, 0.3608352541923523, 0.6676786541938782, 0.2992609739303589, 0.9829412698745728, 0.3838813900947571, 0.631538450717926, 0.3026513457298279, 0.2585331201553345, 0.6113900542259216, 0.756587028503418, 0.04332864284515381, 0.5224406719207764, 0.19201093912124634, 0.855209f, 0.05287838f, 0.4417726993560791, 0.12024885416030884, 0.029516994953155518, 0.5343315005302429, 0.48867f, 0.4813621f, 0.13487565517425537, 0.012934207916259766, 0.019350528717041016, 0.5472375750541687, 0.08224087953567505, 0.31069236993789673, 0.8882145881652832, 0.9514132142066956, 0.9180454611778259, 0.41688746213912964, 0.8188168406486511, 0.346241295337677, 0.2992019057273865, 0.7320829629898071, 0.8536457419395447, 0.6310564279556274, 0.8325394988059998, 0.00968653f, 0.11685407161712646, 0.8857652544975281, 0.773634f, 0.7133487462997437, 0.4509022831916809, 0.7262617945671082, 0.546116054058075, 0.5099307298660278, 0.22266751527786255, 0.6713845133781433, 0.23139095306396484, 0.9891626238822937, 0.3707294464111328, 0.8587684631347656, 0.638119101524353, 0.15825551748275757, 0.10768008232116699, 0.7300475239753723, 0.3542662262916565, 0.7215706706047058, 0.264459f, 0.11367875337600708, 0.6411402225494385, 0.9940628409385681, 0.12355285882949829, 0.03358501195907593, 0.493313729763031, 0.5877903699874878, 0.43070417642593384, 0.9593414664268494, 0.27103692293167114, 0.7816471457481384, 0.6874696016311646, 0.5624056458473206, 0.1386541724205017, 0.9670662879943848, 0.5370826721191406, 0.1546666f, 0.005248546600341797, 0.44133883714675903, 0.18178480863571167, 0.24024450778961182, 0.6694798469543457, 0.4830828905105591, 0.06986802816390991, 0.21702218055725098, 0.5922045707702637, 0.4321068f, 0.2145509123802185, 0.506962776184082, 0.846445620059967, 0.952380359172821};
        double[] rDV = new double[]{0.2445114254951477, 0.8881216049194336, 0.7787207365036011, 0.7791313529014587, 0.8181033134460449, 0.738779604434967, 0.22836273908615112, 0.7394144535064697, 0.18126261234283447, 0.3058180809020996, 0.5276308059692383, 0.34318095445632935, 0.12479633092880249, 0.07394957542419434, 0.1960861086845398, 0.6253464221954346, 0.25265926122665405, 0.266480028629303, 0.2645023465156555, 0.48819422721862793, 0.552147388458252, 0.4567836f, 0.5487140417098999, 0.5603440403938293, 0.6434427499771118, 0.04562878608703613, 0.24013715982437134, 0.519291f, 0.5540598034858704, 0.8740415573120117, 0.7006955146789551, 0.08812171220779419, 0.32849663496017456, 0.7337796688079834, 0.924658477306366, 0.13550466299057007, 0.5504605174064636, 0.82511f, 0.35316604375839233, 0.8066404461860657, 0.8706943988800049, 0.9399321675300598, 0.45933806896209717, 0.6698505878448486, 0.7346011400222778, 0.041009485721588135, 0.13881057500839233, 0.960336f, 0.6680817008018494, 0.016916334629058838, 0.5839191675186157, 0.07391345500946045, 0.0754357f, 0.34715986251831055, 0.14677798748016357, 0.14693760871887207, 0.5386061072349548, 0.6708070635795593, 0.13004088401794434, 0.4449577331542969, 0.9819033145904541, 0.3509639f, 0.42264866828918457, 0.165885329246521, 0.8206489682197571, 0.9308781623840332, 0.12547338008880615, 0.3906365f, 0.7766063213348389, 0.327653706073761, 0.508182168006897, 0.23554962873458862, 0.48890072107315063, 0.977074146270752, 0.7892229557037354, 0.6796925067901611, 0.33828938007354736, 0.27647513151168823, 0.8365504741668701, 0.1629016399383545, 0.13766098022460938, 0.24873757362365723, 0.2141682505607605, 0.4366171956062317, 0.015690267086029053, 0.6241703033447266, 0.3309866189956665, 0.5619782209396362, 0.06743419170379639, 0.5913347005844116, 0.3317415714263916, 0.6040526032447815, 0.18974441289901733, 0.463850200176239, 0.8682568669319153, 0.8864307999610901, 0.12572991847991943, 0.9371832609176636, 0.8322685360908508, 0.5187921524047852, 0.6667921543121338, 0.5347318053245544, 0.3630903959274292, 0.8666432499885559, 0.39926642179489136, 0.16169077157974243, 0.0749329924583435, 0.22555667161941528, 0.422349750995636, 0.37184756994247437, 0.10567647218704224, 0.9233483076095581, 0.33231496810913086, 0.3083727955818176, 0.6629343628883362, 0.5872907638549805, 0.08317047357559204, 0.18471825122833252, 0.6415675282478333, 0.26736754179000854, 0.35471153259277344, 0.33392566442489624, 0.2822568416595459, 0.3415479063987732, 0.934735119342804, 0.060111165046691895, 0.9218002557754517, 0.6890460848808289, 0.6431016325950623, 0.8888872265815735, 0.6065713763237, 0.9995998740196228, 0.17197632789611816, 0.02639162540435791, 0.6707764267921448, 0.4911474585533142, 0.21027302742004395, 0.41992777585983276, 0.5561421513557434, 0.8882282376289368, 0.5729548931121826, 0.36560487747192383, 0.9204193949699402, 0.6254197359085083, 0.11996978521347046, 0.05656898021697998, 0.9652118682861328, 0.6937256455421448, 0.768369197845459, 0.3143112063407898, 0.4413501024246216, 0.8557401299476624, 0.2583711f, 0.3281384f, 0.7601914405822754, 0.5834547877311707, 0.8041953444480896, 0.9553288221359253, 0.3653023838996887, 0.6896886825561523, 0.758456289768219, 0.7460245490074158, 0.08008080720901489, 0.35238271951675415, 0.7504166960716248, 0.669921f, 0.6377243995666504, 0.8955993056297302, 0.8697671294212341, 0.6818041205406189, 0.3808991312980652, 0.07032996416091919, 0.6957184076309204, 0.9935986399650574, 0.0654884f, 0.65358f, 0.7936179637908936, 0.7735726237297058, 0.4575052261352539, 0.3902425765991211, 0.5861840844154358, 0.09859085083007812, 0.63186f, 0.7766900658607483, 0.762592f, 0.30081605911254883, 0.4890395998954773, 0.0186162f, 0.015448391437530518, 0.41216886043548584, 0.4393518f, 0.9824073910713196, 0.4332025f, 0.5824195742607117, 0.668321f, 0.8462724089622498, 0.2544201f};
        double[] temp = new double[]{0.07239288091659546, 0.11081451177597046, 0.8947144150733948, 0.4818856120109558, 0.47291702032089233, 0.7108829617500305, 0.8910062313079834, 0.5206084251403809, 0.02148211f, 0.7300957441329956, 0.3135761022567749, 0.14703214168548584, 0.458843f, 0.5559356808662415, 0.5131953954696655, 0.730245f, 0.5418933629989624, 0.4358208179473877, 0.301279f, 0.3435519337654114, 0.6900568604469299, 0.8693929314613342, 0.33128148317337036, 0.7508120536804199, 0.9513244032859802, 0.5953297019004822, 0.8040459156036377, 0.8915072679519653, 0.5201650857925415, 0.5382011532783508, 0.8861039280891418, 0.47724777460098267, 0.9902423024177551, 0.08052796125411987, 0.8525354862213135, 0.34663712978363037, 0.7756787538528442, 0.2055642008781433, 0.3813878893852234, 0.892017f, 0.15916931629180908, 0.5433878302574158, 0.8662821054458618, 0.898135781288147, 0.025296568870544434, 0.03825432062149048, 0.7622568011283875, 0.6373975872993469, 0.8928418159484863, 0.7460613250732422, 0.2248256802558899, 0.807837f, 0.578716516494751, 0.3400551676750183, 0.9844622015953064, 0.5277466773986816, 0.9944906234741211, 0.9390443563461304, 0.06222742795944214, 0.9049946665763855, 0.8086326122283936, 0.329481303691864, 0.5740917325019836, 0.8601771593093872, 0.19587385654449463, 5.571246147155762E-4, 0.1918622851371765, 0.722139298915863, 0.6600844860076904, 0.38527244329452515, 0.4808387756347656, 0.3439861536026001, 0.05732578f, 0.5512821078300476, 0.1748242974281311, 0.9600297808647156, 0.8880825638771057, 0.32976096868515015, 0.7874847054481506, 0.9623430967330933, 0.6769694089889526, 0.5408291220664978, 0.8079763054847717, 0.10350751876831055, 0.6474418044090271, 0.8680629134178162, 0.054068803787231445, 0.10415881872177124, 0.8393710851669312, 0.8657708764076233, 0.7266204953193665, 0.1751004457473755, 0.5480133891105652, 0.13014495372772217, 0.9472867846488953, 0.8597200512886047, 0.3013002872467041, 0.4238224f, 0.39196282625198364, 0.809512734413147, 0.1840112805366516, 0.3731704354286194, 0.3339831233024597, 0.4605896472930908, 0.8858898878097534, 0.6347107291221619, 0.46498775482177734, 0.05967498f, 0.44788986444473267, 0.2931298613548279, 0.20217031240463257, 0.4624347686767578, 0.9363738894462585, 0.865510880947113, 0.4560563f, 0.6038194298744202, 0.6472351551055908, 0.06761252880096436, 0.6138292551040649, 0.4188615679740906, 0.46671485900878906, 0.3866981863975525, 0.583486020565033, 0.31308305263519287, 0.557391f, 0.20567762851715088, 0.39081525802612305, 0.4749966263771057, 0.038813233375549316, 0.454895555973053, 0.974565863609314, 0.4604310989379883, 0.0630483627319336, 0.516134f, 0.38851475715637207, 0.5214715003967285, 0.9946260452270508, 0.8692699670791626, 0.6989038586616516, 0.20423167943954468, 0.9687852263450623, 0.022141337394714355, 0.021467208862304688, 0.2926299571990967, 0.17640334367752075, 0.8807583451271057, 0.6367034912109375, 0.363603f, 0.891550600528717, 0.4478935f, 0.17098796367645264, 0.06719112396240234, 0.6793853044509888, 0.6467815041542053, 0.8535059094429016, 0.9176908731460571, 0.8873451352119446, 0.9822514057159424, 0.726898193359375, 0.43526601791381836, 0.49868422746658325, 0.518829f, 0.9781343936920166, 0.1073271632194519, 0.6098587512969971, 0.3845386505126953, 0.7937867641448975, 0.9325405359268188, 0.15570902824401855, 0.3262762427330017, 0.0620197057723999, 0.49505484104156494, 0.3505825996398926, 0.1393196f, 0.026801645755767822, 0.21059894561767578, 0.51937335729599, 0.477020800113678, 0.5357824563980103, 0.8482968807220459, 0.2679207921028137, 0.28982776403427124, 0.6527870893478394, 0.8117792010307312, 0.07345986366271973, 0.13400155305862427, 0.17289233207702637, 0.25048571825027466, 0.47708654403686523, 0.7838162183761597, 0.47965264320373535, 0.5476133823394775, 0.8238973617553711, 0.9463911652565002, 0.4204208254814148, 0.41625577211380005, 0.4430721402168274};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = new double[]{0.6509518623352051, 0.6001829504966736, 0.9418213367462158, 0.8883392214775085, 0.8152283430099487, 0.06334799528121948, 0.7893455028533936, 0.2957436442375183, 0.0974772f, 0.5560645461082458, 0.19198966026306152, 0.5653152465820312, 0.9554839134216309, 0.9515798687934875, 0.6356391310691833, 0.2691159248352051, 0.6517156958580017, 0.443727970123291, 0.6284822821617126, 0.3413611650466919, 0.08002978563308716, 0.4377787709236145, 0.008822500705718994, 0.4561234712600708, 0.8230972290039062, 0.815673828125, 0.7047924399375916, 0.8619135618209839, 0.8757086396217346, 0.24930298328399658, 0.16241228580474854, 0.46570885181427, 0.3477322459220886, 0.25927072763442993, 0.14046108722686768, 0.3653895854949951, 0.06767582893371582, 0.7489985823631287, 0.7094589471817017, 0.3708098530769348, 0.9851651787757874, 0.2195839285850525, 0.9558491706848145, 0.4597555994987488, 0.2754145860671997, 0.9272816181182861, 0.5900136828422546, 0.5438328981399536, 0.003787994384765625, 0.9736146926879883, 0.7874667048454285, 0.40701937675476074, 0.5522999167442322, 0.011892378330230713, 0.6964854598045349, 0.590458869934082, 0.9464980363845825, 0.6603988409042358, 0.0532251f, 0.27346527576446533, 0.970314085483551, 0.2819016f, 0.8283076286315918, 0.6131352186203003, 0.003534555435180664, 0.9247344732284546, 0.24889302253723145, 0.4020833969116211, 0.8624935150146484, 0.5289914608001709, 0.4998688f, 0.4623655080795288, 0.3360298275947571, 0.04187941551208496, 0.9002005457878113, 0.6685270667076111, 0.3679124116897583, 0.6217305064201355, 0.009453952312469482, 0.46691662073135376, 0.9916637539863586, 0.3563784956932068, 0.46945f, 0.8930658102035522, 0.7374856472015381, 0.7975067496299744, 0.09197998046875, 0.3733195f, 0.632910966873169, 0.49025118350982666, 0.8211567997932434, 0.598383367061615, 0.4536006f, 0.631979f, 0.42459994554519653, 0.8705502152442932, 0.15872114896774292, 0.05409097671508789, 0.6881560683250427, 0.02670365571975708, 0.5925625562667847, 0.11735033988952637, 0.23178714513778687, 0.1275322437286377, 0.4420758f, 0.5291974544525146, 0.9477770328521729, 0.9596104025840759, 0.01606673002243042, 0.918465793132782, 0.2453020215034485, 0.22911196947097778, 0.828715443611145, 0.579683244228363, 0.4170989394187927, 0.4200577139854431, 0.9163848161697388, 0.6696772575378418, 0.31448155641555786, 0.2604156f, 0.7464327812194824, 0.3005669116973877, 0.3069683909416199, 0.7784543037414551, 0.9596824049949646, 0.125619f, 0.03358179330825806, 0.06000322103500366, 0.7596794962882996, 0.8111856579780579, 0.4363706111907959, 0.13333356380462646, 0.7728575468063354, 0.08547836542129517, 0.8554412722587585, 0.3389943838119507, 0.6708351373672485, 0.1628282070159912, 0.8019115924835205, 0.09200775623321533, 0.8015207052230835, 0.273043692111969, 0.2945243716239929, 0.9463475942611694, 0.8173391222953796, 0.7453126907348633, 0.12158304452896118, 0.23773455619812012, 0.6302096843719482, 0.7737562656402588, 0.9874401092529297, 0.549732506275177, 0.5429871082305908, 0.24930202960968018, 0.5276440978050232, 0.6373094916343689, 0.7006615400314331, 0.20518821477890015, 0.575324f, 0.896943f, 0.932046115398407, 0.7694701552391052, 0.6703704595565796, 0.7166280746459961, 0.98993980884552, 0.5288141965866089, 0.6000065803527832, 0.12455606460571289, 0.2864427f, 0.818203f, 0.1125832200050354, 0.7116471529006958, 0.6174411773681641, 0.2986392378807068, 0.8646838068962097, 0.28855007886886597, 0.4991317391395569, 0.8603385090827942, 0.04428505897521973, 0.6883051991462708, 0.5382832288742065, 0.18619072437286377, 0.9998411536216736, 0.405852735042572, 0.430853009223938, 0.4765207767486572, 0.02739572525024414, 0.817345142364502, 0.45030122995376587, 0.8215782642364502, 0.2964758276939392, 0.8162981867790222, 0.6328366994857788, 0.4160611033439636, 0.6924914717674255, 0.18861699104309082, 0.7928574085235596, 0.3467700481414795, 0.2211957f, 0.6012294292449951, 0.2746180295944214, 0.6097738742828369, 0.05261922f, 0.9543184638023376, 0.24789482355117798, 0.5899292230606079, 0.4115675687789917, 0.12799036502838135, 0.9339743852615356, 0.67907f, 0.37366747856140137, 0.001766502857208252, 0.4671422839164734, 0.4386003017425537, 0.3651232123374939, 0.5288100838661194, 0.9850998520851135, 0.5996655225753784, 0.346443235874176, 0.6736739277839661, 0.8441048264503479, 0.8147296905517578, 0.48172128200531006, 0.06808876991271973, 0.6814826130867004, 0.9565803408622742, 0.6425158977508545, 0.27753937244415283, 0.02545064687728882, 0.6359504461288452, 0.5965036153793335, 0.903853714466095, 0.6715529561042786, 0.661673903465271, 0.804054f, 0.25564026832580566, 0.5136308670043945, 0.285256564617157, 0.649472f, 0.7071608304977417, 0.60802161693573, 0.09578436613082886, 0.817295f, 0.9232532978057861, 0.1510462760925293, 0.4051371216773987, 0.6777509450912476, 0.967474639415741, 0.7159281969070435, 0.38460785150527954, 0.6499515771865845, 0.62510746717453, 0.4958018f, 0.2824367880821228, 0.8878914713859558, 0.5825689435005188, 0.6697731614112854, 0.9207761287689209, 0.4947731f, 0.008708596229553223, 0.10006445646286011, 0.6966527700424194, 0.16810965538024902, 0.5082461833953857, 0.896706223487854, 0.3041588068008423, 0.45464372634887695, 0.8680580854415894, 0.48426932096481323, 0.8670758008956909, 0.03414285182952881, 0.8261834383010864, 0.470597505569458, 0.588239f, 0.9290136098861694, 0.6724194884300232, 0.1638926863670349, 0.05312645435333252, 0.6674451231956482, 0.577468752861023, 0.09091740846633911, 0.09248077869415283, 0.01712364f, 0.46217024326324463, 0.4302392601966858, 0.4374336004257202, 0.4007336497306824, 0.10490113496780396, 0.25070488452911377, 0.06892591714859009, 0.84039705991745, 0.2674095034599304, 0.7126666903495789, 0.15264832973480225, 0.7334351539611816, 0.4488838315010071, 0.5895035862922668, 0.19582968950271606, 0.8045377135276794, 0.5848742723464966, 0.2568965554237366, 0.700680136680603, 0.7183724641799927, 0.5497499108314514, 0.5999972820281982, 0.21196478605270386, 0.47128593921661377, 0.7348502278327942, 0.5425385236740112, 0.5569890737533569, 0.3510686159133911, 0.6236149072647095, 0.31117886304855347, 0.0022922754287719727, 0.8904494643211365, 0.11214488744735718, 0.3326804041862488, 0.45276176929473877, 0.4143361f, 0.09936141967773438, 0.3062365651130676, 0.09901988506317139, 0.9547392725944519, 0.4438260793685913, 0.4993729591369629, 0.6842455863952637, 0.08335745334625244, 0.9311167001724243, 0.4499446153640747, 0.8716374635696411, 0.583105742931366, 0.1713084578514099, 0.801065981388092, 0.8112091422080994, 0.48025286197662354, 0.9335923194885254, 0.9981958866119385, 0.6453402042388916, 0.3126823902130127, 0.9855056405067444, 0.6015281081199646, 0.2754443883895874, 0.282168447971344, 0.02691412f, 0.34141606092453003, 0.60932f, 0.1851118803024292, 0.36114853620529175, 0.11450850963592529, 0.7954187989234924, 0.4332093596458435, 0.923076f, 0.4939503073692322, 0.6547263860702515, 0.6499386429786682, 0.6600009202957153, 0.13437724113464355, 0.8746336698532104, 0.9880804419517517, 0.8379119038581848, 0.5831156373023987, 0.21666818857192993, 0.5759215354919434, 0.002589583396911621, 0.370206f, 0.3989383578300476, 0.12408524751663208, 0.27048546075820923, 0.014462292194366455, 0.785447359085083, 0.36052918434143066, 0.6441958546638489, 0.43922704458236694, 0.0919953f, 0.3981744647026062, 0.7560562491416931, 0.6938904523849487, 0.9992873668670654, 0.558548092842102, 0.03324049711227417, 0.2953376770019531, 0.5482882261276245, 0.3970241f, 0.769289f, 0.6726195812225342, 0.13413798809051514, 0.412647008895874, 0.07882553339004517, 0.36928945779800415, 0.669508159160614, 0.030661165714263916, 0.6311297416687012, 0.847609f, 0.36570948362350464, 0.16190296411514282, 0.40907955169677734, 0.9794331789016724, 0.592849612236023, 0.8539454340934753, 0.35578012466430664, 0.8978803157806396, 0.3947087526321411, 0.028711915016174316, 0.563086748123169, 0.6353626847267151, 0.6186939477920532, 0.965254008769989, 0.8634610772132874, 0.4662940502166748, 0.8983208537101746, 0.3401680588722229, 0.1265612244606018, 0.7015297412872314, 0.22035086154937744, 0.22800451517105103, 0.8801617622375488, 0.7066829204559326, 0.7992992401123047, 0.3269115686416626, 0.795062f, 0.5138784050941467, 0.949977f, 0.7881925106048584, 0.1473301649093628, 0.707848310470581, 0.5285987854003906, 0.760607898235321, 0.22842729091644287, 0.44977283477783203, 0.942483127117157, 0.11990618705749512, 0.27246803045272827, 0.978775680065155, 0.2983056902885437, 0.7406362891197205, 0.3462374806404114, 0.6399704217910767, 0.7631886601448059, 0.12082290649414062, 0.6658508777618408, 0.1335276961326599, 0.898688554763794, 0.6212282776832581, 0.40650224685668945, 0.9811173677444458, 0.5451768636703491, 0.1009787917137146, 0.5291028022766113, 0.14962393045425415, 0.6865153908729553, 0.28221285343170166, 0.8083963394165039, 0.8582217693328857, 0.7187486290931702, 0.8606424927711487, 0.7881113290786743, 0.09032028913497925, 0.2413521409034729, 0.6896867752075195, 0.06475496292114258, 0.518784761428833, 0.14807015657424927, 0.43691498041152954, 0.19577765464782715, 0.9790491461753845, 0.6323774456977844, 0.9673440456390381, 0.801169216632843, 0.3537466f, 0.1590527892112732, 0.5137127637863159, 0.5693542957305908, 0.5933859348297119, 0.36031973361968994, 0.004862606525421143, 0.955907940864563, 0.435133159160614, 0.7676998376846313, 0.9360849261283875, 0.2726297378540039, 0.306257963180542, 0.8174425959587097, 0.966659665107727, 0.578522264957428, 0.536262f, 0.3996008634567261, 0.2473495602607727, 0.6049784421920776, 0.743712842464447, 0.5430749654769897, 0.9324910640716553, 0.7548747658729553, 0.5175958871841431, 0.5289477109909058, 0.6763286590576172, 0.7173013687133789, 0.9514160752296448, 0.6430023312568665, 0.30078601837158203, 0.2224648f, 0.3998076319694519, 0.9593936800956726, 0.5419943332672119, 0.03914106f, 0.9661482572555542, 0.4881061911582947, 0.5162690877914429, 0.1823078989982605, 0.6653456091880798, 0.9192715883255005, 0.6141336560249329, 0.9717618823051453, 0.17392438650131226, 0.2109592f, 0.14533954858779907, 0.6622569561004639, 0.3307681679725647, 0.7501312494277954, 0.5711742639541626, 0.7787448763847351, 0.6029587984085083, 0.5786534547805786, 0.31583845615386963, 0.5415372252464294, 0.11433917284011841, 0.7302539348602295, 0.3301040530204773, 0.18865394592285156, 0.34755223989486694, 0.5359593629837036, 0.06225097179412842, 0.007399857044219971, 0.5868551135063171, 0.4937441945075989, 0.6884572505950928, 0.21358853578567505, 0.6480762958526611, 0.0849841833114624, 0.17305272817611694, 0.7821810841560364, 0.5384006500244141, 0.5809981822967529, 0.4146272540092468, 0.08294445276260376, 0.7625856995582581, 0.1958183f, 0.7238262295722961, 0.9326876997947693, 0.9197047352790833, 0.8877883553504944, 0.650307f, 0.9934638142585754, 0.6571868062019348, 0.12722742557525635, 0.5979337692260742, 0.4537109136581421, 0.6239981055259705, 0.167904794216156, 0.24764496088027954, 0.5846623182296753, 0.7151456475257874, 0.8772715926170349, 0.9459506869316101, 0.10360527038574219, 0.06374752521514893, 0.2882344722747803, 0.45374614000320435, 0.6629791259765625, 0.11881732940673828, 0.4807983636856079, 0.7157248854637146, 0.162250816822052, 0.96637f, 0.6353575587272644, 0.1764342188835144, 0.7185037732124329, 0.2938326597213745, 0.5240815281867981, 0.09684258699417114, 0.88034987449646, 0.06400609016418457, 0.9291844964027405, 0.9177321195602417, 0.20489156246185303, 0.821577787399292, 0.5564447641372681, 0.9664462804794312, 0.3938930630683899, 0.3846585154533386, 0.7118523120880127, 0.3453051447868347, 0.3860864043235779, 0.5238550305366516, 0.04453068971633911, 0.19776177406311035, 0.788760781288147, 0.6654777526855469, 0.9490451812744141, 0.38715285062789917, 0.7927289009094238, 0.002714097499847412, 0.13694608211517334, 0.9983588457107544, 0.8178111910820007, 0.0037052035331726074, 0.506098210811615, 0.6811210513114929, 0.9766339063644409, 0.7787955403327942, 0.7853343486785889, 0.2820806f, 0.4964361786842346, 0.2367574f, 0.7426900863647461, 0.1883484125137329, 0.3034816384315491, 0.313128f, 0.7024965286254883, 0.4467436f, 0.4324516f, 0.7001655101776123, 0.10762393474578857, 0.788548f, 0.9818714261054993, 0.6201741695404053, 0.22900241613388062, 0.8291229009628296, 0.28231966495513916, 0.9505575299263, 0.4091425f, 0.7150647640228271, 0.3911478519439697, 0.8840211033821106, 0.4268037676811218, 0.5394015312194824, 0.16808485984802246, 0.7605984807014465, 0.386419f, 0.7589393258094788, 0.04091453552246094, 0.47496187686920166, 0.6216822266578674, 0.33917683362960815, 0.23803704977035522, 0.19378167390823364, 0.3143085241317749, 0.27374571561813354, 0.1719107f, 0.030318081378936768, 0.175933837890625, 0.7202814221382141, 0.8089985847473145, 0.8491876721382141, 0.6361427307128906, 0.146761953830719, 0.090931236743927, 0.8112027645111084, 0.4885137677192688, 0.3660890460014343, 0.689265f, 0.429807186126709, 0.03829377889633179, 0.06706976890563965, 0.821731f, 0.37602657079696655, 0.09193408489227295, 0.7326413989067078, 0.3486119508743286, 0.6327495574951172, 0.9554303884506226, 0.6174699068069458, 0.549359917640686, 0.721900224685669, 0.24352818727493286, 0.5738447904586792, 0.5754125714302063, 0.9856335520744324, 0.2268328070640564, 0.944637656211853, 0.6371352672576904, 0.4366886019706726, 0.5932654738426208, 0.8531497716903687, 0.14079463481903076, 0.6606864929199219, 0.5118296146392822, 0.020732641220092773, 0.7034631371498108, 0.077323317527771, 0.35112106800079346, 0.6335417628288269, 0.775897f, 0.48655277490615845, 0.1163646f, 0.799717f, 0.3599809408187866, 0.9440813064575195, 0.8740744590759277, 0.218333f, 0.46067f, 0.34753865003585815, 0.082896888256073, 0.8929227590560913, 0.732999324798584, 0.6558902859687805, 0.7461317181587219, 0.02716296911239624, 0.6212952136993408, 0.9109984636306763, 0.7522832751274109, 0.7409507632255554, 0.8169798851013184, 0.44832175970077515, 0.23433732986450195, 0.4347752332687378, 0.33818477392196655, 0.1557931900024414, 0.5189862251281738, 0.642771f, 0.041793644428253174, 0.9137844443321228, 0.46955955028533936, 0.07455533742904663, 0.07765161991119385, 0.48822838068008423, 0.16989731788635254, 0.4179343581199646, 0.1747615933418274, 0.98253333568573, 0.8229067325592041, 0.9144772291183472, 0.7777257561683655, 0.32660573720932007, 0.02226078510284424, 0.9240933656692505, 0.8239884972572327, 0.3034595251083374, 0.726949f, 0.7500197887420654, 0.3422242999076843, 0.9114989042282104, 0.05762660503387451, 0.12957f, 0.3612566590309143, 0.8252291679382324, 0.6254926919937134, 0.6267796754837036, 0.7270654439926147, 0.7560907006263733, 0.3864591121673584, 0.949497640132904, 0.04075592756271362, 0.3011903762817383, 0.826474f, 0.10491985082626343, 0.8389502763748169, 0.5893853902816772, 0.6719704866409302, 0.5941017270088196, 0.4541831612586975, 0.645569f, 0.7796084880828857, 0.20825815200805664, 0.4089175f, 0.8648365139961243, 0.5919468402862549, 0.7489750385284424, 0.23325252532958984, 0.5538254380226135, 0.7037538886070251, 0.3627141f, 0.8519112467765808, 0.9079065322875977, 0.023776113986968994, 0.5097401738166809, 0.08741557598114014, 0.5666462779045105, 0.5485138297080994, 0.621995210647583, 0.8783828616142273, 0.558302640914917, 0.40058547258377075, 0.6272834539413452, 0.847598135471344, 0.8048967719078064, 0.9904307126998901, 0.0028197765350341797, 0.2850811f, 0.7261077165603638, 0.60534f, 0.2847808599472046, 0.1760185956954956, 0.9319604635238647, 0.536185085773468, 0.8076362013816833, 0.919569f, 0.6257537603378296, 0.844948947429657, 0.3240280747413635, 0.99766f, 0.5102447271347046, 0.8335408568382263, 0.3997125029563904, 0.28663647174835205, 0.5777603983879089, 0.17787307500839233, 0.5661239624023438, 0.5107266902923584, 0.8102326393127441, 0.9753450751304626, 0.013635218143463135, 0.6446623206138611, 0.1753881573677063, 0.7564199566841125, 0.6303467154502869, 0.8414230942726135, 0.3033126f, 0.9227107167243958, 0.8336695432662964, 0.7261113524436951, 0.30183327198028564, 0.388860821723938, 0.445101261138916, 0.02265077829360962, 0.5237188935279846, 0.17058312892913818, 0.7530971169471741, 0.4087350368499756, 0.9533158540725708, 0.7266969680786133, 0.4661046266555786, 0.9967281818389893, 0.7202683091163635, 0.43220871686935425, 0.9395624399185181, 0.7626773118972778, 0.07439172267913818, 0.2388496994972229, 0.46951591968536377, 0.768993079662323, 0.7351787090301514, 0.4285966753959656, 0.5746219158172607, 0.9035692811012268, 0.6440433263778687, 0.14724266529083252, 0.6715062260627747, 0.6721590757369995, 0.8451085090637207, 0.8348842859268188, 0.9101046919822693, 0.9928306937217712, 0.06458187103271484, 0.6671907901763916, 0.8408026099205017, 0.9405515789985657, 0.8786545991897583, 0.05758553743362427, 0.08955782651901245, 0.543777346611023, 0.5001208186149597, 0.22120589017868042, 0.01702982187271118, 0.43885964155197144, 0.7849025130271912, 0.7950255870819092, 0.019961953163146973, 0.915767252445221, 0.18735498189926147, 0.7762728929519653, 0.4252128601074219, 0.44179534912109375, 0.9692186713218689, 0.2678305506706238, 0.9470696449279785, 0.5085013508796692, 0.898608386516571, 0.09234827756881714, 0.18559062480926514, 0.8190624713897705, 0.1353311f, 0.5971665382385254, 0.2871297001838684, 0.70472651720047, 0.6755892038345337, 0.4637749195098877, 0.457933f, 0.8442917466163635, 0.0768430233001709, 0.05548733472824097, 0.6984278559684753, 0.05197256803512573, 0.6720170974731445, 0.4855055809020996, 0.730839729309082, 0.11711013317108154, 0.8466771245002747, 0.817875325679779, 0.3379855751991272, 0.522586464881897, 0.4442646f, 0.4824697971343994, 0.06904041767120361, 0.7642671465873718, 0.9995496869087219, 0.4016267f, 0.7419252991676331, 0.9462114572525024, 0.31138163805007935, 0.5031169652938843, 0.2655041217803955, 0.16875064373016357, 0.15042412281036377, 0.19755452871322632, 0.7924220561981201, 0.8699896931648254, 0.46934711933135986, 0.1971113085746765, 0.010204017162322998, 0.965082049369812, 0.920996904373169, 0.36855292320251465, 0.7898276448249817, 0.1691509485244751, 0.38912034034729004, 0.4723517894744873, 0.3836747407913208, 0.9344876408576965, 0.4566189646720886, 0.919285237789154, 0.7354661226272583, 0.7042832374572754, 0.6540389060974121, 0.5579339265823364, 0.2110360860824585, 0.7354021072387695, 0.0876573920249939, 0.9254310727119446, 0.5487639307975769, 0.20146238803863525, 0.7993392944335938, 0.9873659610748291, 0.07094836235046387, 0.11276721954345703, 0.382155f, 0.7517454028129578, 0.09179210662841797, 0.31755197048187256, 0.9050500988960266, 0.060298383235931396, 0.04400122f, 0.34384608268737793, 0.7907451391220093, 0.5852546691894531, 0.554962694644928, 0.5453669428825378, 0.6632364392280579, 0.541219f, 0.6063298583030701, 0.1987825632095337, 0.3201319f, 0.7632346153259277, 0.969533383846283, 0.21202754974365234, 0.39154934883117676, 0.7100131511688232, 0.4267882f, 0.6208920478820801, 0.1880474090576172, 0.1851849f, 0.3557415008544922, 0.3287127614021301, 0.9972618818283081, 0.3919827342033386, 0.20980077981948853, 0.6646774411201477, 0.21044832468032837, 0.5638357996940613, 0.2898000478744507, 0.4611546993255615, 0.2094482183456421, 0.26386332511901855, 0.14105188846588135, 0.9688236713409424, 0.7508171796798706, 0.39229273796081543, 0.4786541f, 0.10759997367858887, 0.49169105291366577, 0.557573676109314, 0.9394609332084656, 0.1869295835494995, 0.4217836260795593, 0.2827451825141907, 0.2683084011077881, 0.2945946455001831, 0.9236767888069153, 0.26487863063812256, 0.9964311718940735, 0.3504962921142578, 0.3708835244178772, 0.7667350769042969, 0.8797033429145813, 0.2308337688446045, 0.9972664713859558, 0.08383917808532715, 0.5921488404273987, 0.0966958999633789, 0.9051253795623779, 0.7378026843070984, 0.5655280947685242, 0.895448625087738, 0.7111059427261353, 0.6418713331222534, 0.7187482714653015, 0.05770617723464966, 0.4131346344947815, 0.4643961191177368, 0.8120251297950745, 0.3794877529144287, 0.5675649642944336, 0.9804295897483826, 0.611447274684906, 0.4789001941680908, 0.028997957706451416, 0.5042521953582764, 0.1717543601989746, 0.647981f, 0.07677322626113892, 0.8927751779556274, 0.6912973523139954, 0.3099422f, 0.2485317f, 0.9110255837440491, 0.3064492344856262, 0.14485788345336914, 0.15474563837051392, 0.4689871668815613, 0.2569807171821594, 0.5958446264266968, 0.7565497159957886, 0.839765191078186, 0.34350985288619995, 0.324125f, 0.3660675883293152, 0.12131696939468384, 0.9281271696090698, 0.9843025803565979, 0.05280798673629761, 0.029904663562774658, 0.7053446173667908, 0.7580896615982056, 0.3063361f, 0.4381835460662842, 0.5389102697372437, 0.5611268877983093, 0.07465380430221558, 0.6727569699287415, 0.15768396854400635, 0.9470506906509399, 0.5455305576324463, 0.4465523958206177, 0.9082247614860535, 0.02735722064971924, 0.9060105681419373, 0.8550707101821899, 0.9411542415618896, 0.3347579836845398, 0.46071213483810425, 0.250135600566864, 0.6715324521064758, 0.4396429657936096, 0.8351794481277466, 0.11102801561355591, 0.4998151659965515, 0.3200779f, 0.9749287366867065, 0.5547958612442017, 0.14950627088546753, 0.3497371f, 0.4780406355857849, 0.6121329665184021, 0.5010260343551636, 0.2476823925971985, 0.6889275312423706, 0.29273325204849243, 0.04988861083984375, 0.19945847988128662, 0.4185903072357178, 0.1777610182762146, 0.5529223084449768, 0.4592137336730957, 0.1432551145553589, 0.4134777784347534, 0.6515211462974548, 0.2542320489883423, 0.8353482484817505, 0.598708987236023, 0.26894646883010864, 0.4912583827972412, 0.9805504679679871, 0.9224080443382263, 0.003290712833404541, 0.1913282871246338, 0.8800251483917236, 0.7319055795669556, 0.10329186916351318, 0.41759783029556274, 0.5913141965866089, 0.4164583683013916, 0.585776150226593, 0.6981778740882874, 0.15393853187561035, 0.4465147852897644, 0.6867828369140625, 0.15058594942092896, 0.421162f, 0.6918757557868958, 0.8296695947647095, 0.08164674043655396, 0.488018274307251, 0.7799808382987976, 0.22962677478790283, 0.24013495445251465, 0.49354857206344604, 0.4803307056427002, 0.8625845909118652, 0.9409147500991821, 0.3738449811935425, 0.5971384644508362, 0.925640344619751, 0.3386768102645874, 0.8591740727424622, 0.007382512092590332, 0.8646526336669922, 0.4146087169647217, 0.8160147070884705, 0.6363281607627869, 0.19196337461471558, 0.03659677505493164, 0.6217617988586426, 0.8612439632415771, 0.4533488154411316, 0.377097f, 0.08022618293762207, 0.07352942228317261, 0.008940458297729492, 0.21502149105072021, 0.9096221327781677, 0.6099874377250671, 0.5892764925956726, 0.2293641f, 0.7968376874923706, 0.6388444304466248, 0.5867627263069153, 0.4114747f, 0.6633950471878052, 0.7117774486541748, 0.5971797704696655, 0.6066367626190186, 0.14624255895614624, 0.8792338967323303, 0.07862681150436401, 0.9487976431846619, 0.3925892114639282, 0.5254116058349609, 0.03024125099182129, 0.4079458f, 0.4002636671066284, 0.377228319644928, 0.08458256721496582, 0.7388638854026794, 0.1170128583908081, 0.6473973393440247, 0.27076244354248047, 0.042061805725097656, 0.9228689670562744, 0.6074087023735046, 0.24590444564819336, 0.7400003671646118, 0.5539177656173706, 0.37698525190353394, 0.9566125869750977, 0.6797528266906738, 0.8438616394996643, 0.640768826007843, 0.31673574447631836, 0.02066051959991455, 0.2376546859741211, 0.8420276641845703, 0.5503710508346558, 0.6040694713592529, 0.010799705982208252, 0.09164392948150635, 0.7179193496704102, 0.2617766261100769, 0.6658649444580078, 0.20622462034225464, 0.62687748670578, 0.45837002992630005, 0.4972526431083679, 0.5427096486091614, 0.7273421287536621, 0.3163532018661499, 0.7547086477279663, 0.4222654104232788, 0.7449423670768738, 0.30605727434158325, 0.899601936340332, 0.18062567710876465, 0.14178425073623657, 0.1372441053390503, 0.8553586006164551, 0.19556903839111328, 0.09026098251342773, 0.9365053176879883, 0.889946460723877, 0.5282188653945923, 0.4571796655654907, 0.9826900959014893, 0.3349630832672119, 0.1797724962234497, 0.4291115403175354, 0.778412401676178, 0.009273886680603027, 0.9686708450317383, 0.3573563f, 0.3140764832496643, 0.2575091f, 0.9378103613853455, 0.29620832204818726, 0.1148260235786438, 0.4829104542732239, 0.22299593687057495, 0.5757408738136292, 0.2115022f, 0.013493120670318604, 0.8713755011558533, 0.7551183104515076, 0.03334003686904907, 0.9193642735481262, 0.06416434049606323, 1.742839813232422E-4, 0.45013582706451416, 0.8420339226722717, 0.14674526453018188, 0.5159410834312439, 0.6904754638671875, 0.11402815580368042, 0.3295474052429199, 0.2279013991355896, 0.6039655208587646, 0.06503736972808838, 0.6264032125473022, 0.6724885106086731, 0.02101290225982666, 0.8208089470863342, 0.7279306650161743, 0.645959734916687, 0.6734339594841003, 0.5102511048316956, 0.9535817503929138, 0.8299912214279175, 0.981050431728363, 0.2776033282279968, 0.02816188335418701, 0.5116065740585327, 0.7695814967155457, 0.03852212429046631, 0.23079532384872437, 0.9343979358673096, 0.777823f, 0.4756407141685486, 0.9635705947875977, 0.4380902647972107, 0.3297031f, 0.3102979063987732, 0.1836319f, 0.6856211423873901, 0.3098219633102417, 0.648065f, 0.5896165370941162, 0.15298187732696533, 0.18815869092941284, 0.9273883104324341, 0.307511568069458, 0.01962477f, 0.2175162434577942, 0.21972954273223877, 0.891794741153717, 0.3894498944282532, 0.5808582305908203, 0.8682305216789246, 0.2578209638595581, 0.7780348062515259, 0.5279797911643982, 0.5080310702323914, 0.15664517879486084, 0.2952747941017151, 0.8230759501457214, 0.6983784437179565, 0.6627737283706665, 0.3489963412284851, 0.8659919500350952, 0.7937084436416626, 0.9907846450805664, 0.8000626564025879, 0.9676315784454346, 0.3826617f, 0.6135448217391968, 0.7592869400978088, 0.5996818542480469, 0.9908860921859741, 0.9012002944946289, 0.968032717704773, 0.2241082787513733, 0.6514387130737305, 0.3176712989807129, 0.42523694038391113, 0.09054797887802124, 0.037241578102111816, 0.034612953662872314, 0.4819169044494629, 0.29966044425964355, 0.7805919647216797, 0.7894067168235779, 0.5287958383560181, 0.42569053173065186, 0.2980288863182068, 0.014539599418640137, 0.05292421579360962, 0.10809731483459473, 0.3333935f, 0.9946624636650085, 0.7751224637031555, 0.624353f, 0.7317911386489868, 0.8117544054985046, 0.7323853969573975, 0.4863104224205017, 0.8820912837982178, 0.5683649182319641, 0.10936683416366577, 0.3313762f, 0.3009471893310547, 0.23716843128204346, 0.812609851360321, 0.6557472944259644, 0.9780479669570923, 0.07850086688995361, 0.8228491544723511, 0.4369269013404846, 0.12703877687454224, 0.9557176232337952, 0.24764782190322876, 0.1715143322944641, 0.6714864373207092, 0.8238219022750854, 0.362632155418396, 0.8948699235916138, 0.1882755160331726, 0.8856696486473083, 0.29906803369522095, 0.012827396392822266, 0.6953750848770142, 0.3211202025413513, 0.0735209f, 0.2514111399650574, 0.9361183643341064, 0.4698304533958435, 0.417522f, 0.28590863943099976, 0.02271193265914917, 0.963187f, 0.047813236713409424, 0.04114645719528198, 0.06799149513244629, 0.583451509475708, 0.2077831f, 0.734062671661377, 0.8824433088302612, 0.8100074529647827, 0.23566365242004395, 0.25940942764282227, 0.8348157405853271, 0.7782089114189148, 0.6931102871894836, 0.8795484304428101, 0.4764787554740906, 0.11344313621520996, 0.9777124524116516, 0.5778182148933411, 0.6849080324172974, 0.1524459719657898, 0.9942015409469604, 0.1579933762550354, 0.5787414312362671, 0.9695965051651001, 0.16167068481445312, 0.8341805934906006, 0.749891996383667, 0.3849417567253113, 0.9686667919158936, 0.8484825491905212, 0.916918933391571, 0.4432496428489685, 0.27583998441696167, 0.5984224677085876, 0.6636173129081726, 0.3727871775627136, 0.3188619613647461, 0.9510856866836548, 0.7385565638542175, 0.6152122616767883, 0.7350873351097107, 0.2929650545120239, 0.4716869592666626, 0.47352153062820435, 0.16909247636795044, 0.4184693f, 0.24536120891571045, 0.2661113142967224, 0.9885817766189575, 0.4289819598197937, 0.937042236328125, 0.5675026774406433, 0.13760638236999512, 0.3093735f, 0.6430613994598389, 0.3290981650352478, 0.0836398f, 0.009225606918334961, 0.37615811824798584, 0.028553307056427002, 0.48446333408355713, 0.4991150498390198, 0.3988942f, 0.8191463947296143, 0.5563161373138428, 0.0436213f, 0.2707523f, 0.21924781799316406, 0.0032776594161987305, 0.555913507938385, 0.9247677326202393, 0.6780568957328796, 0.7469146847724915, 0.42558372020721436, 0.2915125f, 0.31177276372909546, 0.9429993033409119, 0.2717161178588867, 0.31137365102767944, 0.8619832992553711, 0.8973833322525024, 0.12501901388168335, 0.043199896812438965, 0.0761151909828186, 0.3953104615211487, 0.1223346f, 0.9270011186599731, 0.04223615f, 0.6775963306427002, 0.7682334780693054, 0.7945861220359802, 0.7744043469429016, 0.2638785243034363, 0.6240856051445007, 0.66452956199646, 0.4903183f, 0.10881620645523071, 0.1954779028892517, 0.6920332312583923, 0.4535495f, 0.14362138509750366, 0.15276235342025757, 0.3710547089576721, 0.0745911f, 0.2051667f, 0.5136134028434753, 0.4721294641494751, 0.7378913164138794, 0.1813046932220459, 0.2956463694572449, 0.5268296599388123, 0.8086650371551514, 0.03773683309555054, 0.49439412355422974, 0.486642f, 0.6894001364707947, 0.26320451498031616, 0.21840083599090576, 0.5536767244338989, 0.06055384874343872, 0.34097564220428467, 0.908118f, 0.9321529269218445, 0.42502832412719727, 0.681233f, 0.8460714817047119, 0.2277559f, 0.3568272590637207, 0.22732621431350708, 0.5279063582420349, 0.5370925664901733, 0.9591419100761414, 0.7658390998840332, 0.8810517191886902, 0.5475491881370544, 0.6974419355392456, 0.053586483001708984, 0.09162986278533936, 0.6004900932312012, 0.17352807521820068, 0.8421604037284851, 0.8107529282569885, 0.06514900922775269, 0.43462586402893066, 0.9912728667259216, 0.4665064215660095, 0.1996082067489624, 0.9082955718040466, 0.2653149366378784, 0.09385329484939575, 0.12741339206695557, 0.06313693523406982, 0.39330393075942993, 0.625654399394989, 0.5877345204353333, 0.9140537977218628, 0.2213881015777588, 0.6563807129859924, 0.693279f, 0.7194114327430725, 0.620606541633606, 0.8163928389549255, 0.2887510657310486, 0.8090795278549194, 0.44258224964141846, 0.6775196194648743, 0.39449864625930786, 0.7935639023780823, 0.5947905778884888, 0.476837158203125, 0.16170597076416016, 0.24474751949310303, 0.9781606197357178, 0.3999125361442566, 0.2892964f, 0.8208940625190735, 0.976823627948761, 0.04034775495529175, 0.7564624547958374, 0.1983233094215393, 0.6872324347496033, 0.36036133766174316, 0.321910560131073, 0.738504f, 0.5366777777671814, 0.756646f, 0.6106030344963074, 0.684286892414093, 0.17508888244628906, 0.004216015338897705, 0.8457212448120117, 0.667821f, 0.9752103090286255, 0.05391967296600342, 0.7481165528297424, 0.2036747932434082, 0.4817148447036743, 0.12036973237991333, 0.6936349272727966, 0.6152702569961548, 0.18707728385925293, 0.7679993510246277, 0.5319981575012207, 0.9355006217956543, 0.9492633938789368, 0.9136648774147034, 0.18662631511688232, 0.8710337281227112, 0.71226966381073, 0.7726922631263733, 0.19574517011642456, 0.01513201f, 0.3446975350379944, 0.8176447749137878, 0.15981358289718628, 0.4297788739204407, 0.9139003753662109, 0.15962117910385132, 0.8328304886817932, 0.24157452583312988, 0.4944632649421692, 0.3429695963859558, 0.5551697015762329, 0.45743584632873535, 0.2411588430404663, 0.13642078638076782, 0.3585890531539917, 0.20893120765686035, 0.3999766707420349, 0.3554489016532898, 0.3809487819671631, 0.684546172618866, 0.7888901829719543, 0.23890411853790283, 0.975554347038269, 0.1668790578842163, 0.045867919921875, 0.1825239658355713, 0.8701344728469849, 0.6194026470184326, 0.24904322624206543, 0.28581762313842773, 0.9711315631866455, 0.8808215856552124, 0.8873419165611267, 0.8581674098968506, 0.4836914539337158, 0.643143892288208, 0.2642735242843628, 0.744062602519989, 0.255598247051239, 0.3844495415687561, 0.3086775541305542, 0.6335499286651611, 0.9991304278373718, 0.3741641044616699, 0.1402728f, 0.817768f, 0.908772349357605, 0.795759f, 0.1818031668663025, 0.6044567823410034, 0.30087095499038696, 0.17064237594604492, 0.8509389162063599, 0.6263566017150879, 0.14529138803482056, 0.3021506667137146, 0.022048115730285645, 0.9363197684288025, 0.6461151242256165, 0.2776918411254883, 0.2792876958847046, 0.2947568893432617, 0.5312958359718323, 0.011049091815948486, 0.1375860571861267, 0.7038622498512268, 0.11842083930969238, 0.919574499130249, 0.6770463585853577, 0.6431670784950256, 0.9894134998321533, 0.6095563769340515, 0.5997482538223267, 0.8047392964363098, 0.7008893489837646, 0.5876222252845764, 0.3971594572067261, 0.43428903818130493, 0.1142914891242981, 0.6799712777137756, 0.8233009576797485, 0.7551860809326172, 0.9018590450286865, 0.8809505105018616, 0.05597573518753052, 0.812705397605896, 0.5875247716903687, 0.07757604122161865, 0.03894263505935669, 0.4305715560913086, 0.14822477102279663, 0.519745945930481, 0.41567307710647583, 0.6540822386741638, 0.028682172298431396, 0.9929153919219971, 0.9646932482719421, 0.9748871922492981, 0.22497636079788208, 0.5698552131652832, 0.4425198435783386, 0.031136631965637207, 0.4482314f, 0.1928587555885315, 0.5385101437568665, 0.17058277130126953, 0.8842786550521851, 0.4925960302352905, 0.19285714626312256, 0.8988166451454163, 0.5785166025161743, 0.4630613327026367, 0.6613800525665283, 0.5337942838668823, 0.373391330242157, 0.3651595711708069, 0.406228244304657, 0.40289926528930664, 0.7505438923835754, 0.4590064287185669, 0.5183008909225464, 0.2798925042152405, 0.037952303886413574, 0.5046651363372803, 0.9438681602478027, 0.92421954870224, 0.6571817994117737, 0.013633668422698975, 0.1939799189567566, 0.09041261672973633, 0.345627f, 0.7728765606880188, 0.500808f, 0.08500128984451294, 0.29748356342315674, 0.44662773609161377, 0.9807404279708862, 0.3048082f, 0.6448502540588379, 0.038783252239227295, 0.3411346673965454, 0.4642687439918518, 0.632193f, 0.573762059211731, 0.9880422353744507, 0.7591068148612976, 0.7243659496307373, 0.6326938271522522, 0.15848851203918457, 0.6960753798484802, 0.9970938563346863, 0.9242628812789917, 0.4061855673789978, 0.9984256625175476, 0.7714950442314148, 0.1381879448890686, 0.54766845703125, 0.957294225692749, 0.11871588230133057, 0.13997882604599, 0.0511818528175354, 0.001439929f, 0.640539288520813, 0.5372136831283569, 0.988254964351654, 0.5909727215766907, 0.6560129523277283, 0.6522118449211121, 0.6234394311904907, 0.8722777962684631, 0.43745505809783936, 0.548816978931427, 0.6874479055404663, 0.7567602396011353, 0.5519779324531555, 0.5103853940963745, 0.44982558488845825, 0.17895102500915527, 0.30290722846984863, 0.9834316968917847, 0.10685855150222778, 0.5516785383224487, 0.12076324224472046, 0.6712965369224548, 0.34683114290237427, 0.7473106384277344, 0.9330411553382874, 0.07235598564147949, 0.5067808628082275, 0.0025087f, 0.7187255024909973, 0.14851796627044678, 0.641977f, 0.7556514143943787, 0.815785825252533, 0.025985777378082275, 0.381508469581604, 0.6953291296958923, 0.05191493034362793, 0.16858798265457153, 0.3212670683860779, 0.9174706935882568, 0.38022834062576294, 0.524571f, 0.2305523157119751, 0.5782455205917358, 0.657882571220398, 0.8839442729949951, 0.7324052453041077, 0.38852185010910034, 0.25757747888565063, 0.4517058730125427, 0.713152f, 0.6501120924949646, 0.8662785887718201, 0.2521305f, 0.2666589021682739, 0.7891821265220642, 0.6344586610794067, 0.9434590935707092, 0.8672640919685364, 0.8310505747795105, 0.5905670523643494, 0.40662264823913574, 0.9666645526885986, 0.3942912817001343, 0.24276083707809448, 0.744996964931488, 0.7392497658729553, 0.299831748008728, 0.6322846412658691, 0.21669363975524902, 0.06313616037368774, 0.10999709367752075, 0.8749819397926331, 0.9417456388473511, 0.4667717218399048, 0.9786928296089172, 0.7896214723587036, 0.7620546817779541, 0.03035062551498413, 0.3307785391807556, 0.43999582529067993, 0.36358505487442017, 0.5849515795707703, 0.6479195356369019, 0.9537044167518616, 0.13258272409439087, 0.86844801902771, 0.1496993899345398, 0.48139017820358276, 0.3482624292373657, 0.08462584018707275, 0.3805323839187622, 0.5488142967224121, 0.30426204204559326, 0.9699999094009399, 0.6810781955718994, 0.7690017223358154, 0.09415864944458008, 0.5415793657302856, 0.6016722321510315, 0.1268704f, 0.8395405411720276, 0.10896158218383789, 0.447143018245697, 0.04400211572647095, 0.532735288143158, 0.45692336559295654, 0.09778940677642822, 0.6618673801422119, 0.8136199116706848, 0.8020385503768921, 0.8788723945617676, 0.24886244535446167, 0.5074364542961121, 0.8013237118721008, 0.7274978160858154, 0.10655045509338379, 0.6777698993682861, 0.535662829875946, 0.986107f, 0.6057541370391846, 0.058514297008514404, 0.639575719833374, 0.4189627766609192, 0.07146686315536499, 0.7365771532058716, 0.12618637084960938, 0.1631487011909485, 0.7204168438911438, 0.7821925282478333, 0.6270595788955688, 0.27795135974884033, 0.06563377380371094, 0.5381093621253967, 0.7865657210350037, 0.9134471416473389, 0.4832538366317749, 0.5577770471572876, 0.11589920520782471, 0.27617818117141724, 0.5984127521514893, 0.754295289516449, 0.3097231984138489, 6.064176559448242E-4, 0.9153896570205688, 0.41777002811431885, 0.5861884951591492, 0.04134148359298706, 0.583784f, 0.06339305639266968, 0.14693677425384521, 0.1628270149230957, 0.2646523714065552, 0.9737357497215271, 0.12643492221832275, 0.7282484173774719, 0.9110643863677979, 0.1372368335723877, 0.059022724628448486, 0.06403207778930664, 0.5949193835258484, 0.6046154499053955, 0.7274125814437866, 0.8146890997886658, 0.7502153515815735, 0.08302569389343262, 0.4487403631210327, 0.5973082184791565, 0.8319917321205139, 0.5643808245658875, 0.22490352392196655, 0.9362254738807678, 0.1452372f, 0.5927348732948303, 0.4447614f, 0.0049253106117248535, 0.7301391959190369, 0.272363543510437, 0.8293466567993164, 0.5508188009262085, 0.7157495021820068, 0.6128042340278625, 0.3007119297981262, 0.5340821146965027, 0.5056837797164917, 0.3122907876968384, 0.3142017126083374, 0.30722755193710327, 0.8347075581550598, 0.5625746846199036, 0.6972071528434753, 0.5086565613746643, 0.9474677443504333, 0.08500528335571289, 0.0998755693435669, 0.4803658723831177, 0.4793073534965515, 0.0020174384117126465, 0.09046459197998047, 0.764624f, 0.6587765216827393, 0.6350404024124146, 0.6663464903831482, 0.7323201894760132, 0.0624817f, 0.1776188f, 0.3379952311515808, 0.3704376816749573, 0.7112653851509094, 0.9026691317558289, 0.955161988735199, 0.7594781517982483, 0.943994f, 0.05985433f, 0.4500355124473572, 0.4335503f, 0.3986643f, 0.5407384037971497, 0.6802733540534973, 0.09423476457595825, 0.99298495054245, 0.326507031917572, 0.4647974967956543, 0.5803866982460022, 0.9665122032165527, 0.4795478582382202, 0.7572115063667297, 0.4439951777458191, 0.527931809425354, 0.24315327405929565, 0.12627911567687988, 0.3894615173339844, 0.1638982892036438, 0.623225748538971, 0.381394624710083, 0.47070395946502686, 0.1953282356262207, 0.5454620718955994, 0.2552901f, 0.6559685468673706, 0.21416497230529785, 0.4175010919570923, 0.638900876045227, 0.8408862948417664, 0.864998459815979, 0.23752224445343018, 0.4475119709968567, 0.8710504770278931, 0.3337531089782715, 0.5414656400680542, 0.9168245196342468, 0.7091967463493347, 0.4178064f, 0.6862326860427856, 0.0068277716636657715, 0.710091769695282, 0.24184751510620117, 0.6448656320571899, 0.7953763604164124, 0.5377271175384521, 0.38062578439712524, 0.5138623714447021, 0.827816903591156, 0.6417585015296936, 0.19820594787597656, 0.8776569366455078, 0.5501766800880432, 0.298833f, 0.7237867116928101, 0.5692049264907837, 0.2782291769981384, 0.9931439161300659, 0.9825329184532166, 0.9400047063827515, 0.8707274198532104, 0.6609979271888733, 0.7778161764144897, 0.692325234413147, 4.118085E-4f, 0.9362597465515137, 0.885985f, 0.5186017751693726, 0.9098412990570068, 0.715259850025177, 0.14914226531982422, 0.07871353626251221, 0.9500807523727417, 0.8972458243370056, 0.2238718867301941, 0.2691269f, 0.3188428282737732, 0.16398346424102783, 0.7185322642326355, 0.7957355380058289, 0.9214897155761719, 0.8320558667182922, 0.0983426f, 0.9548588395118713, 0.4946465f, 0.6642706394195557, 0.2913872003555298, 0.40758395195007324, 0.26996463537216187, 0.6610062718391418, 0.14082473516464233, 0.9579067230224609, 0.8673551082611084, 0.1950562f, 0.23561668395996094, 0.7245106101036072, 0.5359363555908203, 0.9094613790512085, 0.7462095022201538, 0.1422138810157776, 0.6908122301101685, 0.899948000907898, 0.4906695485115051, 0.4079365134239197, 0.19901710748672485, 0.26305872201919556, 0.8742526173591614, 0.9664371013641357, 0.4635796546936035, 0.8471241593360901, 0.6603974103927612, 0.535107433795929, 0.8463312387466431, 0.3132617473602295, 0.8383875489234924, 0.8199976086616516, 0.8041014671325684, 0.5431116223335266, 0.5127789378166199, 0.2552846074104309, 0.6262242794036865, 0.24266088008880615, 0.6281246542930603, 0.7870466113090515, 0.33135467767715454, 0.8390246033668518, 0.10113614797592163, 0.35402876138687134, 0.976639f, 0.5793247818946838, 0.21843528747558594, 0.4307838f, 0.861075222492218, 0.07585287094116211, 0.8943236470222473, 0.8829567432403564, 0.2668603f, 0.4356384873390198, 0.00799715518951416, 0.734510600566864, 0.017688095569610596, 0.9296445250511169, 0.7574741840362549, 0.009420037269592285, 0.17199641466140747, 0.8394468426704407, 0.9979043006896973, 0.03599768877029419, 0.1833580732345581, 0.4379372000694275, 0.36023545265197754, 0.8938753604888916, 0.3114752769470215, 0.8639543652534485, 0.5734204649925232, 0.6481895446777344, 0.5581182241439819, 0.11554992198944092, 0.6060342192649841, 0.7122871279716492, 0.926002562046051, 0.2677158f, 0.7835817337036133, 0.8719660639762878, 0.9888203740119934, 0.9008547067642212, 0.9737565517425537, 0.9067221283912659, 0.1418384313583374, 0.267184853553772, 0.8269312381744385, 0.27562427520751953, 0.13969367742538452, 0.9129041433334351, 0.24233222007751465, 0.3693675398826599, 0.6769168376922607, 0.8816704750061035, 0.046395063400268555, 0.4409409165382385, 0.5235827565193176, 0.645301878452301, 0.929066002368927, 0.5435224771499634, 0.6802434325218201, 0.014183461666107178, 0.11228436231613159, 0.8571202754974365, 0.8904795050621033, 0.2744571f, 0.9141570329666138, 0.3596855401992798, 0.7641729116439819, 0.06153923273086548, 0.22963637113571167, 0.28162723779678345, 0.4787498712539673, 0.21787422895431519, 0.14670151472091675, 0.515679f, 0.18858152627944946, 0.3832143545150757, 0.1445828676223755, 0.680851936340332, 0.6744951605796814, 0.9423868656158447, 0.031573712825775146, 0.8568223118782043, 0.5866127014160156, 0.4008384943008423, 0.44416117668151855, 0.8137462735176086, 0.69577956199646, 0.29275137186050415, 0.08193308115005493, 0.5154865384101868, 0.5835891366004944, 0.4488357901573181, 0.1449601f, 0.6280182003974915, 0.02099078893661499, 0.28777432441711426, 0.68870609998703, 0.02893310785293579, 0.15384888648986816, 0.7516117691993713, 0.8482186198234558, 0.9011663198471069, 0.4143932f, 0.41415655612945557, 0.40624386072158813, 0.8701590299606323, 0.5846758484840393, 0.06381601095199585, 0.8024723529815674, 0.9775804281234741, 0.5669687986373901, 0.9374921917915344, 0.9824559688568115, 0.698542058467865, 0.4721605181694031, 0.5775920748710632, 0.05956989526748657, 0.028130948543548584, 0.5669340491294861, 0.6453711986541748, 0.4720763564109802, 0.16539990901947021, 0.2607395052909851, 0.6743612885475159, 0.5358563661575317, 0.9901143312454224, 0.6418553590774536, 0.7392902374267578, 0.16331404447555542, 0.294146f, 0.45632845163345337, 0.9785667061805725, 0.19754958152770996, 0.2331169843673706, 0.8730794191360474, 0.30008554458618164, 0.72099769115448, 0.2955474853515625, 0.792374f, 0.9569390416145325, 0.7778092622756958, 0.04030662775039673, 0.8732298016548157, 0.8658574819564819, 0.9034198522567749, 0.1756587028503418, 0.30881762504577637, 0.9992280602455139, 0.40272778272628784, 0.1948530077934265, 0.7388133406639099, 0.18186748027801514, 0.445442795753479, 0.6473257541656494, 0.5158766508102417, 0.5149756073951721, 0.2544465f, 0.3176283836364746, 0.9425168633460999, 0.1086421012878418, 0.21702611446380615, 0.6657266616821289, 0.5577110648155212, 0.08578962087631226, 0.9318283796310425, 0.11503005027770996, 0.21356523036956787, 0.007529854774475098, 0.5641894340515137, 0.37423282861709595, 0.5654611587524414, 0.12371140718460083, 0.48259472846984863, 0.3647156357765198, 0.8695491552352905, 0.6622119545936584, 0.8185244798660278, 0.36894768476486206, 0.19480282068252563, 0.8036501407623291, 0.17555981874465942, 0.2922348976135254, 0.509422242641449, 0.9401782751083374, 0.3217231035232544, 0.9685978293418884, 0.6800822019577026, 0.26149386167526245, 0.9575744867324829, 0.972988486289978, 0.4549046754837036, 0.9499348998069763, 0.9531881809234619, 0.6110239028930664, 0.605256199836731, 0.1793856f, 0.19701474905014038, 0.5316382646560669, 0.8363193869590759, 0.4077202081680298, 0.07164716720581055, 0.588337242603302, 0.9912781119346619, 0.9157894849777222, 0.7541308403015137, 0.20504075288772583, 0.7589273452758789, 0.29176175594329834, 0.9857885241508484, 0.0798794f, 0.23023265600204468, 0.28035175800323486, 0.63829505443573, 0.7849684357643127, 0.5571160316467285, 0.6326165795326233, 0.5542942881584167, 0.8454422354698181, 0.8584381937980652, 0.9021965265274048, 0.5131667852401733, 0.5633307695388794, 0.7463352680206299, 0.46489232778549194, 0.282241f, 7.750988006591797E-4, 0.1538984775543213, 0.8951773047447205, 0.093017578125, 0.6653016209602356, 0.9164631962776184, 0.5486577153205872, 0.3286963701248169, 0.013228535652160645, 0.06790006160736084, 0.184739351272583, 0.03693586587905884, 0.5747041702270508, 0.47532403469085693, 0.45810598134994507, 0.16943734884262085, 0.42745113372802734, 0.05621499f, 0.4284297823905945, 0.2923583388328552, 0.731201f, 0.847369f, 0.03054410219192505, 0.2690683603286743, 0.8593794703483582, 0.9622842073440552, 0.9357259273529053, 0.9653511047363281, 0.31028133630752563, 0.4600705f, 0.9705382585525513, 0.008420407772064209, 0.481328547000885, 0.22291874885559082, 0.3727347254753113, 0.7022898197174072, 0.6847342848777771, 0.6093677878379822, 0.612053632736206, 0.28596222400665283, 0.5618136525154114, 0.3164716958999634, 0.32344913482666016, 0.2560655474662781, 0.610239f, 0.08554404973983765, 0.45568424463272095, 0.6660566926002502, 0.6208009123802185, 0.5540978908538818, 0.9716299176216125, 0.3796687722206116, 0.8779029250144958, 0.2621998190879822, 0.11857682466506958, 0.6822478771209717, 0.414408802986145, 0.02663064f, 0.2660142183303833, 0.4409809708595276, 0.03301882743835449, 0.2035312056541443, 0.7614103555679321, 0.9203643798828125, 0.27264803647994995, 0.7627711892127991, 0.9364356994628906, 0.18483006954193115, 0.7720124125480652, 0.22890710830688477, 0.8898004293441772, 0.8040773272514343, 0.27961277961730957, 0.9286989569664001, 0.6395724415779114, 0.881841242313385, 0.7984927892684937, 0.28877967596054077, 0.6667556762695312, 0.584652304649353, 0.40760207176208496, 0.20487534999847412, 0.3304228186607361, 0.6983435750007629, 0.2445162534713745, 0.45225244760513306, 0.5183216333389282, 0.8969869613647461, 0.994973f, 0.3127283f, 0.6792427897453308, 0.49756646156311035, 0.2446182370185852, 0.7841681241989136, 0.8663041591644287, 0.3856257200241089, 0.8920979499816895, 0.03206747770309448, 0.9835583567619324, 0.4395895004272461, 0.8878638744354248, 0.8983672261238098, 0.2799737f, 0.3272966742515564, 0.1906154751777649, 0.9494964480400085, 0.5610033273696899, 0.6859837174415588, 0.5671120882034302, 0.5138089060783386, 0.20290863513946533, 0.8806162476539612, 0.6982392072677612, 0.6087489128112793, 0.05111217498779297, 0.2348091f, 0.6948846578598022, 0.4115341305732727, 0.6816438436508179, 0.5789591073989868, 0.22470492124557495, 0.6957940459251404, 0.4028325080871582, 0.41261154413223267, 0.8616766333580017, 0.2929880619049072, 0.199548602104187, 0.9490911960601807, 0.3040100336074829, 0.3847161531448364, 0.579404f, 0.8322862386703491, 0.7752384543418884, 0.17401212453842163, 0.802365779876709, 0.686018168926239, 0.1939171552658081, 0.9947915077209473, 0.17338258028030396, 0.6891534328460693, 0.7383081912994385, 0.1138506531715393, 0.19110208749771118, 0.6435990929603577, 0.8657656908035278, 0.6648458242416382, 0.19197314977645874, 0.11231738328933716, 0.9974645376205444, 0.2748087f, 0.35346662998199463, 0.010830879211425781, 0.22595477104187012, 0.8378932476043701, 0.24646568298339844, 0.9143573641777039, 0.027219057083129883, 0.5357368588447571, 0.606813371181488, 0.43530726432800293, 0.9950314164161682, 0.9672191143035889, 0.25945186614990234, 0.48962461948394775, 0.7011597752571106, 0.1413058042526245, 0.6335506439208984, 0.5282097458839417, 0.5111376643180847, 0.0044844746589660645, 0.5896346569061279, 0.7998971343040466, 0.3459045886993408, 0.1590750813484192, 0.2042381763458252, 0.13928836584091187, 0.2216421365737915, 0.9110931754112244, 0.1664230227470398, 0.3558694124221802, 0.873817503452301, 0.837647020816803, 0.804101f, 0.025642216205596924, 0.7800993323326111, 0.6459778547286987, 0.8251388072967529, 0.8539320826530457, 0.5468867421150208, 0.3117386f, 0.3054465651512146, 0.05471134f, 0.47525352239608765, 0.8261238932609558, 0.5385448336601257, 0.6599220633506775, 0.4368583f, 0.48379015922546387, 0.16147947311401367, 0.8797425031661987, 0.18462061882019043, 0.530565083026886, 0.6515367031097412, 0.6450008153915405, 0.31566494703292847, 0.3267715f, 0.3362658619880676, 0.1050936f, 0.1672559380531311, 0.524248480796814, 0.5432221293449402, 0.9735444188117981, 0.5353840589523315, 0.2991332411766052, 0.33110755681991577, 0.31909286975860596, 0.7886317372322083, 0.515080988407135, 0.3642469048500061, 0.3189065456390381, 0.4384058117866516, 0.04039097f, 0.2193442f, 0.013770222663879395, 0.7051225900650024, 0.9256322383880615, 0.6271066069602966, 0.640141f, 0.9761858582496643, 0.0246194f, 0.559607982635498, 0.3336302638053894, 0.12641412019729614, 0.06038510799407959, 0.4633181095123291, 0.09124833345413208, 0.5089029669761658, 0.3891713619232178, 0.421816f, 0.7997372150421143, 0.5212226510047913, 0.4800865650177002, 0.30370694398880005, 0.8542354702949524, 0.2085384726524353, 0.7272270321846008, 0.5306894779205322, 0.6407346725463867, 0.535033f, 0.8566678762435913, 0.5866991877555847, 0.6882566213607788, 0.0943378210067749, 0.23531681299209595, 0.708351f, 0.12902390956878662, 0.9481314420700073, 0.5753650665283203, 0.8543898463249207, 0.7693280577659607, 0.49231088161468506, 0.24075108766555786, 0.3805551f, 0.36817532777786255, 0.2180325984954834, 0.8750873804092407, 0.25729185342788696, 0.958587110042572, 0.6293732523918152, 0.7989283204078674, 0.9003676176071167, 0.3067519f, 0.522468f, 0.37374234199523926, 0.05605369806289673, 0.9817912578582764, 0.1479252576828003, 0.7467827796936035, 0.8386161923408508, 0.36407095193862915, 0.2474244236946106, 0.412142813205719, 0.1820654273033142, 0.12873148918151855, 0.5581108927726746, 0.3261719346046448, 0.1921921968460083, 0.9450361132621765, 0.5492920875549316, 0.7682836651802063, 0.2987557053565979, 0.9884586930274963, 0.032695472240448, 0.24979263544082642, 0.6692923307418823, 0.29402053356170654, 0.9610003232955933, 0.9431910514831543, 0.09151661396026611, 0.4246993660926819, 0.4934433698654175, 0.872253954410553, 0.8249453902244568, 0.5918842554092407, 0.009091436862945557, 0.40021026134490967, 0.7065737843513489, 0.4655643701553345, 0.6380760669708252, 0.9502243995666504, 0.8406790494918823, 0.9355610609054565, 0.4620016813278198, 0.851512610912323, 0.3577541708946228, 0.032628536224365234, 0.4133327603340149, 0.32810938358306885, 0.16893666982650757, 0.8562511801719666, 0.139390230178833, 0.928767f, 0.1249848f, 0.46668845415115356, 0.45235323905944824, 0.7695047855377197, 0.09586489200592041, 0.3301073908805847, 0.17817562818527222, 0.3493330478668213, 0.8794906139373779, 0.6209800839424133, 0.16354703903198242, 0.06971025466918945, 0.515348494052887, 0.8144044280052185, 0.2730111f, 0.9949996471405029, 0.08803999423980713, 0.8873653411865234, 0.4833087921142578, 0.530876636505127, 0.8526777625083923, 0.7025322318077087, 0.6872497200965881, 0.15720611810684204, 0.972221851348877, 0.8969737887382507, 0.7863845229148865, 0.8588995933532715, 0.1279911994934082, 0.7327567338943481, 0.7650204300880432, 0.5708454847335815, 0.1286190152168274, 0.7940106987953186, 0.08538883924484253, 0.5499607920646667, 0.6076438426971436, 0.3085407018661499, 0.26585662364959717, 0.7581654787063599, 0.25187617540359497, 0.9199209213256836, 0.4449191093444824, 0.8746578693389893, 0.3559103012084961, 0.392322301864624, 0.0903896689414978, 0.6349467039108276, 0.045044124126434326, 0.4648236036300659, 0.4859075f, 0.6389528512954712, 0.2699381709098816, 0.619997f, 0.8689391613006592, 0.29305f, 0.7502134442329407, 0.14410966634750366, 0.9622961282730103, 0.00370723f, 0.8576263189315796, 0.5499529242515564, 0.4444027f, 0.3665904402732849, 0.987335f, 0.240320086479187, 0.6548182964324951, 0.7783622741699219, 0.10110968351364136, 0.5083591341972351, 0.4966682195663452, 0.4134100675582886, 0.7502562403678894, 0.4139006733894348, 0.2456112504005432, 0.7693610787391663, 0.23779010772705078, 0.32150983810424805, 0.4278416037559509, 0.2991824746131897, 0.47638624906539917, 0.5311540961265564, 0.41258323192596436, 0.9601984620094299, 0.1863613724708557, 0.3363771438598633, 0.15590375661849976, 0.65840083360672, 0.08003401756286621, 0.3836879f, 0.11390268802642822, 0.5275238752365112, 0.6470330357551575, 0.5221281051635742, 0.6489806771278381, 0.12466102838516235, 0.7193485498428345, 0.5808826088905334, 0.9206711053848267, 0.9565111398696899, 0.6131667494773865, 0.11821246147155762, 0.8732304573059082, 0.172068f, 0.8529213070869446, 0.08538156747817993, 0.2997889518737793, 0.8087485432624817, 0.14579522609710693, 0.24872946739196777, 0.32442182302474976, 0.09025686979293823, 0.8344944715499878, 0.831330418586731, 0.9492169618606567, 0.017191171646118164, 0.7830040454864502, 0.15813356637954712, 0.4665995240211487, 0.8274335861206055, 0.892851710319519, 0.6160694360733032, 0.6442822813987732, 0.9352571368217468, 0.8829110860824585, 0.2399401068687439, 0.21080058813095093, 0.1790058f, 0.8488505482673645, 0.9882116913795471, 0.5663729310035706, 0.7509375810623169, 0.5319893956184387, 0.8279446363449097, 0.03260773420333862, 0.07378655672073364, 0.33268827199935913, 0.1685122847557068, 0.7543100714683533, 0.29183077812194824, 0.3897351026535034, 0.7985692024230957, 0.44939547777175903, 0.5154194831848145, 0.5818765759468079, 0.13466405868530273, 0.14388275146484375, 0.6932974457740784, 0.986190140247345, 0.39330315589904785, 0.3564445972442627, 0.07358604669570923, 0.12403213977813721, 0.8771303296089172, 0.6424749493598938, 0.8794761300086975, 0.5405882000923157, 0.3118047f, 0.15567153692245483, 0.6877219080924988, 0.7784737944602966, 0.49035102128982544, 0.8234102129936218, 0.3156847357749939, 0.32739925384521484, 0.04908335208892822, 0.7015396356582642, 0.945381760597229, 0.4467502236366272, 0.2021367f, 0.1185845136642456, 0.03077346f, 0.980306f, 0.654283344745636, 0.8357887268066406, 0.9280562400817871, 0.1046026349067688, 0.6637902855873108, 0.8381532430648804, 0.4792847f, 0.8951533436775208, 0.5739409327507019, 0.6859405040740967, 0.17915958166122437, 0.2565035820007324, 0.8244737982749939, 0.9524829387664795, 0.415813148021698, 0.0696708f, 0.009189307689666748, 0.9621074795722961, 0.3420698046684265, 0.8687916398048401, 0.4955628514289856, 0.334275484085083, 0.587749183177948, 0.3007734417915344, 0.26423585414886475, 0.20245301723480225, 0.5405172109603882, 0.4585575f, 0.2742095f, 0.07771474123001099, 0.7176271677017212, 0.6495075225830078, 0.8925400376319885, 0.28972136974334717, 0.6292823553085327, 0.5828189253807068, 0.840059757232666, 0.5866852402687073, 0.9425902962684631, 0.479211688041687, 0.05746924877166748, 0.5895750522613525, 0.030076563358306885, 0.4461541175842285, 0.7650487422943115, 0.3555522561073303, 0.6060211658477783, 0.17422592639923096, 0.4158136248588562, 0.7460497617721558, 0.9856443405151367, 0.7248470783233643, 0.8834231495857239, 0.7536943554878235, 0.05517786741256714, 0.8544843792915344, 0.005390822887420654, 0.510254979133606, 0.7145395278930664, 0.9917301535606384, 0.957617461681366, 0.6689183712005615, 0.888713538646698, 0.01558983325958252, 0.07207483053207397, 0.9755200743675232, 0.12969166040420532, 0.318293035030365, 0.8453366756439209, 0.5650875568389893, 0.9192467331886292, 0.044472336769104004, 0.5069327354431152, 0.2455059289932251, 0.4957931637763977, 0.729259192943573, 0.6241743564605713, 0.3657352924346924, 0.9686883687973022, 0.9874942898750305, 0.5807563662528992, 0.8713716864585876, 0.6437022686004639, 0.1897139549255371, 0.16232287883758545, 0.5881336331367493, 0.4978213906288147, 0.7808707356452942, 0.9611266851425171, 0.35990744829177856, 0.13446974754333496, 0.7160015106201172, 0.43740737438201904, 0.3212311267852783, 0.9866673350334167, 0.3925327658653259, 0.576250433921814, 0.6766132712364197, 0.07126224040985107, 0.018990516662597656, 0.500203013420105, 0.9660696983337402, 0.9284626245498657, 0.9700685143470764, 0.7501598000526428, 0.9460257291793823, 0.09436947107315063, 0.8119410872459412, 0.35597097873687744, 0.1387348771095276, 0.2776082158088684, 0.14113473892211914, 0.17546826601028442, 0.4861634373664856, 0.46264582872390747, 0.5450887680053711, 0.19337546825408936, 0.7735902667045593, 0.2007434368133545, 0.07073968648910522, 0.7127261757850647, 0.904783f, 0.0241507887840271, 0.8651928901672363, 0.3294200897216797, 0.2584916949272156, 0.02013498544692993, 0.7440556287765503, 0.7095226645469666, 0.2322072982788086, 0.3094179034233093, 0.5406820774078369, 0.9585694670677185, 0.3838715f, 0.3098604679107666, 0.21392714977264404, 0.5178300738334656, 0.9688085913658142, 0.942695f, 0.9416593313217163, 0.29519742727279663, 0.9940294623374939, 0.20780634880065918, 0.2289997935295105, 0.1546909213066101, 0.4847991466522217, 0.05966258f, 0.41891396045684814, 0.9807302951812744, 0.4916623830795288, 0.14028632640838623, 0.7414002418518066, 0.599197f, 0.4258016347885132, 0.4445517063140869, 0.08721989393234253, 0.6903305649757385, 0.7656075954437256, 0.3211292624473572, 0.28215837478637695, 0.047813f, 0.6497434377670288, 0.6552464962005615, 0.5855830907821655, 0.718691885471344, 0.6869745254516602, 0.5833703875541687, 0.08806800842285156, 0.5604485869407654, 0.7489375472068787, 0.49187082052230835, 0.36073243618011475, 0.9504941701889038, 0.050279855728149414, 0.32922303676605225, 0.1654425859451294, 0.9212827086448669, 0.3957844376564026, 0.7825216054916382, 0.9000325798988342, 0.028293073177337646, 0.7239006757736206, 0.642793f, 0.18422812223434448, 0.21119868755340576, 0.591349f, 0.60922771692276, 0.12612974643707275, 0.7190947532653809, 0.8181021809577942, 0.9000404477119446, 0.2101944088935852, 0.5427869558334351, 0.39313656091690063, 0.7778741121292114, 0.8580233454704285, 0.45059454441070557, 0.8790944814682007, 0.5317802429199219, 0.8034340739250183, 0.6442254781723022, 0.8517132997512817, 0.5477479100227356, 0.8418908715248108, 0.7390331625938416, 0.4740166f, 0.948052704334259, 0.9381551146507263, 0.4949500560760498, 0.6953859329223633, 0.37952595949172974, 0.35987406969070435, 0.7628515362739563, 0.0444417f, 0.01598513126373291, 0.5317613482475281};
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.7679761052131653;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }
}

