package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_TurboPumpTelemetry extends CameraTelemetry {
  private final double turboSpeed;

  private final double turboCurrent;

  private final double turboVoltage;

  private final double turboPower;

  private final double turboPumpTemp;

  public Vacuum_TurboPumpTelemetry(double turboSpeed, double turboCurrent, double turboVoltage,
      double turboPower, double turboPumpTemp) {
    this.turboSpeed = turboSpeed;
    this.turboCurrent = turboCurrent;
    this.turboVoltage = turboVoltage;
    this.turboPower = turboPower;
    this.turboPumpTemp = turboPumpTemp;
  }

  public double getTurboSpeed() {
    return turboSpeed;
  }

  public double getTurboCurrent() {
    return turboCurrent;
  }

  public double getTurboVoltage() {
    return turboVoltage;
  }

  public double getTurboPower() {
    return turboPower;
  }

  public double getTurboPumpTemp() {
    return turboPumpTemp;
  }

  @Override
  public String toString() {
    return "Vacuum_TurboPumpTelemetry{" + "turboSpeed=" + turboSpeed +
        ", turboCurrent=" + turboCurrent +", turboVoltage=" + turboVoltage +
        ", turboPower=" + turboPower +", turboPumpTemp=" + turboPumpTemp +"}";
  }
}
