package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Refrig_Cold1Telemetry extends CameraTelemetry {
  private final double dischrgtmp_P;

  private final double dischrgtmp_M;

  private final double dischrgPrs;

  private final double suctiontmp_P;

  private final double suctiontmp_M;

  private final double suctionPrs;

  private final double liquidtmp_P;

  private final double liquidtmp_M;

  private final double compVoltage;

  private final double compCurrent;

  private final double compPower;

  private final double compVfdVolt;

  private final double compVfdCurr;

  private final double compVfdFreq;

  private final double hGBValvePosn;

  private final double coolValvePosn;

  private final double coolFlowRate;

  private final double waterInTmp;

  private final double waterOutTmp;

  private final double cabinetTmp;

  private final double ambientTmp;

  private final double fan1Speed;

  private final double fan2Speed;

  private final double fan3Speed;

  private final double liquidSubCooling;

  public Refrig_Cold1Telemetry(double dischrgtmp_P, double dischrgtmp_M, double dischrgPrs,
      double suctiontmp_P, double suctiontmp_M, double suctionPrs, double liquidtmp_P,
      double liquidtmp_M, double compVoltage, double compCurrent, double compPower,
      double compVfdVolt, double compVfdCurr, double compVfdFreq, double hGBValvePosn,
      double coolValvePosn, double coolFlowRate, double waterInTmp, double waterOutTmp,
      double cabinetTmp, double ambientTmp, double fan1Speed, double fan2Speed, double fan3Speed,
      double liquidSubCooling) {
    this.dischrgtmp_P = dischrgtmp_P;
    this.dischrgtmp_M = dischrgtmp_M;
    this.dischrgPrs = dischrgPrs;
    this.suctiontmp_P = suctiontmp_P;
    this.suctiontmp_M = suctiontmp_M;
    this.suctionPrs = suctionPrs;
    this.liquidtmp_P = liquidtmp_P;
    this.liquidtmp_M = liquidtmp_M;
    this.compVoltage = compVoltage;
    this.compCurrent = compCurrent;
    this.compPower = compPower;
    this.compVfdVolt = compVfdVolt;
    this.compVfdCurr = compVfdCurr;
    this.compVfdFreq = compVfdFreq;
    this.hGBValvePosn = hGBValvePosn;
    this.coolValvePosn = coolValvePosn;
    this.coolFlowRate = coolFlowRate;
    this.waterInTmp = waterInTmp;
    this.waterOutTmp = waterOutTmp;
    this.cabinetTmp = cabinetTmp;
    this.ambientTmp = ambientTmp;
    this.fan1Speed = fan1Speed;
    this.fan2Speed = fan2Speed;
    this.fan3Speed = fan3Speed;
    this.liquidSubCooling = liquidSubCooling;
  }

  public double getDischrgtmp_P() {
    return dischrgtmp_P;
  }

  public double getDischrgtmp_M() {
    return dischrgtmp_M;
  }

  public double getDischrgPrs() {
    return dischrgPrs;
  }

  public double getSuctiontmp_P() {
    return suctiontmp_P;
  }

  public double getSuctiontmp_M() {
    return suctiontmp_M;
  }

  public double getSuctionPrs() {
    return suctionPrs;
  }

  public double getLiquidtmp_P() {
    return liquidtmp_P;
  }

  public double getLiquidtmp_M() {
    return liquidtmp_M;
  }

  public double getCompVoltage() {
    return compVoltage;
  }

  public double getCompCurrent() {
    return compCurrent;
  }

  public double getCompPower() {
    return compPower;
  }

  public double getCompVfdVolt() {
    return compVfdVolt;
  }

  public double getCompVfdCurr() {
    return compVfdCurr;
  }

  public double getCompVfdFreq() {
    return compVfdFreq;
  }

  public double getHGBValvePosn() {
    return hGBValvePosn;
  }

  public double getCoolValvePosn() {
    return coolValvePosn;
  }

  public double getCoolFlowRate() {
    return coolFlowRate;
  }

  public double getWaterInTmp() {
    return waterInTmp;
  }

  public double getWaterOutTmp() {
    return waterOutTmp;
  }

  public double getCabinetTmp() {
    return cabinetTmp;
  }

  public double getAmbientTmp() {
    return ambientTmp;
  }

  public double getFan1Speed() {
    return fan1Speed;
  }

  public double getFan2Speed() {
    return fan2Speed;
  }

  public double getFan3Speed() {
    return fan3Speed;
  }

  public double getLiquidSubCooling() {
    return liquidSubCooling;
  }

  @Override
  public String toString() {
    return "Refrig_Cold1Telemetry{" + "dischrgtmp_P=" + dischrgtmp_P +
        ", dischrgtmp_M=" + dischrgtmp_M +", dischrgPrs=" + dischrgPrs +
        ", suctiontmp_P=" + suctiontmp_P +", suctiontmp_M=" + suctiontmp_M +
        ", suctionPrs=" + suctionPrs +", liquidtmp_P=" + liquidtmp_P +
        ", liquidtmp_M=" + liquidtmp_M +", compVoltage=" + compVoltage +
        ", compCurrent=" + compCurrent +", compPower=" + compPower +", compVfdVolt=" + compVfdVolt +
        ", compVfdCurr=" + compVfdCurr +", compVfdFreq=" + compVfdFreq +
        ", hGBValvePosn=" + hGBValvePosn +", coolValvePosn=" + coolValvePosn +
        ", coolFlowRate=" + coolFlowRate +", waterInTmp=" + waterInTmp +
        ", waterOutTmp=" + waterOutTmp +", cabinetTmp=" + cabinetTmp +", ambientTmp=" + ambientTmp +
        ", fan1Speed=" + fan1Speed +", fan2Speed=" + fan2Speed +", fan3Speed=" + fan3Speed +
        ", liquidSubCooling=" + liquidSubCooling +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double dischrgtmp_P;

    private double dischrgtmp_M;

    private double dischrgPrs;

    private double suctiontmp_P;

    private double suctiontmp_M;

    private double suctionPrs;

    private double liquidtmp_P;

    private double liquidtmp_M;

    private double compVoltage;

    private double compCurrent;

    private double compPower;

    private double compVfdVolt;

    private double compVfdCurr;

    private double compVfdFreq;

    private double hGBValvePosn;

    private double coolValvePosn;

    private double coolFlowRate;

    private double waterInTmp;

    private double waterOutTmp;

    private double cabinetTmp;

    private double ambientTmp;

    private double fan1Speed;

    private double fan2Speed;

    private double fan3Speed;

    private double liquidSubCooling;

    private Builder() {
    }

    public Builder dischrgtmp_P(double dischrgtmp_P) {
      this.dischrgtmp_P = dischrgtmp_P;
      return this;
    }

    public Builder dischrgtmp_M(double dischrgtmp_M) {
      this.dischrgtmp_M = dischrgtmp_M;
      return this;
    }

    public Builder dischrgPrs(double dischrgPrs) {
      this.dischrgPrs = dischrgPrs;
      return this;
    }

    public Builder suctiontmp_P(double suctiontmp_P) {
      this.suctiontmp_P = suctiontmp_P;
      return this;
    }

    public Builder suctiontmp_M(double suctiontmp_M) {
      this.suctiontmp_M = suctiontmp_M;
      return this;
    }

    public Builder suctionPrs(double suctionPrs) {
      this.suctionPrs = suctionPrs;
      return this;
    }

    public Builder liquidtmp_P(double liquidtmp_P) {
      this.liquidtmp_P = liquidtmp_P;
      return this;
    }

    public Builder liquidtmp_M(double liquidtmp_M) {
      this.liquidtmp_M = liquidtmp_M;
      return this;
    }

    public Builder compVoltage(double compVoltage) {
      this.compVoltage = compVoltage;
      return this;
    }

    public Builder compCurrent(double compCurrent) {
      this.compCurrent = compCurrent;
      return this;
    }

    public Builder compPower(double compPower) {
      this.compPower = compPower;
      return this;
    }

    public Builder compVfdVolt(double compVfdVolt) {
      this.compVfdVolt = compVfdVolt;
      return this;
    }

    public Builder compVfdCurr(double compVfdCurr) {
      this.compVfdCurr = compVfdCurr;
      return this;
    }

    public Builder compVfdFreq(double compVfdFreq) {
      this.compVfdFreq = compVfdFreq;
      return this;
    }

    public Builder hGBValvePosn(double hGBValvePosn) {
      this.hGBValvePosn = hGBValvePosn;
      return this;
    }

    public Builder coolValvePosn(double coolValvePosn) {
      this.coolValvePosn = coolValvePosn;
      return this;
    }

    public Builder coolFlowRate(double coolFlowRate) {
      this.coolFlowRate = coolFlowRate;
      return this;
    }

    public Builder waterInTmp(double waterInTmp) {
      this.waterInTmp = waterInTmp;
      return this;
    }

    public Builder waterOutTmp(double waterOutTmp) {
      this.waterOutTmp = waterOutTmp;
      return this;
    }

    public Builder cabinetTmp(double cabinetTmp) {
      this.cabinetTmp = cabinetTmp;
      return this;
    }

    public Builder ambientTmp(double ambientTmp) {
      this.ambientTmp = ambientTmp;
      return this;
    }

    public Builder fan1Speed(double fan1Speed) {
      this.fan1Speed = fan1Speed;
      return this;
    }

    public Builder fan2Speed(double fan2Speed) {
      this.fan2Speed = fan2Speed;
      return this;
    }

    public Builder fan3Speed(double fan3Speed) {
      this.fan3Speed = fan3Speed;
      return this;
    }

    public Builder liquidSubCooling(double liquidSubCooling) {
      this.liquidSubCooling = liquidSubCooling;
      return this;
    }

    public Refrig_Cold1Telemetry build() {
      return new Refrig_Cold1Telemetry(dischrgtmp_P, dischrgtmp_M, dischrgPrs, suctiontmp_P, suctiontmp_M, suctionPrs, liquidtmp_P, liquidtmp_M, compVoltage, compCurrent, compPower, compVfdVolt, compVfdCurr, compVfdFreq, hGBValvePosn, coolValvePosn, coolFlowRate, waterInTmp, waterOutTmp, cabinetTmp, ambientTmp, fan1Speed, fan2Speed, fan3Speed, liquidSubCooling);
    }
  }
}
