package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Hex_Cryo1Telemetry extends CameraTelemetry {
  private final double c3ExitTmp;

  private final double preC3Tmp;

  private final double preC4Tmp;

  private final double c4ExitTmp;

  private final double evapExitTmp;

  private final double hexRtrnTmp;

  private final double vaporPrs;

  private final double liquidPrs;

  private final double returnPrs;

  public Hex_Cryo1Telemetry(double c3ExitTmp, double preC3Tmp, double preC4Tmp, double c4ExitTmp,
      double evapExitTmp, double hexRtrnTmp, double vaporPrs, double liquidPrs, double returnPrs) {
    this.c3ExitTmp = c3ExitTmp;
    this.preC3Tmp = preC3Tmp;
    this.preC4Tmp = preC4Tmp;
    this.c4ExitTmp = c4ExitTmp;
    this.evapExitTmp = evapExitTmp;
    this.hexRtrnTmp = hexRtrnTmp;
    this.vaporPrs = vaporPrs;
    this.liquidPrs = liquidPrs;
    this.returnPrs = returnPrs;
  }

  public double getC3ExitTmp() {
    return c3ExitTmp;
  }

  public double getPreC3Tmp() {
    return preC3Tmp;
  }

  public double getPreC4Tmp() {
    return preC4Tmp;
  }

  public double getC4ExitTmp() {
    return c4ExitTmp;
  }

  public double getEvapExitTmp() {
    return evapExitTmp;
  }

  public double getHexRtrnTmp() {
    return hexRtrnTmp;
  }

  public double getVaporPrs() {
    return vaporPrs;
  }

  public double getLiquidPrs() {
    return liquidPrs;
  }

  public double getReturnPrs() {
    return returnPrs;
  }

  @Override
  public String toString() {
    return "Hex_Cryo1Telemetry{" + "c3ExitTmp=" + c3ExitTmp +", preC3Tmp=" + preC3Tmp +
        ", preC4Tmp=" + preC4Tmp +", c4ExitTmp=" + c4ExitTmp +", evapExitTmp=" + evapExitTmp +
        ", hexRtrnTmp=" + hexRtrnTmp +", vaporPrs=" + vaporPrs +", liquidPrs=" + liquidPrs +
        ", returnPrs=" + returnPrs +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double c3ExitTmp;

    private double preC3Tmp;

    private double preC4Tmp;

    private double c4ExitTmp;

    private double evapExitTmp;

    private double hexRtrnTmp;

    private double vaporPrs;

    private double liquidPrs;

    private double returnPrs;

    private Builder() {
    }

    public Builder c3ExitTmp(double c3ExitTmp) {
      this.c3ExitTmp = c3ExitTmp;
      return this;
    }

    public Builder preC3Tmp(double preC3Tmp) {
      this.preC3Tmp = preC3Tmp;
      return this;
    }

    public Builder preC4Tmp(double preC4Tmp) {
      this.preC4Tmp = preC4Tmp;
      return this;
    }

    public Builder c4ExitTmp(double c4ExitTmp) {
      this.c4ExitTmp = c4ExitTmp;
      return this;
    }

    public Builder evapExitTmp(double evapExitTmp) {
      this.evapExitTmp = evapExitTmp;
      return this;
    }

    public Builder hexRtrnTmp(double hexRtrnTmp) {
      this.hexRtrnTmp = hexRtrnTmp;
      return this;
    }

    public Builder vaporPrs(double vaporPrs) {
      this.vaporPrs = vaporPrs;
      return this;
    }

    public Builder liquidPrs(double liquidPrs) {
      this.liquidPrs = liquidPrs;
      return this;
    }

    public Builder returnPrs(double returnPrs) {
      this.returnPrs = returnPrs;
      return this;
    }

    public Hex_Cryo1Telemetry build() {
      return new Hex_Cryo1Telemetry(c3ExitTmp, preC3Tmp, preC4Tmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, vaporPrs, liquidPrs, returnPrs);
    }
  }
}
