package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class ImageReadinessDetailedStateEvent extends CameraStateChangeEvent {
  private final ImageReadinessState substate;

  public ImageReadinessDetailedStateEvent(int priority, ImageReadinessState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public ImageReadinessState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "ImageReadinessDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum ImageReadinessState implements SALEnum {
    READY,

    NOT_READY,

    GETTING_READY
  }
}
