package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class EndSetFilterEvent extends CameraEvent {
  private final String filterName;

  private final String filterType;

  private final int filterSlot;

  private final double filterPosition;

  public EndSetFilterEvent(int priority, String filterName, String filterType, int filterSlot,
      double filterPosition) {
    super (priority);
    this.filterName = filterName;
    this.filterType = filterType;
    this.filterSlot = filterSlot;
    this.filterPosition = filterPosition;
  }

  public String getFilterName() {
    return filterName;
  }

  public String getFilterType() {
    return filterType;
  }

  public int getFilterSlot() {
    return filterSlot;
  }

  public double getFilterPosition() {
    return filterPosition;
  }

  @Override
  public String toString() {
    return "EndSetFilterEvent{" + "filterName=" + filterName +", filterType=" + filterType +
        ", filterSlot=" + filterSlot +", filterPosition=" + filterPosition +"}";
  }
}
