package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class StartImageCommand extends CameraCommand {
  private final boolean shutter;

  private final String sensors;

  private final String keyValueMap;

  private final String obsNote;

  private final double timeout;

  public StartImageCommand(boolean shutter, String sensors, String keyValueMap, String obsNote,
      double timeout) {
    this.shutter = shutter;
    this.sensors = sensors;
    this.keyValueMap = keyValueMap;
    this.obsNote = obsNote;
    this.timeout = timeout;
  }

  public boolean isShutter() {
    return shutter;
  }

  public String getSensors() {
    return sensors;
  }

  public String getKeyValueMap() {
    return keyValueMap;
  }

  public String getObsNote() {
    return obsNote;
  }

  public double getTimeout() {
    return timeout;
  }

  @Override
  public String toString() {
    return "StartImageCommand{" + "shutter=" + shutter +", sensors=" + sensors +
        ", keyValueMap=" + keyValueMap +", obsNote=" + obsNote +", timeout=" + timeout +"}";
  }
}
