package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class SetAuthListCommand extends CameraCommand {
  private final String authorizedUsers;

  private final String nonAuthorizedCSCs;

  public SetAuthListCommand(String authorizedUsers, String nonAuthorizedCSCs) {
    this.authorizedUsers = authorizedUsers;
    this.nonAuthorizedCSCs = nonAuthorizedCSCs;
  }

  public String getAuthorizedUsers() {
    return authorizedUsers;
  }

  public String getNonAuthorizedCSCs() {
    return nonAuthorizedCSCs;
  }

  @Override
  public String toString() {
    return "SetAuthListCommand{" + "authorizedUsers=" + authorizedUsers +
        ", nonAuthorizedCSCs=" + nonAuthorizedCSCs +"}";
  }
}
