/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.PeriodicTaskExceptionHandler;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class PeriodicTaskExceptionHandlerTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetLongExecutionThreshold() {
        final AtomicInteger count = new AtomicInteger(0);
        Scheduler s = new Scheduler("tester", 1);
        PeriodicTaskExceptionHandler exceptionHandler = new PeriodicTaskExceptionHandler(){

            public void onLongExecution(PeriodicTask task) {
                task.cancel(true);
            }
        };
        exceptionHandler.setLongExecutionThreshold(1500, TimeUnit.MILLISECONDS);
        Runnable runner = new Runnable(){
            int n = 0;

            @Override
            public void run() {
                try {
                    Thread.sleep(1000 * this.n++);
                    count.addAndGet(1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        PeriodicTask task = new PeriodicTask(s, runner, true, "task", 1L, TimeUnit.SECONDS, exceptionHandler);
        task.start();
        try {
            task.get(5500L, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException x) {
            count.addAndGet(10);
        }
        catch (Exception x) {
            Assert.assertTrue((String)("Abnormal test termination: " + x), (boolean)false);
        }
        s.shutdown();
        try {
            s.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException x) {
            Assert.assertTrue((String)("Abnormal test termination " + x), (boolean)false);
        }
        Assert.assertEquals((long)12L, (long)count.get());
    }

    @Test
    public void testSetDetectLongExecutions() {
        final AtomicInteger count = new AtomicInteger(0);
        Scheduler s = new Scheduler("tester", 1);
        PeriodicTaskExceptionHandler exceptionHandler = new PeriodicTaskExceptionHandler(){

            public void onLongExecution(PeriodicTask task) {
                task.cancel(true);
            }
        };
        exceptionHandler.setDetectLongExecutions(true);
        Runnable runner = new Runnable(){
            int n = 0;

            @Override
            public void run() {
                try {
                    Thread.sleep(1000 * this.n++ + 500);
                    count.addAndGet(1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        PeriodicTask task = new PeriodicTask(s, runner, true, "task", 1L, TimeUnit.SECONDS, exceptionHandler);
        task.start();
        try {
            task.get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException x) {
            count.addAndGet(10);
        }
        catch (Exception x) {
            Assert.assertTrue((String)("Abnormal test termination: " + x), (boolean)false);
        }
        s.shutdown();
        try {
            s.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException x) {
            Assert.assertTrue((String)("Abnormal test termination " + x), (boolean)false);
        }
        Assert.assertEquals((long)11L, (long)count.get());
    }
}

