/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.logging.DailyRollingFileHandler;

public class TestRollingFileHandler {
    @Test
    public void testRollingFileHandler() {
        DailyRollingFileHandler rollingFileHandler = new DailyRollingFileHandler();
        Assert.assertEquals((long)-1L, (long)rollingFileHandler.getNextRollover());
        this.publishAndTest(rollingFileHandler, System.currentTimeMillis());
        this.publishAndTest(rollingFileHandler, System.currentTimeMillis() + 86400000L);
        rollingFileHandler.close();
    }

    private void publishAndTest(DailyRollingFileHandler rollingFileHandler, long millis) {
        LogRecord lr = new LogRecord(Level.SEVERE, "someMsg");
        lr.setMillis(millis);
        rollingFileHandler.publish(lr);
        long endOfDayMillis = this.getEndOfDayMillis(millis);
        Assert.assertEquals((long)endOfDayMillis, (long)rollingFileHandler.getNextRollover());
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date(millis));
        Assert.assertTrue((boolean)rollingFileHandler.fileName(millis).endsWith(date + ".log"));
    }

    private long getEndOfDayMillis(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        ZonedDateTime zdtStart = zdt.toLocalDate().atStartOfDay(zoneId);
        ZonedDateTime zdtTomorrowStart = zdtStart.plusDays(1L);
        return zdtTomorrowStart.toInstant().toEpochMilli();
    }
}

