package org.lsst.ccs.utilities.time;

import java.time.Instant;

/**
 * A utility class to create unique Instant instances within the same millisecond
 * by providing an arbitrary unique value for the nanosecond part of the Instant.
 *
 * @author The LSST CCS Team
 */
public final class CCSInstantFactory {

    private static Instant last = Instant.now();
    private static long nanos = 0;

    /**
     * Get the current unique Instant.
     * The milliseconds part of the Instant is equivalent to the clock System.currentTimemillis().
     * The nanoseconds part is arbitrary and is evaluated incrementally within
     * the same millisecond to make an Instant unique.
     * 
     * @return Return a unique Instant corresponding to the current clock.
     */
    public static synchronized Instant now() {
        Instant i = Instant.now();
        if (i.compareTo(last) == 0) {
            nanos++;
            return i.plusNanos(nanos);
        } else {
            last = i;
            nanos = 0;
            return i;
        }
    }

}
