package org.lsst.ccs.utilities.exc;

/**
 * This is to create a Bundle of linked Exception : a code may not stop at the first Exception it catches
 * but store the Exception in reverse order and then , when finished, throw a Set of Exception.
 * Typical code could look like this:
 * <PRE>
 *      ThrowableList listExc = null
 *     for (Thing thing : things) {
 *         try {
 *
 *         } catch(AnException exc) {
 *              // or use a specific subclass of BundledException
 *             listExc = new BundledException(exc, listExc)
 *     }
 *     if(listExc != null) {
 *         throw  listExc.current() ;
 *     }
 * </PRE>
 * Beware: do not confuse this with a "cause" (such as in getCause()).
 * <P>
 *     The interface <TT>ThrowableList</TT> may help create
 *     list of throwables that do not necessarily extends BundledException.
 *     (this could have been implemented through multiple decorators ...)
 *
 * @author bamade
 */
// Date: 06/06/12

public class BundledException extends Exception implements ThrowableList{
    ThrowableList previousThrowable ;

    public BundledException(ThrowableList previousThrowable) {
        this.previousThrowable = previousThrowable;
    }

    public BundledException(String s, ThrowableList previousThrowable) {
        super(s);
        this.previousThrowable = previousThrowable;
    }

    public BundledException(String s, Throwable throwable, ThrowableList previousThrowable) {
        super(s, throwable);
        this.previousThrowable = previousThrowable;
    }

    public BundledException(Throwable throwable, ThrowableList previousThrowable) {
        super(throwable);
        this.previousThrowable = previousThrowable;
    }

    public Throwable previous() {
        return (Throwable) this.previousThrowable ;
    }

    @Override
    public Throwable current() {
        return this;
    }

    public String toString() {
        return super.toString()+ "\n" + (previousThrowable!=null? previousThrowable.toString():"") ;
    }

    public void setPreviousThrowable(ThrowableList previousThrowable) {
        this.previousThrowable = previousThrowable;
    }
}
