/*
 * this class is for generating a java.awt.geom.Ellipse2D.Float using interface ShapeBean and the method genShape()
 * the ellipse (Shape) will be using to define a clickable part on the ImageIcon
 * all methods set and get and constructor without argument are for generating a xml file with java.beans.XMLEncoder
 */
package org.lsst.ccs.utilities.zonesui;

import java.awt.Shape;

/**
 *
 * @author Pascal Durieu
 */
public class ZEllipse implements ShapeBean {
    private float fx, fy, fwidth, fheight;
    
    public ZEllipse() {}

    public ZEllipse(int ix, int iy, int iw, int ih) {
        this.fx = (float)ix;
        this.fy = (float)iy;
        this.fwidth = (float)iw;
        this.fheight = (float)ih;
    }
    
    // get method
    public int getX () {return (int)fx;}
    public int getY () {return (int)fy;}
    public int getWidth () {return (int)fwidth;}
    public int getHeight () {return (int)fheight;}
    
    //set method
    public void setX (int i) {fx = (float)i;}
    public void setY (int i) {fy = (float)i;}
    public void setWidth (int i) {fwidth = (float)i;}
    public void setHeight (int i) {fheight = (float)i;}

    public void setX (float i) {fx = (float)i;}
    public void setY (float i) {fy = (float)i;}
    public void setWidth (float i) {fwidth = (float)i;}
    public void setHeight (float i) {fheight = (float)i;}
    //method from ShapeBean interface to generate a Shape
    @Override
    public Shape genShape() {
        return new java.awt.geom.Ellipse2D.Float(fx, fy, fwidth, fheight);
    }
    @Override
    public String toString() {
        return "ZEllipse ("+(int)fx+","+(int)fy+","+(int)fwidth+","+(int)fheight+")";
    }    
}
