/*
 * this class is for generating a java.awt.Rectangle using interface ShapeBean and the method genShape(...)
 * the rectngle (Shape) will be using to define a clickable part on the ImageIcon
 * all methods set and get and constructor without argument are for generating a xml file with java.beans.XMLEncoder
 */
package org.lsst.ccs.utilities.zonesui;

import java.awt.Shape;

/**
 *
 * @author Pascal Durieu
 */
public class ZPolygon implements ShapeBean{
    private String[] pointCoords;
    
    public ZPolygon() {}
    
    public ZPolygon (String... str) {
        this.pointCoords = str;
    }
    
    //get method
    public String[] getPoints () {return this.pointCoords;}
    public void setPoints(String... st) {this.pointCoords = st;}
    
    //must repeat the first point at the end of the array for generating the polygon
    //size of array is +1
    public int getNbPoint () {
        return (pointCoords.length+1);
        
    }    
    public int[][] getXY() {
        int[][] tabXY = new int[getNbPoint()][2];
        for (int i=0;i<(getNbPoint()-1);i++) {
            String[] coords = pointCoords[i].split(",");            
            tabXY[i][0] = Integer.parseInt(coords[0]);
            tabXY[i][1] = Integer.parseInt(coords[1]);
        }
        //repeat the first element to the last (cf Polygon class constructor's)
        tabXY[getNbPoint()-1][0] = tabXY[0][0];
        tabXY[getNbPoint()-1][1] = tabXY[0][1];
         
        return tabXY;
    }
    
    public int[] getX(int[][] tab) {
        int[] tabX = new int[tab.length];
        for (int i=0;i<tab.length;i++) {
            tabX[i] = tab[i][0];
        }
        return tabX;
    }
    public int[] getY(int[][] tab) {
        int[] tabY = new int[tab.length];   
        for (int i=0;i<tab.length;i++) {
            tabY[i] = tab[i][1];         
        }
        return tabY;
    }
        
    //method from ShapeBean interface to generate a Shape
    @Override
    public Shape genShape() {
        return new java.awt.Polygon(getX(getXY()),getY(getXY()),getNbPoint() );
    }
    @Override
    public String toString() {      
        int[] ix = getX(getXY());
        int[] iy = getY(getXY());
        String str = "APolygon with "+ getNbPoint()+" points:";
        for (int i=0;i<getNbPoint();i++) {
            str += " ("+ix[i]+","+iy[i]+")";
        }
        return str;
    }
    
}
