/**
 * This package provides  proxies to the standard java.util.logging package.
 * <BR/>
 * Its <TT>Logger</TT> class is only for codes that log messages or data (not for codes that deal with <TT>Level</TT>,
 * <TT>Formatters</TT> or <TT>Handlers</TT>). It provides methods that can simply replace logging invocations
 * meant to be handled by <TT>Log4J</TT> or simple standard java logging invocations: you can then in your codes
 * just change the <TT>import</TT> directives and keep you code "as is".
 * <P/>
 * So you have for instance :
 * <PRE>
 *     Logger logger = Logger.getLogger("org.lsst.ccs.mypackage") ;
 *     //....
 *     logger.info("doing the right thing!") ;
 *     //...
 *     if( logger.isInfoEnabled() ) {
 *         logger.log(Level.INFO, "still better", methodCall()) ;
 *     }
 *     //...
 *     try {
 *         //...
 *     } catch(Exception exc) {
 *         logger.error("Oops!", exc) ;
 *     }
 * </PRE>
 * But the <TT>Logger</TT> class is not only to get syntactic sugar: it provides access to "multi-dimensional logging".
 * <P/>
 * What's that?
 * <P/>
 * The idea is that can log the same call to different loggers in a single invocation.
 * So, for instance, you have the usual logger linked to a package but you want also to address different "concerns" that
 * are common to different classes or package. Then you can write:
 * <PRE>
 *     logger.log(Level.INFO, "Object being initialized", theObject, "INIT");
 * </PRE>
 * this means that the created <TT>LogRecord</TT> will be submitted to the current <TT>Logger</TT>
 * and also to another one named "INIT".
 * <BR/>
 * Thus you can create many "transversal" loggers named "INIT", "CONFIG", "MOVE" (or whatever you want)
 * and then you will be able to handle log informations reporting specifically about one of this "concerns".
 * <PRE>
 *     logger.log(Level.INFO, "Object being moved at initialisation", theObject, "INIT", "MOVE");
 * </PRE>
 * Then you can set the level for the corresponding package to <TT>SEVERE</TT> and set the level
 * of the "INIT" <I>concern</I> to <TT>INFO</TT> .
 * <BR/>
 * All the logging methods of the <TT>Logger</TT> class takes an optional <TT>String... </TT> variable argument list
 * where you can name <I>concerns</I>.
 * <P/>
 * Then you can handle real <TT>java.util.logging.Loggers</TT> that bear a name of package or a name of <I>concern</I>.
 * Then you can use <TT>setLevel</TT> or <TT>addHandler</TT> methods to this actual loggers (of type <TT>java.util.logging.Logger</TT>).
 * <B>But</B> you should note there are changes to the way <TT>Handlers</TT> should be defined and to the configuration
 * file (if you want to pilot logging through a configuration file).
 * <H3>Handler design</H3>
 * Since the same <TT>LogRecord</TT> might be provided to different <TT>Loggers</TT> then
 * a <TT>Handler</TT> may receive many <TT>publish</TT> requests for the <B>same</B> <TT>LogRecord</TT>!
 * It means that the <TT>Handlers</TT> should memorize which records are published and not report twice the same record.
 * <BR/>
 * Special handlers are provided to check for duplicates: <TT>ConsoleHandlerN, StreamHandlerN, SocketHandlerN, ...</TT>
 * all rely on the service of a <TT>IsLoggableDelegate</TT> that checks the records for multiple publishing.
 *
 * <H3>Configuration file</H3>
 * There is a <TT>logging.properties</TT> file to define the behaviour of loggers ans handlers:
 * though this file is in the standard format of <TT>java.util.logging</TT> it is positioned in a different way:
 * <UL>
 *     <LI/> it is considered a better policy to put the file at a global level of the CLASSPATH.
 *     ("/logging.propertie" in resource handling syntax).
 *     <LI/> to obtain this behaviour call <TT>Class.forName("org.lsst.ccs.utilities.logging.LogManagement</TT>
 *     early in your <TT>main</TT> (this will call <TT>static</TT> initialization code)
 * </UL>
 * Example of a <TT>logging.properties</TT> file:
 * <PRE>
 * # ------------------------------------------
 * # The set of handlers to be loaded upon startup.
 * # Comma-separated list of class names.
 * # (? LogManager docs say no comma here, but JDK example has comma.)
 * # handlers=java.util.logging.FileHandler, java.util.logging.ConsoleHandler
 * handlers=org.lsst.ccs.utilities.logging.ConsoleHandlerN
 *
 * # Default global logging level.
 * # Loggers and Handlers may override this level
 * .level=INFO
 *
 * # Loggers
 * # ------------------------------------------
 * # Loggers are usually attached to packages.
 * # Here, the level for each package is specified.
 * # The global level is used by default, so levels
 * # specified here simply act as an override.
 * #myapp.ui.level=ALL
 * #myapp.business.level=CONFIG
 * #myapp.data.level=SEVERE
 * org.lsst=CONFIG
 * MOVE=FINEST
 *
 * # Handlers
 * # -----------------------------------------
 * # --- ConsoleHandler ---
 * # Override of global logging level
 * #java.util.logging.ConsoleHandler.level=SEVERE
 * org.lsst.ccs.utilities.logging.ConsoleHandlerN.level=FINEST
 * </PRE>
 *
 *
 *
 */
package org.lsst.ccs.utilities.logging ;

