package org.lsst.ccs.utilities.exc;

/**
 * @author bamade
 */
// Date: 06/06/12

public class BundledRuntimeException extends RuntimeException implements ThrowableList{
    ThrowableList previousThrowable ;

    public BundledRuntimeException(ThrowableList previousThrowable) {
        this.previousThrowable = previousThrowable;
    }

    public BundledRuntimeException(String s, ThrowableList previousThrowable) {
        super(s);
        this.previousThrowable = previousThrowable;
    }

    public BundledRuntimeException(String s, Throwable throwable, ThrowableList previousThrowable) {
        super(s, throwable);
        this.previousThrowable = previousThrowable;
    }

    public BundledRuntimeException(Throwable throwable, ThrowableList previousThrowable) {
        super(throwable);
        this.previousThrowable = previousThrowable;
    }

    public Throwable previous() {
        return (Throwable) previousThrowable ;
    }

    @Override
    public Throwable current() {
        return this;
    }
}
