/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class RegExFilter
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Basic/Regular Expression";
    private final String name;
    private final String regex;

    @Create(category="AgentChannelsFilter", name="Regular expression filter", path="Built-In/Basic/Regular Expression", description="Channels filter that uses a regular expression to select channels and leaves their paths unchanged.")
    public RegExFilter(@Par(def="RegEx", desc="Filter name.") String name, @Par(desc="Regular expression to be applied to the channel path.") String regex, @Par(def="false", desc="Match the whole path. If checked, a channel is accepted only if the provided regular expression matches its entire path. Otherwise, a channel is accepted if the regular expression matches any part of the path.") boolean wholePath) {
        this.name = name;
        if (regex == null || ((String)regex).isEmpty()) {
            throw new IllegalArgumentException("The regular expression cannot be empty");
        }
        if (!wholePath) {
            regex = ".*" + (String)regex + ".*";
        }
        Pattern.compile((String)regex);
        this.regex = regex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(this.regex);
    }
}

