package org.lsst.ccs.gconsole.util.swing;

import java.awt.Dimension;
import java.util.*;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

/**
 * {@link JComboBox} that limits its maximum height to its preferred height.
 * Intended for use with {@link BoxLayout}.
 * 
 * @param <E> Type of the elements of this combo box.
 *
 * @author onoprien
 */
public class BoxedComboBox<E> extends JComboBox<E> {

// -- Life cycle : -------------------------------------------------------------

    /**
     * Creates a combo box that takes its items from an existing <code>ComboBoxModel</code>.
     * Since the <code>ComboBoxModel</code> is provided, a combo box created using
     * this constructor does not create a default combo box model and
     * may impact how the insert, remove and add methods behave.
     *
     * @param aModel the <code>ComboBoxModel</code> that provides the displayed list of items
     */
    public BoxedComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
    }

    /**
     * Creates a combo box that contains the elements in the specified array.
     * By default the first item in the array (and therefore the data model) becomes selected.
     *
     * @param items  an array of objects to insert into the combo box
     */
    public BoxedComboBox(E[] items) {
        super(items);
    }

    /**
     * Creates a combo box that contains the elements in the specified collection.
     * By default the first item returned by the collection's iterator becomes selected.
     *
     * @param items  an array of objects to insert into the combo box
     */
    public BoxedComboBox(Collection<E> items) {
        super(new Vector<>(items));
    }

    /**
     * Creates a combo box that contains the elements in the specified Vector.
     * By default the first item in the vector (and therefore the data model) becomes selected.
     *
     * @param items  an array of vectors to insert into the combo box
     */
    public BoxedComboBox(Vector<E> items) {
        super(items);
    }

    /**
     * Creates a combo box with a default data model.
     * The default data model is an empty list of objects.
     * Use <code>addItem</code> to add items.  By default the first item in the data model becomes selected.
     */
    public BoxedComboBox() {
        super();
    }


// -- Limit max size : ---------------------------------------------------------

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }
    
}
