package org.lsst.ccs.gconsole.plugins.tracer;

/**
 * Interface to be implemented by tracer filters.
 * Applying this filter to a message may modify the message, in addition to accepting or rejecting it.
 * Implementations should be immutable, may be used for processing multiple messages concurrently.
 *
 * @author onoprien
 */
public interface MessageFilter {
    
    /**
     * Applies this filter to the given message.
     * 
     * @param filteredMessage The message to be filtered.
     * @return The (possibly modified) message if it passes the filter; {@code null} otherwise.
     */
    FilteredMessage apply(FilteredMessage filteredMessage);

}
