package org.lsst.ccs.gconsole.plugins.demo.optpage;

import javax.swing.Box;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.lock.Lock;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;

/**
 * Demo plugin that creates three sets of pages through the {@link OptionalPage} utility.
 * Each set can be activated through the "CCS Tools/Demo/Optional Page" menu.
 * See documentation for {@code OptPage1}, {@code OptPage2}, {@code OptPage3Monitor}, and {@code OptPage3Control}
 * classes implementing {@link OptionalPage} with different behaviors.
 *
 * @author onoprien
 */
//@Plugin(name = "Optional Page Test Plugin",
//        id = "opt-page-test",
//        description = "Test for adding optional pages.",
//        loadAtStart = true)
public class OptPageTestPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public void initialize() {
        OptionalPage.getService().add(new OptPage1());
    }
    
// -- Demo 1: Open a page for every sussystem on the buses : -------------------

    /**
     * Displays one page per subsystem present on the buses.
     * Automatically opened on subsystem discovery, closed and removed from menus on disconnect.
     * Pages state (open or closed) is automatically saved or restored when the console session is saved or restored.
     * <p>
     * Subsystem named "demo-subsystem" gets special treatment.
     * On subsystem disconnect, it stays open until closed by the user.
     * It is also placed last in the menu.
     */
    static class OptPage1 implements OptionalPage {

        @Override
        public boolean isAutoSave() {
            return true;
        }

        @Override
        public String getPage(AgentInfo agent) {
            return "CCS Subsystems/"+ agent.getName() +"/LockTest";
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            Lock lock = new Lock(agent.getName());
            box.add(lock);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        @Override
        public boolean agentDisconnected(AgentInfo agent) {
            return false;
        }
        
    }
    
}
