package org.lsst.ccs.gconsole.plugins.demo.life;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;

/**
 * 
 *
 * @author onoprien
 */
@Plugin(name = "Life cycle Demo Plugin",
        id="life-demo",
        description = "Tester for startup/shutdown.",
        loadAtStart=false)
public class LifeCyclePlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private volatile StringBuilder hist = new StringBuilder();

// -- Life cycle : -------------------------------------------------------------

    @Override
    public void initialize() {
        hist.append("init+");
        System.out.println(hist);
        try {Thread.sleep(1000);} catch (InterruptedException x) {}
        
        // Testing trending service:

        Action a = new AbstractAction("Test trending service") {
            @Override
            public void actionPerformed(ActionEvent e) {
                String path = JOptionPane.showInputDialog("Enter path:");
                TrendingService service = (TrendingService) getConsole().getConsoleLookup().lookup(TrendingService.class);
                service.show(path.split("/"));
            }
        };
        getServices().addMenu(a, "Demo", "Trending");
    }

    @Override
    public void start() {
        hist.append("start+");
        System.out.println(hist);
        try {Thread.sleep(1000);} catch (InterruptedException x) {}
    }

    @Override
    public void stop() {
        hist.append("stop+");
        System.out.println(hist);
        try {Thread.sleep(1000);} catch (InterruptedException x) {}
    }

    @Override
    public void shutdown() {
        hist.append("shut+");
        System.out.println(hist);
        try {Thread.sleep(1000);} catch (InterruptedException x) {}
    }

    @Override
    public ComponentDescriptor save() {
        hist.append("save+");
        System.out.println(hist);
        try {Thread.sleep(1000);} catch (InterruptedException x) {}
        return super.save();
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        hist.append("rest+");
        System.out.println(hist);
        try {Thread.sleep(1000);} catch (InterruptedException x) {}
        return super.restore(storageBean, lastRound);
    }

}
