package org.lsst.ccs.gconsole.plugins.demo.aggregator;

import java.awt.event.ActionEvent;
import java.util.*;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;

/**
 * 
 *
 * @author onoprien
 */
//@Plugin(name="Agent status aggregator test Plugin",
//        id="test_aggregator",
//        description="Agent status aggregator test Plugin.")
public class TestAggregator extends ConsolePlugin {
    
    Listener listener0, listener1;

// -- Life cycle : -------------------------------------------------------------
    
    public TestAggregator() {
        
    }

    @Override
    public void initialize() {
        
        Action act = new AbstractAction("0") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (listener0 == null) {
                    listener0 = new Listener("0");
                    Console.getConsole().getStatusAggregator().addListener(listener0, new DemoFilter());
                } else {
                    Console.getConsole().getStatusAggregator().removeListener(listener0);
                    listener0 = null;
                }
            }
        };
        getServices().addMenu(act, "Demo", "Status Aggregator");
        
        act = new AbstractAction("1") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (listener1 == null) {
                    listener1 = new Listener("1");
                    List<String> agents = Arrays.asList(new String[] {"demo-subsystem"});
                    List<String> channels = Arrays.asList(new String[] {".*", "demo-subsystem-with-monitoring/state/"});
                    Console.getConsole().getStatusAggregator().addListener(listener1, null, Collections.emptyList());
                } else {
                    Console.getConsole().getStatusAggregator().removeListener(listener1);
                    listener1 = null;
                }
            }
        };
        getServices().addMenu(act, "Demo", "Status Aggregator");
    }
    
}
    
// -- Implement listener : -----------------------------------------------------

class Listener implements AgentStatusListener {
    
    private final String name;
    
    Listener(String name) {
        this.name = name;
    }
    
    String getName() {
        return name;
    }

    @Override
    public void connect(AgentStatusEvent event) {
        System.out.println("\nConnect "+ name +": "+ event);
    }

    @Override
    public void configure(AgentStatusEvent event) {
        System.out.println("\nConfigure "+ name +": "+ event);
        for (AgentChannel ch : event.getAddedChannels()) {
            System.out.println(ch.getPath());
        }
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
//        System.out.print(event.getStatusChanges().size() +" ");
        System.out.print(name);
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        System.out.println("\nDisconnect "+ name +": "+ event);
    }

}
