package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

/**
 * Text field that indicates the type of expected input.
 *
 * @author emarin
 */
public class HintTextField extends JTextField implements FocusListener {

    private String hint;
 
    HintTextField() {
        super(0);
    }
 
    public HintTextField(final String hint) {
        super(hint);
        this.hint = hint;
        super.addFocusListener(this);
        super.setForeground(Color.GRAY);
    }
 
    @Override
    public void focusGained(FocusEvent e) {
        if(this.getText().isEmpty()) {
            super.setText("");
        }
        super.setForeground(Color.BLACK);
    }
    
    public void setHint() {
        setText(hint);
        super.setForeground(Color.GRAY);
    }
 
    @Override
    public void focusLost(FocusEvent e) {
        if(this.getText().isEmpty()) {
            super.setText(hint);
            super.setForeground(Color.GRAY);
        }
    }
 
    @Override
    public String getText() {
        String typed = super.getText();
        return typed.equals(hint) ? "" : typed;
    }
    
    
}
