package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Filter that selects subsystem state channels.
 *
 * @author onoprien
 */
public class Versions extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CREATOR_PATH = "Built-In/Special/Versions";
    
    private final Pattern pat = Pattern.compile("([^/]+)/static/version\\.([^/]+)");

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "Versions",
            path = CREATOR_PATH,
            description = "Channels filter that selects software versions channels.")
    public Versions() {
    }
    
// -- Implementing filter : ----------------------------------------------------

    @Override
    public String getDisplayPath(String originPath) {
        Matcher m = pat.matcher(originPath);
        if (m.matches()) {
            return m.group(1) +"/"+ m.group(2);
        } else {
            return null;
        }
    }

    @Override
    public String getOriginPath(String displayPath) {
        String[] ss = displayPath.split("/");
        return ss.length == 2 ? ss[0] +"/static/version."+ ss[1] : null;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("[^/]+/static/version\\.[^/]+");
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? 
                Collections.singletonList(AgentChannel.Key.VALUE) : 
                Arrays.asList(new String[] {AgentChannel.Key.VALUE, "HOST"});
    }

    @Override
    public String getName() {
        return "Versions";
    }

}

