package org.lsst.ccs.gconsole.base;

import java.awt.Dimension;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;

/**
 * Constants used by graphic components.
 *
 * @author onoprien
 */
public class Const {
    
    static public final int HSPACE = 10;
    static public final int VSPACE = 5;
    static public final Dimension HDIM = new Dimension(HSPACE, 0);
    static public final Dimension VDIM = new Dimension(0, VSPACE);
    static public final Dimension HDIM2 = new Dimension(2*HSPACE, 0);
    static public final Dimension VDIM2 = new Dimension(0, 2*VSPACE);
    
    static public final DateTimeFormatter DEFAULT_DT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    static public final DateTimeFormatter BRIEF_DT_FORMAT = DateTimeFormatter.ofPattern("MM.dd HH:mm:ss").withZone(ZoneId.systemDefault());
    static public final DateTimeFormatter DEFAULT_T_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());
    
    static public final Pattern AGENT_NAME_PATTERN = Pattern.compile("[a-zA-Z][-a-zA-Z_0-9]*");

}
