/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.PassThroughInterceptor;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.proxy.ProxyConfiguration;

public class BasicProxyFactoryImpl
implements BasicProxyFactory {
    private static final ConcurrentMap<Set<Class>, Class> CACHE = new ConcurrentHashMap<Set<Class>, Class>();
    private static final Class[] NO_INTERFACES = new Class[0];
    private final Class proxyClass;

    public BasicProxyFactoryImpl(Class superClass, Class[] interfaces) {
        Class previousProxy;
        Class proxyClass;
        if (superClass == null && (interfaces == null || interfaces.length < 1)) {
            throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
        }
        HashSet<Class> key = new HashSet<Class>();
        if (superClass != null) {
            key.add(superClass);
        }
        if (interfaces != null && interfaces.length > 0) {
            key.addAll(Arrays.asList(interfaces));
        }
        if ((proxyClass = (Class)CACHE.get(key)) == null && (previousProxy = CACHE.putIfAbsent(key, proxyClass = new ByteBuddy().with(TypeValidation.DISABLED).with((AuxiliaryType.NamingStrategy)new AuxiliaryType.NamingStrategy.SuffixingRandom("HibernateBasicProxy")).subclass(superClass == null ? Object.class : superClass).implement((Type[])(interfaces == null ? NO_INTERFACES : interfaces)).defineField("$$_hibernate_interceptor", ProxyConfiguration.Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.isVirtual().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isFinalizer()))).intercept((Implementation)MethodDelegation.toField((String)"$$_hibernate_interceptor")).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)FieldAccessor.ofField((String)"$$_hibernate_interceptor").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make().load(BasicProxyFactory.class.getClassLoader()).getLoaded())) != null) {
            proxyClass = previousProxy;
        }
        this.proxyClass = proxyClass;
    }

    @Override
    public Object getProxy() {
        try {
            ProxyConfiguration proxy = (ProxyConfiguration)this.proxyClass.newInstance();
            proxy.$$_hibernate_set_interceptor(new PassThroughInterceptor(proxy, this.proxyClass.getName()));
            return proxy;
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate proxy instance");
        }
    }

    public boolean isInstance(Object object) {
        return this.proxyClass.isInstance(object);
    }
}

