package org.lsst.ccs.gconsole.util.swing;

import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JComponent;

/**
 * Static methods and constants useful with SWING.
 *
 * @author onoprien
 */
public class Utilities {

    /**
     * Input verifier that considers the component valid if it's foreground color is black.
     * Useful with components that update their colors based on validity of user's input.
     */
    static public final InputVerifier BLACK_VERIFIER = new InputVerifier() {
        @Override
        public boolean verify(JComponent input) {
            return input.getForeground().equals(Color.BLACK);
        }
    };

}
