package org.lsst.ccs.gconsole.util.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;


/**
 * {@link MouseAdapter} that does not call {@code mouseClicked(e)} with {@code e.getClickCount() == 1} on double click.
 *
 * @author onoprien
 */
public class MouseAdapterDoubleClick extends MouseAdapter {

// -- Fields : -----------------------------------------------------------------
    
    private int delay = 200;
    private boolean clickedOnce = false;
    private Timer clickTimer;


// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public final void mouseClicked(MouseEvent e) {
        switch (e.getClickCount()) {
            case 1:
                if (clickedOnce) {
                    clickedOnce = false;
                    clickTimer.stop();
                } else {
                    clickedOnce = true;
                    clickTimer = new Timer(200, evt -> {
                        mouseClickedFiltered(e);
                        clickedOnce = false;
                        clickTimer.stop();
                    });
                    clickTimer.setRepeats(false);
                    clickTimer.start();
                }
                break;
            default:
                clickedOnce = false;
                clickTimer.stop();
                mouseClickedFiltered(e);
        }
    }
    
    public void mouseClickedFiltered(MouseEvent e) {
    }
    
    
// -- Testing : ----------------------------------------------------------------
    
    public static void main(String[] args) {
        JFrame frame = new JFrame("Click Action Example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        JLabel label = new JLabel("Click me!");
        label.addMouseListener(new MouseAdapterDoubleClick() {
            @Override
            public void mouseClickedFiltered(MouseEvent e) {
                System.out.println("Filtered "+ e.getClickCount());
            }
            
        });
        frame.getContentPane().add(label);
        frame.pack();
        frame.setVisible(true);
    }

}
